/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.spark.connector.cql.MultipleRetryPolicy$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005e\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!)1\n\u0001C\u0001\u0019\"9\u0011\u000b\u0001b\u0001\n\u0013\u0011\u0006BB,\u0001A\u0003%1\u000bC\u0003Y\u0001\u0011%\u0011\fC\u0003`\u0001\u0011\u0005\u0003\rC\u0003{\u0001\u0011\u00053\u0010C\u0004\u0002\u0014\u0001!\t%!\u0006\t\u000f\u0005\u0015\u0002\u0001\"\u0011\u0002(!9\u00111\t\u0001\u0005B\u0005\u0015\u0003bBA*\u0001\u0011\u0005\u0013QK\u0004\b\u0003;*\u0002\u0012AA0\r\u0019!R\u0003#\u0001\u0002b!11J\u0004C\u0001\u0003SB\u0011\"a\u001b\u000f\u0005\u0004%\t!!\u001c\t\u0011\u0005md\u0002)A\u0005\u0003_B\u0001\"! \u000f\u0005\u0004%\tA\u0015\u0005\b\u0003\u007fr\u0001\u0015!\u0003T\u0005MiU\u000f\u001c;ja2,'+\u001a;ssB{G.[2z\u0015\t1r#A\u0002dc2T!\u0001G\r\u0002\u0013\r|gN\\3di>\u0014(B\u0001\u000e\u001c\u0003\u0015\u0019\b/\u0019:l\u0015\taR$\u0001\u0005eCR\f7\u000f^1y\u0015\u0005q\u0012aA2p[\u000e\u00011c\u0001\u0001\"SA\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0005Y\u0006twMC\u0001'\u0003\u0011Q\u0017M^1\n\u0005!\u001a#AB(cU\u0016\u001cG\u000f\u0005\u0002+k5\t1F\u0003\u0002-[\u0005)!/\u001a;ss*\u0011afL\u0001\u0005G>\u0014XM\u0003\u00021c\u0005\u0019\u0011\r]5\u000b\u0005I\u001a\u0014A\u00023sSZ,'O\u0003\u000257\u0005\u0019qn]:\n\u0005YZ#a\u0003*fiJL\bk\u001c7jGf\fqaY8oi\u0016DH\u000f\u0005\u0002:w5\t!H\u0003\u00028[%\u0011AH\u000f\u0002\u000e\tJLg/\u001a:D_:$X\r\u001f;\u0002\u0017A\u0014xNZ5mK:\u000bW.\u001a\t\u0003\u007f!s!\u0001\u0011$\u0011\u0005\u0005#U\"\u0001\"\u000b\u0005\r{\u0012A\u0002\u001fs_>$hHC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9E)\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0013*\u0013aa\u0015;sS:<'BA$E\u0003\u0019a\u0014N\\5u}Q\u0019Qj\u0014)\u0011\u00059\u0003Q\"A\u000b\t\u000b]\u001a\u0001\u0019\u0001\u001d\t\u000bu\u001a\u0001\u0019\u0001 \u0002\u001b5\f\u0007PU3uef\u001cu.\u001e8u+\u0005\u0019\u0006C\u0001+V\u001b\u0005!\u0015B\u0001,E\u0005\rIe\u000e^\u0001\u000f[\u0006D(+\u001a;ss\u000e{WO\u001c;!\u0003U\u0011X\r\u001e:z\u001b\u0006t\u0017\u0010V5nKN|%\u000f\u00165s_^$\"AW/\u0011\u0005)Z\u0016B\u0001/,\u00055\u0011V\r\u001e:z\t\u0016\u001c\u0017n]5p]\")aL\u0002a\u0001'\u00069aN\u0019*fiJL\u0018!D8o%\u0016\fG\rV5nK>,H\u000fF\u0004[C&|\u0017o\u001d=\t\u000b\t<\u0001\u0019A2\u0002\u000fI,\u0017/^3tiB\u0011AmZ\u0007\u0002K*\u0011a-L\u0001\bg\u0016\u001c8/[8o\u0013\tAWMA\u0004SKF,Xm\u001d;\t\u000b)<\u0001\u0019A6\u0002\u0005\rd\u0007C\u00017n\u001b\u0005i\u0013B\u00018.\u0005A\u0019uN\\:jgR,gnY=MKZ,G\u000eC\u0003q\u000f\u0001\u00071+\u0001\u0005cY>\u001c7NR8s\u0011\u0015\u0011x\u00011\u0001T\u0003!\u0011XmY3jm\u0016$\u0007\"\u0002;\b\u0001\u0004)\u0018a\u00033bi\u0006\u0004&/Z:f]R\u0004\"\u0001\u0016<\n\u0005]$%a\u0002\"p_2,\u0017M\u001c\u0005\u0006s\u001e\u0001\raU\u0001\u000be\u0016$(/_\"pk:$\u0018AD8o/JLG/\u001a+j[\u0016|W\u000f\u001e\u000b\u000b5rlh0!\u0004\u0002\u0010\u0005E\u0001\"\u00022\t\u0001\u0004\u0019\u0007\"\u00026\t\u0001\u0004Y\u0007BB@\t\u0001\u0004\t\t!A\u0005xe&$X\rV=qKB!\u00111AA\u0005\u001b\t\t)AC\u0002\u0002\b5\nAb]3sm\u0016\u0014XM\u001d:peNLA!a\u0003\u0002\u0006\tIqK]5uKRK\b/\u001a\u0005\u0006a\"\u0001\ra\u0015\u0005\u0006e\"\u0001\ra\u0015\u0005\u0006s\"\u0001\raU\u0001\u000e_:,f.\u0019<bS2\f'\r\\3\u0015\u0017i\u000b9\"!\u0007\u0002\u001c\u0005}\u00111\u0005\u0005\u0006E&\u0001\ra\u0019\u0005\u0006U&\u0001\ra\u001b\u0005\u0007\u0003;I\u0001\u0019A*\u0002\u0011I,\u0017/^5sK\u0012Da!!\t\n\u0001\u0004\u0019\u0016!B1mSZ,\u0007\"B=\n\u0001\u0004\u0019\u0016\u0001E8o%\u0016\fX/Z:u\u0003\n|'\u000f^3e)\u001dQ\u0016\u0011FA\u0016\u0003\u0003BQA\u0019\u0006A\u0002\rDq!!\f\u000b\u0001\u0004\ty#A\u0003feJ|'\u000f\u0005\u0003\u00022\u0005mb\u0002BA\u001a\u0003oq1!QA\u001b\u0013\u0005)\u0015bAA\u001d\t\u00069\u0001/Y2lC\u001e,\u0017\u0002BA\u001f\u0003\u007f\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005eB\tC\u0003z\u0015\u0001\u00071+A\bp]\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u001dQ\u0016qIA%\u0003#BQAY\u0006A\u0002\rDq!!\f\f\u0001\u0004\tY\u0005\u0005\u0003\u0002\u0004\u00055\u0013\u0002BA(\u0003\u000b\u0011AcQ8pe\u0012Lg.\u0019;pe\u0016C8-\u001a9uS>t\u0007\"B=\f\u0001\u0004\u0019\u0016!B2m_N,GCAA,!\r!\u0016\u0011L\u0005\u0004\u00037\"%\u0001B+oSR\f1#T;mi&\u0004H.\u001a*fiJL\bk\u001c7jGf\u0004\"A\u0014\b\u0014\u00079\t\u0019\u0007E\u0002U\u0003KJ1!a\u001aE\u0005\u0019\te.\u001f*fMR\u0011\u0011qL\u0001\u000e\u001b\u0006D(+\u001a;ss\u000e{WO\u001c;\u0016\u0005\u0005=\u0004\u0003BA9\u0003oj!!a\u001d\u000b\u0007\u0005UT&\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003s\n\u0019H\u0001\u0007Ee&4XM](qi&|g.\u0001\bNCb\u0014V\r\u001e:z\u0007>,h\u000e\u001e\u0011\u0002)5\u000b\u0007PU3uef\u001cu.\u001e8u\t\u00164\u0017-\u001e7u\u0003Ui\u0015\r\u001f*fiJL8i\\;oi\u0012+g-Y;mi\u0002\u0002")
public class MultipleRetryPolicy
implements RetryPolicy {
    private final int maxRetryCount;

    public static int MaxRetryCountDefault() {
        return MultipleRetryPolicy$.MODULE$.MaxRetryCountDefault();
    }

    public static DriverOption MaxRetryCount() {
        return MultipleRetryPolicy$.MODULE$.MaxRetryCount();
    }

    public RetryVerdict onReadTimeoutVerdict(Request x$1, ConsistencyLevel x$2, int x$3, int x$4, boolean x$5, int x$6) {
        return super.onReadTimeoutVerdict(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public RetryVerdict onWriteTimeoutVerdict(Request x$1, ConsistencyLevel x$2, WriteType x$3, int x$4, int x$5, int x$6) {
        return super.onWriteTimeoutVerdict(x$1, x$2, x$3, x$4, x$5, x$6);
    }

    public RetryVerdict onUnavailableVerdict(Request x$1, ConsistencyLevel x$2, int x$3, int x$4, int x$5) {
        return super.onUnavailableVerdict(x$1, x$2, x$3, x$4, x$5);
    }

    public RetryVerdict onRequestAbortedVerdict(Request x$1, Throwable x$2, int x$3) {
        return super.onRequestAbortedVerdict(x$1, x$2, x$3);
    }

    public RetryVerdict onErrorResponseVerdict(Request x$1, CoordinatorException x$2, int x$3) {
        return super.onErrorResponseVerdict(x$1, x$2, x$3);
    }

    private int maxRetryCount() {
        return this.maxRetryCount;
    }

    private RetryDecision retryManyTimesOrThrow(int nbRetry) {
        RetryDecision retryDecision;
        int n = this.maxRetryCount();
        switch (n) {
            case -1: {
                retryDecision = RetryDecision.RETRY_SAME;
                break;
            }
            default: {
                if (nbRetry < n) {
                    retryDecision = RetryDecision.RETRY_SAME;
                    break;
                }
                retryDecision = RetryDecision.RETHROW;
                break;
            }
        }
        return retryDecision;
    }

    public RetryDecision onReadTimeout(Request request, ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onWriteTimeout(Request request, ConsistencyLevel cl, WriteType writeType, int blockFor, int received, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onUnavailable(Request request, ConsistencyLevel cl, int required, int alive, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onRequestAborted(Request request, Throwable error, int retryCount) {
        return this.retryManyTimesOrThrow(retryCount);
    }

    public RetryDecision onErrorResponse(Request request, CoordinatorException error, int retryCount) {
        return RetryDecision.RETHROW;
    }

    public void close() {
    }

    public MultipleRetryPolicy(DriverContext context, String profileName) {
        this.maxRetryCount = context.getConfig().getProfile(profileName).getInt(MultipleRetryPolicy$.MODULE$.MaxRetryCount(), MultipleRetryPolicy$.MODULE$.MaxRetryCountDefault());
    }
}

