/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.types;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqView$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class TimestampParser$ {
    public static TimestampParser$ MODULE$;
    private final Map<Object, String> formatsWithoutZoneByLength;
    private final Map<Tuple2<Object, Object>, Map<Object, DateTimeFormatter>> converterMatrix;
    private final Seq<DateTimeFormatter> slowPathConverters;
    private final int MaxZoneLength;
    private final int TimeSeparatorPosition;

    static {
        new TimestampParser$();
    }

    private Map<Object, String> formatsWithoutZoneByLength() {
        return this.formatsWithoutZoneByLength;
    }

    private Map<Tuple2<Object, Object>, Map<Object, DateTimeFormatter>> converterMatrix() {
        return this.converterMatrix;
    }

    private Seq<DateTimeFormatter> slowPathConverters() {
        return this.slowPathConverters;
    }

    private Date slowParse(String date) {
        Some some;
        Try try_;
        Option option = ((IterableLike)this.slowPathConverters().view().map((Function1 & Serializable & scala.Serializable)p -> Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ZonedDateTime.parse(date, p)), SeqView$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isSuccess()));
        if (!(option instanceof Some) || !((try_ = (Try)(some = (Some)option).value()) instanceof Success)) {
            throw new IllegalArgumentException(new StringBuilder(14).append("Invalid date: ").append(date).toString());
        }
        Success success = (Success)try_;
        ZonedDateTime d = (ZonedDateTime)success.value();
        Date date2 = Date.from(d.toInstant());
        return date2;
    }

    private int MaxZoneLength() {
        return this.MaxZoneLength;
    }

    private int TimeSeparatorPosition() {
        return this.TimeSeparatorPosition;
    }

    private boolean containsTimeSeparator(char separator, String date) {
        return date.length() > this.TimeSeparatorPosition() && date.charAt(this.TimeSeparatorPosition()) == separator;
    }

    /*
     * WARNING - void declaration
     */
    private int findTimeZoneIndex(String date) {
        void var2_2;
        int found = -1;
        for (int currentIndex = Math.max(date.length() - this.MaxZoneLength(), this.TimeSeparatorPosition()); found < 0 && currentIndex < date.length(); ++currentIndex) {
            if (date.charAt(currentIndex) != '+' && date.charAt(currentIndex) != '-' && date.charAt(currentIndex) != 'Z') continue;
            found = currentIndex;
        }
        return (int)var2_2;
    }

    public Date parseFastOrThrow(String date) {
        int zoneIndex = this.findTimeZoneIndex(date);
        boolean hasZone = zoneIndex > 0;
        int lookupLength = hasZone ? zoneIndex : date.length();
        boolean hasT = this.containsTimeSeparator('T', date);
        boolean hasSpace = this.containsTimeSeparator(' ', date);
        DateTimeFormatter format = (DateTimeFormatter)((MapLike)this.converterMatrix().apply((Object)new Tuple2.mcZZ.sp(hasT, hasZone))).apply((Object)BoxesRunTime.boxToInteger((int)lookupLength));
        return hasT || hasSpace ? (hasZone ? Date.from(ZonedDateTime.parse(date, format).toInstant()) : Date.from(LocalDateTime.parse(date, format).atZone(ZoneId.systemDefault()).toInstant())) : Date.from(LocalDate.parse(date, format).atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public Date parse(String date) {
        Date date2;
        try {
            date2 = this.parseFastOrThrow(date);
        }
        catch (Throwable throwable) {
            date2 = this.slowParse(date);
        }
        return date2;
    }

    public static final /* synthetic */ Tuple2 $anonfun$converterMatrix$2(boolean addT$1, boolean addZone) {
        Map patterns = MODULE$.formatsWithoutZoneByLength().mapValues((Function1 & Serializable & scala.Serializable)p -> addT$1 ? p.replace(" ", "'T'") : p).mapValues((Function1 & Serializable & scala.Serializable)p -> addZone ? new StringBuilder(25).append((String)p).append("[XXXXX][XXXX][XXX][XX][X]").toString() : p).mapValues((Function1 & Serializable & scala.Serializable)x$1 -> DateTimeFormatter.ofPattern(x$1));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcZZ.sp(addT$1, addZone)), (Object)patterns);
    }

    public static final /* synthetic */ Seq $anonfun$converterMatrix$1(Seq booleans$1, boolean addT) {
        return (Seq)booleans$1.map((Function1 & Serializable & scala.Serializable)addZone -> TimestampParser$.$anonfun$converterMatrix$2(addT, BoxesRunTime.unboxToBoolean((Object)addZone)), Seq$.MODULE$.canBuildFrom());
    }

    private TimestampParser$() {
        MODULE$ = this;
        this.formatsWithoutZoneByLength = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyy-MM-dd", "yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ss.S", "yyyy-MM-dd HH:mm:ss.SS", "yyyy-MM-dd HH:mm:ss.SSS"}))).map((Function1 & Serializable & scala.Serializable)p -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)p.length())), p), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Seq booleans = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}));
        Seq result = (Seq)booleans.flatMap((Function1 & Serializable & scala.Serializable)addT -> TimestampParser$.$anonfun$converterMatrix$1(booleans, BoxesRunTime.unboxToBoolean((Object)addT)), Seq$.MODULE$.canBuildFrom());
        this.converterMatrix = result.toMap(Predef$.MODULE$.$conforms());
        this.slowPathConverters = ((TraversableOnce)this.converterMatrix().values().flatMap((Function1 & Serializable & scala.Serializable)x$1 -> x$1.values(), Iterable$.MODULE$.canBuildFrom())).toSeq();
        this.MaxZoneLength = 9;
        this.TimeSeparatorPosition = 10;
    }
}

