/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SocketOptions;
import com.datastax.driver.core.policies.ExponentialReconnectionPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import com.datastax.driver.core.policies.RetryPolicy;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$class;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy$;
import com.datastax.spark.connector.cql.MultipleRetryPolicy;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.io.IOUtils;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

public final class DefaultConnectionFactory$
implements CassandraConnectionFactory {
    public static final DefaultConnectionFactory$ MODULE$;

    static {
        new DefaultConnectionFactory$();
    }

    @Override
    public Set<String> properties() {
        return CassandraConnectionFactory$class.properties(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Cluster.Builder clusterBuilder(CassandraConnectorConf conf) {
        Cluster.Builder builder;
        SocketOptions options = new SocketOptions().setConnectTimeoutMillis(conf.connectTimeoutMillis()).setReadTimeoutMillis(conf.readTimeoutMillis());
        Cluster.Builder builder2 = Cluster.builder().addContactPoints((InetAddress[])conf.hosts().toSeq().toArray(ClassTag$.MODULE$.apply(InetAddress.class))).withPort(conf.port()).withRetryPolicy((RetryPolicy)new MultipleRetryPolicy(conf.queryRetryCount(), conf.queryRetryDelay())).withReconnectionPolicy((ReconnectionPolicy)new ExponentialReconnectionPolicy((long)conf.minReconnectionDelayMillis(), (long)conf.maxReconnectionDelayMillis())).withLoadBalancingPolicy((LoadBalancingPolicy)new LocalNodeFirstLoadBalancingPolicy(conf.hosts(), conf.localDC(), LocalNodeFirstLoadBalancingPolicy$.MODULE$.$lessinit$greater$default$3())).withAuthProvider(conf.authConf().authProvider()).withSocketOptions(options).withCompression(conf.compression());
        if (conf.cassandraSSLConf().enabled()) {
            Cluster.Builder builder3;
            Option<SSLOptions> option = this.maybeCreateSSLOptions(conf.cassandraSSLConf());
            if (option instanceof Some) {
                Some some = (Some)option;
                SSLOptions sslOptions = (SSLOptions)some.x();
                builder3 = builder2.withSSL(sslOptions);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                builder3 = builder2.withSSL();
            }
            builder = builder3;
            return builder;
        } else {
            builder = builder2;
        }
        return builder;
    }

    private Option<SSLOptions> maybeCreateSSLOptions(CassandraConnectorConf.CassandraSSLConf conf) {
        return conf.trustStorePath().map((Function1)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final CassandraConnectorConf.CassandraSSLConf conf$1;

            /*
             * WARNING - void declaration
             */
            public final SSLOptions apply(String x0$1) {
                Option<String> option;
                block5: {
                    TrustManagerFactory trustManagerFactory;
                    String string = x0$1;
                    FileInputStream trustStoreFile = new FileInputStream(string);
                    try {
                        KeyStore keyStore = KeyStore.getInstance(this.conf$1.trustStoreType());
                        option = this.conf$1.trustStorePassword();
                        if (None$.MODULE$.equals(option)) {
                            keyStore.load(trustStoreFile, null);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            if (!(option instanceof Some)) break block5;
                            Some some = (Some)option;
                            String password = (String)some.x();
                            keyStore.load(trustStoreFile, password.toCharArray());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        tmf.init(keyStore);
                        trustManagerFactory = tmf;
                    }
                    catch (Throwable throwable) {
                        void var4_3;
                        IOUtils.closeQuietly((InputStream)var4_3);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)trustStoreFile);
                    TrustManagerFactory tmf = trustManagerFactory;
                    SSLContext context = SSLContext.getInstance(this.conf$1.protocol());
                    context.init(null, tmf.getTrustManagers(), new SecureRandom());
                    JdkSSLOptions jdkSSLOptions = JdkSSLOptions.builder().withSSLContext(context).withCipherSuites((String[])this.conf$1.enabledAlgorithms().toArray(ClassTag$.MODULE$.apply(String.class))).build();
                    return jdkSSLOptions;
                }
                throw new MatchError(option);
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    @Override
    public Cluster createCluster(CassandraConnectorConf conf) {
        return this.clusterBuilder(conf).build();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DefaultConnectionFactory$() {
        MODULE$ = this;
        CassandraConnectionFactory$class.$init$(this);
    }
}

