/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.partitioner;

import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.rdd.partitioner.ReplicaPartition;
import java.net.InetAddress;
import java.util.Random;
import org.apache.spark.Partition;
import org.apache.spark.Partitioner;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0001\u0003\u0001=\u0011!CU3qY&\u001c\u0017\rU1si&$\u0018n\u001c8fe*\u00111\u0001B\u0001\fa\u0006\u0014H/\u001b;j_:,'O\u0003\u0002\u0006\r\u0005\u0019!\u000f\u001a3\u000b\u0005\u001dA\u0011!C2p]:,7\r^8s\u0015\tI!\"A\u0003ta\u0006\u00148N\u0003\u0002\f\u0019\u0005AA-\u0019;bgR\f\u0007PC\u0001\u000e\u0003\r\u0019w.\\\u0002\u0001'\t\u0001\u0001\u0003\u0005\u0002\u0012/5\t!C\u0003\u0002\n')\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0013\tA\"CA\u0006QCJ$\u0018\u000e^5p]\u0016\u0014\b\u0002\u0003\u000e\u0001\u0005\u0003\u0005\u000b\u0011B\u000e\u0002/A\f'\u000f^5uS>t7\u000fU3s%\u0016\u0004H.[2b'\u0016$\bC\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"aA%oi\"Aq\u0001\u0001BC\u0002\u0013\u0005!%F\u0001$!\t!s%D\u0001&\u0015\t1c!A\u0002dc2L!\u0001K\u0013\u0003%\r\u000b7o]1oIJ\f7i\u001c8oK\u000e$xN\u001d\u0005\tU\u0001\u0011\t\u0011)A\u0005G\u0005Q1m\u001c8oK\u000e$xN\u001d\u0011\t\u000b1\u0002A\u0011A\u0017\u0002\rqJg.\u001b;?)\rq\u0003'\r\t\u0003_\u0001i\u0011A\u0001\u0005\u00065-\u0002\ra\u0007\u0005\u0006\u000f-\u0002\ra\t\u0005\bg\u0001\u0011\r\u0011\"\u00035\u0003\u0015Awn\u001d;t+\u0005)\u0004c\u0001\u001c:y9\u0011AdN\u0005\u0003qu\tq\u0001]1dW\u0006<W-\u0003\u0002;w\t1a+Z2u_JT!\u0001O\u000f\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015a\u00018fi*\t\u0011)\u0001\u0003kCZ\f\u0017BA\"?\u0005-Ie.\u001a;BI\u0012\u0014Xm]:\t\r\u0015\u0003\u0001\u0015!\u00036\u0003\u0019Awn\u001d;tA!9q\t\u0001b\u0001\n\u0013A\u0015\u0001\u00038v[\"{7\u000f^:\u0016\u0003mAaA\u0013\u0001!\u0002\u0013Y\u0012!\u00038v[\"{7\u000f^:!\u0011\u001da\u0005A1A\u0005\n5\u000b\u0001\u0003]1si&$\u0018n\u001c8J]\u0012,\u00070Z:\u0016\u00039\u00032AN(R\u0013\t\u00016H\u0001\u0003MSN$\bc\u0001*X75\t1K\u0003\u0002U+\u0006I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003-v\t!bY8mY\u0016\u001cG/[8o\u0013\tA6K\u0001\u0006J]\u0012,\u00070\u001a3TKFDaA\u0017\u0001!\u0002\u0013q\u0015!\u00059beRLG/[8o\u0013:$W\r_3tA!9A\f\u0001b\u0001\n\u0013i\u0016a\u00025pgRl\u0015\r]\u000b\u0002=B!!k\u0018\u001fR\u0013\t\u00017KA\u0002NCBDaA\u0019\u0001!\u0002\u0013q\u0016\u0001\u00035pgRl\u0015\r\u001d\u0011\t\u000f\u0011\u0004!\u0019!C\u0005K\u0006A\u0011N\u001c3fq6\u000b\u0007/F\u0001g!\u0011\u0011vl\u0007\u001f\t\r!\u0004\u0001\u0015!\u0003g\u0003%Ig\u000eZ3y\u001b\u0006\u0004\b\u0005C\u0004k\u0001\t\u0007I\u0011B6\u0002\tI\fg\u000eZ\u000b\u0002YB\u0011Q\u000e]\u0007\u0002]*\u0011q\u000eQ\u0001\u0005kRLG.\u0003\u0002r]\n1!+\u00198e_6Daa\u001d\u0001!\u0002\u0013a\u0017!\u0002:b]\u0012\u0004\u0003\"B;\u0001\t\u00131\u0018A\u0003:b]\u0012|W\u000eS8tiV\tA\bC\u0003y\u0001\u0011\u0005\u00130\u0001\u0007hKR\u0004\u0016M\u001d;ji&|g\u000e\u0006\u0002\u001cu\")1p\u001ea\u0001y\u0006\u00191.Z=\u0011\u0005qi\u0018B\u0001@\u001e\u0005\r\te.\u001f\u0005\u0007\u0003\u0003\u0001A\u0011\t%\u0002\u001b9,X\u000eU1si&$\u0018n\u001c8t\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\tAcZ3u\u000b:$\u0007o\\5oiB\u000b'\u000f^5uS>tG\u0003BA\u0005\u0003\u001f\u00012aLA\u0006\u0013\r\tiA\u0001\u0002\u0011%\u0016\u0004H.[2b!\u0006\u0014H/\u001b;j_:D\u0001\"!\u0005\u0002\u0004\u0001\u0007\u00111C\u0001\na\u0006\u0014H/\u001b;j_:\u00042!EA\u000b\u0013\r\t9B\u0005\u0002\n!\u0006\u0014H/\u001b;j_:\u0004")
public class ReplicaPartitioner
extends Partitioner {
    private final int partitionsPerReplicaSet;
    private final CassandraConnector connector;
    private final Vector<InetAddress> hosts;
    private final int numHosts;
    private final List<IndexedSeq<Object>> partitionIndexes;
    private final Map<InetAddress, IndexedSeq<Object>> hostMap;
    private final Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    private final Random rand;

    public CassandraConnector connector() {
        return this.connector;
    }

    private Vector<InetAddress> hosts() {
        return this.hosts;
    }

    private int numHosts() {
        return this.numHosts;
    }

    private List<IndexedSeq<Object>> partitionIndexes() {
        return this.partitionIndexes;
    }

    private Map<InetAddress, IndexedSeq<Object>> hostMap() {
        return this.hostMap;
    }

    public Map<Object, InetAddress> com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap() {
        return this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap;
    }

    private Random rand() {
        return this.rand;
    }

    private InetAddress randomHost() {
        return (InetAddress)this.hosts().apply(this.rand().nextInt(this.numHosts()));
    }

    public int getPartition(Object key) {
        Set set;
        Object object = key;
        if (object instanceof Set && (set = (Set)object).size() > 0 && set.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Object x$2) {
                return x$2 instanceof InetAddress;
            }
        })) {
            int n;
            Vector replicaSetInDC = ((TraversableOnce)this.hosts().toSet().$amp((GenSet)set)).toVector();
            if (replicaSetInDC.nonEmpty()) {
                InetAddress endpoint = (InetAddress)replicaSetInDC.apply(this.rand().nextInt(replicaSetInDC.size()));
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)endpoint)).apply(this.rand().nextInt(this.partitionsPerReplicaSet)));
            } else {
                n = BoxesRunTime.unboxToInt((Object)((SeqLike)this.hostMap().apply((Object)this.randomHost())).apply(this.rand().nextInt(this.partitionsPerReplicaSet)));
            }
            int n2 = n;
            return n2;
        }
        throw new IllegalArgumentException(new StringBuilder().append((Object)"ReplicaPartitioner can only determine the partition of a tuple whose key is a non-empty Set[InetAddress]. ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid key: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key}))).toString());
    }

    public int numPartitions() {
        return this.partitionsPerReplicaSet * this.numHosts();
    }

    public ReplicaPartition getEndpointPartition(Partition partition) {
        InetAddress endpoints = (InetAddress)this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap().getOrElse((Object)BoxesRunTime.boxToInteger((int)partition.index()), (Function0)new Serializable(this, partition){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaPartitioner $outer;
            private final Partition partition$1;

            public final Nothing$ apply() {
                throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " : Can't get an endpoint for Partition ", ".index"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap(), this.partition$1})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partition$1 = partition$1;
            }
        });
        return new ReplicaPartition(partition.index(), (Set<InetAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetAddress[]{endpoints}))));
    }

    public ReplicaPartitioner(int partitionsPerReplicaSet, CassandraConnector connector) {
        this.partitionsPerReplicaSet = partitionsPerReplicaSet;
        this.connector = connector;
        this.hosts = connector.hosts().toVector();
        this.numHosts = this.hosts().size();
        this.partitionIndexes = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), partitionsPerReplicaSet * this.numHosts()).grouped(partitionsPerReplicaSet).toList();
        this.hostMap = ((TraversableOnce)this.hosts().zip(this.partitionIndexes(), Vector$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.com$datastax$spark$connector$rdd$partitioner$ReplicaPartitioner$$indexMap = (Map)this.hostMap().withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<InetAddress, IndexedSeq<Object>> check$ifrefutable$1) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final IndexedSeq<Tuple2<Object, InetAddress>> apply(Tuple2<InetAddress, IndexedSeq<Object>> x$1) {
                Tuple2<InetAddress, IndexedSeq<Object>> tuple2 = x$1;
                if (tuple2 != null) {
                    InetAddress ip = (InetAddress)tuple2._1();
                    IndexedSeq partitions2 = (IndexedSeq)tuple2._2();
                    IndexedSeq indexedSeq = (IndexedSeq)partitions2.map((Function1)new Serializable(this, ip){
                        public static final long serialVersionUID = 0L;
                        private final InetAddress ip$1;

                        public final Tuple2<Object, InetAddress> apply(int partition) {
                            return new Tuple2((Object)BoxesRunTime.boxToInteger((int)partition), (Object)this.ip$1);
                        }
                        {
                            this.ip$1 = ip$1;
                        }
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
        this.rand = new Random();
    }
}

