/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.CollectionBehavior;
import com.datastax.spark.connector.CollectionColumnName;
import com.datastax.spark.connector.CollectionPrepend$;
import com.datastax.spark.connector.CollectionRemove$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.Schema$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.ListType;
import com.datastax.spark.connector.types.MapType;
import com.datastax.spark.connector.writer.RowWriter;
import com.datastax.spark.connector.writer.RowWriterFactory;
import com.datastax.spark.connector.writer.TableWriter;
import com.datastax.spark.connector.writer.WriteConf;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;

public final class TableWriter$
implements Serializable {
    public static final TableWriter$ MODULE$;

    static {
        new TableWriter$();
    }

    private void checkMissingColumns(TableDef table, Seq<String> columnNames2) {
        IndexedSeq allColumnNames = (IndexedSeq)table.columns().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$16) {
                return x$16.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set missingColumns2 = (Set)columnNames2.toSet().$minus$minus((GenTraversableOnce)allColumnNames);
        if (missingColumns2.nonEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Column(s) not found: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingColumns2.mkString(", ")})));
        }
    }

    private void checkMissingPrimaryKeyColumns(TableDef table, Seq<String> columnNames2) {
        IndexedSeq primaryKeyColumnNames = (IndexedSeq)table.primaryKey().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$17) {
                return x$17.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set missingPrimaryKeyColumns = (Set)primaryKeyColumnNames.toSet().$minus$minus(columnNames2);
        if (missingPrimaryKeyColumns.nonEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Some primary key columns are missing in RDD or have not been selected: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{missingPrimaryKeyColumns.mkString(", ")})));
        }
    }

    private void checkCollectionBehaviors(TableDef table, IndexedSeq<ColumnRef> columnRefs2) {
        IndexedSeq tableCollectionColumns = (IndexedSeq)table.columns().filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ColumnDef cd) {
                return cd.isCollection();
            }
        });
        IndexedSeq tableCollectionColumnNames = (IndexedSeq)tableCollectionColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$18) {
                return x$18.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq tableListColumnNames = (IndexedSeq)((TraversableLike)tableCollectionColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ColumnType<Object>> apply(ColumnDef c) {
                return new Tuple2((Object)c.columnName(), c.columnType());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, ColumnType<Object>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    String name = (String)A1._1();
                    ColumnType x = (ColumnType)A1._2();
                    if (x instanceof ListType) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, ColumnType<Object>> x2) {
                ColumnType x;
                Tuple2<String, ColumnType<Object>> tuple2 = x2;
                boolean bl = tuple2 != null && (x = (ColumnType)tuple2._2()) instanceof ListType;
                return bl;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq tableMapColumnNames = (IndexedSeq)((TraversableLike)tableCollectionColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ColumnType<Object>> apply(ColumnDef c) {
                return new Tuple2((Object)c.columnName(), c.columnType());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<String, ColumnType<Object>>, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 != null) {
                    String name = (String)A1._1();
                    ColumnType x = (ColumnType)A1._2();
                    if (x instanceof MapType) {
                        object = name;
                        return (B1)object;
                    }
                }
                object = function1.apply(x3);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<String, ColumnType<Object>> x3) {
                ColumnType x;
                Tuple2<String, ColumnType<Object>> tuple2 = x3;
                boolean bl = tuple2 != null && (x = (ColumnType)tuple2._2()) instanceof MapType;
                return bl;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq refsWithCollectionBehavior = (IndexedSeq)columnRefs2.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends ColumnRef, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof CollectionColumnName) {
                    CollectionColumnName collectionColumnName = (CollectionColumnName)A1;
                    object = collectionColumnName;
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(ColumnRef x4) {
                ColumnRef columnRef = x4;
                boolean bl = columnRef instanceof CollectionColumnName;
                return bl;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq collectionBehaviorColumnNames = (IndexedSeq)refsWithCollectionBehavior.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(CollectionColumnName x$19) {
                return x$19.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set collectionBehaviorNormalColumn = (Set)collectionBehaviorColumnNames.toSet().$minus$minus((GenTraversableOnce)tableCollectionColumnNames.toSet());
        if (collectionBehaviorNormalColumn.nonEmpty()) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Collection behaviors (add/remove/append/prepend) are only allowed on collection columns.\n           |Normal Columns with illegal behavior: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{collectionBehaviorNormalColumn.mkString()})))).stripMargin());
        }
        IndexedSeq prependBehaviorColumnNames = (IndexedSeq)((TraversableLike)refsWithCollectionBehavior.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CollectionColumnName x$20) {
                CollectionBehavior collectionBehavior = x$20.collectionBehavior();
                CollectionPrepend$ collectionPrepend$ = CollectionPrepend$.MODULE$;
                return !(collectionBehavior != null ? !collectionBehavior.equals(collectionPrepend$) : collectionPrepend$ != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(CollectionColumnName x$21) {
                return x$21.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set prependOnNonList = (Set)prependBehaviorColumnNames.toSet().$minus$minus((GenTraversableOnce)tableListColumnNames.toSet());
        if (prependOnNonList.nonEmpty()) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The prepend collection behavior only applies to Lists. Prepend used on:\n           |", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prependOnNonList.mkString()})))).stripMargin());
        }
        IndexedSeq removeBehaviorColumnNames = (IndexedSeq)((TraversableLike)refsWithCollectionBehavior.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CollectionColumnName x$22) {
                CollectionBehavior collectionBehavior = x$22.collectionBehavior();
                CollectionRemove$ collectionRemove$ = CollectionRemove$.MODULE$;
                return !(collectionBehavior != null ? !collectionBehavior.equals(collectionRemove$) : collectionRemove$ != null);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(CollectionColumnName x$23) {
                return x$23.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Set removeOnMap = (Set)removeBehaviorColumnNames.toSet().$amp((GenSet)tableMapColumnNames.toSet());
        if (removeOnMap.nonEmpty()) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The remove operation is currently not supported for Maps. Remove used on: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{removeOnMap.mkString()})));
        }
    }

    private void checkColumns(TableDef table, IndexedSeq<ColumnRef> columnRefs2) {
        IndexedSeq columnNames2 = (IndexedSeq)columnRefs2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnRef x$24) {
                return x$24.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.checkMissingColumns(table, (Seq<String>)columnNames2);
        this.checkMissingPrimaryKeyColumns(table, (Seq<String>)columnNames2);
        this.checkCollectionBehaviors(table, columnRefs2);
    }

    public <T> TableWriter<T> apply(CassandraConnector connector, String keyspaceName, String tableName, ColumnSelector columnNames2, WriteConf writeConf, RowWriterFactory<T> evidence$1) {
        TableDef tableDef = Schema$.MODULE$.tableFromCassandra(connector, keyspaceName, tableName);
        IndexedSeq<ColumnRef> selectedColumns = columnNames2.selectFrom(tableDef);
        Seq optionColumns = (Seq)writeConf.optionsAsColumns().apply((Object)keyspaceName, (Object)tableName);
        Seq x$31 = (Seq)tableDef.regularColumns().$plus$plus((GenTraversableOnce)optionColumns, Seq$.MODULE$.canBuildFrom());
        String x$32 = tableDef.copy$default$1();
        String x$33 = tableDef.copy$default$2();
        Seq<ColumnDef> x$34 = tableDef.copy$default$3();
        Seq<ColumnDef> x$35 = tableDef.copy$default$4();
        Seq<IndexDef> x$36 = tableDef.copy$default$6();
        boolean x$37 = tableDef.copy$default$7();
        RowWriter rowWriter = ((RowWriterFactory)Predef$.MODULE$.implicitly(evidence$1)).rowWriter(tableDef.copy(x$32, x$33, x$34, x$35, (Seq<ColumnDef>)x$31, x$36, x$37), (IndexedSeq<ColumnRef>)((IndexedSeq)selectedColumns.$plus$plus((GenTraversableOnce)optionColumns.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ColumnRef apply(ColumnDef x$25) {
                return x$25.ref();
            }
        }, Seq$.MODULE$.canBuildFrom()), IndexedSeq$.MODULE$.canBuildFrom())));
        this.checkColumns(tableDef, selectedColumns);
        return new TableWriter(connector, tableDef, selectedColumns, rowWriter, writeConf);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private TableWriter$() {
        MODULE$ = this;
    }
}

