/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.AuthConfFactory;
import com.datastax.spark.connector.cql.AuthConfFactory$;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.DefaultAuthConfFactory$;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.util.ConfigParameter;
import com.datastax.spark.connector.writer.WriteConf$;
import org.apache.spark.sql.cassandra.CassandraSourceOptions;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.TableRef;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;

public final class DefaultSource$ {
    public static final DefaultSource$ MODULE$;
    private final String CassandraDataSourceTableNameProperty;
    private final String CassandraDataSourceKeyspaceNameProperty;
    private final String CassandraDataSourceClusterNameProperty;
    private final String CassandraDataSourceUserDefinedSchemaNameProperty;
    private final String CassandraDataSourcePushdownEnableProperty;
    private final String CassandraDataSourceProviderPackageName;
    private final String CassandraDataSourceProviderClassName;
    private final Set<String> confProperties;

    static {
        new DefaultSource$();
    }

    public String CassandraDataSourceTableNameProperty() {
        return this.CassandraDataSourceTableNameProperty;
    }

    public String CassandraDataSourceKeyspaceNameProperty() {
        return this.CassandraDataSourceKeyspaceNameProperty;
    }

    public String CassandraDataSourceClusterNameProperty() {
        return this.CassandraDataSourceClusterNameProperty;
    }

    public String CassandraDataSourceUserDefinedSchemaNameProperty() {
        return this.CassandraDataSourceUserDefinedSchemaNameProperty;
    }

    public String CassandraDataSourcePushdownEnableProperty() {
        return this.CassandraDataSourcePushdownEnableProperty;
    }

    public String CassandraDataSourceProviderPackageName() {
        return this.CassandraDataSourceProviderPackageName;
    }

    public String CassandraDataSourceProviderClassName() {
        return this.CassandraDataSourceProviderClassName;
    }

    public Tuple2<TableRef, CassandraSourceOptions> TableRefAndOptions(Map<String, String> parameters) {
        String tableName = (String)parameters.apply((Object)this.CassandraDataSourceTableNameProperty());
        String keyspaceName = (String)parameters.apply((Object)this.CassandraDataSourceKeyspaceNameProperty());
        Option clusterName = parameters.get((Object)this.CassandraDataSourceClusterNameProperty());
        boolean pushdown = new StringOps(Predef$.MODULE$.augmentString((String)parameters.getOrElse((Object)this.CassandraDataSourcePushdownEnableProperty(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "true";
            }
        }))).toBoolean();
        Map<String, String> cassandraConfs = this.buildConfMap(parameters);
        return new Tuple2((Object)new TableRef(tableName, keyspaceName, (Option<String>)clusterName), (Object)new CassandraSourceOptions(pushdown, cassandraConfs));
    }

    public Set<String> confProperties() {
        return this.confProperties;
    }

    public Map<String, String> buildConfMap(Map<String, String> parameters) {
        return parameters.filterKeys((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String elem) {
                return DefaultSource$.MODULE$.confProperties().contains((Object)elem);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean cassandraSource(String provider) {
        String string = provider;
        String string2 = this.CassandraDataSourceProviderPackageName();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = provider;
        String string4 = this.CassandraDataSourceProviderClassName();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private DefaultSource$() {
        MODULE$ = this;
        this.CassandraDataSourceTableNameProperty = "table";
        this.CassandraDataSourceKeyspaceNameProperty = "keyspace";
        this.CassandraDataSourceClusterNameProperty = "cluster";
        this.CassandraDataSourceUserDefinedSchemaNameProperty = "schema";
        this.CassandraDataSourcePushdownEnableProperty = "pushdown";
        this.CassandraDataSourceProviderPackageName = this.getClass().getPackage().getName();
        this.CassandraDataSourceProviderClassName = new StringBuilder().append((Object)this.CassandraDataSourceProviderPackageName()).append((Object)".DefaultSource").toString();
        this.confProperties = (Set)((SetLike)ReadConf$.MODULE$.Properties().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigParameter<? super Object> x$4) {
                return x$4.name();
            }
        }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)WriteConf$.MODULE$.Properties().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigParameter<?> x$5) {
                return x$5.name();
            }
        }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)CassandraConnectorConf$.MODULE$.Properties().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigParameter<?> x$6) {
                return x$6.name();
            }
        }, Set$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)CassandraSourceRelation$.MODULE$.Properties().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigParameter<? extends Product> x$7) {
                return x$7.name();
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)AuthConfFactory$.MODULE$.Properties().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ConfigParameter<AuthConfFactory> x$8) {
                return x$8.name();
            }
        }, Set$.MODULE$.canBuildFrom())).$plus$plus(DefaultAuthConfFactory$.MODULE$.properties());
    }
}

