/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.bdp.hadoop.hive.metastore;

import com.datastax.bdp.hadoop.hive.metastore.CatalogTableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;

public class TableOrViewMetadata
implements CatalogTableMetadata {
    private RelationMetadata metadata;

    public TableOrViewMetadata(TableMetadata tableMetadata) {
        this.metadata = tableMetadata;
    }

    public TableOrViewMetadata(ViewMetadata viewMetadata) {
        this.metadata = viewMetadata;
    }

    @Override
    public String getTableName() {
        return this.metadata.getName().asInternal();
    }

    @Override
    public String getDbName() {
        return this.metadata.getKeyspace().asInternal();
    }

    public String getKeyspace() {
        return this.metadata.getKeyspace().asInternal();
    }

    @Override
    public String getSourceProvider() {
        return "org.apache.spark.sql.cassandra";
    }

    @Override
    public SerDeInfo getSerDeInfo() {
        SerDeInfo serDeInfo = new SerDeInfo();
        serDeInfo.putToParameters("table", this.getTableName());
        serDeInfo.putToParameters("keyspace", this.getDbName());
        serDeInfo.putToParameters("pushdown", "true");
        return serDeInfo;
    }
}

