/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.writer.RateLimiter$;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0001\u0002\u0001\u001b\tY!+\u0019;f\u0019&l\u0017\u000e^3s\u0015\t\u0019A!\u0001\u0004xe&$XM\u001d\u0006\u0003\u000b\u0019\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003!!\u0017\r^1ti\u0006D(\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001qA\u0003\u0005\u0002\u0010%5\t\u0001CC\u0001\u0012\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0002C\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fUI!A\u0006\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011a\u0001!\u0011!Q\u0001\ne\tAA]1uKB\u0011qBG\u0005\u00037A\u0011A\u0001T8oO\"AQ\u0004\u0001B\u0001B\u0003%\u0011$\u0001\u0006ck\u000e\\W\r^*ju\u0016D\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001I\u0001\u0005i&lW\rE\u0002\u0010CeI!A\t\t\u0003\u0013\u0019+hn\u0019;j_:\u0004\u0004\u0002\u0003\u0013\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u000bMdW-\u001a9\u0011\t=1\u0013\u0004K\u0005\u0003OA\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005=I\u0013B\u0001\u0016\u0011\u0005\r\te.\u001f\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9\u0002\u0014GM\u001a\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000baY\u0003\u0019A\r\t\u000buY\u0003\u0019A\r\t\u000f}Y\u0003\u0013!a\u0001A!9Ae\u000bI\u0001\u0002\u0004)\u0003\u0002C\u001b\u0001\u0005\u0004%\tA\u0001\u001c\u0002\u0015\t,8m[3u\r&dG.F\u00018!\tA\u0014)D\u0001:\u0015\tQ4(\u0001\u0004bi>l\u0017n\u0019\u0006\u0003yu\n!bY8oGV\u0014(/\u001a8u\u0015\tqt(\u0001\u0003vi&d'\"\u0001!\u0002\t)\fg/Y\u0005\u0003\u0005f\u0012!\"\u0011;p[&\u001cGj\u001c8h\u0011\u0019!\u0005\u0001)A\u0005o\u0005Y!-^2lKR4\u0015\u000e\u001c7!\u0011!1\u0005A1A\u0005\u0002\t1\u0014\u0001\u00037bgR$\u0016.\\3\t\r!\u0003\u0001\u0015!\u00038\u0003%a\u0017m\u001d;US6,\u0007\u0005C\u0003K\u0001\u0011%1*\u0001\u0003mK\u0006\\GC\u0001'P!\tyQ*\u0003\u0002O!\t!QK\\5u\u0011\u0015\u0001\u0016\n1\u0001\u001a\u0003\u0019!x\u000eT3bW\"\u0012\u0011J\u0015\t\u0003'Zk\u0011\u0001\u0016\u0006\u0003+B\t!\"\u00198o_R\fG/[8o\u0013\t9FKA\u0004uC&d'/Z2\t\r)\u0003A\u0011\u0001\u0002Z)\u0005a\u0005\"B.\u0001\t\u0003a\u0016AC7bs\n,7\u000b\\3faR\u0011A*\u0018\u0005\u0006=j\u0003\r!G\u0001\u000ba\u0006\u001c7.\u001a;TSj,wa\u00021\u0003\u0003\u0003E\t!Y\u0001\f%\u0006$X\rT5nSR,'\u000f\u0005\u00020E\u001a9\u0011AAA\u0001\u0012\u0003\u00197c\u00012\u000f)!)AF\u0019C\u0001KR\t\u0011\rC\u0004hEF\u0005I\u0011\u00015\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\u0005I'F\u0001\u0011kW\u0005Y\u0007C\u00017p\u001b\u0005i'B\u00018U\u0003%)hn\u00195fG.,G-\u0003\u0002q[\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fI\u0014\u0017\u0013!C\u0001g\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\u0012\u0001\u001e\u0016\u0003K)DqA\u001e2\u0002\u0002\u0013%q/A\u0006sK\u0006$'+Z:pYZ,G#\u0001=\u0011\u0005edX\"\u0001>\u000b\u0005m|\u0014\u0001\u00027b]\u001eL!! >\u0003\r=\u0013'.Z2u\u0001")
public class RateLimiter
implements Serializable {
    private final long rate;
    private final long bucketSize;
    private final Function0<Object> time;
    private final Function1<Object, Object> sleep;
    private final AtomicLong bucketFill;
    private final AtomicLong lastTime;

    public static Function1<Object, Object> $lessinit$greater$default$4() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$4();
    }

    public static Function0<Object> $lessinit$greater$default$3() {
        return RateLimiter$.MODULE$.$lessinit$greater$default$3();
    }

    public AtomicLong bucketFill() {
        return this.bucketFill;
    }

    public AtomicLong lastTime() {
        return this.lastTime;
    }

    private void leak(long toLeak) {
        while (true) {
            long fill = this.bucketFill().get();
            long reallyToLeak = package$.MODULE$.min(fill, toLeak);
            if (!this.bucketFill().compareAndSet(fill, fill - reallyToLeak)) continue;
            return;
        }
    }

    public void leak() {
        long currentTime = this.time.apply$mcJ$sp();
        long prevTime = this.lastTime().getAndSet(currentTime);
        long elapsedTime = package$.MODULE$.max(currentTime - prevTime, 0L);
        this.leak(elapsedTime * this.rate / 1000L);
    }

    public void maybeSleep(long packetSize) {
        this.leak();
        long currentFill = this.bucketFill().addAndGet(packetSize);
        long overflow = currentFill - this.bucketSize;
        long delay = 1000L * overflow / this.rate;
        if (delay > 0L) {
            this.sleep.apply((Object)BoxesRunTime.boxToLong((long)delay));
        }
    }

    public RateLimiter(long rate, long bucketSize, Function0<Object> time, Function1<Object, Object> sleep) {
        this.rate = rate;
        this.bucketSize = bucketSize;
        this.time = time;
        this.sleep = sleep;
        Predef$.MODULE$.require(rate > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A positive rate is required";
            }
        });
        Predef$.MODULE$.require(bucketSize > 0L, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "A positive bucket size is required";
            }
        });
        this.bucketFill = new AtomicLong(0L);
        this.lastTime = new AtomicLong(time.apply$mcJ$sp());
    }
}

