/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.Auto;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.DseSearchOptimizationSetting;
import org.apache.spark.sql.cassandra.Off$;
import org.apache.spark.sql.cassandra.On$;
import org.apache.spark.sql.cassandra.SolrConstants$;
import org.apache.spark.sql.cassandra.SolrPredicateRules$;
import org.apache.spark.sql.cassandra.SolrPredicateRules$SolrFilter$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.collection.mutable.WrappedArray;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\t=d\u0001B\u0001\u0003\u00015\u0011!cU8meB\u0013X\rZ5dCR,'+\u001e7fg*\u00111\u0001B\u0001\nG\u0006\u001c8/\u00198ee\u0006T!!\u0002\u0004\u0002\u0007M\fHN\u0003\u0002\b\u0011\u0005)1\u000f]1sW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\b\u00151A\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t1\u0011I\\=SK\u001a\u0004\"!\u0006\f\u000e\u0003\tI!a\u0006\u0002\u0003/\r\u000b7o]1oIJ\f\u0007K]3eS\u000e\fG/\u001a*vY\u0016\u001c\bCA\r$\u001b\u0005Q\"BA\u000e\u001d\u0003\u0011)H/\u001b7\u000b\u0005uq\u0012!C2p]:,7\r^8s\u0015\t9qD\u0003\u0002!C\u0005AA-\u0019;bgR\f\u0007PC\u0001#\u0003\r\u0019w.\\\u0005\u0003Ii\u0011q\u0001T8hO&tw\r\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003e\u0019X-\u0019:dQ>\u0003H/[7ju\u0006$\u0018n\u001c8F]\u0006\u0014G.\u001a3\u0011\u0005UA\u0013BA\u0015\u0003\u0005q!5/Z*fCJ\u001c\u0007n\u00149uS6L'0\u0019;j_:\u001cV\r\u001e;j]\u001eDQa\u000b\u0001\u0005\u00021\na\u0001P5oSRtDCA\u0017/!\t)\u0002\u0001C\u0003'U\u0001\u0007q\u0005\u0003\u00041\u0001\u0011\u0005!!M\u0001\u0006CB\u0004H.\u001f\u000b\u0006eU:t(\u0012\t\u0003+MJ!\u0001\u000e\u0002\u0003%\u0005s\u0017\r\\={K\u0012\u0004&/\u001a3jG\u0006$Xm\u001d\u0005\u0006m=\u0002\rAM\u0001\u000baJ,G-[2bi\u0016\u001c\b\"\u0002\u001d0\u0001\u0004I\u0014\u0001\u0003;bE2,G)\u001a4\u0011\u0005ijT\"A\u001e\u000b\u0005qb\u0012aA2rY&\u0011ah\u000f\u0002\t)\u0006\u0014G.\u001a#fM\")\u0001i\fa\u0001\u0003\u0006I1\u000f]1sW\u000e{gN\u001a\t\u0003\u0005\u000ek\u0011AB\u0005\u0003\t\u001a\u0011\u0011b\u00159be.\u001cuN\u001c4\t\u000b\u0019{\u0003\u0019A$\u0002+\u001d,GoU8me&sG-\u001a=fI\u000e{G.^7ogB)q\u0002S\u001dB\u0015&\u0011\u0011\n\u0005\u0002\n\rVt7\r^5p]J\u00022a\u0013(R\u001d\tyA*\u0003\u0002N!\u00051\u0001K]3eK\u001aL!a\u0014)\u0003\u0007M+GO\u0003\u0002N!A\u00111JU\u0005\u0003'B\u0013aa\u0015;sS:<\u0007\"\u0002\u0019\u0001\t\u0003*F\u0003\u0002\u001aW/bCQA\u000e+A\u0002IBQ\u0001\u000f+A\u0002eBQ\u0001\u0011+A\u0002\u0005CQA\u0017\u0001\u0005\u0002m\u000b\u0001eZ3u'>d'/\u00138eKb,GmQ8mk6t7O\u0012:p[N{GN\u001d-N\u0019R\u0019!\nX/\t\u000baJ\u0006\u0019A\u001d\t\u000b\u0001K\u0006\u0019A!\t\u000b}\u0003A\u0011\u00011\u00021\u0005d'/Z1es\u000e{g\u000e^1j]N\u001cv\u000e\u001c:Rk\u0016\u0014\u0018\u0010\u0006\u0002bIB\u0011qBY\u0005\u0003GB\u0011qAQ8pY\u0016\fg\u000eC\u00037=\u0002\u0007!\u0007C\u0003g\u0001\u0011\u0005q-A\njg\u000e{gN^3si&\u0014G.\u001a+p'>d'\u000fF\u0002bQBDQ![3A\u0002)\faAZ5mi\u0016\u0014\bCA6o\u001b\u0005a'BA7\u0005\u0003\u001d\u0019x.\u001e:dKNL!a\u001c7\u0003\r\u0019KG\u000e^3s\u0011\u0015\tX\r1\u0001K\u0003-Ig\u000eZ3yK\u0012\u001cu\u000e\\:\u0007\tM\u0004\u0001\t\u001e\u0002\u000b'>d'OR5mi\u0016\u00148\u0003\u0002:kkb\u0004\"a\u0004<\n\u0005]\u0004\"a\u0002)s_\u0012,8\r\u001e\t\u0003\u001feL!A\u001f\t\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011q\u0014(Q3A\u0005\u0002u\f\u0011b]8meF+XM]=\u0016\u0003EC\u0001b :\u0003\u0012\u0003\u0006I!U\u0001\u000bg>d'/U;fef\u0004\u0003BCA\u0002e\nU\r\u0011\"\u0001\u0002\u0006\u0005Q!/\u001a4fe\u0016t7-Z:\u0016\u0005\u0005\u001d\u0001\u0003B\b\u0002\nEK1!a\u0003\u0011\u0005\u0015\t%O]1z\u0011)\tyA\u001dB\tB\u0003%\u0011qA\u0001\fe\u00164WM]3oG\u0016\u001c\b\u0005\u0003\u0004,e\u0012\u0005\u00111\u0003\u000b\u0007\u0003+\tI\"a\u0007\u0011\u0007\u0005]!/D\u0001\u0001\u0011\u0019a\u0018\u0011\u0003a\u0001#\"A\u00111AA\t\u0001\u0004\t9\u0001C\u0005\u0002 I\f\t\u0011\"\u0001\u0002\"\u0005!1m\u001c9z)\u0019\t)\"a\t\u0002&!AA0!\b\u0011\u0002\u0003\u0007\u0011\u000b\u0003\u0006\u0002\u0004\u0005u\u0001\u0013!a\u0001\u0003\u000fA\u0011\"!\u000bs#\u0003%\t!a\u000b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0006\u0016\u0004#\u0006=2FAA\u0019!\u0011\t\u0019$!\u0010\u000e\u0005\u0005U\"\u0002BA\u001c\u0003s\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005m\u0002#\u0001\u0006b]:|G/\u0019;j_:LA!a\u0010\u00026\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\r#/%A\u0005\u0002\u0005\u0015\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003\u000fRC!a\u0002\u00020!I\u00111\n:\u0002\u0002\u0013\u0005\u0013QJ\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005=\u0003\u0003BA)\u00037j!!a\u0015\u000b\t\u0005U\u0013qK\u0001\u0005Y\u0006twM\u0003\u0002\u0002Z\u0005!!.\u0019<b\u0013\r\u0019\u00161\u000b\u0005\n\u0003?\u0012\u0018\u0011!C\u0001\u0003C\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a\u0019\u0011\u0007=\t)'C\u0002\u0002hA\u00111!\u00138u\u0011%\tYG]A\u0001\n\u0003\ti'\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005=\u0014Q\u000f\t\u0004\u001f\u0005E\u0014bAA:!\t\u0019\u0011I\\=\t\u0015\u0005]\u0014\u0011NA\u0001\u0002\u0004\t\u0019'A\u0002yIEB\u0011\"a\u001fs\u0003\u0003%\t%! \u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a \u0011\r\u0005\u0005\u0015qQA8\u001b\t\t\u0019IC\u0002\u0002\u0006B\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\tI)a!\u0003\u0011%#XM]1u_JD\u0011\"!$s\u0003\u0003%\t!a$\u0002\u0011\r\fg.R9vC2$2!YAI\u0011)\t9(a#\u0002\u0002\u0003\u0007\u0011q\u000e\u0005\n\u0003+\u0013\u0018\u0011!C!\u0003/\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003GB\u0011\"a's\u0003\u0003%\t%!(\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0014\t\u0013\u0005\u0005&/!A\u0005B\u0005\r\u0016AB3rk\u0006d7\u000fF\u0002b\u0003KC!\"a\u001e\u0002 \u0006\u0005\t\u0019AA8\u000f%\tI\u000bAA\u0001\u0012\u0003\tY+\u0001\u0006T_2\u0014h)\u001b7uKJ\u0004B!a\u0006\u0002.\u001aA1\u000fAA\u0001\u0012\u0003\tykE\u0003\u0002.\u0006E\u0006\u0010E\u0005\u00024\u0006e\u0016+a\u0002\u0002\u00165\u0011\u0011Q\u0017\u0006\u0004\u0003o\u0003\u0012a\u0002:v]RLW.Z\u0005\u0005\u0003w\u000b)LA\tBEN$(/Y2u\rVt7\r^5p]JBqaKAW\t\u0003\ty\f\u0006\u0002\u0002,\"Q\u00111TAW\u0003\u0003%)%!(\t\u0013A\ni+!A\u0005\u0002\u0006\u0015GCBA\u000b\u0003\u000f\fI\r\u0003\u0004}\u0003\u0007\u0004\r!\u0015\u0005\t\u0003\u0007\t\u0019\r1\u0001\u0002\b!Q\u0011QZAW\u0003\u0003%\t)a4\u0002\u000fUt\u0017\r\u001d9msR!\u0011\u0011[Ao!\u0015y\u00111[Al\u0013\r\t)\u000e\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\r=\tI.UA\u0004\u0013\r\tY\u000e\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\u0005}\u00171ZA\u0001\u0002\u0004\t)\"A\u0002yIABq!a9\u0001\t\u0003\t)/\u0001\u0007u_N{GN]*ue&tw\rF\u0002R\u0003OD\u0001\"!;\u0002b\u0002\u0007\u0011qN\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003[\u0004A\u0011AAx\u0003M\u0019wN\u001c<feR$vnU8me\u001aKG\u000e^3s)\u0011\t)\"!=\t\r%\fY\u000f1\u0001k\u0011\u001d\t)\u0010\u0001C\u0001\u0003o\f!dZ3u!\u0006\u0014H/\u001b;j_:\\U-\u001f*fgR\u0014\u0018n\u0019;j_:$b!!?\u0003\u0002\t\r\u0001\u0003B&O\u0003w\u00042a[A\u007f\u0013\r\ty\u0010\u001c\u0002\b\u000bF,\u0018\r\u001c+p\u0011\u00191\u00141\u001fa\u0001e!1\u0001(a=A\u0002eBqAa\u0002\u0001\t\u0003\u0011I!A\u000bgS:$Wk]3mKN\u001c\u0018j\u001d(pi:+H\u000e\\:\u0015\r\t-!1\u0003B\r!\u0011YeJ!\u0004\u0011\u0007-\u0014y!C\u0002\u0003\u00121\u0014\u0011\"S:O_RtU\u000f\u001c7\t\u0011\tU!Q\u0001a\u0001\u0005/\tqAZ5mi\u0016\u00148\u000fE\u0002L\u001d*Da\u0001\u000fB\u0003\u0001\u0004I\u0004b\u0002B\u000f\u0001\u0011\u0005!qD\u0001\u0013G>tg/\u001a:u)>\u001cv\u000e\u001c:Rk\u0016\u0014\u0018\u0010F\u00063\u0005C\u0011\u0019C!\n\u0003*\t-\u0002B\u0002\u001c\u0003\u001c\u0001\u0007!\u0007\u0003\u00049\u00057\u0001\r!\u000f\u0005\b\u0005O\u0011Y\u00021\u0001K\u0003E\u0019x\u000e\u001c:J]\u0012,\u00070\u001a3GS\u0016dGm\u001d\u0005\u0007M\tm\u0001\u0019A\u0014\t\r\u0001\u0013Y\u00021\u0001B\u0011%\u0011y\u0003\u0001b\u0001\n\u0013\u0011\t$A\nfg\u000e\f\u0007/\u00192mK^{'\u000f\u001a+pW\u0016t7/\u0006\u0002\u00034A)q\"!\u0003\u0002P!A!q\u0007\u0001!\u0002\u0013\u0011\u0019$\u0001\u000bfg\u000e\f\u0007/\u00192mK^{'\u000f\u001a+pW\u0016t7\u000f\t\u0005\n\u0005w\u0001!\u0019!C\u0005\u0005c\ta\"Z:dCB\f'\r\\3DQ\u0006\u00148\u000f\u0003\u0005\u0003@\u0001\u0001\u000b\u0011\u0002B\u001a\u0003=)7oY1qC\ndWm\u00115beN\u0004\u0003\"\u0003B\"\u0001\t\u0007I\u0011\u0002B\u0019\u0003Q)7oY1qC\ndWm\u00165ji\u0016\u001c\b/Y2fg\"A!q\t\u0001!\u0002\u0013\u0011\u0019$A\u000bfg\u000e\f\u0007/\u00192mK^C\u0017\u000e^3ta\u0006\u001cWm\u001d\u0011\t\u0013\t-\u0003A1A\u0005\n\t5\u0013AC3tG\u0006\u0004\u0018M\u00197fgV\u0011!q\n\t\u0005\u0005#\u0012I&\u0004\u0002\u0003T)!!Q\u000bB,\u0003\u0015\u0011XmZ3y\u0015\rY\u0012qK\u0005\u0005\u00057\u0012\u0019FA\u0004QCR$XM\u001d8\t\u0011\t}\u0003\u0001)A\u0005\u0005\u001f\n1\"Z:dCB\f'\r\\3tA!9!1\r\u0001\u0005\n\u0005\u0015\u0011!E3tG\u0006\u0004\u0018M\u00197f\u000b:$\u0018\u000e^5fg\"9!q\r\u0001\u0005\u0002\t%\u0014aE3tG\u0006\u0004XmU8me\u000e{g\u000eZ5uS>tGcA)\u0003l!9!Q\u000eB3\u0001\u0004\t\u0016!C2p]\u0012LG/[8o\u0001")
public class SolrPredicateRules
implements CassandraPredicateRules,
Logging {
    private final DseSearchOptimizationSetting searchOptimizationEnabled;
    private final String[] escapableWordTokens;
    private final String[] escapableChars;
    private final String[] escapableWhitespaces;
    private final Pattern escapables;
    private volatile SolrPredicateRules$SolrFilter$ SolrFilter$module;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SolrPredicateRules$SolrFilter$ SolrFilter$lzycompute() {
        SolrPredicateRules solrPredicateRules2 = this;
        synchronized (solrPredicateRules2) {
            if (this.SolrFilter$module != null) return this.SolrFilter$module;
            this.SolrFilter$module = new SolrPredicateRules$SolrFilter$(this);
            return this.SolrFilter$module;
        }
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf sparkConf, Function2<TableDef, SparkConf, scala.collection.immutable.Set<String>> getSolrIndexedColumns) {
        Option option;
        block4: {
            AnalyzedPredicates analyzedPredicates;
            block3: {
                AnalyzedPredicates usefulPredicates;
                block2: {
                    scala.collection.immutable.Set<IsNotNull> uselessIsNotNulls = this.findUselessIsNotNulls((scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark())), tableDef);
                    usefulPredicates = new AnalyzedPredicates(predicates.handledByCassandra(), (scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)predicates.handledBySpark().$minus$minus(uselessIsNotNulls)));
                    scala.collection.immutable.Set<EqualTo> pkRestriction = this.getPartitionKeyRestriction(usefulPredicates, tableDef);
                    boolean primaryKeyRestrictionExists = pkRestriction.nonEmpty() && pkRestriction.subsetOf(usefulPredicates.handledByCassandra()) && usefulPredicates.handledBySpark().isEmpty();
                    boolean solrEnabledOnTargetHosts = BoxesRunTime.unboxToBoolean(CassandraConnector$.MODULE$.apply(sparkConf).withSessionDo(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(CqlSession session) {
                            Iterable hosts2 = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(session.getMetadata().getNodes().values()).asScala();
                            Iterable possibleHosts = (Iterable)hosts2.filter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Node host) {
                                    NodeDistance nodeDistance = host.getDistance();
                                    NodeDistance nodeDistance2 = NodeDistance.IGNORED;
                                    return nodeDistance != null ? !nodeDistance.equals(nodeDistance2) : nodeDistance2 != null;
                                }
                            });
                            return possibleHosts.forall((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final boolean apply(Node host) {
                                    Option workloads = Option$.MODULE$.apply(host.getExtras().get("DSE_WORKLOADS"));
                                    return workloads.exists((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(Object x$1) {
                                            return ((Set)x$1).contains("Search");
                                        }
                                    });
                                }
                            });
                        }
                    }));
                    Option failedRequirement = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToBoolean((!solrEnabledOnTargetHosts ? 1 : 0) != 0), (Object)"Search is not enabled on DSE Target nodes."), new Tuple2((Object)BoxesRunTime.boxToBoolean((!this.searchOptimizationEnabled.enabled() ? 1 : 0) != 0), (Object)"Automatic Search optimizations for Spark SQL are disabled."), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)primaryKeyRestrictionExists), (Object)"There is a primary key restriction present"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.alreadyContainsSolrQuery(usefulPredicates)), (Object)"Manual Solr query (solr_query = xxx) present.")}))).collectFirst((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x1;
                            if (A1 != null) {
                                boolean bl = A1._1$mcZ$sp();
                                String reason = (String)A1._2();
                                if (bl) {
                                    object = reason;
                                    return (B1)object;
                                }
                            }
                            object = function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                            boolean bl;
                            Tuple2<Object, String> tuple2 = x1;
                            boolean bl2 = tuple2 != null && true == (bl = tuple2._1$mcZ$sp());
                            return bl2;
                        }
                    });
                    option = failedRequirement;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    String reasonForFailure = (String)some.x();
                    this.logDebug((Function0<String>)new Serializable(this, reasonForFailure){
                        public static final long serialVersionUID = 0L;
                        private final String reasonForFailure$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not using Solr Optimizations. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.reasonForFailure$1}));
                        }
                        {
                            this.reasonForFailure$1 = reasonForFailure$1;
                        }
                    });
                    analyzedPredicates = usefulPredicates;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                analyzedPredicates = this.convertToSolrQuery(usefulPredicates, tableDef, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)getSolrIndexedColumns.apply((Object)tableDef, (Object)sparkConf)), this.searchOptimizationEnabled, sparkConf);
            }
            return analyzedPredicates;
        }
        throw new MatchError((Object)option);
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf sparkConf) {
        return this.apply(predicates, tableDef, sparkConf, (Function2<TableDef, SparkConf, scala.collection.immutable.Set<String>>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SolrPredicateRules $outer;

            public final scala.collection.immutable.Set<String> apply(TableDef tableDef, SparkConf sparkConf) {
                return this.$outer.getSolrIndexedColumnsFromSolrXML(tableDef, sparkConf);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public scala.collection.immutable.Set<String> getSolrIndexedColumnsFromSolrXML(TableDef tableDef, SparkConf sparkConf) {
        Try try_;
        block7: {
            scala.collection.immutable.Set set;
            block6: {
                block2: {
                    Try try_2;
                    block5: {
                        scala.collection.immutable.Set set2;
                        block4: {
                            block3: {
                                scala.collection.immutable.Set indexed;
                                Success success;
                                String schema2;
                                String SelectSolrSchema = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT blobAsText(resource_value) FROM\n         |solr_admin.solr_resources\n         |where core_name = '", ".", "'\n         |and resource_name = 'schema.xml.bak' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableDef.keyspaceName(), tableDef.tableName()})))).stripMargin();
                                try_ = Try$.MODULE$.apply((Function0)new Serializable(this, sparkConf, SelectSolrSchema){
                                    public static final long serialVersionUID = 0L;
                                    private final SparkConf sparkConf$1;
                                    public final String SelectSolrSchema$1;

                                    public final String apply() {
                                        return ((GettableByIndex)((PagingIterable)CassandraConnector$.MODULE$.apply(this.sparkConf$1).withSessionDo(new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ $anonfun$7 $outer;

                                            public final ResultSet apply(CqlSession x$2) {
                                                return x$2.execute(this.$outer.SelectSolrSchema$1);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        })).one()).getString(0);
                                    }
                                    {
                                        this.sparkConf$1 = sparkConf$1;
                                        this.SelectSolrSchema$1 = SelectSolrSchema$1;
                                    }
                                });
                                if (!(try_ instanceof Success) || (schema2 = (String)(success = (Success)try_).value()) == null) break block2;
                                String string = schema2;
                                try_2 = Try$.MODULE$.apply((Function0)new Serializable(this, string){
                                    public static final long serialVersionUID = 0L;
                                    private final String x4$1;

                                    public final scala.collection.immutable.Set<String> apply() {
                                        Elem schemaXML = (Elem)XML$.MODULE$.loadString(this.x4$1);
                                        return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)((scala.xml.Node)((IterableLike)schemaXML.child().filter((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(scala.xml.Node x$3) {
                                                String string = x$3.label();
                                                String string2 = "fields";
                                                return !(string != null ? !string.equals(string2) : string2 != null);
                                            }
                                        })).head()).child().filter((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(scala.xml.Node x) {
                                                String string = x.label();
                                                String string2 = "field";
                                                return !(string != null ? !string.equals(string2) : string2 != null);
                                            }
                                        })).filter((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(scala.xml.Node x$4) {
                                                return !new StringOps(Predef$.MODULE$.augmentString((String)x$4.attributes().asAttrMap().getOrElse((Object)"multiValued", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "false";
                                                    }
                                                }))).toBoolean();
                                            }
                                        })).filter((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final boolean apply(scala.xml.Node x$5) {
                                                return new StringOps(Predef$.MODULE$.augmentString((String)x$5.attributes().asAttrMap().getOrElse((Object)"indexed", (Function0)new Serializable(this){
                                                    public static final long serialVersionUID = 0L;

                                                    public final String apply() {
                                                        return "false";
                                                    }
                                                }))).toBoolean();
                                            }
                                        })).map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(scala.xml.Node x$6) {
                                                return ((SeqLike)x$6.attribute("name").get()).toString();
                                            }
                                        }, Seq$.MODULE$.canBuildFrom())).toSet();
                                    }
                                    {
                                        this.x4$1 = x4$1;
                                    }
                                });
                                if (!(try_2 instanceof Success)) break block3;
                                Success success2 = (Success)try_2;
                                set2 = indexed = (scala.collection.immutable.Set)success2.value();
                                break block4;
                            }
                            if (!(try_2 instanceof Failure)) break block5;
                            Failure failure = (Failure)try_2;
                            Throwable e = failure.exception();
                            set2 = this.solrIndexedFail$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse schema.xml.bak: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
                        }
                        set = set2;
                        break block6;
                    }
                    throw new MatchError((Object)try_2);
                }
                if (!(try_ instanceof Failure)) break block7;
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                set = this.solrIndexedFail$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to access Solr Info: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e})));
            }
            return set;
        }
        throw new MatchError((Object)try_);
    }

    public boolean alreadyContainsSolrQuery(AnalyzedPredicates predicates) {
        return ((TraversableOnce)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark()).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    String column = equalTo.attribute();
                    Object value2 = equalTo.value();
                    String string = column;
                    String string2 = SolrConstants$.MODULE$.SolrQuery();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = new EqualTo(column, value2);
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Filter x2) {
                String column;
                Filter filter = x2;
                if (!(filter instanceof EqualTo)) return false;
                EqualTo equalTo = (EqualTo)filter;
                String string = column = equalTo.attribute();
                String string2 = SolrConstants$.MODULE$.SolrQuery();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
        }, Set$.MODULE$.canBuildFrom())).nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConvertibleToSolr(Filter filter, scala.collection.immutable.Set<String> indexedCols) {
        Not not;
        Filter child;
        IsNotNull isNotNull;
        String attr;
        IsNull isNull;
        String attr2;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr3 = equalTo.attribute();
            Object value2 = equalTo.value();
            if (attr3 != null) {
                String string = attr3;
                if (value2 instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attr4 = equalNullSafe.attribute();
            Object value3 = equalNullSafe.value();
            if (attr4 != null) {
                String string = attr4;
                if (value3 instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attr5 = in.attribute();
            Object[] values = in.values();
            if (attr5 != null) {
                String string = attr5;
                if (values != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr6 = greaterThan.attribute();
            Object value4 = greaterThan.value();
            if (attr6 != null) {
                String string = attr6;
                if (value4 instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr7 = greaterThanOrEqual.attribute();
            Object value5 = greaterThanOrEqual.value();
            if (attr7 != null) {
                String string = attr7;
                if (value5 instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr8 = lessThan.attribute();
            Object value6 = lessThan.value();
            if (attr8 != null) {
                String string = attr8;
                if (value6 instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr9 = lessThanOrEqual.attribute();
            Object value7 = lessThanOrEqual.value();
            if (attr9 != null) {
                String string = attr9;
                if (value7 instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof IsNull && (attr2 = (isNull = (IsNull)filter2).attribute()) != null) {
            String string = attr2;
            return indexedCols.contains((Object)string);
        }
        if (filter2 instanceof IsNotNull && (attr = (isNotNull = (IsNotNull)filter2).attribute()) != null) {
            String string = attr;
            return indexedCols.contains((Object)string);
        }
        if (filter2 instanceof And) {
            And and2 = (And)filter2;
            Filter left = and2.left();
            Filter right = and2.right();
            if (left != null) {
                Filter filter3 = left;
                if (right != null) {
                    Filter filter4 = right;
                    if (!this.isConvertibleToSolr(filter3, indexedCols)) return false;
                    if (!this.isConvertibleToSolr(filter4, indexedCols)) return false;
                    return true;
                }
            }
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            if (left != null) {
                Filter filter5 = left;
                if (right != null) {
                    Filter filter6 = right;
                    if (!this.isConvertibleToSolr(filter5, indexedCols)) return false;
                    if (!this.isConvertibleToSolr(filter6, indexedCols)) return false;
                    return true;
                }
            }
        }
        if (filter2 instanceof Not && (child = (not = (Not)filter2).child()) != null) {
            Filter filter7 = child;
            return this.isConvertibleToSolr(filter7, indexedCols);
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr10 = stringStartsWith.attribute();
            String value8 = stringStartsWith.value();
            if (attr10 != null) {
                String string = attr10;
                if (value8 != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attr11 = stringEndsWith.attribute();
            String value9 = stringEndsWith.value();
            if (attr11 != null) {
                String string = attr11;
                if (value9 != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attr12 = stringContains.attribute();
            String value10 = stringContains.value();
            if (attr12 != null) {
                String string = attr12;
                if (value10 != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        this.logError((Function0<String>)new Serializable(this, filter2){
            public static final long serialVersionUID = 0L;
            private final Filter x1$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown Filter Type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.x1$1}));
            }
            {
                this.x1$1 = x1$1;
            }
        });
        return false;
    }

    public SolrPredicateRules$SolrFilter$ SolrFilter() {
        return this.SolrFilter$module == null ? this.SolrFilter$lzycompute() : this.SolrFilter$module;
    }

    public String toSolrString(Object value2) {
        String string;
        Object object = value2;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            string = DateTimeFormatter.ISO_INSTANT.format(timestamp.toInstant());
        } else {
            string = object.toString();
        }
        return StringEscapeUtils.escapeJson((String)this.escapeSolrCondition(string));
    }

    public SolrFilter convertToSolrFilter(Filter filter) {
        Filter filter2;
        block17: {
            SolrFilter solrFilter;
            block3: {
                block16: {
                    block15: {
                        block14: {
                            Not not;
                            Filter child;
                            block13: {
                                block12: {
                                    block11: {
                                        IsNotNull isNotNull;
                                        String attr;
                                        block10: {
                                            IsNull isNull;
                                            String attr2;
                                            block9: {
                                                block8: {
                                                    block7: {
                                                        block6: {
                                                            block5: {
                                                                block4: {
                                                                    block2: {
                                                                        filter2 = filter;
                                                                        if (!(filter2 instanceof EqualTo)) break block2;
                                                                        EqualTo equalTo = (EqualTo)filter2;
                                                                        String attr3 = equalTo.attribute();
                                                                        Object value2 = equalTo.value();
                                                                        if (attr3 == null) break block2;
                                                                        String string = attr3;
                                                                        if (!(value2 instanceof Object)) break block2;
                                                                        Object object = value2;
                                                                        solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(object)})), filter.references());
                                                                        break block3;
                                                                    }
                                                                    if (!(filter2 instanceof EqualNullSafe)) break block4;
                                                                    EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
                                                                    String attr4 = equalNullSafe.attribute();
                                                                    Object value3 = equalNullSafe.value();
                                                                    if (attr4 == null) break block4;
                                                                    String string = attr4;
                                                                    if (!(value3 instanceof Object)) break block4;
                                                                    Object object = value3;
                                                                    solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(object)})), filter.references());
                                                                    break block3;
                                                                }
                                                                if (!(filter2 instanceof In)) break block5;
                                                                In in = (In)filter2;
                                                                String attr5 = in.attribute();
                                                                Object[] values = in.values();
                                                                if (attr5 == null) break block5;
                                                                String string = attr5;
                                                                if (values == null) break block5;
                                                                Object[] objectArray = values;
                                                                solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1)new Serializable(this){
                                                                    public static final long serialVersionUID = 0L;
                                                                    private final /* synthetic */ SolrPredicateRules $outer;

                                                                    public final String apply(Object value2) {
                                                                        return this.$outer.toSolrString(value2);
                                                                    }
                                                                    {
                                                                        if ($outer == null) {
                                                                            throw null;
                                                                        }
                                                                        this.$outer = $outer;
                                                                    }
                                                                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString(" ")})), filter.references());
                                                                break block3;
                                                            }
                                                            if (!(filter2 instanceof GreaterThan)) break block6;
                                                            GreaterThan greaterThan = (GreaterThan)filter2;
                                                            String attr6 = greaterThan.attribute();
                                                            Object value4 = greaterThan.value();
                                                            if (attr6 == null) break block6;
                                                            String string = attr6;
                                                            if (!(value4 instanceof Object)) break block6;
                                                            Object object = value4;
                                                            solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":{", " TO *]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(object)})), filter.references());
                                                            break block3;
                                                        }
                                                        if (!(filter2 instanceof GreaterThanOrEqual)) break block7;
                                                        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
                                                        String attr7 = greaterThanOrEqual.attribute();
                                                        Object value5 = greaterThanOrEqual.value();
                                                        if (attr7 == null) break block7;
                                                        String string = attr7;
                                                        if (!(value5 instanceof Object)) break block7;
                                                        Object object = value5;
                                                        solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":[", " TO *]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(object)})), filter.references());
                                                        break block3;
                                                    }
                                                    if (!(filter2 instanceof LessThan)) break block8;
                                                    LessThan lessThan = (LessThan)filter2;
                                                    String attr8 = lessThan.attribute();
                                                    Object value6 = lessThan.value();
                                                    if (attr8 == null) break block8;
                                                    String string = attr8;
                                                    if (!(value6 instanceof Object)) break block8;
                                                    Object object = value6;
                                                    solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":[* TO ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(object)})), filter.references());
                                                    break block3;
                                                }
                                                if (!(filter2 instanceof LessThanOrEqual)) break block9;
                                                LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
                                                String attr9 = lessThanOrEqual.attribute();
                                                Object value7 = lessThanOrEqual.value();
                                                if (attr9 == null) break block9;
                                                String string = attr9;
                                                if (!(value7 instanceof Object)) break block9;
                                                Object object = value7;
                                                solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":[* TO ", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(object)})), filter.references());
                                                break block3;
                                            }
                                            if (!(filter2 instanceof IsNull) || (attr2 = (isNull = (IsNull)filter2).attribute()) == null) break block10;
                                            String string = attr2;
                                            solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-", ":[* TO *]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string)})), filter.references());
                                            break block3;
                                        }
                                        if (!(filter2 instanceof IsNotNull) || (attr = (isNotNull = (IsNotNull)filter2).attribute()) == null) break block11;
                                        String string = attr;
                                        solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string)})), filter.references());
                                        break block3;
                                    }
                                    if (!(filter2 instanceof And)) break block12;
                                    And and2 = (And)filter2;
                                    Filter left = and2.left();
                                    Filter right = and2.right();
                                    if (left == null) break block12;
                                    Filter filter3 = left;
                                    if (right == null) break block12;
                                    Filter filter4 = right;
                                    solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " AND ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.convertToSolrFilter(filter3).solrQuery(), this.convertToSolrFilter(filter4).solrQuery()})), filter.references());
                                    break block3;
                                }
                                if (!(filter2 instanceof Or)) break block13;
                                Or or = (Or)filter2;
                                Filter left = or.left();
                                Filter right = or.right();
                                if (left == null) break block13;
                                Filter filter5 = left;
                                if (right == null) break block13;
                                Filter filter6 = right;
                                solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", " OR ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.convertToSolrFilter(filter5).solrQuery(), this.convertToSolrFilter(filter6).solrQuery()})), filter.references());
                                break block3;
                            }
                            if (!(filter2 instanceof Not) || (child = (not = (Not)filter2).child()) == null) break block14;
                            Filter filter7 = child;
                            solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-(", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.convertToSolrFilter(filter7).solrQuery()})), filter.references());
                            break block3;
                        }
                        if (!(filter2 instanceof StringStartsWith)) break block15;
                        StringStartsWith stringStartsWith = (StringStartsWith)filter2;
                        String attr = stringStartsWith.attribute();
                        String value8 = stringStartsWith.value();
                        if (attr == null) break block15;
                        String string = attr;
                        if (value8 == null) break block15;
                        String string2 = value8;
                        solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", "*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(string2)})), filter.references());
                        break block3;
                    }
                    if (!(filter2 instanceof StringEndsWith)) break block16;
                    StringEndsWith stringEndsWith = (StringEndsWith)filter2;
                    String attr = stringEndsWith.attribute();
                    String value9 = stringEndsWith.value();
                    if (attr == null) break block16;
                    String string = attr;
                    if (value9 == null) break block16;
                    String string3 = value9;
                    solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":*", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(string3)})), filter.references());
                    break block3;
                }
                if (!(filter2 instanceof StringContains)) break block17;
                StringContains stringContains = (StringContains)filter2;
                String attr = stringContains.attribute();
                String value10 = stringContains.value();
                if (attr == null) break block17;
                String string = attr;
                if (value10 == null) break block17;
                String string4 = value10;
                solrFilter = new SolrFilter(this, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":*", "*"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.toSolrString(string), this.toSolrString(string4)})), filter.references());
            }
            return solrFilter;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " cannot be converted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{filter2})));
    }

    public scala.collection.immutable.Set<EqualTo> getPartitionKeyRestriction(AnalyzedPredicates predicates, TableDef tableDef) {
        scala.collection.immutable.Set partitionKeyRestrictions;
        scala.collection.immutable.Set equalsRestrictions = (scala.collection.immutable.Set)predicates.handledByCassandra().collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    object = equalTo;
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x3) {
                Filter filter = x3;
                boolean bl = filter instanceof EqualTo;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
        Map equalsRestrictionsByName = ((TraversableOnce)equalsRestrictions.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, EqualTo> apply(EqualTo eqClause) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)eqClause.attribute()), (Object)eqClause);
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Set partitionKeyColumnNames = ((TraversableOnce)tableDef.partitionKey().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$7) {
                return x$7.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        boolean partitionKeyFullyRestricted = ((SetLike)partitionKeyColumnNames.$minus$minus((GenTraversableOnce)(partitionKeyRestrictions = (scala.collection.immutable.Set)equalsRestrictions.filter((Function1)new Serializable(this, partitionKeyColumnNames){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set partitionKeyColumnNames$1;

            public final boolean apply(EqualTo x0$1) {
                EqualTo equalTo = x0$1;
                if (equalTo != null) {
                    String attr = equalTo.attribute();
                    boolean bl = this.partitionKeyColumnNames$1.contains((Object)attr);
                    return bl;
                }
                throw new MatchError((Object)equalTo);
            }
            {
                this.partitionKeyColumnNames$1 = partitionKeyColumnNames$1;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(EqualTo x$8) {
                return x$8.attribute();
            }
        }, Set$.MODULE$.canBuildFrom()))).isEmpty();
        return partitionKeyFullyRestricted ? partitionKeyRestrictions : Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<IsNotNull> findUselessIsNotNulls(scala.collection.immutable.Set<Filter> filters, TableDef tableDef) {
        IndexedSeq primaryKeyColumnNames = (IndexedSeq)tableDef.primaryKey().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$9) {
                return x$9.columnName();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Map isNotNullColumns = ((TraversableOnce)filters.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof IsNotNull) {
                    IsNotNull isNotNull = (IsNotNull)A1;
                    String attr = isNotNull.attribute();
                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)new IsNotNull(attr));
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x4) {
                Filter filter = x4;
                boolean bl = filter instanceof IsNotNull;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Set restrictedColumns = (scala.collection.immutable.Set)filters.collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x5;
                if (A1 instanceof LessThan) {
                    LessThan lessThan = (LessThan)A1;
                    String attr = lessThan.attribute();
                    object = attr;
                } else if (A1 instanceof LessThanOrEqual) {
                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)A1;
                    String attr = lessThanOrEqual.attribute();
                    object = attr;
                } else if (A1 instanceof GreaterThan) {
                    GreaterThan greaterThan = (GreaterThan)A1;
                    String attr = greaterThan.attribute();
                    object = attr;
                } else if (A1 instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)A1;
                    String attr = greaterThanOrEqual.attribute();
                    object = attr;
                } else if (A1 instanceof EqualNullSafe) {
                    EqualNullSafe equalNullSafe = (EqualNullSafe)A1;
                    String attr = equalNullSafe.attribute();
                    object = attr;
                } else if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    String attr = equalTo.attribute();
                    object = attr;
                } else {
                    object = function1.apply(x5);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x5) {
                Filter filter = x5;
                boolean bl = filter instanceof LessThan ? true : (filter instanceof LessThanOrEqual ? true : (filter instanceof GreaterThan ? true : (filter instanceof GreaterThanOrEqual ? true : (filter instanceof EqualNullSafe ? true : filter instanceof EqualTo))));
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set uselessIsNotNulls = ((TraversableOnce)((TraversableLike)primaryKeyColumnNames.$plus$plus((GenTraversableOnce)restrictedColumns, IndexedSeq$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this, isNotNullColumns){
            public static final long serialVersionUID = 0L;
            private final Map isNotNullColumns$1;

            public final Iterable<IsNotNull> apply(String attr) {
                return Option$.MODULE$.option2Iterable(this.isNotNullColumns$1.get((Object)attr));
            }
            {
                this.isNotNullColumns$1 = isNotNullColumns$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        this.logDebug((Function0<String>)new Serializable(this, uselessIsNotNulls){
            public static final long serialVersionUID = 0L;
            private final scala.collection.immutable.Set uselessIsNotNulls$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found isNotNulls ", " that are already not needed"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.uselessIsNotNulls$1}));
            }
            {
                this.uselessIsNotNulls$1 = uselessIsNotNulls$1;
            }
        });
        return uselessIsNotNulls;
    }

    public AnalyzedPredicates convertToSolrQuery(AnalyzedPredicates predicates, TableDef tableDef, scala.collection.immutable.Set<String> solrIndexedFields, DseSearchOptimizationSetting searchOptimizationEnabled, SparkConf sparkConf) {
        Tuple2 tuple2;
        block6: {
            DseSearchOptimizationSetting dseSearchOptimizationSetting;
            block13: {
                AnalyzedPredicates analyzedPredicates;
                block8: {
                    AnalyzedPredicates analyzedPredicates2;
                    block11: {
                        block12: {
                            AnalyzedPredicates optimizedPredicates;
                            EqualTo combinedSolrFilter;
                            scala.collection.immutable.Set solrConvertibleFilters;
                            block9: {
                                Tuple2 tuple22;
                                block10: {
                                    AnalyzedPredicates analyzedPredicates3;
                                    double queryRatio;
                                    Tuple2.mcJJ.sp sp2;
                                    String solrStringNoFailoverTolerant;
                                    String FaultTolerant;
                                    block7: {
                                        Tuple2 tuple23;
                                        scala.collection.immutable.Set possibleSolrPredicates;
                                        scala.collection.immutable.Set allPredicates = (scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark());
                                        scala.collection.immutable.Set<EqualTo> pkRestriction = this.getPartitionKeyRestriction(predicates, tableDef);
                                        if (pkRestriction.nonEmpty()) {
                                            this.logDebug((Function0<String>)new Serializable(this, pkRestriction){
                                                public static final long serialVersionUID = 0L;
                                                private final scala.collection.immutable.Set pkRestriction$1;

                                                public final String apply() {
                                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition restriction being withheld from Solr Conversion:  ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.pkRestriction$1}));
                                                }
                                                {
                                                    this.pkRestriction$1 = pkRestriction$1;
                                                }
                                            });
                                        }
                                        if ((tuple2 = (possibleSolrPredicates = (scala.collection.immutable.Set)allPredicates.$minus$minus(pkRestriction)).partition((Function1)new Serializable(this, solrIndexedFields){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ SolrPredicateRules $outer;
                                            private final scala.collection.immutable.Set solrIndexedFields$1;

                                            public final boolean apply(Filter x$10) {
                                                return this.$outer.isConvertibleToSolr(x$10, (scala.collection.immutable.Set<String>)this.solrIndexedFields$1);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                                this.solrIndexedFields$1 = solrIndexedFields$1;
                                            }
                                        })) == null) break block6;
                                        scala.collection.immutable.Set solrConvertibleFilters2 = (scala.collection.immutable.Set)tuple2._1();
                                        scala.collection.immutable.Set sparkFilters = (scala.collection.immutable.Set)tuple2._2();
                                        Tuple2 tuple24 = tuple23 = new Tuple2((Object)solrConvertibleFilters2, (Object)sparkFilters);
                                        solrConvertibleFilters = (scala.collection.immutable.Set)tuple24._1();
                                        scala.collection.immutable.Set sparkFilters2 = (scala.collection.immutable.Set)tuple24._2();
                                        this.logDebug((Function0<String>)new Serializable(this, solrConvertibleFilters){
                                            public static final long serialVersionUID = 0L;
                                            private final scala.collection.immutable.Set solrConvertibleFilters$1;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Converting ", " to Solr Predicates"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.solrConvertibleFilters$1}));
                                            }
                                            {
                                                this.solrConvertibleFilters$1 = solrConvertibleFilters$1;
                                            }
                                        });
                                        scala.collection.immutable.Set solrFilters = (scala.collection.immutable.Set)solrConvertibleFilters.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ SolrPredicateRules $outer;

                                            public final SolrFilter apply(Filter filter) {
                                                return this.$outer.convertToSolrFilter(filter);
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw null;
                                                }
                                                this.$outer = $outer;
                                            }
                                        }, Set$.MODULE$.canBuildFrom());
                                        String combinedFilterQuery = ((TraversableOnce)solrFilters.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply(SolrFilter x0$2) {
                                                SolrFilter solrFilter = x0$2;
                                                if (solrFilter != null) {
                                                    String query = solrFilter.solrQuery();
                                                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"", "\""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{query}));
                                                    return string;
                                                }
                                                throw new MatchError((Object)((Object)solrFilter));
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(", ");
                                        String solrString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"q\":\"*:*\", \"fq\":[", "]}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{combinedFilterQuery}));
                                        FaultTolerant = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"shards.failover\": false", "\"shards.tolerant\": true"}))).mkString(",");
                                        solrStringNoFailoverTolerant = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"q\":\"*:*\", \"fq\":[", "], ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{combinedFilterQuery, FaultTolerant}));
                                        combinedSolrFilter = new EqualTo(SolrConstants$.MODULE$.SolrQuery(), (Object)solrString);
                                        optimizedPredicates = new AnalyzedPredicates((scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{combinedSolrFilter}))).$plus$plus(pkRestriction)), (scala.collection.immutable.Set<Filter>)sparkFilters2);
                                        if (!solrConvertibleFilters.isEmpty()) break block7;
                                        this.logDebug((Function0<String>)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final String apply() {
                                                return "No Solr Convertible Filters Found";
                                            }
                                        });
                                        analyzedPredicates = predicates;
                                        break block8;
                                    }
                                    dseSearchOptimizationSetting = searchOptimizationEnabled;
                                    if (!(dseSearchOptimizationSetting instanceof Auto)) break block9;
                                    Auto auto = (Auto)dseSearchOptimizationSetting;
                                    double ratio = auto.ratio();
                                    CassandraConnector conn = CassandraConnector$.MODULE$.apply(sparkConf);
                                    String request = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SELECT COUNT(*) from \"", "\".\"", "\" where solr_query=?"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tableDef.keyspaceName(), tableDef.tableName()}));
                                    this.logDebug((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final String apply() {
                                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking total number of records"})).s((Seq)Nil$.MODULE$);
                                        }
                                    });
                                    tuple22 = (Tuple2)conn.withSessionDo(new Serializable(this, FaultTolerant, solrStringNoFailoverTolerant, request){
                                        public static final long serialVersionUID = 0L;
                                        private final String FaultTolerant$1;
                                        private final String solrStringNoFailoverTolerant$1;
                                        private final String request$1;

                                        public final Tuple2<Object, Object> apply(CqlSession session) {
                                            DriverExecutionProfile pagingDisabled = session.getContext().getConfig().getDefaultProfile().withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, -1);
                                            SimpleStatement totalRequest = (SimpleStatement)SimpleStatement.newInstance((String)this.request$1, (Object[])new Object[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{\"q\":\"*:*\", ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.FaultTolerant$1}))}).setExecutionProfile(pagingDisabled);
                                            SimpleStatement queryRequest = (SimpleStatement)SimpleStatement.newInstance((String)this.request$1, (Object[])new Object[]{this.solrStringNoFailoverTolerant$1}).setExecutionProfile(pagingDisabled);
                                            CompletionStage totalFuture = session.executeAsync((Statement)totalRequest);
                                            CompletionStage queryFuture = session.executeAsync((Statement)queryRequest);
                                            return new Tuple2.mcJJ.sp(((GettableByIndex)((AsyncPagingIterable)totalFuture.toCompletableFuture().get(5L, TimeUnit.SECONDS)).one()).getLong(0), ((GettableByIndex)((AsyncPagingIterable)queryFuture.toCompletableFuture().get(5L, TimeUnit.SECONDS)).one()).getLong(0));
                                        }
                                        {
                                            this.FaultTolerant$1 = FaultTolerant$1;
                                            this.solrStringNoFailoverTolerant$1 = solrStringNoFailoverTolerant$1;
                                            this.request$1 = request$1;
                                        }
                                    });
                                    if (tuple22 == null) break block10;
                                    long totalRecords = tuple22._1$mcJ$sp();
                                    long queryRecords = tuple22._2$mcJ$sp();
                                    long l = totalRecords;
                                    long l2 = queryRecords;
                                    Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(l, l2);
                                    long totalRecords2 = sp3._1$mcJ$sp();
                                    long queryRecords2 = sp3._2$mcJ$sp();
                                    double d = queryRatio = totalRecords2 == 0L ? 0.0 : (double)queryRecords2 / (double)totalRecords2;
                                    if (queryRatio > ratio) {
                                        this.logDebug((Function0<String>)new Serializable(this, ratio, queryRatio){
                                            public static final long serialVersionUID = 0L;
                                            private final double ratio$1;
                                            private final double queryRatio$1;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting ", " of the total records. Required to be less than ", " for DSE Search, falling back to Full Table Scan"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.queryRatio$1), BoxesRunTime.boxToDouble((double)this.ratio$1)}));
                                            }
                                            {
                                                this.ratio$1 = ratio$1;
                                                this.queryRatio$1 = queryRatio$1;
                                            }
                                        });
                                        analyzedPredicates3 = predicates;
                                    } else {
                                        this.logDebug((Function0<String>)new Serializable(this, ratio, queryRatio){
                                            public static final long serialVersionUID = 0L;
                                            private final double ratio$1;
                                            private final double queryRatio$1;

                                            public final String apply() {
                                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Requesting ", " of the total records. Less than ", ", using DSE Search Optimized request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.queryRatio$1), BoxesRunTime.boxToDouble((double)this.ratio$1)}));
                                            }
                                            {
                                                this.ratio$1 = ratio$1;
                                                this.queryRatio$1 = queryRatio$1;
                                            }
                                        });
                                        analyzedPredicates3 = optimizedPredicates;
                                    }
                                    analyzedPredicates2 = analyzedPredicates3;
                                    break block11;
                                }
                                throw new MatchError((Object)tuple22);
                            }
                            if (!On$.MODULE$.equals(dseSearchOptimizationSetting)) break block12;
                            this.logDebug((Function0<String>)new Serializable(this, solrConvertibleFilters, (Filter)combinedSolrFilter){
                                public static final long serialVersionUID = 0L;
                                private final scala.collection.immutable.Set solrConvertibleFilters$1;
                                private final Filter combinedSolrFilter$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Converted ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.solrConvertibleFilters$1, this.combinedSolrFilter$1}));
                                }
                                {
                                    this.solrConvertibleFilters$1 = solrConvertibleFilters$1;
                                    this.combinedSolrFilter$1 = combinedSolrFilter$1;
                                }
                            });
                            analyzedPredicates2 = optimizedPredicates;
                            break block11;
                        }
                        if (!Off$.MODULE$.equals(dseSearchOptimizationSetting)) break block13;
                        analyzedPredicates2 = predicates;
                    }
                    analyzedPredicates = analyzedPredicates2;
                }
                return analyzedPredicates;
            }
            throw new MatchError((Object)dseSearchOptimizationSetting);
        }
        throw new MatchError((Object)tuple2);
    }

    private String[] escapableWordTokens() {
        return this.escapableWordTokens;
    }

    private String[] escapableChars() {
        return this.escapableChars;
    }

    private String[] escapableWhitespaces() {
        return this.escapableWhitespaces;
    }

    private Pattern escapables() {
        return this.escapables;
    }

    private String[] escapableEntities() {
        return (String[])Predef$.MODULE$.refArrayOps((Object[])new String[][]{this.escapableWordTokens(), this.escapableChars(), this.escapableWhitespaces()}).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final WrappedArray<String> apply(String[] xs) {
                return Predef$.MODULE$.wrapRefArray((Object[])xs);
            }
        }, ClassTag$.MODULE$.apply(String.class));
    }

    public String escapeSolrCondition(String condition) {
        Matcher matcher = this.escapables().matcher(condition);
        StringBuilder escaped = package$.MODULE$.StringBuilder().newBuilder();
        int firstUnprocessedCharPosition = 0;
        while (matcher.find()) {
            escaped.append(condition.substring(firstUnprocessedCharPosition, matcher.start()));
            firstUnprocessedCharPosition = matcher.end();
            escaped.append("\\");
            escaped.append(matcher.group());
        }
        escaped.append(condition.substring(firstUnprocessedCharPosition, condition.length()));
        return escaped.toString();
    }

    private final scala.collection.immutable.Set solrIndexedFail$1(String str2) {
        this.logDebug((Function0<String>)new Serializable(this, str2){
            public static final long serialVersionUID = 0L;
            private final String str$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Retrieval of Solr Index Info Failed: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.str$1}));
            }
            {
                this.str$1 = str$1;
            }
        });
        return Predef$.MODULE$.Set().empty();
    }

    public SolrPredicateRules(DseSearchOptimizationSetting searchOptimizationEnabled) {
        this.searchOptimizationEnabled = searchOptimizationEnabled;
        Logging.class.$init$((Logging)this);
        this.escapableWordTokens = (String[])((Object[])new String[]{"AND", "OR", "NOT"});
        this.escapableChars = (String[])Predef$.MODULE$.refArrayOps((Object[])"\\+-!():^[]\"{}~*?|&;/".split("")).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String ch) {
                return Pattern.quote(ch);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.escapableWhitespaces = (String[])((Object[])new String[]{"\\s"});
        this.escapables = Pattern.compile(Predef$.MODULE$.refArrayOps((Object[])this.escapableEntities()).mkString("|"));
    }

    public class SolrFilter
    extends Filter
    implements Product,
    Serializable {
        private final String solrQuery;
        private final String[] references;
        public final /* synthetic */ SolrPredicateRules $outer;

        public String solrQuery() {
            return this.solrQuery;
        }

        public String[] references() {
            return this.references;
        }

        public SolrFilter copy(String solrQuery, String[] references) {
            return new SolrFilter(this.org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer(), solrQuery, references);
        }

        public String copy$default$1() {
            return this.solrQuery();
        }

        public String[] copy$default$2() {
            return this.references();
        }

        public String productPrefix() {
            return "SolrFilter";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    object = this.references();
                    break;
                }
                case 0: {
                    object = this.solrQuery();
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SolrFilter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SolrFilter)) return false;
            if (((SolrFilter)((Object)object)).org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer() != this.org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SolrFilter solrFilter = (SolrFilter)((Object)x$1);
            String string = this.solrQuery();
            String string2 = solrFilter.solrQuery();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.references() != solrFilter.references()) return false;
            if (!solrFilter.canEqual((Object)this)) return false;
            return true;
        }

        public /* synthetic */ SolrPredicateRules org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer() {
            return this.$outer;
        }

        public SolrFilter(SolrPredicateRules $outer, String solrQuery, String[] references) {
            this.solrQuery = solrQuery;
            this.references = references;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }
}

