/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra.execution;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.util.Logging;
import org.apache.spark.Dependency;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.cassandra.AlwaysOff$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation;
import org.apache.spark.sql.cassandra.DirectJoinSetting;
import org.apache.spark.sql.cassandra.execution.CassandraDirectJoinExec;
import org.apache.spark.sql.cassandra.execution.CassandraDirectJoinStrategy;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.DataSourceScanExec;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.joins.package;
import org.apache.spark.sql.sources.BaseRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;

public final class CassandraDirectJoinStrategy$
implements Logging,
Serializable {
    public static final CassandraDirectJoinStrategy$ MODULE$;
    private final Map<package.BuildSide, Seq<JoinType>> validJoins;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraDirectJoinStrategy$();
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public Option<CassandraTableScanRDD<?>> getCassandraTableScanRDD(RDD<?> rdd) {
        None$ none$;
        block2: {
            while (true) {
                RDD rDD;
                if ((rDD = rdd) instanceof CassandraTableScanRDD) {
                    CassandraTableScanRDD cassandraTableScanRDD = (CassandraTableScanRDD)rDD;
                    none$ = new Some((Object)cassandraTableScanRDD);
                    break block2;
                }
                if (!rdd.dependencies().headOption().nonEmpty()) break;
                rdd = ((Dependency)rDD.dependencies().head()).rdd();
            }
            none$ = None$.MODULE$;
        }
        return none$;
    }

    public Option<LogicalRelation> getLogicalRelation(LogicalPlan plan) {
        None$ none$;
        Seq leaves = plan.collectLeaves();
        if (leaves.size() != 1) {
            none$ = None$.MODULE$;
        } else {
            None$ none$2;
            LogicalPlan logicalPlan = (LogicalPlan)leaves.head();
            if (logicalPlan instanceof LogicalRelation) {
                LogicalRelation logicalRelation = (LogicalRelation)logicalPlan;
                none$2 = new Some((Object)logicalRelation);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    public Option<DataSourceScanExec> getScanExec(SparkPlan plan) {
        None$ none$;
        Seq leaves = plan.collectLeaves();
        if (leaves.size() != 1) {
            none$ = None$.MODULE$;
        } else {
            None$ none$2;
            SparkPlan sparkPlan = (SparkPlan)leaves.head();
            if (sparkPlan instanceof DataSourceScanExec) {
                DataSourceScanExec dataSourceScanExec = (DataSourceScanExec)sparkPlan;
                none$2 = new Some((Object)dataSourceScanExec);
            } else {
                none$2 = None$.MODULE$;
            }
            none$ = none$2;
        }
        return none$;
    }

    public Map<package.BuildSide, Seq<JoinType>> validJoins() {
        return this.validJoins;
    }

    public boolean validJoinType(package.BuildSide cassandraSide, JoinType joinType) {
        return ((SeqLike)this.validJoins().apply((Object)cassandraSide)).contains((Object)joinType);
    }

    public Option<CassandraSourceRelation> getCassandraSource(LogicalPlan plan) {
        return this.getLogicalRelation(plan).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<CassandraSourceRelation> apply(LogicalRelation logicalSource) {
                None$ none$;
                BaseRelation baseRelation = logicalSource.relation();
                if (baseRelation instanceof CassandraSourceRelation) {
                    CassandraSourceRelation cassandraSourceRelation = (CassandraSourceRelation)baseRelation;
                    none$ = new Some((Object)cassandraSourceRelation);
                } else {
                    none$ = None$.MODULE$;
                }
                return none$;
            }
        });
    }

    public <T extends QueryPlan<T>> boolean hasCassandraChild(T plan) {
        return plan.children().size() == 1 && plan.children().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(T x0$2) {
                T t;
                LogicalRelation logicalRelation;
                T t2 = x0$2;
                boolean bl = t2 instanceof LogicalRelation && (logicalRelation = (LogicalRelation)t2).relation() instanceof CassandraSourceRelation ? true : t2 instanceof DataSourceScanExec && ((DataSourceScanExec)(t = t2)).relation() instanceof CassandraSourceRelation;
                return bl;
            }
        });
    }

    public SparkPlan reorderPlan(SparkPlan plan, CassandraDirectJoinExec directJoin) {
        DataSourceScanExec dataSourceScanExec;
        SparkPlan sparkPlan = plan;
        SparkPlan sparkPlan2 = sparkPlan instanceof DataSourceScanExec && (dataSourceScanExec = (DataSourceScanExec)sparkPlan).relation() instanceof CassandraSourceRelation ? directJoin : (SparkPlan)sparkPlan.transform((PartialFunction)new Serializable(directJoin){
            public static final long serialVersionUID = 0L;
            private final CassandraDirectJoinExec directJoin$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = CassandraDirectJoinStrategy$.MODULE$.hasCassandraChild(A1) ? A1.withNewChildren((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CassandraDirectJoinExec[]{this.directJoin$1}))) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = CassandraDirectJoinStrategy$.MODULE$.hasCassandraChild(sparkPlan);
                return bl;
            }
            {
                this.directJoin$1 = directJoin$1;
            }
        });
        SparkPlan reordered = sparkPlan2;
        return (SparkPlan)reordered.transform((PartialFunction)new Serializable(directJoin){
            public static final long serialVersionUID = 0L;
            private final CassandraDirectJoinExec directJoin$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof ProjectExec) {
                    ProjectExec projectExec = (ProjectExec)A1;
                    Seq projectList = projectExec.projectList();
                    SparkPlan child = projectExec.child();
                    Seq children = (Seq)projectList.collect((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends NamedExpression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                            Object object;
                            Alias alias;
                            Expression child;
                            A1 A1 = x3;
                            if (A1 instanceof Alias && (child = (alias = (Alias)A1).child()) instanceof AttributeReference) {
                                AttributeReference attributeReference = (AttributeReference)child;
                                object = attributeReference.toAttribute();
                            } else if (A1 instanceof AttributeReference) {
                                AttributeReference attributeReference = (AttributeReference)A1;
                                object = attributeReference;
                            } else {
                                object = function1.apply(x3);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(NamedExpression x3) {
                            Alias alias;
                            Expression child;
                            NamedExpression namedExpression = x3;
                            boolean bl = namedExpression instanceof Alias && (child = (alias = (Alias)namedExpression).child()) instanceof AttributeReference ? true : namedExpression instanceof AttributeReference;
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom());
                    Seq prefix = (Seq)this.directJoin$1.output().takeWhile((Function1)new Serializable(this, children){
                        public static final long serialVersionUID = 0L;
                        private final Seq children$1;

                        public final boolean apply(Attribute attribute) {
                            return !this.children$1.contains((Object)attribute);
                        }
                        {
                            this.children$1 = children$1;
                        }
                    });
                    Seq suffix = (Seq)((SeqLike)((IterableLike)this.directJoin$1.output().reverse()).takeWhile((Function1)new Serializable(this, children){
                        public static final long serialVersionUID = 0L;
                        private final Seq children$1;

                        public final boolean apply(Attribute attribute) {
                            return !this.children$1.contains((Object)attribute);
                        }
                        {
                            this.children$1 = children$1;
                        }
                    })).reverse();
                    object = new ProjectExec((Seq)((TraversableLike)prefix.$plus$plus((GenTraversableOnce)projectList, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)suffix, Seq$.MODULE$.canBuildFrom()), child);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan = x2;
                boolean bl = sparkPlan instanceof ProjectExec;
                return bl;
            }
            {
                this.directJoin$1 = directJoin$1;
            }
        });
    }

    public boolean validJoinBranch(LogicalPlan plan, Seq<Expression> keys) {
        boolean safePlan = this.containsSafePlans(plan);
        boolean pkConstrained = this.allPartitionKeysAreJoined(plan, keys);
        if (this.containsSafePlans(plan)) {
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plan was safe"})).s((Seq)Nil$.MODULE$);
                }
            });
        }
        if (pkConstrained) {
            this.logDebug((Function0<String>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Plan constrained on all partition keys"})).s((Seq)Nil$.MODULE$);
                }
            });
        }
        return safePlan && pkConstrained;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean allPartitionKeysAreJoined(LogicalPlan plan, Seq<Expression> joinKeys) {
        LogicalPlan logicalPlan = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan);
        if (option.isEmpty()) return false;
        Seq attributes = (Seq)((Tuple3)option.get())._1();
        LogicalPlan logicalPlan2 = (LogicalPlan)((Tuple3)option.get())._3();
        if (!(logicalPlan2 instanceof LogicalRelation)) return false;
        LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
        BaseRelation cassandraSource = logicalRelation.relation();
        if (!(cassandraSource instanceof CassandraSourceRelation)) return false;
        CassandraSourceRelation cassandraSourceRelation = (CassandraSourceRelation)cassandraSource;
        Seq joinKeysExprId = (Seq)joinKeys.collect((PartialFunction)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x4;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    object = attributeReference.exprId();
                } else {
                    object = function1.apply(x4);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x4) {
                Expression expression = x4;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map joinKeyAliases = (Map)this.aliasMap((Seq<NamedExpression>)attributes).filter((Function1)new Serializable(joinKeysExprId){
            public static final long serialVersionUID = 0L;
            private final Seq joinKeysExprId$1;

            public final boolean apply(Tuple2<String, ExprId> x0$3) {
                Tuple2<String, ExprId> tuple2 = x0$3;
                if (tuple2 != null) {
                    ExprId value2 = (ExprId)tuple2._2();
                    boolean bl = this.joinKeysExprId$1.contains((Object)value2);
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.joinKeysExprId$1 = joinKeysExprId$1;
            }
        });
        Seq partitionKeyNames2 = (Seq)cassandraSourceRelation.tableDef().partitionKey().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ColumnDef x$5) {
                return x$5.columnName();
            }
        }, Seq$.MODULE$.canBuildFrom());
        boolean allKeysPresent = partitionKeyNames2.forall((Function1)new Serializable(joinKeyAliases){
            public static final long serialVersionUID = 0L;
            private final Map joinKeyAliases$1;

            public final boolean apply(String key) {
                return this.joinKeyAliases$1.contains((Object)key);
            }
            {
                this.joinKeyAliases$1 = joinKeyAliases$1;
            }
        });
        if (allKeysPresent) return allKeysPresent;
        this.logDebug((Function0<String>)new Serializable(joinKeyAliases, partitionKeyNames2){
            public static final long serialVersionUID = 0L;
            private final Map joinKeyAliases$1;
            private final Seq partitionKeyNames$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Not all ", " should be contained within ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionKeyNames$1, this.joinKeyAliases$1}));
            }
            {
                this.joinKeyAliases$1 = joinKeyAliases$1;
                this.partitionKeyNames$1 = partitionKeyNames$1;
            }
        });
        return allKeysPresent;
    }

    public Map<String, ExprId> aliasMap(Seq<NamedExpression> aliases2) {
        return ((TraversableOnce)aliases2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, ExprId> apply(NamedExpression x0$1) {
                NamedExpression namedExpression;
                block4: {
                    Tuple2 tuple2;
                    block3: {
                        block2: {
                            Alias alias;
                            Expression child;
                            namedExpression = x0$1;
                            if (!(namedExpression instanceof Alias) || !((child = (alias = (Alias)namedExpression).child()) instanceof AttributeReference)) break block2;
                            AttributeReference attributeReference = (AttributeReference)child;
                            tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attributeReference.name()), (Object)alias.exprId());
                            break block3;
                        }
                        if (!(namedExpression instanceof AttributeReference)) break block4;
                        AttributeReference attributeReference = (AttributeReference)namedExpression;
                        tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attributeReference.name()), (Object)attributeReference.exprId());
                    }
                    return tuple2;
                }
                throw new MatchError((Object)namedExpression);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsSafePlans(LogicalPlan plan) {
        LogicalPlan logicalPlan = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan);
        if (option.isEmpty()) return false;
        LogicalPlan logicalPlan2 = (LogicalPlan)((Tuple3)option.get())._3();
        if (!(logicalPlan2 instanceof LogicalRelation)) return false;
        LogicalRelation logicalRelation = (LogicalRelation)logicalPlan2;
        BaseRelation relation = logicalRelation.relation();
        if (!(relation instanceof CassandraSourceRelation)) return false;
        CassandraSourceRelation cassandraSourceRelation = (CassandraSourceRelation)relation;
        DirectJoinSetting directJoinSetting = cassandraSourceRelation.directJoinSetting();
        AlwaysOff$ alwaysOff$ = AlwaysOff$.MODULE$;
        if (directJoinSetting == null) {
            if (alwaysOff$ == null) return false;
            return true;
        } else if (directJoinSetting.equals(alwaysOff$)) return false;
        return true;
    }

    public CassandraDirectJoinStrategy apply(SparkSession spark) {
        return new CassandraDirectJoinStrategy(spark);
    }

    public Option<SparkSession> unapply(CassandraDirectJoinStrategy x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.spark());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CassandraDirectJoinStrategy$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.validJoins = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package.BuildRight$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinType[]{Inner$.MODULE$, LeftOuter$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package.BuildLeft$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinType[]{Inner$.MODULE$, RightOuter$.MODULE$})))}));
    }
}

