/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CassandraConnectorConf$;
import com.datastax.spark.connector.cql.ContactInfo;
import com.datastax.spark.connector.cql.DefaultConnectionFactory$;
import com.datastax.spark.connector.cql.IpBasedContactInfo;
import com.datastax.spark.connector.cql.RefCountedCache;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.types.TypeConverter$;
import com.datastax.spark.connector.util.ConfigCheck;
import com.datastax.spark.connector.util.DriverUtil$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.SerialShutdownHooks$;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetSocketAddress;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

public final class CassandraConnector$
implements Logging,
scala.Serializable {
    public static CassandraConnector$ MODULE$;
    private final RefCountedCache<CassandraConnectorConf, CqlSession> sessionCache;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraConnector$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public RefCountedCache<CassandraConnectorConf, CqlSession> sessionCache() {
        return this.sessionCache;
    }

    /*
     * WARNING - void declaration
     */
    private CqlSession createSession(CassandraConnectorConf conf) {
        void v0;
        LazyRef endpointsStr$lzy = new LazyRef();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Attempting to open native connection to Cassandra with ").append(CassandraConnector$.endpointsStr$1(endpointsStr$lzy, conf)).toString());
        try {
            void var3_3;
            CqlSession session = conf.connectionFactory().createSession(conf);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Connected to Cassandra cluster.");
            v0 = var3_3;
        }
        catch (Throwable e) {
            throw new IOException(new StringBuilder(53).append("Failed to open native connection to Cassandra at ").append(CassandraConnector$.endpointsStr$1(endpointsStr$lzy, conf)).append(" :: ").append(e.getLocalizedMessage()).toString(), e);
        }
        return v0;
    }

    private void destroySession(CqlSession session) {
        session.close();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Disconnected from Cassandra cluster.");
    }

    /*
     * WARNING - void declaration
     */
    public Set<InetSocketAddress> com$datastax$spark$connector$cql$CassandraConnector$$dataCenterNodes(CqlSession session) {
        void var3_3;
        Set allNodes = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getMetadata().getNodes()).asScala()).values().toSet();
        Set nodes = (Set)((TraversableLike)allNodes.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CassandraConnector$.$anonfun$dataCenterNodes$1(x$3)))).flatMap((Function1 & Serializable & scala.Serializable)node -> Option$.MODULE$.option2Iterable(DriverUtil$.MODULE$.toAddress(node)), Set$.MODULE$.canBuildFrom());
        if (nodes.isEmpty()) {
            throw new ConfigCheck.ConnectorConfigurationException(new StringBuilder(64).append("Could not determine suitable nodes in local DC for known nodes: ").append(((TraversableOnce)allNodes.map((Function1 & Serializable & scala.Serializable)n -> new Tuple2((Object)n.getHostId(), (Object)DriverUtil$.MODULE$.toAddress(n)), Set$.MODULE$.canBuildFrom())).mkString(", ")).toString());
        }
        return var3_3;
    }

    private Set<CassandraConnectorConf> alternativeConnectionConfigs(CassandraConnectorConf conf, CqlSession session) {
        Set set;
        ContactInfo contactInfo = conf.contactInfo();
        if (contactInfo instanceof IpBasedContactInfo) {
            IpBasedContactInfo ipBasedContactInfo = (IpBasedContactInfo)contactInfo;
            Set<InetSocketAddress> nodes = this.com$datastax$spark$connector$cql$CassandraConnector$$dataCenterNodes(session);
            set = (Set)((SetLike)nodes.map((Function1 & Serializable & scala.Serializable)n -> conf.copy(ipBasedContactInfo.copy((Set<InetSocketAddress>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InetSocketAddress[]{n}))), ipBasedContactInfo.copy$default$2(), ipBasedContactInfo.copy$default$3()), conf.copy$default$2(), conf.copy$default$3(), conf.copy$default$4(), conf.copy$default$5(), conf.copy$default$6(), conf.copy$default$7(), conf.copy$default$8(), conf.copy$default$9(), conf.copy$default$10(), conf.copy$default$11(), conf.copy$default$12(), conf.copy$default$13(), conf.copy$default$14(), conf.copy$default$15()), Set$.MODULE$.canBuildFrom())).$plus((Object)conf.copy(ipBasedContactInfo.copy(nodes, ipBasedContactInfo.copy$default$2(), ipBasedContactInfo.copy$default$3()), conf.copy$default$2(), conf.copy$default$3(), conf.copy$default$4(), conf.copy$default$5(), conf.copy$default$6(), conf.copy$default$7(), conf.copy$default$8(), conf.copy$default$9(), conf.copy$default$10(), conf.copy$default$11(), conf.copy$default$12(), conf.copy$default$13(), conf.copy$default$14(), conf.copy$default$15()));
        } else {
            set = Predef$.MODULE$.Set().empty();
        }
        return set;
    }

    public CassandraConnector apply(CassandraConnectorConf conf) {
        return new CassandraConnector(conf);
    }

    public CassandraConnector apply(SparkConf conf) {
        return this.apply(CassandraConnectorConf$.MODULE$.apply(conf));
    }

    public CassandraConnector apply(SparkContext sc) {
        return this.apply(sc.getConf());
    }

    public CassandraConnector apply(ContactInfo contactInfo, Option<String> localDC, int keepAliveMillis, int minReconnectionDelayMillis, int maxReconnectionDelayMillis, int queryRetryCount, int connectTimeoutMillis, int readTimeoutMillis, CassandraConnectionFactory connectionFactory) {
        ContactInfo x$1 = contactInfo;
        Option<String> x$2 = localDC;
        int x$3 = keepAliveMillis;
        int x$4 = minReconnectionDelayMillis;
        int x$5 = maxReconnectionDelayMillis;
        int x$6 = queryRetryCount;
        int x$7 = connectTimeoutMillis;
        int x$8 = readTimeoutMillis;
        CassandraConnectionFactory x$9 = connectionFactory;
        Option<Object> x$10 = CassandraConnectorConf$.MODULE$.apply$default$6();
        Option<Object> x$11 = CassandraConnectorConf$.MODULE$.apply$default$7();
        String x$12 = CassandraConnectorConf$.MODULE$.apply$default$8();
        int x$13 = CassandraConnectorConf$.MODULE$.apply$default$13();
        int x$14 = CassandraConnectorConf$.MODULE$.apply$default$14();
        boolean x$15 = CassandraConnectorConf$.MODULE$.apply$default$15();
        CassandraConnectorConf config = new CassandraConnectorConf(x$1, x$2, x$3, x$4, x$5, x$10, x$11, x$12, x$6, x$7, x$8, x$9, x$13, x$14, x$15);
        return new CassandraConnector(config);
    }

    public Option<String> apply$default$2() {
        return None$.MODULE$;
    }

    public int apply$default$3() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.KeepAliveMillisParam().default());
    }

    public int apply$default$4() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MinReconnectionDelayParam().default());
    }

    public int apply$default$5() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.MaxReconnectionDelayParam().default());
    }

    public int apply$default$6() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.QueryRetryParam().default());
    }

    public int apply$default$7() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ConnectionTimeoutParam().default());
    }

    public int apply$default$8() {
        return BoxesRunTime.unboxToInt((Object)CassandraConnectorConf$.MODULE$.ReadTimeoutParam().default());
    }

    public CassandraConnectionFactory apply$default$9() {
        return DefaultConnectionFactory$.MODULE$;
    }

    public void evictCache() {
        this.sessionCache().evict();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final /* synthetic */ String endpointsStr$lzycompute$1(LazyRef endpointsStr$lzy$1, CassandraConnectorConf conf$1) {
        String string;
        LazyRef lazyRef = endpointsStr$lzy$1;
        synchronized (lazyRef) {
            string = endpointsStr$lzy$1.initialized() ? (String)endpointsStr$lzy$1.value() : (String)endpointsStr$lzy$1.initialize((Object)conf$1.contactInfo().endPointStr());
        }
        return string;
    }

    private static final String endpointsStr$1(LazyRef endpointsStr$lzy$1, CassandraConnectorConf conf$1) {
        return endpointsStr$lzy$1.initialized() ? (String)endpointsStr$lzy$1.value() : CassandraConnector$.endpointsStr$lzycompute$1(endpointsStr$lzy$1, conf$1);
    }

    public static final /* synthetic */ boolean $anonfun$dataCenterNodes$1(Node x$3) {
        NodeDistance nodeDistance = x$3.getDistance();
        NodeDistance nodeDistance2 = NodeDistance.IGNORED;
        return nodeDistance == null ? nodeDistance2 != null : !nodeDistance.equals(nodeDistance2);
    }

    private CassandraConnector$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        TypeConverter$.MODULE$.registerConverter((TypeConverter)new CassandraConnector.GenericRowWithSchemeToValuesByNameConverter());
        TypeConverter$.MODULE$.registerConverter((TypeConverter)new CassandraConnector.GenericRowWithSchemeToValuesSeqConverter());
        this.sessionCache = new RefCountedCache((Function1 & Serializable & scala.Serializable)conf -> MODULE$.createSession((CassandraConnectorConf)conf), (Function1 & Serializable & scala.Serializable)session -> {
            CassandraConnector$.MODULE$.destroySession(session);
            return BoxedUnit.UNIT;
        }, (Function2 & Serializable & scala.Serializable)(conf, session) -> MODULE$.alternativeConnectionConfigs((CassandraConnectorConf)conf, (CqlSession)session));
        SerialShutdownHooks$.MODULE$.add("Clearing session cache for C* connector", 200, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String classLoaderCheckName = "com.datastax.spark.connector.util.ClassLoaderCheck";
            try {
                String check = MODULE$.sessionCache().getClass().getClassLoader().loadClass(classLoaderCheckName).getSimpleName();
                MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Class loader check: ").append(check).toString());
                MODULE$.sessionCache().shutdown();
            }
            catch (Throwable throwable) {
                ClassNotFoundException classNotFoundException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof ClassNotFoundException && (classNotFoundException = (ClassNotFoundException)throwable2).getMessage().contains(classLoaderCheckName)) {
                    MODULE$.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Couldn't shutdown the session cache.");
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        });
    }
}

