/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.cql;

import com.datastax.bdp.spark.ContinuousPagingScanner$;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OngoingConfigOptions;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metadata.schema.SchemaChangeListener;
import com.datastax.oss.driver.api.core.session.SessionBuilder;
import com.datastax.oss.driver.internal.core.connection.ExponentialReconnectionPolicy;
import com.datastax.oss.driver.internal.core.ssl.DefaultSslEngineFactory;
import com.datastax.spark.connector.cql.AuthConf;
import com.datastax.spark.connector.cql.CassandraConnectionFactory;
import com.datastax.spark.connector.cql.CassandraConnectionFactory$;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnectorConf;
import com.datastax.spark.connector.cql.CloudBasedContactInfo;
import com.datastax.spark.connector.cql.ContactInfo;
import com.datastax.spark.connector.cql.DefaultScanner;
import com.datastax.spark.connector.cql.IpBasedContactInfo;
import com.datastax.spark.connector.cql.LocalNodeFirstLoadBalancingPolicy;
import com.datastax.spark.connector.cql.MultipleRetryPolicy;
import com.datastax.spark.connector.cql.MultipleRetryPolicy$;
import com.datastax.spark.connector.cql.MultiplexingSchemaListener;
import com.datastax.spark.connector.cql.ProfileFileBasedContactInfo;
import com.datastax.spark.connector.cql.Scanner;
import com.datastax.spark.connector.rdd.ReadConf;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.List;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFiles$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class DefaultConnectionFactory$
implements CassandraConnectionFactory {
    public static DefaultConnectionFactory$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new DefaultConnectionFactory$();
    }

    @Override
    public Set<String> properties() {
        return CassandraConnectionFactory.properties$(this);
    }

    private Logger logger$lzycompute() {
        DefaultConnectionFactory$ defaultConnectionFactory$ = this;
        synchronized (defaultConnectionFactory$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"com.datastax.spark.connector.cql.CassandraConnectionFactory");
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ProgrammaticDriverConfigLoaderBuilder connectorConfigBuilder(CassandraConnectorConf conf, ProgrammaticDriverConfigLoaderBuilder initBuilder) {
        Seq seq;
        Seq universalProperties = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{(Function1 & Serializable & scala.Serializable)builder -> DefaultConnectionFactory$.basicProperties$1(builder, conf), (Function1 & Serializable & scala.Serializable)b -> DefaultConnectionFactory$.compressionProperties$1(b, conf), (Function1 & Serializable & scala.Serializable)b -> DefaultConnectionFactory$.localDCProperty$1(b, conf)}));
        ContactInfo contactInfo = conf.contactInfo();
        if (contactInfo instanceof IpBasedContactInfo) {
            IpBasedContactInfo ipBasedContactInfo = (IpBasedContactInfo)contactInfo;
            seq = (Seq)universalProperties.$colon$plus((Object)DefaultConnectionFactory$.ipBasedConnectionProperties$1(ipBasedContactInfo), Seq$.MODULE$.canBuildFrom());
        } else {
            seq = universalProperties;
        }
        Seq appliedProperties = seq;
        return (ProgrammaticDriverConfigLoaderBuilder)appliedProperties.foldLeft((Object)initBuilder, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ProgrammaticDriverConfigLoaderBuilder builder = (ProgrammaticDriverConfigLoaderBuilder)tuple2._1();
            Function1 properties = (Function1)tuple2._2();
            ProgrammaticDriverConfigLoaderBuilder programmaticDriverConfigLoaderBuilder = (ProgrammaticDriverConfigLoaderBuilder)properties.apply((Object)builder);
            return programmaticDriverConfigLoaderBuilder;
        });
    }

    @Override
    public CqlSession createSession(CassandraConnectorConf conf) {
        CqlSessionBuilder cqlSessionBuilder;
        ProgrammaticDriverConfigLoaderBuilder configLoaderBuilder = DriverConfigLoader.programmaticBuilder();
        DriverConfigLoader configLoader = this.connectorConfigBuilder(conf, configLoaderBuilder).build();
        CqlSessionBuilder initialBuilder = CqlSession.builder();
        ContactInfo contactInfo = conf.contactInfo();
        if (contactInfo instanceof IpBasedContactInfo) {
            IpBasedContactInfo ipBasedContactInfo = (IpBasedContactInfo)contactInfo;
            cqlSessionBuilder = (CqlSessionBuilder)((SessionBuilder)ipBasedContactInfo.authConf().authProvider().fold((Function0 & Serializable & scala.Serializable)() -> initialBuilder, (Function1 & Serializable & scala.Serializable)x$1 -> (CqlSessionBuilder)initialBuilder.withAuthProvider(x$1))).withConfigLoader(configLoader);
        } else if (contactInfo instanceof CloudBasedContactInfo) {
            CloudBasedContactInfo cloudBasedContactInfo = (CloudBasedContactInfo)contactInfo;
            String path = cloudBasedContactInfo.path();
            AuthConf authConf = cloudBasedContactInfo.authConf();
            cqlSessionBuilder = (CqlSessionBuilder)((SessionBuilder)authConf.authProvider().fold((Function0 & Serializable & scala.Serializable)() -> initialBuilder, (Function1 & Serializable & scala.Serializable)x$1 -> (CqlSessionBuilder)initialBuilder.withAuthProvider(x$1))).withCloudSecureConnectBundle(this.maybeGetLocalFile(path)).withConfigLoader(configLoader);
        } else if (contactInfo instanceof ProfileFileBasedContactInfo) {
            ProfileFileBasedContactInfo profileFileBasedContactInfo = (ProfileFileBasedContactInfo)contactInfo;
            String path = profileFileBasedContactInfo.path();
            this.logger().warn(new StringBuilder(71).append("Ignoring all programmatic configuration, only using configuration from ").append(path).toString());
            cqlSessionBuilder = (CqlSessionBuilder)initialBuilder.withConfigLoader(DriverConfigLoader.fromUrl((URL)this.maybeGetLocalFile(path)));
        } else {
            throw new MatchError((Object)contactInfo);
        }
        CqlSessionBuilder builderWithContactInfo = cqlSessionBuilder;
        String appName = (String)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)env -> env.conf().getAppId()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "NoAppID");
        return (CqlSession)builderWithContactInfo.withApplicationName(new StringBuilder(26).append("Spark-Cassandra-Connector-").append(appName).toString()).withSchemaChangeListener((SchemaChangeListener)new MultiplexingSchemaListener()).build();
    }

    public URL maybeGetLocalFile(String path) {
        URL uRL;
        Path localPath = Paths.get(SparkFiles$.MODULE$.get(path), new String[0]);
        if (Files.exists(localPath, new LinkOption[0])) {
            this.logger().info(new StringBuilder(46).append("Found the ").append(path).append(" locally at ").append(localPath).append(", using this local file.").toString());
            uRL = localPath.toUri().toURL();
        } else {
            try {
                uRL = new URL(path);
            }
            catch (MalformedURLException e) {
                throw new IOException(new StringBuilder(213).append("The provided path ").append(path).append(" is not a valid URL nor an existing locally path. Provide an ").append("URL accessible to all executors or a path existing on all executors (you may use `spark.files` to ").append("distribute a file to each executor).").toString(), e);
            }
        }
        return uRL;
    }

    public boolean continuousPagingEnabled(CqlSession session) {
        boolean bl;
        boolean confEnabled = SparkEnv$.MODULE$.get().conf().getBoolean(CassandraConnectionFactory$.MODULE$.continuousPagingParam().name(), BoxesRunTime.unboxToBoolean((Object)CassandraConnectionFactory$.MODULE$.continuousPagingParam().default()));
        ProtocolVersion pv = session.getContext().getProtocolVersion();
        if (pv.getCode() > DseProtocolVersion.DSE_V1.getCode() && confEnabled) {
            this.logger().debug("Scan Method Being Set to Continuous Paging");
            bl = true;
        } else {
            this.logger().debug("Scan Mode Disabled or Connecting to Non-DSE Cassandra Cluster");
            bl = false;
        }
        return bl;
    }

    @Override
    public Scanner getScanner(ReadConf readConf, CassandraConnectorConf connConf, IndexedSeq<String> columnNames) {
        Scanner scanner;
        boolean isContinuousPagingEnabled = BoxesRunTime.unboxToBoolean(new CassandraConnector(connConf).withSessionDo((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)DefaultConnectionFactory$.MODULE$.continuousPagingEnabled(session))));
        if (isContinuousPagingEnabled) {
            this.logger().debug("Using ContinousPagingScanner");
            scanner = ContinuousPagingScanner$.MODULE$.apply(readConf, connConf, columnNames);
        } else {
            this.logger().debug("Not Connected to DSE 5.1 or Greater Falling back to Non-Continuous Paging");
            scanner = new DefaultScanner(readConf, connConf, columnNames);
        }
        return scanner;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final ProgrammaticDriverConfigLoaderBuilder basicProperties$1(ProgrammaticDriverConfigLoaderBuilder builder, CassandraConnectorConf conf$1) {
        int localCoreThreadCount = Math.max(1, Runtime.getRuntime().availableProcessors() - 1);
        return (ProgrammaticDriverConfigLoaderBuilder)builder.withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE, BoxesRunTime.unboxToInt((Object)conf$1.localConnectionsPerExecutor().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> localCoreThreadCount))).withInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE, BoxesRunTime.unboxToInt((Object)conf$1.remoteConnectionsPerExecutor().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 1))).withInt((DriverOption)DefaultDriverOption.CONNECTION_INIT_QUERY_TIMEOUT, conf$1.connectTimeoutMillis()).withDuration((DriverOption)DefaultDriverOption.CONTROL_CONNECTION_TIMEOUT, Duration.ofMillis(conf$1.connectTimeoutMillis())).withDuration((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REQUEST_TIMEOUT, Duration.ofMillis(conf$1.connectTimeoutMillis())).withInt((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, conf$1.readTimeoutMillis()).withClass((DriverOption)DefaultDriverOption.RETRY_POLICY_CLASS, MultipleRetryPolicy.class).withClass((DriverOption)DefaultDriverOption.RECONNECTION_POLICY_CLASS, ExponentialReconnectionPolicy.class).withDuration((DriverOption)DefaultDriverOption.RECONNECTION_BASE_DELAY, Duration.ofMillis(conf$1.minReconnectionDelayMillis())).withDuration((DriverOption)DefaultDriverOption.RECONNECTION_MAX_DELAY, Duration.ofMillis(conf$1.maxReconnectionDelayMillis())).withInt((DriverOption)DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_QUIET_PERIOD, conf$1.quietPeriodBeforeCloseMillis() / 1000).withInt((DriverOption)DefaultDriverOption.NETTY_ADMIN_SHUTDOWN_TIMEOUT, conf$1.timeoutBeforeCloseMillis() / 1000).withInt((DriverOption)DefaultDriverOption.NETTY_IO_SHUTDOWN_QUIET_PERIOD, conf$1.quietPeriodBeforeCloseMillis() / 1000).withInt((DriverOption)DefaultDriverOption.NETTY_IO_SHUTDOWN_TIMEOUT, conf$1.timeoutBeforeCloseMillis() / 1000).withBoolean((DriverOption)DefaultDriverOption.NETTY_DAEMON, true).withBoolean((DriverOption)DefaultDriverOption.RESOLVE_CONTACT_POINTS, conf$1.resolveContactPoints()).withInt(MultipleRetryPolicy$.MODULE$.MaxRetryCount(), conf$1.queryRetryCount()).withDuration((DriverOption)DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_FIRST_PAGE, Duration.ofMillis(conf$1.readTimeoutMillis())).withDuration((DriverOption)DseDriverOption.CONTINUOUS_PAGING_TIMEOUT_OTHER_PAGES, Duration.ofMillis(conf$1.readTimeoutMillis()));
    }

    public static final /* synthetic */ boolean $anonfun$connectorConfigBuilder$3(String x$1) {
        String string = x$1.toLowerCase();
        String string2 = "none";
        return string == null ? string2 != null : !string.equals(string2);
    }

    private static final ProgrammaticDriverConfigLoaderBuilder compressionProperties$1(ProgrammaticDriverConfigLoaderBuilder b, CassandraConnectorConf conf$1) {
        return (ProgrammaticDriverConfigLoaderBuilder)Option$.MODULE$.apply((Object)conf$1.compression()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DefaultConnectionFactory$.$anonfun$connectorConfigBuilder$3(x$1))).fold((Function0 & Serializable & scala.Serializable)() -> b, (Function1 & Serializable & scala.Serializable)c -> (ProgrammaticDriverConfigLoaderBuilder)b.withString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, c.toLowerCase()));
    }

    private static final ProgrammaticDriverConfigLoaderBuilder localDCProperty$1(ProgrammaticDriverConfigLoaderBuilder b, CassandraConnectorConf conf$1) {
        return (ProgrammaticDriverConfigLoaderBuilder)conf$1.localDC().map((Function1 & Serializable & scala.Serializable)x$2 -> (ProgrammaticDriverConfigLoaderBuilder)b.withString((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER, x$2)).getOrElse((Function0 & Serializable & scala.Serializable)() -> b);
    }

    private static final Option clientAuthEnabled$1(Option value, IpBasedContactInfo ipConf$1) {
        return ipConf$1.cassandraSSLConf().clientAuthEnabled() ? value : None$.MODULE$;
    }

    private static final Function1 ipBasedConnectionProperties$1(IpBasedContactInfo ipConf) {
        return (Function1 & Serializable & scala.Serializable)builder -> {
            builder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableOnce)ipConf.hosts().map((Function1 & Serializable & scala.Serializable)h -> new StringBuilder(1).append(h.getHostString()).append(":").append(h.getPort()).toString(), Set$.MODULE$.canBuildFrom())).toList()).asJava()).withClass((DriverOption)DefaultDriverOption.LOAD_BALANCING_POLICY_CLASS, LocalNodeFirstLoadBalancingPolicy.class);
            return ipConf.cassandraSSLConf().enabled() ? (ProgrammaticDriverConfigLoaderBuilder)((OngoingConfigOptions)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_TRUSTSTORE_PATH), ipConf.cassandraSSLConf().trustStorePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_TRUSTSTORE_PASSWORD), ipConf.cassandraSSLConf().trustStorePassword()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_KEYSTORE_PATH), (Object)DefaultConnectionFactory$.clientAuthEnabled$1(ipConf.cassandraSSLConf().keyStorePath(), ipConf)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DefaultDriverOption.SSL_KEYSTORE_PASSWORD), (Object)DefaultConnectionFactory$.clientAuthEnabled$1(ipConf.cassandraSSLConf().keyStorePassword(), ipConf))}))).foldLeft(builder, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
                Tuple2 tuple2;
                ProgrammaticDriverConfigLoaderBuilder b;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$1, x1$1);
                        if (tuple22 == null) break block2;
                        b = (ProgrammaticDriverConfigLoaderBuilder)tuple22._1();
                        tuple2 = (Tuple2)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                DefaultDriverOption name = (DefaultDriverOption)tuple2._1();
                Option value = (Option)tuple2._2();
                ProgrammaticDriverConfigLoaderBuilder programmaticDriverConfigLoaderBuilder = (ProgrammaticDriverConfigLoaderBuilder)value.map((Function1 & Serializable & scala.Serializable)x$3 -> (ProgrammaticDriverConfigLoaderBuilder)b.withString((DriverOption)name, x$3)).getOrElse((Function0 & Serializable & scala.Serializable)() -> b);
                return programmaticDriverConfigLoaderBuilder;
            })).withClass((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, DefaultSslEngineFactory.class).withStringList((DriverOption)DefaultDriverOption.SSL_CIPHER_SUITES, (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ipConf.cassandraSSLConf().enabledAlgorithms().toList()).asJava()).withBoolean((DriverOption)DefaultDriverOption.SSL_HOSTNAME_VALIDATION, false) : builder;
        };
    }

    private DefaultConnectionFactory$() {
        MODULE$ = this;
        CassandraConnectionFactory.$init$(this);
    }
}

