/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.datasource;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.querybuilder.BuildableQuery;
import com.datastax.oss.driver.api.querybuilder.SchemaBuilder;
import com.datastax.oss.driver.api.querybuilder.schema.AlterKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.AlterKeyspaceStart;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableAddColumn;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableAddColumnEnd;
import com.datastax.oss.driver.api.querybuilder.schema.AlterTableWithOptionsEnd;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspace;
import com.datastax.oss.driver.api.querybuilder.schema.CreateKeyspaceStart;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTable;
import com.datastax.oss.driver.api.querybuilder.schema.CreateTableStart;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.datasource.CassandraCatalog$;
import com.datastax.spark.connector.datasource.CassandraCatalogException;
import com.datastax.spark.connector.datasource.CassandraSourceUtil$;
import com.datastax.spark.connector.datasource.CassandraTable;
import com.datastax.spark.connector.datasource.CassandraTable$;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.NamedReference;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\rma\u0001B A\u0001-CQA\u001c\u0001\u0005\u0002=D\u0001B\u001d\u0001\t\u0006\u0004%Ia\u001d\u0005\bq\u0002\u0011\r\u0011\"\u0003z\u0011\u0019i\b\u0001)A\u0005u\"9a\u0010\u0001b\u0001\n\u0013I\bBB@\u0001A\u0003%!\u0010\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0003z\u0011\u001d\t\u0019\u0001\u0001Q\u0001\niD\u0001\"!\u0002\u0001\u0005\u0004%I!\u001f\u0005\b\u0003\u000f\u0001\u0001\u0015!\u0003{\u0011!\tI\u0001\u0001b\u0001\n\u0013I\bbBA\u0006\u0001\u0001\u0006IA\u001f\u0005\n\u0003\u001b\u0001!\u0019!C\u0005\u0003\u001fA\u0001\"!\t\u0001A\u0003%\u0011\u0011\u0003\u0005\t\u0003G\u0001!\u0019!C\u0005s\"9\u0011Q\u0005\u0001!\u0002\u0013Q\b\u0002CA\u0014\u0001\t\u0007I\u0011B=\t\u000f\u0005%\u0002\u0001)A\u0005u\"I\u00111\u0006\u0001C\u0002\u0013%\u0011Q\u0006\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u00020!Q1\t\u0001a\u0001\u0002\u0004%I!!\u0010\t\u0017\u0005-\u0003\u00011AA\u0002\u0013%\u0011Q\n\u0005\f\u00037\u0002\u0001\u0019!A!B\u0013\ty\u0004C\u0006\u0002^\u0001\u0001\r\u00111A\u0005\n\u0005}\u0003bCA5\u0001\u0001\u0007\t\u0019!C\u0005\u0003WB1\"a\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002b!Y\u0011\u0011\u000f\u0001A\u0002\u0003\u0007I\u0011BA:\u0011-\ty\b\u0001a\u0001\u0002\u0004%I!!!\t\u0017\u0005\u0015\u0005\u00011A\u0001B\u0003&\u0011Q\u000f\u0005\f\u0003\u000f\u0003\u0001\u0019!a\u0001\n\u0013\tI\tC\u0006\u0002 \u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0006bCAS\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0017C1\"a*\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\n\"Y\u0011\u0011\u0016\u0001A\u0002\u0003\u0007I\u0011BAV\u0011-\ty\u000b\u0001a\u0001\u0002\u0003\u0006K!a#\t\u000f\u0005E\u0006\u0001\"\u0011\u00024\"9\u0011q\u0017\u0001\u0005B\u0005u\u0006bBA`\u0001\u0011\u0005\u0013\u0011\u0019\u0005\b\u0003\u007f\u0003A\u0011IAf\u0011\u001d\t\t\u000e\u0001C!\u0003'Dq!!:\u0001\t\u0003\n9\u000fC\u0004\u0002|\u0002!\t%!@\t\u000f\t\u0005\u0001\u0001\"\u0011\u0003\u0004!9!Q\u0002\u0001\u0005B\t=\u0001b\u0002B\u000e\u0001\u0011\u0005#Q\u0004\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0011\u001d\u0011)\u0006\u0001C\u0005\u0005/BqAa\u001d\u0001\t\u0013\u0011)\bC\u0004\u0003\n\u0002!\tEa#\t\u000f\te\u0005\u0001\"\u0011\u0003\u001c\"9!q\u0014\u0001\u0005B\t\u0005va\u0002BV\u0001\"\u0005!Q\u0016\u0004\u0007\u007f\u0001C\tAa,\t\r9,D\u0011\u0001B\\\u0011!\u0011I,\u000eb\u0001\n\u0013I\bb\u0002B^k\u0001\u0006IA\u001f\u0005\b\u0005{+D\u0011\u0001B`\u0011\u001d\u0011)-\u000eC\u0005\u0005\u000fDqAa56\t\u0003\u0011)\u000eC\u0004\u0003ZV\"\tAa7\t\u000f\teX\u0007\"\u0003\u0003|\"9!q`\u001b\u0005\u0002\r\u0005!\u0001E\"bgN\fg\u000e\u001a:b\u0007\u0006$\u0018\r\\8h\u0015\t\t%)\u0001\u0006eCR\f7o\\;sG\u0016T!a\u0011#\u0002\u0013\r|gN\\3di>\u0014(BA#G\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0005*\u0001\u0005eCR\f7\u000f^1y\u0015\u0005I\u0015aA2p[\u000e\u00011C\u0002\u0001M)\n,\u0007\u000e\u0005\u0002N%6\taJ\u0003\u0002P!\u0006!A.\u00198h\u0015\u0005\t\u0016\u0001\u00026bm\u0006L!a\u0015(\u0003\r=\u0013'.Z2u!\t)\u0006-D\u0001W\u0015\t9\u0006,A\u0004dCR\fGn\\4\u000b\u0005\rK&B\u0001.\\\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000brS!!\u00180\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0016aA8sO&\u0011\u0011M\u0016\u0002\u000e\u0007\u0006$\u0018\r\\8h!2,x-\u001b8\u0011\u0005U\u001b\u0017B\u00013W\u00051!\u0016M\u00197f\u0007\u0006$\u0018\r\\8h!\t)f-\u0003\u0002h-\n\u00112+\u001e9q_J$8OT1nKN\u0004\u0018mY3t!\tIG.D\u0001k\u0015\tY')\u0001\u0003vi&d\u0017BA7k\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#\u00019\u0011\u0005E\u0004Q\"\u0001!\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u0003Q\u0004\"!\u001e<\u000e\u0003eK!a^-\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002!I+\u0007\u000f\\5dCRLwN\\\"mCN\u001cX#\u0001>\u0011\u00055[\u0018B\u0001?O\u0005\u0019\u0019FO]5oO\u0006\t\"+\u001a9mS\u000e\fG/[8o\u00072\f7o\u001d\u0011\u0002#I+\u0007\u000f\\5dCRLwN\u001c$bGR|'/\u0001\nSKBd\u0017nY1uS>tg)Y2u_J\u0004\u0013!\u0004#ve\u0006\u0014G.Z,sSR,7/\u0001\bEkJ\f'\r\\3Xe&$Xm\u001d\u0011\u0002/9+Go^8sWR{\u0007o\u001c7pOf\u001cFO]1uK\u001eL\u0018\u0001\u0007(fi^|'o\u001b+pa>dwnZ=TiJ\fG/Z4zA\u0005q1+[7qY\u0016\u001cFO]1uK\u001eL\u0018aD*j[BdWm\u0015;sCR,w-\u001f\u0011\u00023%;gn\u001c:fIJ+\u0007\u000f\\5dCRLwN\\(qi&|gn]\u000b\u0003\u0003#\u0001R!a\u0005\u0002\u001eil!!!\u0006\u000b\t\u0005]\u0011\u0011D\u0001\u000bG>dG.Z2uS>t'BAA\u000e\u0003\u0015\u00198-\u00197b\u0013\u0011\ty\"!\u0006\u0003\u0007M+\u0017/\u0001\u000eJO:|'/\u001a3SKBd\u0017nY1uS>tw\n\u001d;j_:\u001c\b%\u0001\u0007QCJ$\u0018\u000e^5p].+\u00170A\u0007QCJ$\u0018\u000e^5p].+\u0017\u0010I\u0001\u000e\u00072,8\u000f^3sS:<7*Z=\u0002\u001d\rcWo\u001d;fe&twmS3zA\u0005\u00192)Y:tC:$'/\u0019)s_B,'\u000f^5fgV\u0011\u0011q\u0006\t\u0006\u0003c\t9D_\u0007\u0003\u0003gQA!!\u000e\u0002\u0016\u00059Q.\u001e;bE2,\u0017\u0002BA\u001d\u0003g\u00111aU3u\u0003Q\u0019\u0015m]:b]\u0012\u0014\u0018\r\u0015:pa\u0016\u0014H/[3tAU\u0011\u0011q\b\t\u0005\u0003\u0003\n9%\u0004\u0002\u0002D)\u0019\u0011Q\t\"\u0002\u0007\r\fH.\u0003\u0003\u0002J\u0005\r#AE\"bgN\fg\u000e\u001a:b\u0007>tg.Z2u_J\fQbY8o]\u0016\u001cGo\u001c:`I\u0015\fH\u0003BA(\u0003/\u0002B!!\u0015\u0002T5\u0011\u0011\u0011D\u0005\u0005\u0003+\nIB\u0001\u0003V]&$\b\"CA--\u0005\u0005\t\u0019AA \u0003\rAH%M\u0001\u000bG>tg.Z2u_J\u0004\u0013\u0001E2p]N|G.\u001b3bi\u0016$7i\u001c8g+\t\t\t\u0007\u0005\u0003\u0002d\u0005\u0015T\"A.\n\u0007\u0005\u001d4LA\u0005Ta\u0006\u00148nQ8oM\u0006!2m\u001c8t_2LG-\u0019;fI\u000e{gNZ0%KF$B!a\u0014\u0002n!I\u0011\u0011L\r\u0002\u0002\u0003\u0007\u0011\u0011M\u0001\u0012G>t7o\u001c7jI\u0006$X\rZ\"p]\u001a\u0004\u0013AD2bi\u0006dwnZ(qi&|gn]\u000b\u0003\u0003k\u0002B!a\u001e\u0002|5\u0011\u0011\u0011\u0010\u0006\u0003WfKA!! \u0002z\tA2)Y:f\u0013:\u001cXM\\:ji&4Xm\u0015;sS:<W*\u00199\u0002%\r\fG/\u00197pO>\u0003H/[8og~#S-\u001d\u000b\u0005\u0003\u001f\n\u0019\tC\u0005\u0002Zq\t\t\u00111\u0001\u0002v\u0005y1-\u0019;bY><w\n\u001d;j_:\u001c\b%A\u0006dCR\fGn\\4OC6,WCAAF!\u0011\ti)a'\u000f\t\u0005=\u0015q\u0013\t\u0005\u0003#\u000bI\"\u0004\u0002\u0002\u0014*\u0019\u0011Q\u0013&\u0002\rq\u0012xn\u001c;?\u0013\u0011\tI*!\u0007\u0002\rA\u0013X\rZ3g\u0013\ra\u0018Q\u0014\u0006\u0005\u00033\u000bI\"A\bdCR\fGn\\4OC6,w\fJ3r)\u0011\ty%a)\t\u0013\u0005es$!AA\u0002\u0005-\u0015\u0001D2bi\u0006dwn\u001a(b[\u0016\u0004\u0013A\u00048b[\u0016LE-\u001a8uS\u001aLWM]\u0001\u0013]\u0006lW-\u00133f]RLg-[3s?\u0012*\u0017\u000f\u0006\u0003\u0002P\u00055\u0006\"CA-E\u0005\u0005\t\u0019AAF\u0003=q\u0017-\\3JI\u0016tG/\u001b4jKJ\u0004\u0013AC5oSRL\u0017\r\\5{KR1\u0011qJA[\u0003sCq!a.%\u0001\u0004\tY)\u0001\u0003oC6,\u0007bBA^I\u0001\u0007\u0011QO\u0001\b_B$\u0018n\u001c8t)\t\tY)\u0001\bmSN$h*Y7fgB\f7-Z:\u0015\u0005\u0005\r\u0007CBA)\u0003\u000b\fI-\u0003\u0003\u0002H\u0006e!!B!se\u0006L\bCBA)\u0003\u000b\fY\t\u0006\u0003\u0002D\u00065\u0007bBAhO\u0001\u0007\u0011\u0011Z\u0001\n]\u0006lWm\u001d9bG\u0016\fqb\u0019:fCR,g*Y7fgB\f7-\u001a\u000b\u0007\u0003\u001f\n).a6\t\u000f\u0005=\u0007\u00061\u0001\u0002J\"9\u0011\u0011\u001c\u0015A\u0002\u0005m\u0017\u0001C7fi\u0006$\u0017\r^1\u0011\u0011\u0005u\u0017\u0011]AF\u0003\u0017k!!a8\u000b\u0005-\u0004\u0016\u0002BAr\u0003?\u00141!T1q\u00039\tG\u000e^3s\u001d\u0006lWm\u001d9bG\u0016$b!a\u0014\u0002j\u0006-\bbBAhS\u0001\u0007\u0011\u0011\u001a\u0005\b\u0003[L\u0003\u0019AAx\u0003\u001d\u0019\u0007.\u00198hKN\u0004b!!\u0015\u0002r\u0006U\u0018\u0002BAz\u00033\u0011!\u0002\u0010:fa\u0016\fG/\u001a3?!\r)\u0016q_\u0005\u0004\u0003s4&a\u0004(b[\u0016\u001c\b/Y2f\u0007\"\fgnZ3\u0002+1|\u0017\r\u001a(b[\u0016\u001c\b/Y2f\u001b\u0016$\u0018\rZ1uCR!\u00111\\A\u0000\u0011\u001d\tyM\u000ba\u0001\u0003\u0013\fQ\u0002\u001a:pa:\u000bW.Z:qC\u000e,G\u0003\u0002B\u0003\u0005\u0017\u0001B!!\u0015\u0003\b%!!\u0011BA\r\u0005\u001d\u0011un\u001c7fC:Dq!a4,\u0001\u0004\tI-\u0001\u0006mSN$H+\u00192mKN$BA!\u0005\u0003\u001aA1\u0011\u0011KAc\u0005'\u00012!\u0016B\u000b\u0013\r\u00119B\u0016\u0002\u000b\u0013\u0012,g\u000e^5gS\u0016\u0014\bbBAhY\u0001\u0007\u0011\u0011Z\u0001\nY>\fG\rV1cY\u0016$BAa\b\u0003&A\u0019QK!\t\n\u0007\t\rbKA\u0003UC\ndW\rC\u0004\u0003(5\u0002\rAa\u0005\u0002\u000b%$WM\u001c;\u0002\u0017\r\u0014X-\u0019;f)\u0006\u0014G.\u001a\u000b\u000b\u0005?\u0011iCa\f\u0003@\tE\u0003b\u0002B\u0014]\u0001\u0007!1\u0003\u0005\b\u0005cq\u0003\u0019\u0001B\u001a\u0003\u0019\u00198\r[3nCB!!Q\u0007B\u001e\u001b\t\u00119DC\u0002\u0003:e\u000bQ\u0001^=qKNLAA!\u0010\u00038\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u000f\t\u0005c\u00061\u0001\u0003D\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\r\u0005E\u0013Q\u0019B#!\u0011\u00119E!\u0014\u000e\u0005\t%#b\u0001B&1\u0006YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\u0011\u0011yE!\u0013\u0003\u0013Q\u0013\u0018M\\:g_Jl\u0007b\u0002B*]\u0001\u0007\u00111\\\u0001\u000baJ|\u0007/\u001a:uS\u0016\u001c\u0018aD2iK\u000e\\7i\u001c7v[:t\u0015-\\3\u0015\t\te#\u0011\u000f\t\u0005\u00057\u0012i'\u0004\u0002\u0003^)!!q\fB1\u0003\u0011\u0019wN]3\u000b\t\t\r$QM\u0001\u0004CBL'\u0002\u0002B4\u0005S\na\u0001\u001a:jm\u0016\u0014(b\u0001B6\r\u0006\u0019qn]:\n\t\t=$Q\f\u0002\u000e\u0007Fd\u0017\nZ3oi&4\u0017.\u001a:\t\u000f\u0005]v\u00061\u0001\u0002J\u000692\r[3dWJ+Wn\u001c<f\u001d>\u0014X.\u00197D_2,XN\u001c\u000b\u0007\u00053\u00129Ha\"\t\u000f\te\u0004\u00071\u0001\u0003|\u0005IA/\u00192mK6+G/\u0019\t\u0005\u0005{\u0012\u0019)\u0004\u0002\u0003\u0000)!!\u0011\u0007BA\u0015\u0011\tIN!\u0018\n\t\t\u0015%q\u0010\u0002\u000e)\u0006\u0014G.Z'fi\u0006$\u0017\r^1\t\u000f\u0005]\u0006\u00071\u0001\u0002J\u0006Q\u0011\r\u001c;feR\u000b'\r\\3\u0015\r\t}!Q\u0012BH\u0011\u001d\u00119#\ra\u0001\u0005'Aq!!<2\u0001\u0004\u0011\t\n\u0005\u0004\u0002R\u0005E(1\u0013\t\u0004+\nU\u0015b\u0001BL-\nYA+\u00192mK\u000eC\u0017M\\4f\u0003%!'o\u001c9UC\ndW\r\u0006\u0003\u0003\u0006\tu\u0005b\u0002B\u0014e\u0001\u0007!1C\u0001\fe\u0016t\u0017-\\3UC\ndW\r\u0006\u0004\u0002P\t\r&q\u0015\u0005\b\u0005K\u001b\u0004\u0019\u0001B\n\u0003!yG\u000eZ%eK:$\bb\u0002BUg\u0001\u0007!1C\u0001\t]\u0016<\u0018\nZ3oi\u0006\u00012)Y:tC:$'/Y\"bi\u0006dwn\u001a\t\u0003cV\u001a2!\u000eBY!\u0011\t\tFa-\n\t\tU\u0016\u0011\u0004\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\t5\u0016\u0001E(oYf|e.\u001a(b[\u0016\u001c\b/Y2f\u0003Eye\u000e\\=P]\u0016t\u0015-\\3ta\u0006\u001cW\rI\u0001\u0011O\u0016$H+\u00192mK6+G/\u0019#bi\u0006$bAa\u001f\u0003B\n\r\u0007BB\":\u0001\u0004\ty\u0004C\u0004\u0003(e\u0002\rAa\u0005\u0002\u001f\u001d,GoS3zgB\f7-Z'fi\u0006$bA!3\u0003P\nE\u0007\u0003\u0002B?\u0005\u0017LAA!4\u0003\u0000\t\u00012*Z=ta\u0006\u001cW-T3uC\u0012\fG/\u0019\u0005\u0007\u0007j\u0002\r!a\u0010\t\u000f\u0005='\b1\u0001\u0002J\u0006q1\r[3dW:\u000bW.Z:qC\u000e,G\u0003BA(\u0005/Dq!a4<\u0001\u0004\tI-\u0001\toC6,7\u000f]1dK6K7o]5oOR1!Q\u001cBw\u0005o\u0004BAa8\u0003j6\u0011!\u0011\u001d\u0006\u0005\u0005G\u0014)/\u0001\u0005b]\u0006d\u0017p]5t\u0015\r\u00119/W\u0001\tG\u0006$\u0018\r\\=ti&!!1\u001eBq\u0005aqunU;dQ:\u000bW.Z:qC\u000e,W\t_2faRLwN\u001c\u0005\b\u00033d\u0004\u0019\u0001Bx!\u0011\u0011\tPa=\u000e\u0005\t\u0005\u0015\u0002\u0002B{\u0005\u0003\u0013\u0001\"T3uC\u0012\fG/\u0019\u0005\b\u0003\u001fd\u0004\u0019AAe\u0003-9W\r^'fi\u0006$\u0017\r^1\u0015\t\t=(Q \u0005\u0007\u0007v\u0002\r!a\u0010\u0002\u0019Q\f'\r\\3NSN\u001c\u0018N\\4\u0015\u0011\r\r1QCB\f\u00073\u0001Ba!\u0002\u0004\u00109!1qAB\u0006\u001d\u0011\t\tj!\u0003\n\u0005\u0005m\u0011\u0002BB\u0007\u00033\tq\u0001]1dW\u0006<W-\u0003\u0003\u0004\u0012\rM!!\u0003+ie><\u0018M\u00197f\u0015\u0011\u0019i!!\u0007\t\u000f\u0005eg\b1\u0001\u0003p\"9\u0011q\u001a A\u0002\u0005%\u0007bBA\\}\u0001\u0007\u00111\u0012")
public class CassandraCatalog
implements CatalogPlugin,
TableCatalog,
SupportsNamespaces,
Logging {
    private SparkSession sparkSession;
    private final String ReplicationClass;
    private final String ReplicationFactor;
    private final String DurableWrites;
    private final String NetworkTopologyStrategy;
    private final String SimpleStrategy;
    private final Seq<String> IgnoredReplicationOptions;
    private final String PartitionKey;
    private final String ClusteringKey;
    private final scala.collection.mutable.Set<String> com$datastax$spark$connector$datasource$CassandraCatalog$$CassandraProperties;
    private CassandraConnector connector;
    private SparkConf consolidatedConf;
    private CaseInsensitiveStringMap catalogOptions;
    private String catalogName;
    private String nameIdentifier;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;
    private volatile boolean bitmap$0;

    public static Throwable tableMissing(Metadata metadata, String[] stringArray, String string) {
        return CassandraCatalog$.MODULE$.tableMissing(metadata, stringArray, string);
    }

    public static NoSuchNamespaceException namespaceMissing(Metadata metadata, String[] stringArray) {
        return CassandraCatalog$.MODULE$.namespaceMissing(metadata, stringArray);
    }

    public static void checkNamespace(String[] stringArray) {
        CassandraCatalog$.MODULE$.checkNamespace(stringArray);
    }

    public static TableMetadata getTableMetaData(CassandraConnector cassandraConnector, Identifier identifier) {
        return CassandraCatalog$.MODULE$.getTableMetaData(cassandraConnector, identifier);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public boolean namespaceExists(String[] x$1) {
        return super.namespaceExists(x$1);
    }

    public void invalidateTable(Identifier x$1) {
        super.invalidateTable(x$1);
    }

    public boolean tableExists(Identifier x$1) {
        return super.tableExists(x$1);
    }

    public boolean purgeTable(Identifier x$1) throws UnsupportedOperationException {
        return super.purgeTable(x$1);
    }

    public String[] defaultNamespace() {
        return super.defaultNamespace();
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    private SparkSession sparkSession$lzycompute() {
        CassandraCatalog cassandraCatalog = this;
        synchronized (cassandraCatalog) {
            if (!this.bitmap$0) {
                this.sparkSession = SparkSession$.MODULE$.active();
                this.bitmap$0 = true;
            }
        }
        return this.sparkSession;
    }

    private SparkSession sparkSession() {
        return !this.bitmap$0 ? this.sparkSession$lzycompute() : this.sparkSession;
    }

    private String ReplicationClass() {
        return this.ReplicationClass;
    }

    private String ReplicationFactor() {
        return this.ReplicationFactor;
    }

    private String DurableWrites() {
        return this.DurableWrites;
    }

    private String NetworkTopologyStrategy() {
        return this.NetworkTopologyStrategy;
    }

    private String SimpleStrategy() {
        return this.SimpleStrategy;
    }

    private Seq<String> IgnoredReplicationOptions() {
        return this.IgnoredReplicationOptions;
    }

    private String PartitionKey() {
        return this.PartitionKey;
    }

    private String ClusteringKey() {
        return this.ClusteringKey;
    }

    public scala.collection.mutable.Set<String> com$datastax$spark$connector$datasource$CassandraCatalog$$CassandraProperties() {
        return this.com$datastax$spark$connector$datasource$CassandraCatalog$$CassandraProperties;
    }

    private CassandraConnector connector() {
        return this.connector;
    }

    private void connector_$eq(CassandraConnector x$1) {
        this.connector = x$1;
    }

    private SparkConf consolidatedConf() {
        return this.consolidatedConf;
    }

    private void consolidatedConf_$eq(SparkConf x$1) {
        this.consolidatedConf = x$1;
    }

    private CaseInsensitiveStringMap catalogOptions() {
        return this.catalogOptions;
    }

    private void catalogOptions_$eq(CaseInsensitiveStringMap x$1) {
        this.catalogOptions = x$1;
    }

    private String catalogName() {
        return this.catalogName;
    }

    private void catalogName_$eq(String x$1) {
        this.catalogName = x$1;
    }

    private String nameIdentifier() {
        return this.nameIdentifier;
    }

    private void nameIdentifier_$eq(String x$1) {
        this.nameIdentifier = x$1;
    }

    public void initialize(String name, CaseInsensitiveStringMap options) {
        SparkConf sparkConf;
        this.catalogOptions_$eq(options);
        SparkConf x$1 = sparkConf = this.sparkSession().sparkContext().getConf();
        scala.collection.immutable.Map x$2 = this.sparkSession().conf().getAll();
        String x$3 = name;
        scala.collection.immutable.Map x$4 = ((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)options).asScala()).toMap(Predef$.MODULE$.$conforms());
        String x$5 = CassandraSourceUtil$.MODULE$.consolidateConfs$default$4();
        this.consolidatedConf_$eq(CassandraSourceUtil$.MODULE$.consolidateConfs(x$1, (scala.collection.immutable.Map<String, String>)x$2, x$3, x$5, (scala.collection.immutable.Map<String, String>)x$4));
        this.connector_$eq(CassandraConnector$.MODULE$.apply(this.consolidatedConf()));
        this.catalogName_$eq(name);
        this.nameIdentifier_$eq(this.connector().conf().contactInfo().endPointStr());
    }

    public String name() {
        return this.catalogName();
    }

    public String[][] listNamespaces() {
        return (String[][])((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(CassandraCatalog$.MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(this.connector()).getKeyspaces()).asScala()).keys().map((Function1 & Serializable & scala.Serializable)cqlIdentifier -> (String[])((Object[])new String[]{cqlIdentifier.asInternal()}), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    public String[][] listNamespaces(String[] namespace) {
        CassandraCatalog$.MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getKeyspaceMeta(this.connector(), namespace);
        return (String[][])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) {
        CreateKeyspace createKeyspace;
        scala.collection.mutable.Map ksMeta = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadata).asScala();
        CassandraCatalog$.MODULE$.checkNamespace(namespace);
        if (CassandraCatalog$.MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getMetadata(this.connector()).getKeyspace(CqlIdentifier.fromInternal((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head()))).isPresent()) {
            throw new NamespaceAlreadyExistsException(new StringBuilder(15).append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head()).append(" already exists").toString());
        }
        CreateKeyspaceStart createStmt = SchemaBuilder.createKeyspace((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head()));
        String replicationClass = (String)ksMeta.getOrElse((Object)this.ReplicationClass(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new CassandraCatalogException(new StringBuilder(75).append("Creating a keyspace requires a ").append(this.ReplicationClass()).append(" DBOption for the replication strategy class").toString());
        });
        String string = replicationClass.toLowerCase(Locale.ROOT);
        String string2 = this.SimpleStrategy();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String replicationFactor = (String)ksMeta.getOrElse((Object)this.ReplicationFactor(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new CassandraCatalogException(new StringBuilder(34).append("Need a ").append(this.ReplicationFactor()).append(" option with SimpleStrategy").toString());
            });
            createKeyspace = (CreateKeyspace)createStmt.withSimpleStrategy(new StringOps(Predef$.MODULE$.augmentString(replicationFactor)).toInt());
        } else {
            String string4 = this.NetworkTopologyStrategy();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                scala.collection.mutable.Map datacenters = (scala.collection.mutable.Map)ksMeta.$minus$minus(this.IgnoredReplicationOptions()).map((Function1 & Serializable & scala.Serializable)pair -> new Tuple2(pair._1(), (Object)Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString((String)pair._2())).toInt())), Map$.MODULE$.canBuildFrom());
                createKeyspace = (CreateKeyspace)createStmt.withNetworkTopologyStrategy((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(datacenters).asJava());
            } else {
                throw new CassandraCatalogException(new StringBuilder(38).append("Unknown keyspace replication strategy ").append(string).toString());
            }
        }
        CreateKeyspace createWithReplication = createKeyspace;
        CreateKeyspace finalCreateStmt = (CreateKeyspace)createWithReplication.withDurableWrites(new StringOps(Predef$.MODULE$.augmentString((String)ksMeta.getOrElse((Object)this.DurableWrites(), (Function0 & Serializable & scala.Serializable)() -> "True"))).toBoolean());
        this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute(finalCreateStmt.asCql()));
    }

    public void alterNamespace(String[] namespace, Seq<NamespaceChange> changes) {
        AlterKeyspace alterKeyspace;
        CassandraCatalog$.MODULE$.checkNamespace(namespace);
        scala.collection.mutable.Map ksMeta = (scala.collection.mutable.Map)changes.foldLeft(JavaConverters$.MODULE$.mapAsScalaMapConverter(this.loadNamespaceMetadata(namespace)).asScala(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)tuple2._1();
                NamespaceChange setProperty = (NamespaceChange)tuple2._2();
                if (metadata != null) {
                    scala.collection.mutable.Map map = metadata;
                    if (setProperty instanceof NamespaceChange.SetProperty) {
                        NamespaceChange.SetProperty setProperty2 = (NamespaceChange.SetProperty)setProperty;
                        return map.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)setProperty2.property()), (Object)setProperty2.value()));
                    }
                }
            }
            if (tuple2 != null) {
                scala.collection.mutable.Map metadata = (scala.collection.mutable.Map)tuple2._1();
                NamespaceChange removeProperty = (NamespaceChange)tuple2._2();
                if (metadata != null) {
                    scala.collection.mutable.Map map = metadata;
                    if (removeProperty instanceof NamespaceChange.RemoveProperty) {
                        NamespaceChange.RemoveProperty removeProperty2 = (NamespaceChange.RemoveProperty)removeProperty;
                        return map.$minus((Object)removeProperty2.property());
                    }
                }
            }
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            NamespaceChange other = (NamespaceChange)tuple2._2();
            throw new CassandraCatalogException(new StringBuilder(44).append("Unable to handle alter namespace operation: ").append(other.getClass().getSimpleName()).toString());
        });
        AlterKeyspaceStart alterStart = SchemaBuilder.alterKeyspace((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])namespace)).head()));
        AlterKeyspace alterWithDurable = (AlterKeyspace)alterStart.withDurableWrites(new StringOps(Predef$.MODULE$.augmentString((String)ksMeta.getOrElse((Object)this.DurableWrites(), (Function0 & Serializable & scala.Serializable)() -> "True"))).toBoolean());
        String replicationClass = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)ksMeta.getOrElse((Object)this.ReplicationClass(), (Function0 & Serializable & scala.Serializable)() -> {
            throw new CassandraCatalogException(new StringBuilder(38).append("Altering a keyspace requires a ").append(this.ReplicationClass()).append(" option").toString());
        })).split("\\."))).last();
        String string = replicationClass.toLowerCase(Locale.ROOT);
        String string2 = this.SimpleStrategy();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            String replicationFactor = (String)ksMeta.getOrElse((Object)this.ReplicationFactor(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new CassandraCatalogException(new StringBuilder(34).append("Need a ").append(this.ReplicationFactor()).append(" option with SimpleStrategy").toString());
            });
            alterKeyspace = (AlterKeyspace)alterWithDurable.withSimpleStrategy(new StringOps(Predef$.MODULE$.augmentString(replicationFactor)).toInt());
        } else {
            String string4 = this.NetworkTopologyStrategy();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                scala.collection.mutable.Map datacenters = (scala.collection.mutable.Map)ksMeta.$minus$minus(this.IgnoredReplicationOptions()).map((Function1 & Serializable & scala.Serializable)pair -> new Tuple2(pair._1(), (Object)Predef$.MODULE$.int2Integer(new StringOps(Predef$.MODULE$.augmentString((String)pair._2())).toInt())), Map$.MODULE$.canBuildFrom());
                alterKeyspace = (AlterKeyspace)alterWithDurable.withNetworkTopologyStrategy((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(datacenters).asJava());
            } else {
                throw new CassandraCatalogException(new StringBuilder(29).append("Unknown replication strategy ").append(string).toString());
            }
        }
        AlterKeyspace alterWithReplication = alterKeyspace;
        this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute(alterWithReplication.asCql()));
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) {
        KeyspaceMetadata ksMetadata = CassandraCatalog$.MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getKeyspaceMeta(this.connector(), namespace);
        return (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(ksMetadata.getReplication()).asScala()).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.DurableWrites()), (Object)((Object)BoxesRunTime.boxToBoolean((boolean)ksMetadata.isDurableWrites())).toString()))).asJava();
    }

    public boolean dropNamespace(String[] namespace) {
        CassandraCatalog$.MODULE$.checkNamespace(namespace);
        KeyspaceMetadata keyspace = CassandraCatalog$.MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getKeyspaceMeta(this.connector(), namespace);
        ResultSet dropResult = (ResultSet)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)session -> session.execute(SchemaBuilder.dropKeyspace((CqlIdentifier)keyspace.getName()).asCql()));
        return dropResult.wasApplied();
    }

    public Identifier[] listTables(String[] namespace) {
        return (Identifier[])((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(CassandraCatalog$.MODULE$.com$datastax$spark$connector$datasource$CassandraCatalog$$getKeyspaceMeta(this.connector(), namespace).getTables()).asScala()).keys().map((Function1 & Serializable & scala.Serializable)tableName -> Identifier.of((String[])namespace, (String)tableName.asInternal()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Identifier.class));
    }

    public Table loadTable(Identifier ident) {
        TableMetadata tableMeta = CassandraCatalog$.MODULE$.getTableMetaData(this.connector(), ident);
        return new CassandraTable(this.sparkSession(), this.catalogOptions(), this.connector(), this.catalogName(), tableMeta, CassandraTable$.MODULE$.apply$default$6());
    }

    public Table createTable(Identifier ident, StructType schema, Transform[] partitions, Map<String, String> properties) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        scala.collection.mutable.Map tableProps;
        block13: {
            Try try_;
            Failure failure;
            boolean bl;
            block12: {
                tableProps = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(properties).asScala();
                bl = false;
                failure = null;
                try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> CassandraCatalog$.MODULE$.getTableMetaData(this.connector(), ident));
                if (try_ instanceof Success) {
                    throw new TableAlreadyExistsException(ident);
                }
                if (!(try_ instanceof Failure)) break block12;
                bl = true;
                failure = (Failure)try_;
                Throwable noSuchTableException = failure.exception();
                if (noSuchTableException instanceof NoSuchTableException) break block13;
            }
            if (bl) {
                Throwable e = failure.exception();
                throw e;
            }
            throw new MatchError((Object)try_);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Transform[] invalidPartitions = (Transform[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CassandraCatalog.$anonfun$createTable$2(x$1)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidPartitions)).nonEmpty()) {
            throw new UnsupportedOperationException(new StringBuilder(87).append("Cassandra Tables can only by partitioned based on direct references to columns, found: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])invalidPartitions)).mkString(",")).toString());
        }
        String[] providedPartitionKeyNames = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitions)).map((Function1 & Serializable & scala.Serializable)x$2 -> (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((NamedReference)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$2.references())).head()).fieldNames())).head(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        String[] stringArray4 = providedPartitionKeyNames;
        if (stringArray4 != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(stringArray3 = stringArray4))).nonEmpty() && tableProps.contains((Object)this.PartitionKey())) {
            throw new CassandraCatalogException(new StringBuilder(82).append("Table property ").append(this.PartitionKey()).append(" is specified as well as PARTITIONED BY clause, please use just one").toString());
        }
        if (stringArray4 != null && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])(stringArray2 = stringArray4))).nonEmpty()) {
            stringArray = stringArray2;
        } else if (stringArray4 != null && tableProps.contains((Object)this.PartitionKey())) {
            stringArray = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((String)tableProps.apply((Object)this.PartitionKey())).split(","))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.replaceAll("\\s", ""), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        } else {
            throw new CassandraCatalogException(new StringBuilder(89).append("Cassandra Tables need partition keys defined in property ").append(this.PartitionKey()).append(" or with 'PARTITIONED BY columns").toString());
        }
        String[] partitionKeys = stringArray;
        CqlIdentifier[] partitionKeyNames = (CqlIdentifier[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionKeys)).map((Function1 & Serializable & scala.Serializable)x$1 -> CqlIdentifier.fromInternal((String)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CqlIdentifier.class)));
        Seq clusteringKeyNames = (Seq)((TraversableLike)Option$.MODULE$.option2Iterable(tableProps.get((Object)this.ClusteringKey())).toSeq().flatMap((Function1 & Serializable & scala.Serializable)value -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])value.split(","))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.replaceAll("\\s", "").split("\\."), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))))), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            String[] stringArray = x0$1;
            Option option = Array$.MODULE$.unapplySeq((Object)stringArray);
            if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(2) == 0) {
                String name = (String)((SeqLike)option.get()).apply(0);
                String order = (String)((SeqLike)option.get()).apply(1);
                ClusteringOrder clusteringOrder = (ClusteringOrder)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ClusteringOrder.valueOf((String)order.toUpperCase())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    throw new CassandraCatalogException(new StringBuilder(65).append("Invalid clustering order found in ").append(name).append(".").append(order).append(", must be ASC or DESC or blank").toString());
                });
                tuple2 = new Tuple2((Object)CqlIdentifier.fromInternal((String)name), (Object)clusteringOrder);
            } else {
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(1) == 0) {
                    String name = (String)((SeqLike)option2.get()).apply(0);
                    tuple2 = new Tuple2((Object)CqlIdentifier.fromInternal((String)name), (Object)ClusteringOrder.ASC);
                } else {
                    throw new CassandraCatalogException(new StringBuilder(55).append("Unable to parse clustering column ").append(stringArray).append(", too many components").toString());
                }
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom());
        ProtocolVersion protocolVersion = (ProtocolVersion)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getContext().getProtocolVersion());
        scala.collection.immutable.Map columnToType = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).map((Function1 & Serializable & scala.Serializable)sparkField -> new Tuple2((Object)CqlIdentifier.fromInternal((String)sparkField.name()), (Object)CassandraSourceUtil$.MODULE$.sparkSqlToJavaDriverType(sparkField.dataType(), protocolVersion)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
        CassandraCatalog$.MODULE$.checkNamespace(ident.namespace());
        CqlIdentifier namespace = CqlIdentifier.fromInternal((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ident.namespace())).head()));
        CqlIdentifier table = CqlIdentifier.fromInternal((String)ident.name());
        CreateTableStart createTableStart = SchemaBuilder.createTable((CqlIdentifier)namespace, (CqlIdentifier)table);
        CreateTable createTableWithPk = (CreateTable)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionKeyNames)).foldLeft((Object)createTableStart, (Function2 & Serializable & scala.Serializable)(createTable, pkName) -> {
            DataType dataType = (DataType)columnToType.getOrElse(pkName, (Function0 & Serializable & scala.Serializable)() -> {
                throw new CassandraCatalogException(new StringBuilder(68).append(pkName).append(" was defined as a partition key but it does not exist in the schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).mkString(",")).toString());
            });
            return createTable.withPartitionKey(pkName, dataType);
        });
        CreateTable createTableWithClustering = (CreateTable)clusteringKeyNames.foldLeft((Object)createTableWithPk, (Function2 & Serializable & scala.Serializable)(createTable, ckName) -> {
            DataType dataType = (DataType)columnToType.get((Object)CqlIdentifier.fromInternal((String)((CqlIdentifier)ckName._1()).asInternal().toLowerCase(Locale.ROOT))).orElse((Function0 & Serializable & scala.Serializable)() -> columnToType.get(ckName._1())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new CassandraCatalogException(new StringBuilder(69).append(ckName).append(" was defined as a clustering key but it does not exist in the schema ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).mkString(",")).toString());
            });
            return (CreateTable)createTable.withClusteringColumn((CqlIdentifier)ckName._1(), dataType).withClusteringOrder((CqlIdentifier)ckName._1(), (ClusteringOrder)ckName._2());
        });
        scala.collection.immutable.Set normalColumns = (scala.collection.immutable.Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).map((Function1 & Serializable & scala.Serializable)x$1 -> CqlIdentifier.fromInternal((String)x$1), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CqlIdentifier.class))))).toSet().$minus$minus((GenTraversableOnce)((TraversableLike)clusteringKeyNames.map((Function1 & Serializable & scala.Serializable)x$6 -> (CqlIdentifier)x$6._1(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionKeyNames)), Seq$.MODULE$.canBuildFrom()));
        CreateTable createTableWithColumns = (CreateTable)normalColumns.foldLeft((Object)createTableWithClustering, (Function2 & Serializable & scala.Serializable)(createTable, colName) -> {
            DataType dataType = (DataType)columnToType.apply(colName);
            return createTable.withColumn(colName, dataType);
        });
        Tuple2 tuple2 = tableProps.partition((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)CassandraCatalog.$anonfun$createTable$21(this, x0$2)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.mutable.Map userProperties = (scala.collection.mutable.Map)tuple2._1();
        scala.collection.mutable.Map unusedProperties = (scala.collection.mutable.Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)userProperties, (Object)unusedProperties);
        Tuple2 tuple23 = tuple22;
        scala.collection.mutable.Map userProperties2 = (scala.collection.mutable.Map)tuple23._1();
        scala.collection.mutable.Map unusedProperties2 = (scala.collection.mutable.Map)tuple23._2();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Ignoring non-cassandra properties for table ").append(unusedProperties2).toString());
        CreateTable createTableWithProperties = (CreateTable)userProperties2.foldLeft((Object)createTableWithColumns, (Function2 & Serializable & scala.Serializable)(x0$3, x1$1) -> {
            Tuple2 tuple2;
            CreateTable createStmt;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$3, x1$1);
                    if (tuple22 == null) break block2;
                    createStmt = (CreateTable)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String key = (String)tuple2._1();
            String value = (String)tuple2._2();
            CreateTable createTable = (CreateTable)createStmt.withOption(key, CassandraSourceUtil$.MODULE$.parseProperty(value));
            return createTable;
        });
        this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$8 -> x$8.execute(createTableWithProperties.asCql()));
        return this.loadTable(ident);
    }

    public CqlIdentifier com$datastax$spark$connector$datasource$CassandraCatalog$$checkColumnName(String[] name) {
        if (name.length != 1) {
            throw new CassandraCatalogException(new StringBuilder(70).append("Cassandra Column Identifiers can only have a single identifier, given ").append(name).toString());
        }
        return CqlIdentifier.fromInternal((String)((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])name)).head()));
    }

    /*
     * WARNING - void declaration
     */
    public CqlIdentifier com$datastax$spark$connector$datasource$CassandraCatalog$$checkRemoveNormalColumn(TableMetadata tableMeta, String[] name) {
        void var3_3;
        CqlIdentifier colName = this.com$datastax$spark$connector$datasource$CassandraCatalog$$checkColumnName(name);
        scala.collection.immutable.Set primaryKeys = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableMeta.getPrimaryKey()).asScala()).map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.getName().asInternal(), Buffer$.MODULE$.canBuildFrom())).toSet();
        if (primaryKeys.contains((Object)colName.asInternal())) {
            throw new CassandraCatalogException(new StringBuilder(57).append("Cassandra cannot drop primary key columns: Tried to drop ").append(colName).toString());
        }
        return var3_3;
    }

    public Table alterTable(Identifier ident, Seq<TableChange> changes) {
        Object object;
        Object object2;
        Object object3;
        ProtocolVersion protocolVersion = (ProtocolVersion)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$10 -> x$10.getContext().getProtocolVersion());
        TableMetadata tableMetadata = CassandraCatalog$.MODULE$.getTableMetaData(this.connector(), ident);
        CqlIdentifier keyspace = tableMetadata.getKeyspace();
        CqlIdentifier table = tableMetadata.getName();
        changes.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            CassandraCatalog.$anonfun$alterTable$2(x0$1);
            return BoxedUnit.UNIT;
        });
        Seq propertiesToAdd = (Seq)changes.collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;

            public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TableChange.SetProperty) {
                    TableChange.SetProperty setProperty = (TableChange.SetProperty)A1;
                    if (!this.$outer.com$datastax$spark$connector$datasource$CassandraCatalog$$CassandraProperties().contains((Object)setProperty.property())) {
                        throw new CassandraCatalogException(new StringBuilder(41).append("Unable to set unknown Cassandra Property ").append(setProperty.property()).toString());
                    }
                    object = setProperty;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TableChange x1) {
                TableChange tableChange = x1;
                boolean bl = tableChange instanceof TableChange.SetProperty;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq columnsToRemove = (Seq)changes.collect((PartialFunction)new scala.Serializable(this, tableMetadata){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;
            private final TableMetadata tableMetadata$1;

            public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof TableChange.DeleteColumn) {
                    TableChange.DeleteColumn deleteColumn = (TableChange.DeleteColumn)A1;
                    object = this.$outer.com$datastax$spark$connector$datasource$CassandraCatalog$$checkRemoveNormalColumn(this.tableMetadata$1, deleteColumn.fieldNames());
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TableChange x2) {
                TableChange tableChange = x2;
                boolean bl = tableChange instanceof TableChange.DeleteColumn;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.tableMetadata$1 = tableMetadata$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq columnsToAdd = (Seq)changes.collect((PartialFunction)new scala.Serializable(this, protocolVersion){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CassandraCatalog $outer;
            private final ProtocolVersion protocolVersion$2;

            public final <A1 extends TableChange, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x3;
                if (A1 instanceof TableChange.AddColumn) {
                    TableChange.AddColumn addColumn = (TableChange.AddColumn)A1;
                    object = new Tuple2((Object)this.$outer.com$datastax$spark$connector$datasource$CassandraCatalog$$checkColumnName(addColumn.fieldNames()), (Object)CassandraSourceUtil$.MODULE$.sparkSqlToJavaDriverType(addColumn.dataType(), this.protocolVersion$2));
                } else {
                    object = function1.apply(x3);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(TableChange x3) {
                TableChange tableChange = x3;
                boolean bl = tableChange instanceof TableChange.AddColumn;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.protocolVersion$2 = protocolVersion$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        if (propertiesToAdd.nonEmpty()) {
            String setOptionsStatement = ((BuildableQuery)propertiesToAdd.foldLeft((Object)((AlterTableWithOptionsEnd)SchemaBuilder.alterTable((CqlIdentifier)keyspace, (CqlIdentifier)table)), (Function2 & Serializable & scala.Serializable)(x0$2, x1$1) -> {
                Tuple2 tuple2 = new Tuple2(x0$2, x1$1);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                AlterTableWithOptionsEnd alter = (AlterTableWithOptionsEnd)tuple2._1();
                TableChange.SetProperty prop = (TableChange.SetProperty)tuple2._2();
                AlterTableWithOptionsEnd alterTableWithOptionsEnd = (AlterTableWithOptionsEnd)alter.withOption(prop.property(), CassandraSourceUtil$.MODULE$.parseProperty(prop.value()));
                return alterTableWithOptionsEnd;
            })).asCql();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Executing Set Table Properties: ").append(setOptionsStatement).toString());
            object3 = this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$11 -> x$11.execute(setOptionsStatement));
        } else {
            object3 = BoxedUnit.UNIT;
        }
        if (columnsToRemove.nonEmpty()) {
            String dropColumnsStatement = SchemaBuilder.alterTable((CqlIdentifier)keyspace, (CqlIdentifier)table).dropColumns((CqlIdentifier[])columnsToRemove.toArray(ClassTag$.MODULE$.apply(CqlIdentifier.class))).asCql();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Executing Drop Table Columns: ").append(dropColumnsStatement).toString());
            object2 = this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$12 -> x$12.execute(dropColumnsStatement));
        } else {
            object2 = BoxedUnit.UNIT;
        }
        if (columnsToAdd.nonEmpty()) {
            String addColumnStatement = ((AlterTableAddColumnEnd)columnsToAdd.foldRight((Object)SchemaBuilder.alterTable((CqlIdentifier)keyspace, (CqlIdentifier)table), (Function2 & Serializable & scala.Serializable)(x0$3, x1$2) -> {
                AlterTableAddColumn alterBuilder;
                Tuple2 tuple2;
                block3: {
                    Tuple2 tuple22;
                    block2: {
                        tuple22 = new Tuple2(x0$3, x1$2);
                        if (tuple22 == null) break block2;
                        tuple2 = (Tuple2)tuple22._1();
                        alterBuilder = (AlterTableAddColumn)tuple22._2();
                        if (tuple2 != null) break block3;
                    }
                    throw new MatchError((Object)tuple22);
                }
                CqlIdentifier colName = (CqlIdentifier)tuple2._1();
                DataType dataType = (DataType)tuple2._2();
                AlterTableAddColumnEnd alterTableAddColumnEnd = alterBuilder.addColumn(colName, dataType);
                return alterTableAddColumnEnd;
            })).asCql();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Executing Add Table Columns: ").append(addColumnStatement).toString());
            object = this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$13 -> x$13.execute(addColumnStatement));
        } else {
            object = BoxedUnit.UNIT;
        }
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Table Alteration Complete");
        return this.loadTable(ident);
    }

    public boolean dropTable(Identifier ident) {
        TableMetadata tableMeta = CassandraCatalog$.MODULE$.getTableMetaData(this.connector(), ident);
        return ((ResultSet)this.connector().withSessionDo((Function1 & Serializable & scala.Serializable)x$14 -> x$14.execute(SchemaBuilder.dropTable((CqlIdentifier)tableMeta.getKeyspace(), (CqlIdentifier)tableMeta.getName()).asCql()))).wasApplied();
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) {
        throw new UnsupportedOperationException("Cassandra does not support renaming tables");
    }

    public Table alterTable(Identifier ident, TableChange[] changes) {
        return this.alterTable(ident, (Seq<TableChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public void alterNamespace(String[] namespace, NamespaceChange[] changes) {
        this.alterNamespace(namespace, (Seq<NamespaceChange>)Predef$.MODULE$.wrapRefArray((Object[])changes));
    }

    public static final /* synthetic */ boolean $anonfun$createTable$2(Transform x$1) {
        String string = x$1.name();
        String string2 = "identity";
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$createTable$21(CassandraCatalog $this, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String key = (String)tuple2._1();
        boolean bl = $this.com$datastax$spark$connector$datasource$CassandraCatalog$$CassandraProperties().contains((Object)key);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$alterTable$2(TableChange x0$1) {
        TableChange tableChange = x0$1;
        boolean bl = tableChange instanceof TableChange.AddColumn ? true : (tableChange instanceof TableChange.DeleteColumn ? true : tableChange instanceof TableChange.SetProperty);
        if (!bl) {
            if (tableChange != null) {
                TableChange tableChange2 = tableChange;
                throw new CassandraCatalogException(new StringBuilder(52).append("Cassandra Catalog does not support Alter operation: ").append(tableChange2.getClass().getSimpleName()).toString());
            }
            throw new MatchError((Object)tableChange);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public CassandraCatalog() {
        Logging.$init$((Logging)this);
        this.ReplicationClass = "class";
        this.ReplicationFactor = "replication_factor";
        this.DurableWrites = "durable_writes";
        this.NetworkTopologyStrategy = "networktopologystrategy";
        this.SimpleStrategy = "simplestrategy";
        this.IgnoredReplicationOptions = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.ReplicationClass(), this.DurableWrites(), "owner", "location", "comment"}));
        this.PartitionKey = "partition_key";
        this.ClusteringKey = "clustering_key";
        this.com$datastax$spark$connector$datasource$CassandraCatalog$$CassandraProperties = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter((Set)RelationParser.OPTION_CODECS.keySet()).asScala();
    }
}

