/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.datasource;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import com.datastax.spark.connector.AllColumns$;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.CassandraRowMetadata$;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.PartitionKeyColumns$;
import com.datastax.spark.connector.PrimaryKeyColumns$;
import com.datastax.spark.connector.SomeColumns;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.datasource.ScanHelper;
import com.datastax.spark.connector.datasource.ScanHelper$;
import com.datastax.spark.connector.package$;
import com.datastax.spark.connector.rdd.CassandraLimit$;
import com.datastax.spark.connector.rdd.CqlWhereClause;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.util.CqlWhereParser;
import com.datastax.spark.connector.util.CqlWhereParser$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.BoundStatementBuilder;
import com.datastax.spark.connector.writer.BoundStatementBuilder$;
import com.datastax.spark.connector.writer.RateLimiter;
import com.datastax.spark.connector.writer.RateLimiter$;
import com.datastax.spark.connector.writer.RowWriter;
import java.io.Serializable;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.TraversableOnce$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class JoinHelper$
implements Logging {
    public static JoinHelper$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new JoinHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public Seq<ColumnRef> joinColumnNames(ColumnSelector joinColumns, TableDef tableDef) {
        Seq seq;
        ColumnSelector columnSelector = joinColumns;
        if (AllColumns$.MODULE$.equals(columnSelector)) {
            throw new IllegalArgumentException("Unable to join against all columns in a Cassandra Table. Only primary key columns allowed.");
        }
        if (PrimaryKeyColumns$.MODULE$.equals(columnSelector)) {
            seq = (Seq)tableDef.primaryKey().map((Function1 & Serializable & scala.Serializable)col -> package$.MODULE$.toNamedColumnRef(col.columnName()), IndexedSeq$.MODULE$.canBuildFrom());
        } else if (PartitionKeyColumns$.MODULE$.equals(columnSelector)) {
            seq = (Seq)tableDef.partitionKey().map((Function1 & Serializable & scala.Serializable)col -> package$.MODULE$.toNamedColumnRef(col.columnName()), Seq$.MODULE$.canBuildFrom());
        } else if (columnSelector instanceof SomeColumns) {
            SomeColumns someColumns = (SomeColumns)columnSelector;
            Seq<ColumnRef> cs = someColumns.columns();
            ScanHelper$.MODULE$.checkColumnsExistence(cs, tableDef);
            seq = (Seq)cs.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                ColumnRef columnRef;
                ColumnRef columnRef2 = x0$1;
                if (columnRef2 == null) {
                    throw new IllegalArgumentException("Unable to join against unnamed columns. No CQL Functions allowed.");
                }
                ColumnRef columnRef3 = columnRef = columnRef2;
                return columnRef3;
            }, Seq$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)columnSelector);
        }
        return seq;
    }

    public String getJoinQueryString(TableDef tableDef, Seq<ColumnRef> joinColumns, ScanHelper.CqlQueryParts queryParts) {
        Seq whereClauses = (Seq)queryParts.whereClause().predicates().flatMap((Function1 & Serializable & scala.Serializable)cqlWhere -> CqlWhereParser$.MODULE$.parse((String)cqlWhere), Seq$.MODULE$.canBuildFrom());
        Seq joinColumnNames = (Seq)joinColumns.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.columnName(), Seq$.MODULE$.canBuildFrom());
        Set joinColumnPredicates = ((TraversableOnce)whereClauses.collect((PartialFunction)new scala.Serializable(joinColumnNames){
            public static final long serialVersionUID = 0L;
            private final Seq joinColumnNames$1;

            public final <A1 extends CqlWhereParser.Predicate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                CqlWhereParser.RangePredicate rangePredicate;
                String c;
                CqlWhereParser.InListPredicate inListPredicate;
                String c2;
                CqlWhereParser.InPredicate inPredicate;
                String c3;
                CqlWhereParser.EqPredicate eqPredicate;
                String c4;
                A1 A1 = x1;
                Object object = A1 instanceof CqlWhereParser.EqPredicate && this.joinColumnNames$1.contains((Object)(c4 = (eqPredicate = (CqlWhereParser.EqPredicate)A1).columnName())) ? c4 : (A1 instanceof CqlWhereParser.InPredicate && this.joinColumnNames$1.contains((Object)(c3 = (inPredicate = (CqlWhereParser.InPredicate)A1).columnName())) ? c3 : (A1 instanceof CqlWhereParser.InListPredicate && this.joinColumnNames$1.contains((Object)(c2 = (inListPredicate = (CqlWhereParser.InListPredicate)A1).columnName())) ? c2 : (A1 instanceof CqlWhereParser.RangePredicate && this.joinColumnNames$1.contains((Object)(c = (rangePredicate = (CqlWhereParser.RangePredicate)A1).columnName())) ? c : function1.apply(x1))));
                return (B1)object;
            }

            public final boolean isDefinedAt(CqlWhereParser.Predicate x1) {
                CqlWhereParser.RangePredicate rangePredicate;
                String c;
                CqlWhereParser.InListPredicate inListPredicate;
                String c2;
                CqlWhereParser.InPredicate inPredicate;
                String c3;
                CqlWhereParser.EqPredicate eqPredicate;
                String c4;
                CqlWhereParser.Predicate predicate = x1;
                boolean bl = predicate instanceof CqlWhereParser.EqPredicate && this.joinColumnNames$1.contains((Object)(c4 = (eqPredicate = (CqlWhereParser.EqPredicate)predicate).columnName())) ? true : (predicate instanceof CqlWhereParser.InPredicate && this.joinColumnNames$1.contains((Object)(c3 = (inPredicate = (CqlWhereParser.InPredicate)predicate).columnName())) ? true : (predicate instanceof CqlWhereParser.InListPredicate && this.joinColumnNames$1.contains((Object)(c2 = (inListPredicate = (CqlWhereParser.InListPredicate)predicate).columnName())) ? true : predicate instanceof CqlWhereParser.RangePredicate && this.joinColumnNames$1.contains((Object)(c = (rangePredicate = (CqlWhereParser.RangePredicate)predicate).columnName()))));
                return bl;
            }
            {
                this.joinColumnNames$1 = joinColumnNames$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        Predef$.MODULE$.require(joinColumnPredicates.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(162).append("Columns specified in both the join on clause and the where clause.\n         |Partition key columns are always part of the join clause.\n         |Columns in both: ").append(joinColumnPredicates.mkString(", ")).toString())).stripMargin());
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Generating Single Key Query Prepared Statement String");
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("SelectedColumns : ").append(queryParts.selectedColumnRefs()).append(" -- JoinColumnNames : ").append(joinColumnNames).toString());
        String columns = ((TraversableOnce)queryParts.selectedColumnRefs().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.cql(), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ");
        Seq joinWhere = (Seq)joinColumnNames.map((Function1 & Serializable & scala.Serializable)name -> new StringBuilder(4).append(CqlIdentifier.fromInternal((String)name)).append(" = :").append((String)name).toString(), Seq$.MODULE$.canBuildFrom());
        String limitClause = CassandraLimit$.MODULE$.limitToClause(queryParts.limitClause());
        String orderBy = (String)queryParts.clusteringOrder().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toCql(tableDef)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String filter = ((TraversableOnce)queryParts.whereClause().predicates().$plus$plus((GenTraversableOnce)joinWhere, Seq$.MODULE$.canBuildFrom())).mkString(" AND ");
        CqlIdentifier quotedKeyspaceName = CqlIdentifier.fromInternal((String)tableDef.keyspaceName());
        CqlIdentifier quotedTableName = CqlIdentifier.fromInternal((String)tableDef.tableName());
        String query = new StringBuilder(23).append("SELECT ").append(columns).append(" ").append("FROM ").append(quotedKeyspaceName).append(".").append(quotedTableName).append(" ").append("WHERE ").append(filter).append(" ").append(orderBy).append(" ").append(limitClause).toString();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Query : ").append(query).toString());
        return query;
    }

    public PreparedStatement getJoinPreparedStatement(CqlSession session, String queryString, ConsistencyLevel consistencyLevel) {
        SimpleStatement stmt = (SimpleStatement)SimpleStatement.newInstance((String)queryString).setConsistencyLevel(consistencyLevel).setIdempotent(Predef$.MODULE$.boolean2Boolean(true));
        return session.prepare(stmt);
    }

    public CassandraRowMetadata getCassandraRowMetadata(CqlSession session, PreparedStatement statement, IndexedSeq<ColumnRef> selectedColumnRefs) {
        CodecRegistry codecRegistry = session.getContext().getCodecRegistry();
        scala.collection.immutable.IndexedSeq columnNames = ((TraversableOnce)selectedColumnRefs.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.selectedAs(), IndexedSeq$.MODULE$.canBuildFrom())).toIndexedSeq();
        return CassandraRowMetadata$.MODULE$.fromPreparedStatement((IndexedSeq)columnNames, statement, codecRegistry);
    }

    public <L> BoundStatementBuilder<L> getKeyBuilderStatementBuilder(CqlSession session, RowWriter<L> rowWriter, PreparedStatement preparedStatement, CqlWhereClause whereClause) {
        ProtocolVersion protocolVersion = session.getContext().getProtocolVersion();
        RowWriter<L> x$1 = rowWriter;
        PreparedStatement x$2 = preparedStatement;
        Seq<Object> x$3 = whereClause.values();
        ProtocolVersion x$4 = protocolVersion;
        boolean x$5 = BoundStatementBuilder$.MODULE$.$lessinit$greater$default$4();
        return new BoundStatementBuilder<L>(x$1, x$2, x$3, x$5, x$4);
    }

    public <T> Iterator<T> slidingPrefetchIterator(Iterator<Future<T>> it, int batchSize) {
        int x$2;
        int x$1;
        Iterator.GroupedIterator qual$1 = it.grouped(batchSize);
        Tuple2 tuple2 = qual$1.sliding(x$1 = 2, x$2 = qual$1.sliding$default$2()).span((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)it.hasNext()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator firstElements = (Iterator)tuple2._1();
        Iterator lastElement = (Iterator)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)firstElements, (Object)lastElement);
        Tuple2 tuple23 = tuple22;
        Iterator firstElements2 = (Iterator)tuple23._1();
        Iterator lastElement2 = (Iterator)tuple23._2();
        return TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)firstElements2.map((Function1 & Serializable & scala.Serializable)x$7 -> (Seq)x$7.head()).$plus$plus((Function0 & Serializable & scala.Serializable)() -> TraversableOnce$.MODULE$.flattenTraversableOnce((TraversableOnce)lastElement2, (Function1)Predef$.MODULE$.$conforms()).flatten()), (Function1)Predef$.MODULE$.$conforms()).flatten().map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get());
    }

    public RateLimiter requestsPerSecondRateLimiter(ReadConf readConf) {
        return new RateLimiter(BoxesRunTime.unboxToInt((Object)readConf.readsPerSec().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)), BoxesRunTime.unboxToInt((Object)readConf.readsPerSec().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE)), RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
    }

    public Function1<Row, Row> maybeRateLimit(ReadConf readConf) {
        Function1 & Serializable & scala.Serializable intersect;
        Option<Object> option = readConf.throughputMiBPS();
        if (option instanceof Some) {
            Some some = (Some)option;
            double throughput = BoxesRunTime.unboxToDouble((Object)some.value());
            long bytesPerSecond = (long)(throughput * (double)1024 * (double)1024);
            RateLimiter rateLimiter = new RateLimiter(bytesPerSecond, bytesPerSecond, RateLimiter$.MODULE$.$lessinit$greater$default$3(), RateLimiter$.MODULE$.$lessinit$greater$default$4());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Throttling join at ").append(bytesPerSecond).append(" bytes per second").toString());
            intersect = (Function1 & Serializable & scala.Serializable)row -> {
                rateLimiter.maybeSleep(com.datastax.spark.connector.cql.package$.MODULE$.getRowBinarySize((Row)row));
                return row;
            };
        } else if (None$.MODULE$.equals(option)) {
            intersect = (Function1 & Serializable & scala.Serializable)x -> (Row)Predef$.MODULE$.identity(x);
        } else {
            throw new MatchError(option);
        }
        return intersect;
    }

    private JoinHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

