/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.datasource;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.spark.connector.ColumnName;
import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.TTL;
import com.datastax.spark.connector.WriteTime;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.ScanResult;
import com.datastax.spark.connector.cql.Scanner;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.datasource.ScanHelper;
import com.datastax.spark.connector.rdd.CassandraLimit$;
import com.datastax.spark.connector.rdd.CqlWhereClause;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitionGenerator;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartitionGenerator$;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.partitioner.DataSizeEstimates;
import com.datastax.spark.connector.rdd.partitioner.dht.Token;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory;
import com.datastax.spark.connector.rdd.partitioner.dht.TokenFactory$;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.util.CqlWhereParser;
import com.datastax.spark.connector.util.CqlWhereParser$;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.util.Quote$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.sql.cassandra.DsePredicateRules$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScanHelper$
implements Logging {
    public static ScanHelper$ MODULE$;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new ScanHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public Seq<ColumnRef> checkColumnsExistence(Seq<ColumnRef> columns, TableDef tableDef) {
        Set allColumnNames = ((TraversableOnce)tableDef.columns().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.columnName(), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        Set regularColumnNames = ((TraversableOnce)tableDef.regularColumns().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columnName(), Seq$.MODULE$.canBuildFrom())).toSet();
        String keyspaceName = tableDef.keyspaceName();
        String tableName = tableDef.tableName();
        return (Seq)columns.map((Function1 & Serializable & scala.Serializable)column -> ScanHelper$.checkSingleColumn$1(column, allColumnNames, keyspaceName, tableName, regularColumnNames), Seq$.MODULE$.canBuildFrom());
    }

    public ScanResult fetchTokenRange(Scanner scanner, TableDef tableDef, ScanHelper.CqlQueryParts queryParts, CqlTokenRange<?, ?> range, ConsistencyLevel consistencyLevel, int fetchSize) {
        CqlSession session = scanner.getSession();
        Tuple2<String, Seq<Object>> tuple2 = this.tokenRangeToCqlQuery(range, tableDef, queryParts);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String cql = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cql, (Object)values);
        Tuple2 tuple23 = tuple22;
        String cql2 = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Fetching data for range ").append(range.cql(MODULE$.partitionKeyStr(tableDef))).append(" ").append("with ").append(cql2).append(" ").append("with params ").append(values2.mkString("[", ",", "]")).toString());
        BoundStatement stmt = (BoundStatement)this.prepareScanStatement(session, cql2, (Seq<Object>)values2).setConsistencyLevel(consistencyLevel).setPageSize(fetchSize).setRoutingToken(range.range().startNativeToken());
        ScanResult scanResult = scanner.scan(stmt);
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Row iterator for range ").append(range.cql(MODULE$.partitionKeyStr(tableDef))).append(" obtained successfully.").toString());
        return scanResult;
    }

    public String partitionKeyStr(TableDef tableDef) {
        return ((TraversableOnce)((TraversableLike)tableDef.partitionKey().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.columnName(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote(name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
    }

    public Tuple2<String, Seq<Object>> tokenRangeToCqlQuery(CqlTokenRange<?, ?> range, TableDef tableDef, ScanHelper.CqlQueryParts cqlQueryParts) {
        Tuple2 tuple2;
        String columns = ((TraversableOnce)cqlQueryParts.selectedColumnRefs().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.cql(), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ");
        Tuple2 tuple22 = tuple2 = this.containsPartitionKey(tableDef, cqlQueryParts.whereClause()) ? new Tuple2((Object)"", (Object)Seq$.MODULE$.empty()) : range.cql(this.partitionKeyStr(tableDef));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String cql = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)cql, (Object)values);
        Tuple2 tuple24 = tuple23;
        String cql2 = (String)tuple24._1();
        Seq values2 = (Seq)tuple24._2();
        String string = cql2;
        String filter = ((TraversableOnce)((TraversableLike)cqlQueryParts.whereClause().predicates().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)ScanHelper$.$anonfun$tokenRangeToCqlQuery$2(x$8)))).mkString(" AND ");
        String limitClause = CassandraLimit$.MODULE$.limitToClause(cqlQueryParts.limitClause());
        String orderBy = (String)cqlQueryParts.clusteringOrder().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toCql(tableDef)).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        CqlIdentifier keyspaceName = CqlIdentifier.fromInternal((String)tableDef.keyspaceName());
        CqlIdentifier tableName = CqlIdentifier.fromInternal((String)tableDef.tableName());
        String queryTemplate = new StringBuilder(39).append("SELECT ").append(columns).append(" ").append("FROM ").append(keyspaceName.asCql(true)).append(".").append(tableName.asCql(true)).append(" ").append("WHERE ").append(filter).append(" ").append(orderBy).append(" ").append(limitClause).append(" ALLOW FILTERING").toString();
        Seq queryParamValues = (Seq)values2.$plus$plus(cqlQueryParts.whereClause().values(), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)queryTemplate, (Object)queryParamValues);
    }

    public boolean containsPartitionKey(TableDef tableDef, CqlWhereClause clause) {
        Seq saiColumns;
        Set pk = ((TraversableOnce)tableDef.partitionKey().map((Function1 & Serializable & scala.Serializable)x$10 -> x$10.columnName(), Seq$.MODULE$.canBuildFrom())).toSet();
        Seq wherePredicates = (Seq)clause.predicates().flatMap((Function1 & Serializable & scala.Serializable)cqlWhere -> CqlWhereParser$.MODULE$.parse((String)cqlWhere), Seq$.MODULE$.canBuildFrom());
        Set whereColumns = ((TraversableOnce)wherePredicates.collect((PartialFunction)new scala.Serializable(pk, saiColumns = (Seq)((TraversableLike)tableDef.indexes().filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ScanHelper$.$anonfun$containsPartitionKey$3(x$11)))).map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.target(), Seq$.MODULE$.canBuildFrom())){
            public static final long serialVersionUID = 0L;
            private final Set pk$1;
            private final Seq saiColumns$1;

            public final <A1 extends CqlWhereParser.Predicate, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                CqlWhereParser.InListPredicate inListPredicate;
                String c;
                CqlWhereParser.InPredicate inPredicate;
                String c2;
                Object object;
                CqlWhereParser.EqPredicate eqPredicate;
                String c3;
                A1 A1 = x1;
                if (A1 instanceof CqlWhereParser.EqPredicate && this.pk$1.contains((Object)(c3 = (eqPredicate = (CqlWhereParser.EqPredicate)A1).columnName()))) {
                    object = c3;
                } else if (A1 instanceof CqlWhereParser.InPredicate && this.pk$1.contains((Object)(c2 = (inPredicate = (CqlWhereParser.InPredicate)A1).columnName()))) {
                    object = c2;
                } else if (A1 instanceof CqlWhereParser.InListPredicate && this.pk$1.contains((Object)(c = (inListPredicate = (CqlWhereParser.InListPredicate)A1).columnName()))) {
                    object = c;
                } else {
                    CqlWhereParser.RangePredicate rangePredicate;
                    String c4;
                    if (A1 instanceof CqlWhereParser.RangePredicate && this.pk$1.contains((Object)(c4 = (rangePredicate = (CqlWhereParser.RangePredicate)A1).columnName())) && !this.saiColumns$1.contains((Object)c4)) {
                        throw new UnsupportedOperationException(new StringBuilder(98).append("Range predicates on partition key columns (here: ").append(c4).append(") are ").append("not supported in where. Use filter instead.").toString());
                    }
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(CqlWhereParser.Predicate x1) {
                CqlWhereParser.RangePredicate rangePredicate;
                String c;
                CqlWhereParser.InListPredicate inListPredicate;
                String c2;
                CqlWhereParser.InPredicate inPredicate;
                String c3;
                CqlWhereParser.EqPredicate eqPredicate;
                String c4;
                CqlWhereParser.Predicate predicate = x1;
                boolean bl = predicate instanceof CqlWhereParser.EqPredicate && this.pk$1.contains((Object)(c4 = (eqPredicate = (CqlWhereParser.EqPredicate)predicate).columnName())) ? true : (predicate instanceof CqlWhereParser.InPredicate && this.pk$1.contains((Object)(c3 = (inPredicate = (CqlWhereParser.InPredicate)predicate).columnName())) ? true : (predicate instanceof CqlWhereParser.InListPredicate && this.pk$1.contains((Object)(c2 = (inListPredicate = (CqlWhereParser.InListPredicate)predicate).columnName())) ? true : predicate instanceof CqlWhereParser.RangePredicate && this.pk$1.contains((Object)(c = (rangePredicate = (CqlWhereParser.RangePredicate)predicate).columnName())) && !this.saiColumns$1.contains((Object)c)));
                return bl;
            }
            {
                this.pk$1 = pk$1;
                this.saiColumns$1 = saiColumns$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet();
        boolean primaryKeyComplete = whereColumns.nonEmpty() && whereColumns.size() == pk.size();
        boolean whereColumnsAllIndexed = whereColumns.forall((Function1 & Serializable & scala.Serializable)column -> BoxesRunTime.boxToBoolean((boolean)tableDef.isIndexed(column)));
        if (!primaryKeyComplete && !whereColumnsAllIndexed) {
            Set missing = (Set)pk.$minus$minus((GenTraversableOnce)whereColumns);
            throw new UnsupportedOperationException(new StringBuilder(125).append("Partition key predicate must include all partition key columns or partition key columns need").append(" to be indexed. Missing columns: ").append(missing.mkString(",")).toString());
        }
        return primaryKeyComplete;
    }

    public BoundStatement prepareScanStatement(CqlSession session, String cql, Seq<Object> values) {
        BoundStatement boundStatement;
        try {
            PreparedStatement stmt = session.prepare(cql);
            TypeConverter[] converters = (TypeConverter[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((Iterable)stmt.getVariableDefinitions()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> ColumnType$.MODULE$.converterToCassandra(v.getType()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeConverter.class));
            Seq convertedValues = (Seq)((TraversableLike)values.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])converters), Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ScanHelper$.$anonfun$prepareScanStatement$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$13 -> {
                Tuple2 tuple2 = x$13;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object value = tuple2._1();
                TypeConverter converter = (TypeConverter)tuple2._2();
                Object object = converter.convert(value);
                return object;
            }, Seq$.MODULE$.canBuildFrom());
            boundStatement = (BoundStatement)stmt.bind((Object[])convertedValues.toArray(ClassTag$.MODULE$.AnyRef())).setIdempotent(Predef$.MODULE$.boolean2Boolean(true));
        }
        catch (Throwable t) {
            throw new IOException(new StringBuilder(34).append("Exception during preparation of ").append(cql).append(": ").append(t.getMessage()).toString(), t);
        }
        return boundStatement;
    }

    public CassandraPartitionGenerator<Object, Token> getPartitionGenerator(CassandraConnector connector, TableDef tableDef, CqlWhereClause whereClause, int minSplitCount, Option<Object> partitionCount, long splitSize) {
        CassandraPartitionGenerator<Object, Token> cassandraPartitionGenerator;
        TokenFactory<Object, Token> tokenFactory = TokenFactory$.MODULE$.forSystemLocalPartitioner(connector);
        if (this.containsPartitionKey(tableDef, whereClause)) {
            cassandraPartitionGenerator = CassandraPartitionGenerator$.MODULE$.apply(connector, tableDef, 1, tokenFactory);
        } else {
            CassandraPartitionGenerator<Object, Token> cassandraPartitionGenerator2;
            Option<Object> option = partitionCount;
            if (option instanceof Some) {
                Some some = (Some)option;
                int splitCount = BoxesRunTime.unboxToInt((Object)some.value());
                cassandraPartitionGenerator2 = CassandraPartitionGenerator$.MODULE$.apply(connector, tableDef, splitCount, tokenFactory);
            } else if (None$.MODULE$.equals(option)) {
                int n;
                long estimateDataSize = new DataSizeEstimates<Object, Token>(connector, tableDef.keyspaceName(), tableDef.tableName(), tokenFactory).dataSizeInBytes();
                if (estimateDataSize == Long.MAX_VALUE || estimateDataSize < 0L) {
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(391).append("Size Estimates has overflowed and calculated that the data size is Infinite.\n                 |Falling back to ").append(minSplitCount).append(" (2 * SparkCores + 1) Split Count.\n                 |This is most likely occurring because you are reading size_estimates\n                 |from a DataCenter which has very small primary ranges. Explicitly set\n                 |the splitCount when reading to manually adjust this.").toString())).stripMargin());
                    n = minSplitCount;
                } else {
                    long splitCountEstimate = estimateDataSize / splitSize;
                    n = Math.max((int)splitCountEstimate, Math.max(minSplitCount, 1));
                }
                int splitCount = n;
                cassandraPartitionGenerator2 = CassandraPartitionGenerator$.MODULE$.apply(connector, tableDef, splitCount, tokenFactory);
            } else {
                throw new MatchError(option);
            }
            cassandraPartitionGenerator = cassandraPartitionGenerator2;
        }
        return cassandraPartitionGenerator;
    }

    private static final ColumnRef checkSingleColumn$1(ColumnRef column, Set allColumnNames$1, String keyspaceName$1, String tableName$1, Set regularColumnNames$1) {
        ColumnRef columnRef = column;
        if (columnRef instanceof ColumnName) {
            ColumnName columnName = (ColumnName)columnRef;
            String columnName2 = columnName.columnName();
            if (!allColumnNames$1.contains((Object)columnName2)) {
                throw new IOException(new StringBuilder(28).append("Column ").append(column).append(" not found in table ").append(keyspaceName$1).append(".").append(tableName$1).toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (columnRef instanceof TTL) {
            TTL tTL = (TTL)columnRef;
            String columnName = tTL.columnName();
            if (!regularColumnNames$1.contains((Object)columnName)) {
                throw new IOException(new StringBuilder(93).append("TTL can be obtained only for regular columns, ").append("but column ").append(columnName).append(" is not a regular column in table ").append(keyspaceName$1).append(".").append(tableName$1).append(".").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (columnRef instanceof WriteTime) {
            WriteTime writeTime = (WriteTime)columnRef;
            String columnName = writeTime.columnName();
            if (!regularColumnNames$1.contains((Object)columnName)) {
                throw new IOException(new StringBuilder(93).append("TTL can be obtained only for regular columns, ").append("but column ").append(columnName).append(" is not a regular column in table ").append(keyspaceName$1).append(".").append(tableName$1).append(".").toString());
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        return column;
    }

    public static final /* synthetic */ boolean $anonfun$tokenRangeToCqlQuery$2(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$containsPartitionKey$3(IndexDef x$11) {
        return x$11.className().contains((Object)DsePredicateRules$.MODULE$.StorageAttachedIndex());
    }

    public static final /* synthetic */ boolean $anonfun$prepareScanStatement$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private ScanHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

