/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd;

import com.datastax.bdp.util.ScalaJavaUtil$;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.spark.connector.CassandraRowMetadata;
import com.datastax.spark.connector.CassandraRowMetadata$;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.CassandraTableScanRDD;
import com.datastax.spark.connector.rdd.ReadConf;
import com.datastax.spark.connector.rdd.ReadConf$;
import com.datastax.spark.connector.rdd.partitioner.CassandraPartition;
import com.datastax.spark.connector.rdd.partitioner.CqlTokenRange;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator;
import com.datastax.spark.connector.rdd.reader.PrefetchingResultSetIterator$;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.types.ColumnType$;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.util.CountingIterator;
import com.datastax.spark.connector.util.CountingIterator$;
import com.datastax.spark.connector.util.MergeJoinIterator;
import com.datastax.spark.connector.util.NameTools$;
import com.datastax.spark.connector.util.Quote$;
import com.datastax.spark.connector.util.Threads$;
import com.datastax.spark.connector.util.package$;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.Partition;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.metrics.InputMetricsUpdater;
import org.apache.spark.metrics.InputMetricsUpdater$;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001\u0002\f\u0018\u0001\tB\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001\u0015\u0005\t)\u0002\u0011\t\u0011)A\u0005+\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005\\\u0001\t\u0005\t\u0015a\u0003]\u0011!\u0011\u0007A!A!\u0002\u0017\u0019\u0007\"\u00023\u0001\t\u0003)\u0007b\u0002\u000e\u0001\u0005\u0004%\t!\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00028\t\u000bU\u0004A\u0011\u0001<\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!I\u00111\u0004\u0001C\u0002\u0013\u0005\u0011Q\u0004\u0005\t\u0003[\u0001\u0001\u0015!\u0003\u0002 !9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0002BCA1\u0001!\u0015\r\u0011\"\u0003\u0002d!9\u0011Q\r\u0001\u0005\n\u0005\u001d\u0004bBAM\u0001\u0011%\u00111\u0014\u0005\b\u0003\u000b\u0004A\u0011BAd\u0011\u001d\t9\u0010\u0001C\u0005\u0003sDqAa\u000b\u0001\t\u0003\u0012i\u0003C\u0004\u0003T\u0001!\tF!\u0016\t\u000f\tu\u0003\u0001\"\u0011\u0003`\t)2)Y:tC:$'/Y'fe\u001e,'j\\5o%\u0012#%B\u0001\r\u001a\u0003\r\u0011H\r\u001a\u0006\u00035m\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003!!\u0017\r^1ti\u0006D(\"\u0001\u0011\u0002\u0007\r|Wn\u0001\u0001\u0016\u0007\r\u0012Uj\u0005\u0002\u0001IA\u0019Q\u0005\f\u0018\u000e\u0003\u0019R!\u0001G\u0014\u000b\u0005qA#BA\u0015+\u0003\u0019\t\u0007/Y2iK*\t1&A\u0002pe\u001eL!!\f\u0014\u0003\u0007I#E\t\u0005\u00030eQZU\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\rQ+\b\u000f\\33!\r)T\b\u0011\b\u0003mmr!a\u000e\u001e\u000e\u0003aR!!O\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0014B\u0001\u001f1\u0003\u001d\u0001\u0018mY6bO\u0016L!AP \u0003\u0007M+\u0017O\u0003\u0002=aA\u0011\u0011I\u0011\u0007\u0001\t\u0015\u0019\u0005A1\u0001E\u0005\u0005a\u0015CA#I!\tyc)\u0003\u0002Ha\t9aj\u001c;iS:<\u0007CA\u0018J\u0013\tQ\u0005GA\u0002B]f\u00042!N\u001fM!\t\tU\nB\u0003O\u0001\t\u0007AIA\u0001S\u0003\t\u00198\r\u0005\u0002R%6\tq%\u0003\u0002TO\ta1\u000b]1sW\u000e{g\u000e^3yi\u0006YA.\u001a4u'\u000e\fgN\u0015#E!\r1v\u000bQ\u0007\u0002/%\u0011\u0001l\u0006\u0002\u0016\u0007\u0006\u001c8/\u00198ee\u0006$\u0016M\u00197f'\u000e\fgN\u0015#E\u00031\u0011\u0018n\u001a5u'\u000e\fgN\u0015#E!\r1v\u000bT\u0001\rY\u00164Go\u00117bgN$\u0016m\u001a\t\u0004;\u0002\u0004U\"\u00010\u000b\u0005}\u0003\u0014a\u0002:fM2,7\r^\u0005\u0003Cz\u0013\u0001b\u00117bgN$\u0016mZ\u0001\u000ee&<\u0007\u000e^\"mCN\u001cH+Y4\u0011\u0007u\u0003G*\u0001\u0004=S:LGO\u0010\u000b\u0005M*\\G\u000eF\u0002hQ&\u0004BA\u0016\u0001A\u0019\")1L\u0002a\u00029\")!M\u0002a\u0002G\")qJ\u0002a\u0001!\")AK\u0002a\u0001+\")\u0011L\u0002a\u00015V\ta\u000e\u0005\u0002pe6\t\u0001O\u0003\u0002r3\u0005\u00191-\u001d7\n\u0005M\u0004(AE\"bgN\fg\u000e\u001a:b\u0007>tg.Z2u_J\f!bY8o]\u0016\u001cGo\u001c:!\u0003=9W\r\u001e)beRLG/[8o\u0017\u0016LH#B<|y\u00065\u0001cA\u001b>qB\u0011q._\u0005\u0003uB\u0014\u0011bQ8mk6tG)\u001a4\t\u000biI\u0001\u0019\u00018\t\u000buL\u0001\u0019\u0001@\u0002\u0019-,\u0017p\u001d9bG\u0016t\u0015-\\3\u0011\u0007}\f9A\u0004\u0003\u0002\u0002\u0005\r\u0001CA\u001c1\u0013\r\t)\u0001M\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00111\u0002\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015\u0001\u0007\u0003\u0004\u0002\u0010%\u0001\rA`\u0001\ni\u0006\u0014G.\u001a(b[\u0016\f1c\u00195fG.4\u0016\r\\5e\u001b\u0016\u0014x-\u001a&pS:$\"!!\u0006\u0011\u0007=\n9\"C\u0002\u0002\u001aA\u0012A!\u00168ji\u0006YAk\\6f]\u000e{G.^7o+\t\ty\u0002\u0005\u0003\u0002\"\u0005-RBAA\u0012\u0015\u0011\t)#a\n\u0002\t1\fgn\u001a\u0006\u0003\u0003S\tAA[1wC&!\u0011\u0011BA\u0012\u00031!vn[3o\u0007>dW/\u001c8!\u00039!xn[3o\u000bb$(/Y2u_J$B!a\r\u0002TA!\u0011QGA(\u001b\t\t9D\u0003\u0003\u0002:\u0005m\u0012!\u0002;pW\u0016t'\u0002BA\u001f\u0003\u007f\t\u0001\"\\3uC\u0012\fG/\u0019\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0003d_J,'\u0002BA#\u0003\u000f\n1!\u00199j\u0015\u0011\tI%a\u0013\u0002\r\u0011\u0014\u0018N^3s\u0015\r\ti%H\u0001\u0004_N\u001c\u0018\u0002BA)\u0003o\u0011Q\u0001V8lK:Dq!!\u0016\u000e\u0001\u0004\t9&A\u0002s_^\u0004B!!\u0017\u0002^5\u0011\u00111\f\u0006\u0004c\u0006}\u0012\u0002BA0\u00037\u00121AU8x\u0003MaWM\u001a;QCJ$\u0018\u000e^5p].+\u0017p\u0015;s+\u0005q\u0018\u0001\u0006;pW\u0016t'+\u00198hKR{7)\u001d7Rk\u0016\u0014\u00180\u0006\u0003\u0002j\u0005]DCBA6\u0003_\nY\bE\u00030ey\fi\u0007E\u00026{!Cq!!\u001d\u0010\u0001\u0004\t\u0019(A\u0004ge>l'\u000b\u0012#\u0011\tY;\u0016Q\u000f\t\u0004\u0003\u0006]DABA=\u001f\t\u0007AIA\u0001U\u0011\u001d\tih\u0004a\u0001\u0003\u007f\nQA]1oO\u0016\u0004d!!!\u0002\u0010\u0006U\u0005\u0003CAB\u0003\u0013\u000bi)a%\u000e\u0005\u0005\u0015%bAAD/\u0005Y\u0001/\u0019:uSRLwN\\3s\u0013\u0011\tY)!\"\u0003\u001b\r\u000bH\u000eV8lK:\u0014\u0016M\\4f!\r\t\u0015q\u0012\u0003\f\u0003#\u000bY(!A\u0001\u0002\u000b\u0005AIA\u0002`IE\u00022!QAK\t-\t9*a\u001f\u0002\u0002\u0003\u0005)\u0011\u0001#\u0003\u0007}##'A\bde\u0016\fG/Z*uCR,W.\u001a8u))\ti*a)\u00020\u0006e\u00161\u0018\t\u0005\u00033\ny*\u0003\u0003\u0002\"\u0006m#A\u0004\"pk:$7\u000b^1uK6,g\u000e\u001e\u0005\b\u0003K\u0003\u0002\u0019AAT\u0003\u001d\u0019Xm]:j_:\u0004B!!+\u0002,6\u0011\u0011qH\u0005\u0005\u0003[\u000byD\u0001\u0006Dc2\u001cVm]:j_:Dq!!-\u0011\u0001\u0004\t\u0019,\u0001\u0005sK\u0006$7i\u001c8g!\r1\u0016QW\u0005\u0004\u0003o;\"\u0001\u0003*fC\u0012\u001cuN\u001c4\t\u000bE\u0004\u0002\u0019\u0001@\t\u000f\u0005u\u0006\u00031\u0001\u0002@\u00061a/\u00197vKN\u0004BaLAa\u0011&\u0019\u00111\u0019\u0019\u0003\u0015q\u0012X\r]3bi\u0016$g(\u0001\nd_:4XM\u001d;S_^LE/\u001a:bi>\u0014X\u0003BAe\u0003'$\u0002\"a3\u0002V\u0006m\u00171\u001e\t\u0006k\u00055\u0017\u0011[\u0005\u0004\u0003\u001f|$\u0001C%uKJ\fGo\u001c:\u0011\u0007\u0005\u000b\u0019\u000e\u0002\u0004\u0002zE\u0011\r\u0001\u0012\u0005\b\u0003/\f\u0002\u0019AAm\u0003!IG/\u001a:bi>\u0014\b#B\u001b\u0002N\u0006]\u0003bBAo#\u0001\u0007\u0011q\\\u0001\ne><(+Z1eKJ\u0004b!!9\u0002h\u0006EWBAAr\u0015\r\t)oF\u0001\u0007e\u0016\fG-\u001a:\n\t\u0005%\u00181\u001d\u0002\n%><(+Z1eKJDq!!<\u0012\u0001\u0004\ty/\u0001\bd_2,XN\\'fi\u0006$\u0015\r^1\u0011\t\u0005E\u00181_\u0007\u00023%\u0019\u0011Q_\r\u0003)\r\u000b7o]1oIJ\f'k\\<NKR\fG-\u0019;b\u0003=1W\r^2i)>\\WM\u001c*b]\u001e,W\u0003BA~\u0005\u000f!\"\"!@\u0002\u0000\n\u0005!\u0011\u0002B\u000e!\u0019y#'a<\u0002Z\"9\u0011Q\u0015\nA\u0002\u0005\u001d\u0006bBA9%\u0001\u0007!1\u0001\t\u0005-^\u0013)\u0001E\u0002B\u0005\u000f!a!!\u001f\u0013\u0005\u0004!\u0005bBA?%\u0001\u0007!1\u0002\u0019\u0007\u0005\u001b\u0011\tBa\u0006\u0011\u0011\u0005\r\u0015\u0011\u0012B\b\u0005+\u00012!\u0011B\t\t-\u0011\u0019B!\u0003\u0002\u0002\u0003\u0005)\u0011\u0001#\u0003\u0007}#3\u0007E\u0002B\u0005/!1B!\u0007\u0003\n\u0005\u0005\t\u0011!B\u0001\t\n\u0019q\f\n\u001b\t\u000f\tu!\u00031\u0001\u0003 \u0005\u0019\u0012N\u001c9vi6+GO]5dgV\u0003H-\u0019;feB!!\u0011\u0005B\u0014\u001b\t\u0011\u0019CC\u0002\u0003&\u001d\nq!\\3ue&\u001c7/\u0003\u0003\u0003*\t\r\"aE%oaV$X*\u001a;sS\u000e\u001cX\u000b\u001d3bi\u0016\u0014\u0018aB2p[B,H/\u001a\u000b\u0007\u0005_\u0011\tDa\u000f\u0011\tU\niM\f\u0005\b\u0005g\u0019\u0002\u0019\u0001B\u001b\u0003\u0015\u0019\b\u000f\\5u!\r\t&qG\u0005\u0004\u0005s9#!\u0003)beRLG/[8o\u0011\u001d\u0011id\u0005a\u0001\u0005\u007f\tqaY8oi\u0016DH\u000fE\u0002R\u0005\u0003J1Aa\u0011(\u0005-!\u0016m]6D_:$X\r\u001f;)\u0007M\u00119\u0005\u0005\u0003\u0003J\t=SB\u0001B&\u0015\r\u0011ieJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B)\u0005\u0017\u0012A\u0002R3wK2|\u0007/\u001a:Ba&\fQbZ3u!\u0006\u0014H/\u001b;j_:\u001cXC\u0001B,!\u0015y#\u0011\fB\u001b\u0013\r\u0011Y\u0006\r\u0002\u0006\u0003J\u0014\u0018-_\u0001\u0016O\u0016$\bK]3gKJ\u0014X\r\u001a'pG\u0006$\u0018n\u001c8t)\u0011\u0011\tGa\u0019\u0011\u0007Ujd\u0010C\u0004\u00034U\u0001\rA!\u000e")
public class CassandraMergeJoinRDD<L, R>
extends RDD<Tuple2<Seq<L>, Seq<R>>> {
    private String leftPartitionKeyStr;
    private final CassandraTableScanRDD<L> leftScanRDD;
    private final CassandraTableScanRDD<R> rightScanRDD;
    private final CassandraConnector connector;
    private final String TokenColumn;
    private volatile boolean bitmap$0;

    public CassandraConnector connector() {
        return this.connector;
    }

    public Seq<ColumnDef> getPartitionKey(CassandraConnector connector, String keyspaceName, String tableName) {
        Option option = package$.MODULE$.schemaFromCassandra(connector, (Option<String>)new Some((Object)keyspaceName), (Option<String>)new Some((Object)tableName)).tables().headOption();
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                Metadata metadata = (Metadata)connector.withSessionDo((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getMetadata());
                Option suggestions = NameTools$.MODULE$.getSuggestions(metadata, keyspaceName, tableName);
                String errorMessage = NameTools$.MODULE$.getErrorString(keyspaceName, (Option)new Some((Object)tableName), suggestions);
                throw new IOException(errorMessage);
            }
            throw new MatchError((Object)option);
        }
        Some some = (Some)option;
        TableDef table = (TableDef)some.value();
        Seq seq = table.partitionKey();
        return seq;
    }

    public void checkValidMergeJoin() {
        Seq leftPartitionKeyTypes = (Seq)this.getPartitionKey(this.leftScanRDD.connector(), this.leftScanRDD.keyspaceName(), this.leftScanRDD.tableName()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.columnType(), Seq$.MODULE$.canBuildFrom());
        Seq rightPartitionKeyTypes = (Seq)this.getPartitionKey(this.rightScanRDD.connector(), this.rightScanRDD.keyspaceName(), this.rightScanRDD.tableName()).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.columnType(), Seq$.MODULE$.canBuildFrom());
        Seq seq = leftPartitionKeyTypes;
        Seq seq2 = rightPartitionKeyTypes;
        Predef$.MODULE$.assert(!(seq != null ? !seq.equals(seq2) : seq2 != null), (Function0 & Serializable & scala.Serializable)() -> "Partition key types do not match between Right and Left RDDs in MergeJoin");
    }

    public String TokenColumn() {
        return this.TokenColumn;
    }

    public Token tokenExtractor(Row row) {
        return row.getToken(this.TokenColumn());
    }

    private String leftPartitionKeyStr$lzycompute() {
        CassandraMergeJoinRDD cassandraMergeJoinRDD = this;
        synchronized (cassandraMergeJoinRDD) {
            if (!this.bitmap$0) {
                this.leftPartitionKeyStr = ((TraversableOnce)((TraversableLike)this.getPartitionKey(this.connector(), this.leftScanRDD.keyspaceName(), this.leftScanRDD.tableName()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.columnName(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)name -> Quote$.MODULE$.quote(name), Seq$.MODULE$.canBuildFrom())).mkString(", ");
                this.bitmap$0 = true;
            }
        }
        return this.leftPartitionKeyStr;
    }

    private String leftPartitionKeyStr() {
        return !this.bitmap$0 ? this.leftPartitionKeyStr$lzycompute() : this.leftPartitionKeyStr;
    }

    private <T> Tuple2<String, Seq<Object>> tokenRangeToCqlQuery(CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range) {
        String columns = ((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.cql(), IndexedSeq$.MODULE$.canBuildFrom())).mkString(", ");
        String pk = ((TraversableOnce)fromRDD.tableDef().partitionKey().map((Function1 & Serializable & scala.Serializable)colDef -> Quote$.MODULE$.quote(colDef.columnName()), Seq$.MODULE$.canBuildFrom())).mkString(",");
        Tuple2<String, Seq<Object>> tuple2 = range.cql(this.leftPartitionKeyStr());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String cql = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cql, (Object)values);
        Tuple2 tuple23 = tuple22;
        String cql2 = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        String string = cql2;
        String filter = ((TraversableOnce)((TraversableLike)fromRDD.where().predicates().$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)CassandraMergeJoinRDD.$anonfun$tokenRangeToCqlQuery$3(x$8)))).mkString(" AND ");
        String limitClause = (String)fromRDD.limit().map((Function1 & Serializable & scala.Serializable)limit -> new StringBuilder(6).append("LIMIT ").append(limit).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String orderBy = (String)fromRDD.clusteringOrder().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toCql(fromRDD.tableDef())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        String quotedKeyspaceName = Quote$.MODULE$.quote(fromRDD.keyspaceName());
        String quotedTableName = Quote$.MODULE$.quote(fromRDD.tableName());
        String queryTemplate = new StringBuilder(52).append("SELECT ").append(columns).append(", TOKEN(").append(pk).append(") as ").append(this.TokenColumn()).append(" ").append("FROM ").append(quotedKeyspaceName).append(".").append(quotedTableName).append(" ").append("WHERE ").append(filter).append(" ").append(orderBy).append(" ").append(limitClause).append(" ALLOW FILTERING").toString();
        Seq queryParamValues = (Seq)values2.$plus$plus(fromRDD.where().values(), Seq$.MODULE$.canBuildFrom());
        return new Tuple2((Object)queryTemplate, (Object)queryParamValues);
    }

    private BoundStatement createStatement(CqlSession session, ReadConf readConf, String cql, Seq<Object> values) {
        BoundStatement boundStatement;
        try {
            PreparedStatement stmt = session.prepare(cql);
            TypeConverter[] converters = (TypeConverter[])((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable((java.lang.Iterable)stmt.getVariableDefinitions()).map((Function1 & Serializable & scala.Serializable)v -> ColumnType$.MODULE$.converterToCassandra(v.getType()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeConverter.class));
            Seq convertedValues = (Seq)((TraversableLike)values.zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])converters), Seq$.MODULE$.canBuildFrom())).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CassandraMergeJoinRDD.$anonfun$createStatement$2(check$ifrefutable$1))).map((Function1 & Serializable & scala.Serializable)x$10 -> {
                Tuple2 tuple2 = x$10;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object value = tuple2._1();
                TypeConverter converter = (TypeConverter)tuple2._2();
                Object object = converter.convert(value);
                return object;
            }, Seq$.MODULE$.canBuildFrom());
            boundStatement = (BoundStatement)stmt.bind((Object[])convertedValues.toArray(ClassTag$.MODULE$.AnyRef())).setIdempotent(Predef$.MODULE$.boolean2Boolean(true)).setPageSize(readConf.fetchSizeInRows()).setConsistencyLevel(readConf.consistencyLevel());
        }
        catch (Throwable t) {
            throw new IOException(new StringBuilder(34).append("Exception during preparation of ").append(cql).append(": ").append(t.getMessage()).toString(), t);
        }
        return boundStatement;
    }

    private <T> Iterator<T> convertRowIterator(Iterator<Row> iterator, RowReader<T> rowReader, CassandraRowMetadata columnMetaData) {
        return iterator.map((Function1 & Serializable & scala.Serializable)row -> rowReader.read((Row)row, columnMetaData));
    }

    private <T> Tuple2<CassandraRowMetadata, Iterator<Row>> fetchTokenRange(CqlSession session, CassandraTableScanRDD<T> fromRDD, CqlTokenRange<?, ?> range, InputMetricsUpdater inputMetricsUpdater) {
        Tuple2<String, Seq<Object>> tuple2 = this.tokenRangeToCqlQuery(fromRDD, range);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String cql = (String)tuple2._1();
        Seq values = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)cql, (Object)values);
        Tuple2 tuple23 = tuple22;
        String cql2 = (String)tuple23._1();
        Seq values2 = (Seq)tuple23._2();
        this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Fetching data for range ").append(range).append(" ").append("with ").append(cql2).append(" ").append("with params ").append(values2.mkString("[", ",", "]")).toString());
        BoundStatement stmt = this.createStatement(session, fromRDD.readConf(), cql2, (Seq<Object>)values2);
        Future fetchResult = ScalaJavaUtil$.MODULE$.asScalaFuture(session.executeAsync((Statement)stmt), (ExecutionContextExecutor)Threads$.MODULE$.BlockingIOExecutionContext()).map((Function1 & Serializable & scala.Serializable)rs -> {
            scala.collection.immutable.IndexedSeq columnNames = (scala.collection.immutable.IndexedSeq)((TraversableOnce)fromRDD.selectedColumnRefs().map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.selectedAs(), IndexedSeq$.MODULE$.canBuildFrom())).toIndexedSeq().$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.TokenColumn()})), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom());
            CassandraRowMetadata columnMetaData = CassandraRowMetadata$.MODULE$.fromResultSet((IndexedSeq)columnNames, rs, session);
            PrefetchingResultSetIterator iterator = new PrefetchingResultSetIterator((AsyncResultSet)rs, PrefetchingResultSetIterator$.MODULE$.$lessinit$greater$default$2());
            Iterator iteratorWithMetrics = iterator.map((Function1 & Serializable & scala.Serializable)row -> inputMetricsUpdater.updateMetrics((Row)row));
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Row iterator for range ").append(range).append(" obtained successfully.").toString());
            return new Tuple2((Object)columnMetaData, iteratorWithMetrics);
        }, (ExecutionContext)Threads$.MODULE$.BlockingIOExecutionContext()).recover((PartialFunction)new scala.Serializable(null, cql2){
            public static final long serialVersionUID = 0L;
            private final String cql$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 != null) {
                    A1 A12 = A1;
                    throw new IOException(new StringBuilder(32).append("Exception during execution of ").append(this.cql$1).append(": ").append(A12.getMessage()).toString(), A12);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable != null;
                return bl;
            }
            {
                this.cql$1 = cql$1;
            }
        }, (ExecutionContext)Threads$.MODULE$.BlockingIOExecutionContext());
        return (Tuple2)Await$.MODULE$.result((Awaitable)fetchResult, (Duration)Duration$.MODULE$.Inf());
    }

    @DeveloperApi
    public Iterator<Tuple2<Seq<L>, Seq<R>>> compute(Partition split, TaskContext context2) {
        Tuple2 tuple2 = this.openSessions$1();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        CqlSession leftSession = (CqlSession)tuple2._1();
        CqlSession rightSession = (CqlSession)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)leftSession, (Object)rightSession);
        Tuple2 tuple23 = tuple22;
        CqlSession leftSession2 = (CqlSession)tuple23._1();
        CqlSession rightSession2 = (CqlSession)tuple23._2();
        CassandraPartition partition = (CassandraPartition)split;
        Iterable tokenRanges = partition.tokenRanges();
        boolean x$1 = this.leftScanRDD.readConf().taskMetricsEnabled() || this.rightScanRDD.readConf().taskMetricsEnabled();
        Option<Object> x$2 = ReadConf$.MODULE$.$lessinit$greater$default$1();
        int x$3 = ReadConf$.MODULE$.$lessinit$greater$default$2();
        int x$4 = ReadConf$.MODULE$.$lessinit$greater$default$3();
        ConsistencyLevel x$5 = ReadConf$.MODULE$.$lessinit$greater$default$4();
        Option<Object> x$6 = ReadConf$.MODULE$.$lessinit$greater$default$6();
        Option<Object> x$7 = ReadConf$.MODULE$.$lessinit$greater$default$7();
        int x$8 = ReadConf$.MODULE$.$lessinit$greater$default$8();
        Option<String> x$9 = ReadConf$.MODULE$.$lessinit$greater$default$9();
        ReadConf metricsReadConf = new ReadConf(x$2, x$3, x$4, x$5, x$1, x$6, x$7, x$8, x$9);
        InputMetricsUpdater metricsUpdater = InputMetricsUpdater$.MODULE$.apply(context2, metricsReadConf, InputMetricsUpdater$.MODULE$.apply$default$3());
        Iterator mergingIterator = tokenRanges.iterator().flatMap((Function1 & Serializable & scala.Serializable)tokenRange -> {
            Tuple2<CassandraRowMetadata, Iterator<Row>> tuple2 = this.fetchTokenRange(leftSession2, $this.leftScanRDD, (CqlTokenRange<?, ?>)tokenRange, metricsUpdater);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            CassandraRowMetadata leftMetadata = (CassandraRowMetadata)tuple2._1();
            Iterator leftRowIterator = (Iterator)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)leftMetadata, (Object)leftRowIterator);
            Tuple2 tuple23 = tuple22;
            CassandraRowMetadata leftMetadata2 = (CassandraRowMetadata)tuple23._1();
            Iterator leftRowIterator2 = (Iterator)tuple23._2();
            Tuple2<CassandraRowMetadata, Iterator<Row>> tuple24 = this.fetchTokenRange(rightSession2, $this.rightScanRDD, (CqlTokenRange<?, ?>)tokenRange, metricsUpdater);
            if (tuple24 == null) {
                throw new MatchError(tuple24);
            }
            CassandraRowMetadata rightMetadata = (CassandraRowMetadata)tuple24._1();
            Iterator rightRowIterator = (Iterator)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)rightMetadata, (Object)rightRowIterator);
            Tuple2 tuple26 = tuple25;
            CassandraRowMetadata rightMetadata2 = (CassandraRowMetadata)tuple26._1();
            Iterator rightRowIterator2 = (Iterator)tuple26._2();
            MergeJoinIterator rowMerger = new MergeJoinIterator(leftRowIterator2, rightRowIterator2, (Function1 & Serializable & scala.Serializable)row -> this.tokenExtractor((Row)row), (Function1 & Serializable & scala.Serializable)row -> this.tokenExtractor((Row)row), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            return rowMerger.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Seq seq;
                Token token;
                Seq rRows;
                block3: {
                    Tuple3 tuple3;
                    block2: {
                        tuple3 = x0$1;
                        if (tuple3 == null) break block2;
                        Token t = (Token)tuple3._1();
                        Seq lRows = (Seq)tuple3._2();
                        rRows = (Seq)tuple3._3();
                        if (t == null) break block2;
                        token = t;
                        if (lRows == null) break block2;
                        seq = lRows;
                        if (rRows != null) break block3;
                    }
                    throw new MatchError((Object)tuple3);
                }
                Seq seq2 = rRows;
                Tuple3 tuple3 = new Tuple3((Object)token, (Object)this.convertRowIterator((Iterator<Row>)seq.iterator(), $this.leftScanRDD.rowReader(), leftMetadata2).toList(), (Object)this.convertRowIterator((Iterator<Row>)seq2.iterator(), $this.rightScanRDD.rowReader(), rightMetadata2).toList());
                return tuple3;
            });
        });
        CountingIterator countingIterator = new CountingIterator(mergingIterator, CountingIterator$.MODULE$.$lessinit$greater$default$2());
        context2.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)context -> {
            double duration = (double)metricsUpdater.finish() / 1.0E9;
            this.logDebug((Function0 & Serializable & scala.Serializable)() -> {
                Integer arg$macro$1 = BoxesRunTime.boxToInteger((int)countingIterator.count());
                String arg$macro$2 = $this.leftScanRDD.keyspaceName();
                String arg$macro$3 = $this.leftScanRDD.tableName();
                String arg$macro$4 = $this.rightScanRDD.tableName();
                Integer arg$macro$5 = BoxesRunTime.boxToInteger((int)partition.index());
                double arg$macro$6 = duration;
                return new StringOps(Predef$.MODULE$.augmentString(new StringOps("Fetched %s rows from\n            |%s %s and %s\n            |for partition %s in %.3f s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1, arg$macro$2, arg$macro$3, arg$macro$4, arg$macro$5, BoxesRunTime.boxToDouble((double)arg$macro$6)})))).stripMargin();
            });
            CassandraMergeJoinRDD.closeSessions$1(leftSession2, rightSession2);
            return context;
        });
        Iterator iteratorWithoutToken = countingIterator.map((Function1 & Serializable & scala.Serializable)tuple -> new Tuple2(tuple._2(), tuple._3()));
        return iteratorWithoutToken;
    }

    public Partition[] getPartitions() {
        this.checkValidMergeJoin();
        return this.leftScanRDD.partitions().length >= this.rightScanRDD.partitions().length ? this.leftScanRDD.partitions() : this.rightScanRDD.partitions();
    }

    public Seq<String> getPreferredLocations(Partition split) {
        return Predef$.MODULE$.wrapRefArray((Object[])((CassandraPartition)split).endpoints());
    }

    public static final /* synthetic */ boolean $anonfun$tokenRangeToCqlQuery$3(String x$8) {
        return new StringOps(Predef$.MODULE$.augmentString(x$8)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$createStatement$2(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    private final Tuple2 openSessions$1() {
        Tuple2 tuple2;
        CassandraConnector cassandraConnector = this.leftScanRDD.connector();
        CassandraConnector cassandraConnector2 = this.rightScanRDD.connector();
        if (!(cassandraConnector != null ? !cassandraConnector.equals(cassandraConnector2) : cassandraConnector2 != null)) {
            CqlSession session = this.leftScanRDD.connector().openSession();
            tuple2 = new Tuple2((Object)session, (Object)session);
        } else {
            tuple2 = new Tuple2((Object)this.leftScanRDD.connector().openSession(), (Object)this.rightScanRDD.connector().openSession());
        }
        return tuple2;
    }

    private static final void closeSessions$1(CqlSession leftSession, CqlSession rightSession) {
        CqlSession cqlSession = leftSession;
        CqlSession cqlSession2 = rightSession;
        if (cqlSession == null ? cqlSession2 != null : !cqlSession.equals(cqlSession2)) {
            rightSession.close();
        }
        leftSession.close();
    }

    public CassandraMergeJoinRDD(SparkContext sc, CassandraTableScanRDD<L> leftScanRDD, CassandraTableScanRDD<R> rightScanRDD, ClassTag<L> leftClassTag, ClassTag<R> rightClassTag) {
        this.leftScanRDD = leftScanRDD;
        this.rightScanRDD = rightScanRDD;
        super(sc, (Seq)Seq$.MODULE$.empty(), ClassTag$.MODULE$.apply(Tuple2.class));
        this.connector = leftScanRDD.connector();
        this.TokenColumn = "mj_tok_col";
    }
}

