/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.rdd.reader;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.ColumnSelector;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.rdd.reader.KeyValueRowReader;
import com.datastax.spark.connector.rdd.reader.RowReader;
import com.datastax.spark.connector.rdd.reader.RowReaderFactory;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001%4Qa\u0002\u0005\u0001\u0019QA\u0001B\r\u0001\u0003\u0002\u0003\u0006Ia\r\u0005\to\u0001\u0011\t\u0011)A\u0005q!A\u0011\b\u0001B\u0001B\u0003%!\bC\u0003<\u0001\u0011\u0005A\bC\u0003B\u0001\u0011\u0005#\tC\u0003`\u0001\u0011\u0005\u0003M\u0001\rLKf4\u0016\r\\;f%><(+Z1eKJ4\u0015m\u0019;pefT!!\u0003\u0006\u0002\rI,\u0017\rZ3s\u0015\tYA\"A\u0002sI\u0012T!!\u0004\b\u0002\u0013\r|gN\\3di>\u0014(BA\b\u0011\u0003\u0015\u0019\b/\u0019:l\u0015\t\t\"#\u0001\u0005eCR\f7\u000f^1y\u0015\u0005\u0019\u0012aA2p[V\u0019Q#\n\u0019\u0014\u0007\u00011B\u0004\u0005\u0002\u001855\t\u0001DC\u0001\u001a\u0003\u0015\u00198-\u00197b\u0013\tY\u0002D\u0001\u0004B]f\u0014VM\u001a\t\u0004;y\u0001S\"\u0001\u0005\n\u0005}A!\u0001\u0005*poJ+\u0017\rZ3s\r\u0006\u001cGo\u001c:z!\u00119\u0012eI\u0018\n\u0005\tB\"A\u0002+va2,'\u0007\u0005\u0002%K1\u0001A!\u0002\u0014\u0001\u0005\u0004A#!A&\u0004\u0001E\u0011\u0011\u0006\f\t\u0003/)J!a\u000b\r\u0003\u000f9{G\u000f[5oOB\u0011q#L\u0005\u0003]a\u00111!\u00118z!\t!\u0003\u0007B\u00032\u0001\t\u0007\u0001FA\u0001W\u00031YW-_*fY\u0016\u001cG/[8o!\t!T'D\u0001\r\u0013\t1DB\u0001\bD_2,XN\\*fY\u0016\u001cGo\u001c:\u0002\r-,\u0017P\u0015*G!\ribdI\u0001\tm\u0006dW/\u001a*S\rB\u0019QDH\u0018\u0002\rqJg.\u001b;?)\u0011idh\u0010!\u0011\tu\u00011e\f\u0005\u0006e\u0011\u0001\ra\r\u0005\u0006o\u0011\u0001\r\u0001\u000f\u0005\u0006s\u0011\u0001\rAO\u0001\ne><(+Z1eKJ$2a\u0011$O!\riB\tI\u0005\u0003\u000b\"\u0011\u0011BU8x%\u0016\fG-\u001a:\t\u000b\u001d+\u0001\u0019\u0001%\u0002\u000bQ\f'\r\\3\u0011\u0005%cU\"\u0001&\u000b\u0005-c\u0011aA2rY&\u0011QJ\u0013\u0002\t)\u0006\u0014G.\u001a#fM\")q*\u0002a\u0001!\u0006y1m\u001c7v[:\u001cV\r\\3di&|g\u000eE\u0002R3rs!AU,\u000f\u0005M3V\"\u0001+\u000b\u0005U;\u0013A\u0002\u001fs_>$h(C\u0001\u001a\u0013\tA\u0006$A\u0004qC\u000e\\\u0017mZ3\n\u0005i[&AC%oI\u0016DX\rZ*fc*\u0011\u0001\f\u0007\t\u0003iuK!A\u0018\u0007\u0003\u0013\r{G.^7o%\u00164\u0017a\u0003;be\u001e,Go\u00117bgN,\u0012!\u0019\t\u0004E\u001a\u0004cBA2e!\t\u0019\u0006$\u0003\u0002f1\u00051\u0001K]3eK\u001aL!a\u001a5\u0003\u000b\rc\u0017m]:\u000b\u0005\u0015D\u0002")
public class KeyValueRowReaderFactory<K, V>
implements RowReaderFactory<Tuple2<K, V>> {
    private final ColumnSelector keySelection;
    private final RowReaderFactory<K> keyRRF;
    private final RowReaderFactory<V> valueRRF;

    @Override
    public RowReader<Tuple2<K, V>> rowReader(TableDef table, IndexedSeq<ColumnRef> columnSelection) {
        RowReader<K> keyReader = this.keyRRF.rowReader(table, this.keySelection.selectFrom(table));
        RowReader<V> valueReader = this.valueRRF.rowReader(table, columnSelection);
        return new KeyValueRowReader<K, V>(keyReader, valueReader);
    }

    @Override
    public Class<Tuple2<K, V>> targetClass() {
        return Tuple2.class;
    }

    public KeyValueRowReaderFactory(ColumnSelector keySelection, RowReaderFactory<K> keyRRF, RowReaderFactory<V> valueRRF) {
        this.keySelection = keySelection;
        this.keyRRF = keyRRF;
        this.valueRRF = valueRRF;
    }
}

