/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.connection.BusyConnectionException;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.spark.connector.util.Logging;
import com.datastax.spark.connector.writer.AsyncExecutor$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.concurrent.TrieMap;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ed\u0001\u0002\f\u0018\u0001\tB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"Aq\n\u0001B\u0001B\u0003%\u0001\u000b\u0003\u0005{\u0001\t\u0005\t\u0015!\u0003Q\u0011\u0015I\u0006\u0001\"\u0001|\u0011%\t\u0019\u0001\u0001b\u0001\n\u0013\t)\u0001\u0003\u0005\u0002\u000e\u0001\u0001\u000b\u0011BA\u0004\u0011%\ty\u0001\u0001b\u0001\n\u0013\t\t\u0002\u0003\u0005\u00022\u0001\u0001\u000b\u0011BA\n\u0011%\t\u0019\u0004\u0001a\u0001\n\u0013\t)\u0004C\u0005\u0002R\u0001\u0001\r\u0011\"\u0003\u0002T!A\u0011\u0011\f\u0001!B\u0013\t9\u0004C\u0004\u0002d\u0001!\t!!\u001a\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0002j!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA;\u0001\u0011\u0005\u0011qO\u0004\u0006-^A\ta\u0016\u0004\u0006-]A\t\u0001\u0017\u0005\u00063J!\tAW\u0003\u00057J\u0001A\fC\u0004i%E\u0005I\u0011A5\u0003\u001b\u0005\u001b\u0018P\\2Fq\u0016\u001cW\u000f^8s\u0015\tA\u0012$\u0001\u0004xe&$XM\u001d\u0006\u00035m\t\u0011bY8o]\u0016\u001cGo\u001c:\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003!!\u0017\r^1ti\u0006D(\"\u0001\u0011\u0002\u0007\r|Wn\u0001\u0001\u0016\u0007\r2\u0014jE\u0002\u0001I)\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0007CA\u0016/\u001b\u0005a#BA\u0017\u001a\u0003\u0011)H/\u001b7\n\u0005=b#a\u0002'pO\u001eLgnZ\u0001\fCNLhnY!di&|g\u000e\u0005\u0003&eQz\u0014BA\u001a'\u0005%1UO\\2uS>t\u0017\u0007\u0005\u00026m1\u0001A!B\u001c\u0001\u0005\u0004A$!\u0001+\u0012\u0005eb\u0004CA\u0013;\u0013\tYdEA\u0004O_RD\u0017N\\4\u0011\u0005\u0015j\u0014B\u0001 '\u0005\r\te.\u001f\t\u0004\u0001\u001aCU\"A!\u000b\u0005\t\u001b\u0015AC2p]\u000e,(O]3oi*\u0011Q\u0006\u0012\u0006\u0002\u000b\u0006!!.\u0019<b\u0013\t9\u0015IA\bD_6\u0004H.\u001a;j_:\u001cF/Y4f!\t)\u0014\nB\u0003K\u0001\t\u0007\u0001HA\u0001S\u0003Ii\u0017\r_\"p]\u000e,(O]3oiR\u000b7o[:\u0011\u0005\u0015j\u0015B\u0001('\u0005\rIe\u000e^\u0001\u000fgV\u001c7-Z:t\u0011\u0006tG\r\\3s!\r)\u0013kU\u0005\u0003%\u001a\u0012aa\u00149uS>t\u0007c\u0001+\u0015i9\u0011Q+E\u0007\u0002/\u0005i\u0011i]=oG\u0016CXmY;u_J\u0004\"!\u0016\n\u0014\u0005I!\u0013A\u0002\u001fj]&$h\bF\u0001X\u0005\u001dA\u0015M\u001c3mKJ,\"!X1\u0011\r\u0015r\u0006M\u00192f\u0013\tyfEA\u0005Gk:\u001cG/[8ogA\u0011Q'\u0019\u0003\u0006oQ\u0011\r\u0001\u000f\t\u0003K\rL!\u0001\u001a\u0014\u0003\t1{gn\u001a\t\u0003K\u0019L!a\u001a\u0014\u0003\tUs\u0017\u000e^\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0007)D\u00180F\u0001lU\tawN\u0004\u0002&[&\u0011aNJ\u0001\u0005\u001d>tWmK\u0001q!\t\th/D\u0001s\u0015\t\u0019H/A\u0005v]\u000eDWmY6fI*\u0011QOJ\u0001\u000bC:tw\u000e^1uS>t\u0017BA<s\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006oU\u0011\r\u0001\u000f\u0003\u0006\u0015V\u0011\r\u0001O\u0001\u000fM\u0006LG.\u001e:f\u0011\u0006tG\r\\3s)\u0019aXP`@\u0002\u0002A!Q\u000b\u0001\u001bI\u0011\u0015\u0001T\u00011\u00012\u0011\u0015YU\u00011\u0001M\u0011\u001dyU\u0001%AA\u0002ACQA_\u0003A\u0002A\u000b\u0011b]3nCBDwN]3\u0016\u0005\u0005\u001d\u0001c\u0001!\u0002\n%\u0019\u00111B!\u0003\u0013M+W.\u00199i_J,\u0017AC:f[\u0006\u0004\bn\u001c:fA\u0005q\u0001/\u001a8eS:<g)\u001e;ve\u0016\u001cXCAA\n!!\t)\"!\b\u0002\"\u0005-RBAA\f\u0015\r\u0011\u0015\u0011\u0004\u0006\u0004\u000371\u0013AC2pY2,7\r^5p]&!\u0011qDA\f\u0005\u001d!&/[3NCB\u0004R!a\t\u0002(!k!!!\n\u000b\u0005\t3\u0013\u0002BA\u0015\u0003K\u0011aAR;ukJ,\u0007cA\u0013\u0002.%\u0019\u0011q\u0006\u0014\u0003\u000f\t{w\u000e\\3b]\u0006y\u0001/\u001a8eS:<g)\u001e;ve\u0016\u001c\b%A\bmCR,7\u000f^#yG\u0016\u0004H/[8o+\t\t9\u0004\u0005\u0003&#\u0006e\u0002\u0003BA\u001e\u0003\u0017rA!!\u0010\u0002H9!\u0011qHA#\u001b\t\t\tEC\u0002\u0002D\u0005\na\u0001\u0010:p_Rt\u0014\"A\u0014\n\u0007\u0005%c%A\u0004qC\u000e\\\u0017mZ3\n\t\u00055\u0013q\n\u0002\n)\"\u0014xn^1cY\u0016T1!!\u0013'\u0003Ma\u0017\r^3ti\u0016C8-\u001a9uS>tw\fJ3r)\r)\u0017Q\u000b\u0005\n\u0003/Z\u0011\u0011!a\u0001\u0003o\t1\u0001\u001f\u00132\u0003Aa\u0017\r^3ti\u0016C8-\u001a9uS>t\u0007\u0005K\u0002\r\u0003;\u00022!JA0\u0013\r\t\tG\n\u0002\tm>d\u0017\r^5mK\u0006\u0011r-\u001a;MCR,7\u000f^#yG\u0016\u0004H/[8o)\t\t9$\u0001\u0007fq\u0016\u001cW\u000f^3Bgft7\r\u0006\u0003\u0002\"\u0005-\u0004BBA7\u001d\u0001\u0007A'\u0001\u0003uCN\\\u0017aB3yK\u000e,H/\u001a\u000b\u0004\u0011\u0006M\u0004BBA7\u001f\u0001\u0007A'\u0001\u0010xC&$hi\u001c:DkJ\u0014XM\u001c;ms\u0016CXmY;uS:<G+Y:lgR\tQ\r")
public class AsyncExecutor<T, R>
implements Logging {
    private final Function1<T, CompletionStage<R>> asyncAction;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$successHandler;
    public final Option<Function3<T, Object, Object, BoxedUnit>> com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler;
    private final Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    private final TrieMap<Future<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    private volatile Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public static <T, R> None$ $lessinit$greater$default$3() {
        return AsyncExecutor$.MODULE$.$lessinit$greater$default$3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public Semaphore com$datastax$spark$connector$writer$AsyncExecutor$$semaphore() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore;
    }

    public TrieMap<Future<R>, Object> com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures;
    }

    private Option<Throwable> com$datastax$spark$connector$writer$AsyncExecutor$$latestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException;
    }

    public void com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq(Option<Throwable> x$1) {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = x$1;
    }

    public Option<Throwable> getLatestException() {
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException();
    }

    public Future<R> executeAsync(T task) {
        long submissionTimestamp = System.nanoTime();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().acquire();
        Promise promise = Promise$.MODULE$.apply();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().put((Object)promise.future(), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        long executionTimestamp = System.nanoTime();
        return this.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(task, promise, submissionTimestamp, executionTimestamp);
    }

    public R execute(T task) {
        return (R)Await$.MODULE$.result(this.executeAsync(task), (Duration)Duration$.MODULE$.apply(20L, TimeUnit.SECONDS));
    }

    public void waitForCurrentlyExecutingTasks() {
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().snapshot().withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AsyncExecutor.$anonfun$waitForCurrentlyExecutingTasks$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            Tuple2 tuple2 = x$4;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Future future = (Future)tuple2._1();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> Await$.MODULE$.result((Awaitable)future, (Duration)Duration$.MODULE$.Inf()));
            return try_;
        });
    }

    public final Future com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(Object task$1, Promise promise$1, long submissionTimestamp$1, long executionTimestamp$1) {
        CompletionStage value = (CompletionStage)this.asyncAction.apply(task$1);
        value.whenComplete(new BiConsumer<R, Throwable>(this, promise$1, task$1, submissionTimestamp$1, executionTimestamp$1){
            private final /* synthetic */ AsyncExecutor $outer;
            private final Promise promise$1;
            private final Object task$1;
            private final long submissionTimestamp$1;
            private final long executionTimestamp$1;

            public BiConsumer<R, Throwable> andThen(BiConsumer<? super R, ? super Throwable> x$1) {
                return BiConsumer.super.andThen(x$1);
            }

            private void release() {
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore().release();
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures().remove((Object)this.promise$1.future());
            }

            private void onSuccess(R result) {
                this.release();
                this.promise$1.success(result);
                this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                    $anon$1.$anonfun$onSuccess$1(this, x$1);
                    return BoxedUnit.UNIT;
                });
            }

            private void onFailure(Throwable throwable) {
                AllNodesFailedException allNodesFailedException;
                Throwable throwable2 = throwable;
                if (throwable2 instanceof AllNodesFailedException && ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((allNodesFailedException = (AllNodesFailedException)throwable2).getAllErrors()).asScala()).values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$onFailure$1(x$2)))) {
                    this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "BusyConnectionException ... Retrying");
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.promise$1, this.submissionTimestamp$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable2 instanceof NoNodeAvailableException) {
                    this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No Nodes Available ... Retrying");
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.promise$1, this.submissionTimestamp$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (throwable2 instanceof OverloadedException) {
                    this.$outer.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Backpressure rejection ... Retrying");
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$tryFuture$1(this.task$1, this.promise$1, this.submissionTimestamp$1, this.executionTimestamp$1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    this.$outer.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Failed to execute: ").append($this.task$1).toString(), throwable2);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$latestException_$eq((Option<Throwable>)new Some((Object)throwable));
                    this.release();
                    this.promise$1.failure(throwable);
                    this.$outer.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler.foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                        $anon$1.$anonfun$onFailure$6(this, x$3);
                        return BoxedUnit.UNIT;
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }

            public void accept(R r, Throwable t) {
                Option$.MODULE$.apply((Object)t).foreach((Function1 & Serializable & scala.Serializable)throwable -> {
                    $anon$1.$anonfun$accept$1(this, throwable);
                    return BoxedUnit.UNIT;
                });
                Option$.MODULE$.apply(r).foreach((Function1 & Serializable & scala.Serializable)result -> {
                    $anon$1.$anonfun$accept$2(this, result);
                    return BoxedUnit.UNIT;
                });
            }

            public static final /* synthetic */ void $anonfun$onSuccess$1($anon$1 $this, Function3 x$1) {
                x$1.apply($this.task$1, (Object)BoxesRunTime.boxToLong((long)$this.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)$this.executionTimestamp$1));
            }

            public static final /* synthetic */ boolean $anonfun$onFailure$1(List x$2) {
                return x$2 instanceof BusyConnectionException;
            }

            public static final /* synthetic */ void $anonfun$onFailure$6($anon$1 $this, Function3 x$3) {
                x$3.apply($this.task$1, (Object)BoxesRunTime.boxToLong((long)$this.submissionTimestamp$1), (Object)BoxesRunTime.boxToLong((long)$this.executionTimestamp$1));
            }

            public static final /* synthetic */ void $anonfun$accept$1($anon$1 $this, Throwable throwable) {
                $this.onFailure(throwable);
            }

            public static final /* synthetic */ void $anonfun$accept$2($anon$1 $this, Object result) {
                $this.onSuccess(result);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.promise$1 = promise$1;
                this.task$1 = task$1;
                this.submissionTimestamp$1 = submissionTimestamp$1;
                this.executionTimestamp$1 = executionTimestamp$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onSuccess$1$adapted(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 scala.Function3 ), $anonfun$onFailure$1$adapted(java.util.List ), $anonfun$onFailure$2(), $anonfun$onFailure$3(), $anonfun$onFailure$4(), $anonfun$onFailure$5(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 ), $anonfun$onFailure$6$adapted(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 scala.Function3 ), $anonfun$accept$1$adapted(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 java.lang.Throwable ), $anonfun$accept$2$adapted(com.datastax.spark.connector.writer.AsyncExecutor$$anon$1 java.lang.Object )}, serializedLambda);
            }
        });
        return promise$1.future();
    }

    public static final /* synthetic */ boolean $anonfun$waitForCurrentlyExecutingTasks$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public AsyncExecutor(Function1<T, CompletionStage<R>> asyncAction, int maxConcurrentTasks, Option<Function3<T, Object, Object, BoxedUnit>> successHandler, Option<Function3<T, Object, Object, BoxedUnit>> failureHandler) {
        this.asyncAction = asyncAction;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$successHandler = successHandler;
        this.com$datastax$spark$connector$writer$AsyncExecutor$$failureHandler = failureHandler;
        Logging.$init$((Logging)this);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$semaphore = new Semaphore(maxConcurrentTasks);
        this.com$datastax$spark$connector$writer$AsyncExecutor$$pendingFutures = new TrieMap();
        this.com$datastax$spark$connector$writer$AsyncExecutor$$latestException = None$.MODULE$;
    }
}

