/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.spark.connector.writer;

import com.datastax.spark.connector.ColumnRef;
import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.TypeConverter;
import com.datastax.spark.connector.writer.RowWriter;
import org.apache.spark.sql.Row;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001de\u0001B\f\u0019\u0001\rB\u0001\"\u000f\u0001\u0003\u0006\u0004%\tA\u000f\u0005\t\u0003\u0002\u0011\t\u0011)A\u0005w!A!\t\u0001BC\u0002\u0013\u00051\t\u0003\u0005U\u0001\t\u0005\t\u0015!\u0003E\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u001dQ\u0006A1A\u0005BmCaa\u001a\u0001!\u0002\u0013a\u0006b\u00025\u0001\u0005\u0004%I!\u001b\u0005\u0007e\u0002\u0001\u000b\u0011\u00026\t\u000fM\u0004!\u0019!C\u0005i\"9\u0011q\u0001\u0001!\u0002\u0013)\b\"CA\r\u0001\t\u0007I\u0011BA\u000e\u0011!\ty\u0003\u0001Q\u0001\n\u0005u\u0001bBA\u001a\u0001\u0011\u0005\u0013QG\u0004\b\u0003\u0017B\u0002\u0012AA'\r\u00199\u0002\u0004#\u0001\u0002P!1Q\u000b\u0005C\u0001\u0003/:q!!\u0017\u0011\u0011\u0003\tYFB\u0004\u0002`AA\t!!\u0019\t\rU\u001bB\u0011AA5\u0011\u001d\tYg\u0005C!\u0003[B\u0011\"a\u001d\u0011\u0003\u0003%I!!\u001e\u0003\u0019M\u000bHNU8x/JLG/\u001a:\u000b\u0005eQ\u0012AB<sSR,'O\u0003\u0002\u001c9\u0005I1m\u001c8oK\u000e$xN\u001d\u0006\u0003;y\tQa\u001d9be.T!a\b\u0011\u0002\u0011\u0011\fG/Y:uCbT\u0011!I\u0001\u0004G>l7\u0001A\n\u0004\u0001\u0011R\u0003CA\u0013)\u001b\u00051#\"A\u0014\u0002\u000bM\u001c\u0017\r\\1\n\u0005%2#AB!osJ+g\rE\u0002,Y9j\u0011\u0001G\u0005\u0003[a\u0011\u0011BU8x/JLG/\u001a:\u0011\u0005=:T\"\u0001\u0019\u000b\u0005E\u0012\u0014aA:rY*\u0011Qd\r\u0006\u0003iU\na!\u00199bG\",'\"\u0001\u001c\u0002\u0007=\u0014x-\u0003\u00029a\t\u0019!k\\<\u0002\u000bQ\f'\r\\3\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!A\u0010\u000e\u0002\u0007\r\fH.\u0003\u0002A{\tAA+\u00192mK\u0012+g-\u0001\u0004uC\ndW\rI\u0001\u0010g\u0016dWm\u0019;fI\u000e{G.^7ogV\tA\tE\u0002F\u001bBs!AR&\u000f\u0005\u001dSU\"\u0001%\u000b\u0005%\u0013\u0013A\u0002\u001fs_>$h(C\u0001(\u0013\tae%A\u0004qC\u000e\\\u0017mZ3\n\u00059{%AC%oI\u0016DX\rZ*fc*\u0011AJ\n\t\u0003#Jk\u0011AG\u0005\u0003'j\u0011\u0011bQ8mk6t'+\u001a4\u0002!M,G.Z2uK\u0012\u001cu\u000e\\;n]N\u0004\u0013A\u0002\u001fj]&$h\bF\u0002X1f\u0003\"a\u000b\u0001\t\u000be*\u0001\u0019A\u001e\t\u000b\t+\u0001\u0019\u0001#\u0002\u0017\r|G.^7o\u001d\u0006lWm]\u000b\u00029B\u0019Q)X0\n\u0005y{%aA*fcB\u0011\u0001\r\u001a\b\u0003C\n\u0004\"a\u0012\u0014\n\u0005\r4\u0013A\u0002)sK\u0012,g-\u0003\u0002fM\n11\u000b\u001e:j]\u001eT!a\u0019\u0014\u0002\u0019\r|G.^7o\u001d\u0006lWm\u001d\u0011\u0002\u000f\r|G.^7ogV\t!\u000eE\u0002l]>l\u0011\u0001\u001c\u0006\u0003[\u001a\n!bY8mY\u0016\u001cG/[8o\u0013\tqF\u000e\u0005\u0002=a&\u0011\u0011/\u0010\u0002\n\u0007>dW/\u001c8EK\u001a\f\u0001bY8mk6t7\u000fI\u0001\fG>dW/\u001c8UsB,7/F\u0001v!\rYgN\u001e\u0019\u0003o~\u00042\u0001_>~\u001b\u0005I(B\u0001>\u001b\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0018P\u0001\u0006D_2,XN\u001c+za\u0016\u0004\"A`@\r\u0001\u0011a\u0011\u0011AA\u0002\u0003\u0003\u0005\tQ!\u0001\u0002\f\t\u0019q\fJ\u001a\t\u0013\u0005\u00151\"!A\u0001\u0002\u0005%\u0011\u0001\u0003\u0013b]>tg-\u001e8\u0002\u0019\r|G.^7o)f\u0004Xm\u001d\u0011\f\u0001E!\u0011QBA\n!\r)\u0013qB\u0005\u0004\u0003#1#a\u0002(pi\"Lgn\u001a\t\u0004K\u0005U\u0011bAA\fM\t\u0019\u0011I\\=\u0002\u0015\r|gN^3si\u0016\u00148/\u0006\u0002\u0002\u001eA!1N\\A\u0010a\u0011\t\t#!\u000b\u0011\u000ba\f\u0019#a\n\n\u0007\u0005\u0015\u0012PA\u0007UsB,7i\u001c8wKJ$XM\u001d\t\u0004}\u0006%B\u0001DA\u0016\u0003[\t\t\u0011!A\u0003\u0002\u0005E\"aA0%c!I\u0011QA\u0007\u0002\u0002\u0003\u0005\u0011\u0011B\u0001\fG>tg/\u001a:uKJ\u001c\b%E\u0002\u0002\u000e\u0011\n\u0001C]3bI\u000e{G.^7o-\u0006dW/Z:\u0015\r\u0005]\u0012QHA!!\r)\u0013\u0011H\u0005\u0004\u0003w1#\u0001B+oSRDa!a\u0010\u000f\u0001\u0004q\u0013a\u0001:po\"9\u00111\t\bA\u0002\u0005\u0015\u0013A\u00022vM\u001a,'\u000fE\u0003&\u0003\u000f\n\u0019\"C\u0002\u0002J\u0019\u0012Q!\u0011:sCf\fAbU9m%><xK]5uKJ\u0004\"a\u000b\t\u0014\tA!\u0013\u0011\u000b\t\u0004K\u0005M\u0013bAA+M\ta1+\u001a:jC2L'0\u00192mKR\u0011\u0011QJ\u0001\b\r\u0006\u001cGo\u001c:z!\r\tifE\u0007\u0002!\t9a)Y2u_JL8\u0003B\n%\u0003G\u0002BaKA3]%\u0019\u0011q\r\r\u0003!I{wo\u0016:ji\u0016\u0014h)Y2u_JLHCAA.\u0003%\u0011xn^,sSR,'\u000fF\u0003X\u0003_\n\t\bC\u0003:+\u0001\u00071\bC\u0003C+\u0001\u0007A)A\u0006sK\u0006$'+Z:pYZ,GCAA<!\u0011\tI(a!\u000e\u0005\u0005m$\u0002BA?\u0003\u007f\nA\u0001\\1oO*\u0011\u0011\u0011Q\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0006\u0006m$AB(cU\u0016\u001cG\u000f")
public class SqlRowWriter
implements RowWriter<Row> {
    private final TableDef table;
    private final IndexedSeq<ColumnRef> selectedColumns;
    private final Seq<String> columnNames;
    private final Seq<ColumnDef> columns;
    private final Seq<ColumnType<?>> columnTypes;
    private final Seq<TypeConverter<?>> converters;

    public TableDef table() {
        return this.table;
    }

    public IndexedSeq<ColumnRef> selectedColumns() {
        return this.selectedColumns;
    }

    @Override
    public Seq<String> columnNames() {
        return this.columnNames;
    }

    private Seq<ColumnDef> columns() {
        return this.columns;
    }

    private Seq<ColumnType<?>> columnTypes() {
        return this.columnTypes;
    }

    private Seq<TypeConverter<?>> converters() {
        return this.converters;
    }

    @Override
    public void readColumnValues(Row row, Object[] buffer) {
        Predef$.MODULE$.require(row.size() == this.columnNames().size(), (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(31).append("Invalid row size: ").append(row.size()).append(" instead of ").append(this.columnNames().size()).append(".").toString());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), row.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)i -> {
            Object colValue = row.apply(i);
            buffer$1[i] = ((TypeConverter)this.converters().apply(i)).convert(colValue);
        });
    }

    public SqlRowWriter(TableDef table, IndexedSeq<ColumnRef> selectedColumns) {
        this.table = table;
        this.selectedColumns = selectedColumns;
        this.columnNames = (Seq)selectedColumns.map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        this.columns = (Seq)this.columnNames().map((Function1)table.columnByName(), Seq$.MODULE$.canBuildFrom());
        this.columnTypes = (Seq)this.columns().map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.columnType(), Seq$.MODULE$.canBuildFrom());
        this.converters = (Seq)this.columns().map((Function1 & java.io.Serializable & Serializable)x$3 -> x$3.columnType().converterToCassandra(), Seq$.MODULE$.canBuildFrom());
    }
}

