/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.spark.connector.cql.ColumnDef;
import com.datastax.spark.connector.cql.IndexDef;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.types.AsciiType$;
import com.datastax.spark.connector.types.BigIntType$;
import com.datastax.spark.connector.types.ColumnType;
import com.datastax.spark.connector.types.DateType$;
import com.datastax.spark.connector.types.DecimalType$;
import com.datastax.spark.connector.types.DoubleType$;
import com.datastax.spark.connector.types.FloatType$;
import com.datastax.spark.connector.types.InetType$;
import com.datastax.spark.connector.types.IntType$;
import com.datastax.spark.connector.types.SmallIntType$;
import com.datastax.spark.connector.types.TextType$;
import com.datastax.spark.connector.types.TimeType$;
import com.datastax.spark.connector.types.TimeUUIDType$;
import com.datastax.spark.connector.types.TimestampType$;
import com.datastax.spark.connector.types.TinyIntType$;
import com.datastax.spark.connector.types.UUIDType$;
import com.datastax.spark.connector.types.VarCharType$;
import com.datastax.spark.connector.types.VarIntType$;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.PredicateOps$FilterOps$;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.IsNotNull;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyRef;

public final class DsePredicateRules$
implements CassandraPredicateRules,
Logging {
    public static DsePredicateRules$ MODULE$;
    private final String StorageAttachedIndex;
    private final scala.collection.immutable.Set<ColumnType<?>> saiTextTypes;
    private final scala.collection.immutable.Set<ColumnType<?>> saiNumericTypes;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new DsePredicateRules$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public String StorageAttachedIndex() {
        return this.StorageAttachedIndex;
    }

    private scala.collection.immutable.Set<ColumnType<?>> saiTextTypes() {
        return this.saiTextTypes;
    }

    private scala.collection.immutable.Set<ColumnType<?>> saiNumericTypes() {
        return this.saiNumericTypes;
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates2, TableDef tableDef2, SparkConf sparkConf) {
        Seq pushDownRules = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function2[]{(Function2 & Serializable & scala.Serializable)(predicates, tableDef) -> MODULE$.pushOnlySolrQuery((AnalyzedPredicates)predicates, (TableDef)tableDef)}))).$plus$plus(this.storageAttachedIndexPredicateRules(predicates2, tableDef2), Seq$.MODULE$.canBuildFrom());
        return (AnalyzedPredicates)pushDownRules.foldLeft((Object)predicates2, (Function2 & Serializable & scala.Serializable)(p, rule) -> (AnalyzedPredicates)rule.apply(p, (Object)tableDef2));
    }

    private AnalyzedPredicates pushOnlySolrQuery(AnalyzedPredicates predicates, TableDef tableDef) {
        scala.collection.immutable.Set allPredicates = (scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark());
        scala.collection.immutable.Set solrQuery = (scala.collection.immutable.Set)allPredicates.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    String column = equalTo.attribute();
                    Object value = equalTo.value();
                    String string = column;
                    String string2 = "solr_query";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = new EqualTo(column, value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Filter x1) {
                String column;
                Filter filter = x1;
                if (!(filter instanceof EqualTo)) return false;
                EqualTo equalTo = (EqualTo)filter;
                String string = column = equalTo.attribute();
                String string2 = "solr_query";
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
        }, Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set solrIsNotNull = (scala.collection.immutable.Set)allPredicates.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof IsNotNull) {
                    String column;
                    IsNotNull isNotNull = (IsNotNull)A1;
                    String string = column = isNotNull.attribute();
                    String string2 = "solr_query";
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = new IsNotNull(column);
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Filter x2) {
                String column;
                Filter filter = x2;
                if (!(filter instanceof IsNotNull)) return false;
                IsNotNull isNotNull = (IsNotNull)filter;
                String string = column = isNotNull.attribute();
                String string2 = "solr_query";
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
        }, Set$.MODULE$.canBuildFrom());
        return solrQuery.nonEmpty() ? new AnalyzedPredicates((scala.collection.immutable.Set<Filter>)solrQuery, (scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)allPredicates.$minus$minus((GenTraversableOnce)solrQuery).$minus$minus((GenTraversableOnce)solrIsNotNull))) : predicates;
    }

    private Seq<IndexDef> saiIndexes(TableDef table) {
        return (Seq)table.indexes().filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DsePredicateRules$.$anonfun$saiIndexes$1(x$1)));
    }

    private AnalyzedPredicates pushDownPredicates(AnalyzedPredicates predicates, TableDef table, Function1<Filter, Object> eligibleForPushDown) {
        Seq indexColumns = (Seq)this.saiIndexes(table).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.targetColumn(), Seq$.MODULE$.canBuildFrom());
        Set pushedEqualityPredicates = (Set)((TraversableLike)predicates.handledByCassandra().collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = PredicateOps$FilterOps$.MODULE$.isEqualToPredicate(A1) ? PredicateOps$FilterOps$.MODULE$.columnName(A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x1) {
                Filter filter = x1;
                boolean bl = PredicateOps$FilterOps$.MODULE$.isEqualToPredicate(filter);
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).to(scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        Tuple2 tuple2 = predicates.handledBySpark().partition((Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)DsePredicateRules$.$anonfun$pushDownPredicates$2(eligibleForPushDown, indexColumns, pushedEqualityPredicates, filter)));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set handledByCassandra = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set handledBySpark = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)handledByCassandra, (Object)handledBySpark);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Set handledByCassandra2 = (scala.collection.immutable.Set)tuple23._1();
        scala.collection.immutable.Set handledBySpark2 = (scala.collection.immutable.Set)tuple23._2();
        return new AnalyzedPredicates((scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus((GenTraversableOnce)handledByCassandra2)), (scala.collection.immutable.Set<Filter>)handledBySpark2);
    }

    private AnalyzedPredicates pushDownSAITextPredicates(AnalyzedPredicates predicates, TableDef table) {
        return this.pushDownPredicates(predicates, table, (Function1<Filter, Object>)(Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)DsePredicateRules$.$anonfun$pushDownSAITextPredicates$1(table, filter)));
    }

    private AnalyzedPredicates pushDownSAINumericPredicates(AnalyzedPredicates predicates, TableDef table) {
        return this.pushDownPredicates(predicates, table, (Function1<Filter, Object>)(Function1 & Serializable & scala.Serializable)filter -> BoxesRunTime.boxToBoolean((boolean)DsePredicateRules$.$anonfun$pushDownSAINumericPredicates$1(table, filter)));
    }

    private Seq<Function2<AnalyzedPredicates, TableDef, AnalyzedPredicates>> storageAttachedIndexPredicateRules(AnalyzedPredicates predicates2, TableDef table2) {
        Seq seq;
        scala.collection.immutable.Set partitionKeyColumns = ((TraversableOnce)table2.partitionKey().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.columnName(), Seq$.MODULE$.canBuildFrom())).toSet();
        Option inClauseInPartitionKey = predicates2.handledByCassandra().find((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)DsePredicateRules$.$anonfun$storageAttachedIndexPredicateRules$2(partitionKeyColumns, f)));
        if (inClauseInPartitionKey.isDefined()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(87).append("SAI pushdown is not possible, the query contains IN clause ").append("on ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Filter)inClauseInPartitionKey.get()).references())).mkString(",")).append(" partition key column(s).").toString());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else if (this.saiIndexes(table2).isEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("There are no SAI indexes on the given table: ").append(table2.name()).toString());
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function2[]{(Function2 & Serializable & scala.Serializable)(predicates, table) -> MODULE$.pushDownSAITextPredicates((AnalyzedPredicates)predicates, (TableDef)table), (Function2 & Serializable & scala.Serializable)(predicates, table) -> MODULE$.pushDownSAINumericPredicates((AnalyzedPredicates)predicates, (TableDef)table)}));
        }
        return seq;
    }

    public static final /* synthetic */ boolean $anonfun$saiIndexes$1(IndexDef x$1) {
        return x$1.className().contains((Object)MODULE$.StorageAttachedIndex());
    }

    private static final /* synthetic */ String columnName$lzycompute$1(LazyRef columnName$lzy$1, Filter filter$1) {
        String string;
        LazyRef lazyRef = columnName$lzy$1;
        synchronized (lazyRef) {
            string = columnName$lzy$1.initialized() ? (String)columnName$lzy$1.value() : (String)columnName$lzy$1.initialize((Object)PredicateOps$FilterOps$.MODULE$.columnName(filter$1));
        }
        return string;
    }

    private static final String columnName$1(LazyRef columnName$lzy$1, Filter filter$1) {
        return columnName$lzy$1.initialized() ? (String)columnName$lzy$1.value() : DsePredicateRules$.columnName$lzycompute$1(columnName$lzy$1, filter$1);
    }

    private static final /* synthetic */ boolean eligibleForSAIPushDown$lzycompute$1(LazyBoolean eligibleForSAIPushDown$lzy$1, Function1 eligibleForPushDown$1, Filter filter$1, Seq indexColumns$1, Set pushedEqualityPredicates$1, LazyRef columnName$lzy$1) {
        boolean bl;
        LazyBoolean lazyBoolean = eligibleForSAIPushDown$lzy$1;
        synchronized (lazyBoolean) {
            bl = eligibleForSAIPushDown$lzy$1.initialized() ? eligibleForSAIPushDown$lzy$1.value() : eligibleForSAIPushDown$lzy$1.initialize(BoxesRunTime.unboxToBoolean((Object)eligibleForPushDown$1.apply((Object)filter$1)) && indexColumns$1.contains((Object)DsePredicateRules$.columnName$1(columnName$lzy$1, filter$1)) && !pushedEqualityPredicates$1.contains((Object)DsePredicateRules$.columnName$1(columnName$lzy$1, filter$1)));
        }
        return bl;
    }

    private static final boolean eligibleForSAIPushDown$1(LazyBoolean eligibleForSAIPushDown$lzy$1, Function1 eligibleForPushDown$1, Filter filter$1, Seq indexColumns$1, Set pushedEqualityPredicates$1, LazyRef columnName$lzy$1) {
        return eligibleForSAIPushDown$lzy$1.initialized() ? eligibleForSAIPushDown$lzy$1.value() : DsePredicateRules$.eligibleForSAIPushDown$lzycompute$1(eligibleForSAIPushDown$lzy$1, eligibleForPushDown$1, filter$1, indexColumns$1, pushedEqualityPredicates$1, columnName$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$pushDownPredicates$2(Function1 eligibleForPushDown$1, Seq indexColumns$1, Set pushedEqualityPredicates$1, Filter filter) {
        LazyRef columnName$lzy = new LazyRef();
        LazyBoolean eligibleForSAIPushDown$lzy = new LazyBoolean();
        boolean isEqualityPredicate = PredicateOps$FilterOps$.MODULE$.isEqualToPredicate(filter);
        Object object = isEqualityPredicate && DsePredicateRules$.eligibleForSAIPushDown$1(eligibleForSAIPushDown$lzy, eligibleForPushDown$1, filter, indexColumns$1, pushedEqualityPredicates$1, columnName$lzy) ? pushedEqualityPredicates$1.$plus$eq((Object)DsePredicateRules$.columnName$1(columnName$lzy, filter)) : BoxedUnit.UNIT;
        return DsePredicateRules$.eligibleForSAIPushDown$1(eligibleForSAIPushDown$lzy, eligibleForPushDown$1, filter, indexColumns$1, pushedEqualityPredicates$1, columnName$lzy);
    }

    public static final /* synthetic */ boolean $anonfun$pushDownSAITextPredicates$1(TableDef table$1, Filter filter) {
        return PredicateOps$FilterOps$.MODULE$.isEqualToPredicate(filter) && MODULE$.saiTextTypes().contains((Object)((ColumnDef)table$1.columnByName().apply((Object)PredicateOps$FilterOps$.MODULE$.columnName(filter))).columnType());
    }

    public static final /* synthetic */ boolean $anonfun$pushDownSAINumericPredicates$1(TableDef table$2, Filter filter) {
        return (PredicateOps$FilterOps$.MODULE$.isEqualToPredicate(filter) || PredicateOps$FilterOps$.MODULE$.isRangePredicate(filter)) && MODULE$.saiNumericTypes().contains((Object)((ColumnDef)table$2.columnByName().apply((Object)PredicateOps$FilterOps$.MODULE$.columnName(filter))).columnType());
    }

    public static final /* synthetic */ boolean $anonfun$storageAttachedIndexPredicateRules$2(scala.collection.immutable.Set partitionKeyColumns$1, Filter f) {
        return PredicateOps$FilterOps$.MODULE$.isInPredicate(f) && new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])f.references())).exists((Function1 & Serializable & scala.Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionKeyColumns$1.contains((Object)elem)));
    }

    private DsePredicateRules$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.StorageAttachedIndex = "StorageAttachedIndex";
        this.saiTextTypes = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[]{TextType$.MODULE$, AsciiType$.MODULE$, VarCharType$.MODULE$, UUIDType$.MODULE$}));
        this.saiNumericTypes = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ColumnType[]{IntType$.MODULE$, BigIntType$.MODULE$, SmallIntType$.MODULE$, TinyIntType$.MODULE$, FloatType$.MODULE$, DoubleType$.MODULE$, VarIntType$.MODULE$, DecimalType$.MODULE$, TimestampType$.MODULE$, DateType$.MODULE$, InetType$.MODULE$, TimeType$.MODULE$, TimestampType$.MODULE$, TimeUUIDType$.MODULE$}));
    }
}

