/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra;

import com.datastax.oss.driver.api.core.AsyncPagingIterable;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.GettableByIndex;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.spark.connector.cql.CassandraConnector;
import com.datastax.spark.connector.cql.CassandraConnector$;
import com.datastax.spark.connector.cql.TableDef;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.format.DateTimeFormatter;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.cassandra.AnalyzedPredicates;
import org.apache.spark.sql.cassandra.Auto;
import org.apache.spark.sql.cassandra.CassandraPredicateRules;
import org.apache.spark.sql.cassandra.DseSearchOptimizationSetting;
import org.apache.spark.sql.cassandra.Off$;
import org.apache.spark.sql.cassandra.On$;
import org.apache.spark.sql.cassandra.SolrConstants$;
import org.apache.spark.sql.cassandra.SolrPredicateRules$SolrFilter$;
import org.apache.spark.sql.sources.And;
import org.apache.spark.sql.sources.EqualNullSafe;
import org.apache.spark.sql.sources.EqualTo;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.GreaterThanOrEqual;
import org.apache.spark.sql.sources.In;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.IsNull;
import org.apache.spark.sql.sources.LessThan;
import org.apache.spark.sql.sources.LessThanOrEqual;
import org.apache.spark.sql.sources.Not;
import org.apache.spark.sql.sources.Or;
import org.apache.spark.sql.sources.StringContains;
import org.apache.spark.sql.sources.StringEndsWith;
import org.apache.spark.sql.sources.StringStartsWith;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.xml.Elem;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\t]d\u0001\u0002\u00180\u0001iB\u0001B\u0015\u0001\u0003\u0002\u0003\u0006Ia\u0015\u0005\u0006-\u0002!\ta\u0016\u0005\u00075\u0002!\taL.\t\ri\u0003A\u0011IA\u0003\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001fAq!!\u0006\u0001\t\u0003\t9\u0002C\u0004\u0002\"\u0001!\t!a\t\u0007\r\u0005e\u0002\u0001QA\u001e\u0011)\tI\u0005\u0003BK\u0002\u0013\u0005\u00111\n\u0005\n\u0003\u001bB!\u0011#Q\u0001\n}D!\"a\u0014\t\u0005+\u0007I\u0011AA)\u0011)\tI\u0006\u0003B\tB\u0003%\u00111\u000b\u0005\u0007-\"!\t!a\u0017\t\u0013\u0005\u0015\u0004\"!A\u0005\u0002\u0005\u001d\u0004\"CA7\u0011E\u0005I\u0011AA8\u0011%\t)\tCI\u0001\n\u0003\t9\tC\u0005\u0002\f\"\t\t\u0011\"\u0011\u0002\u000e\"I\u0011Q\u0014\u0005\u0002\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003OC\u0011\u0011!C\u0001\u0003SC\u0011\"!.\t\u0003\u0003%\t%a.\t\u0013\u0005\u0015\u0007\"!A\u0005\u0002\u0005\u001d\u0007\"CAf\u0011\u0005\u0005I\u0011IAg\u0011%\ty\rCA\u0001\n\u0003\n\t\u000eC\u0005\u0002T\"\t\t\u0011\"\u0011\u0002V\u001eI\u0011\u0011\u001c\u0001\u0002\u0002#\u0005\u00111\u001c\u0004\n\u0003s\u0001\u0011\u0011!E\u0001\u0003;DaA\u0016\u000e\u0005\u0002\u0005-\b\"CAh5\u0005\u0005IQIAi\u0011!Q&$!A\u0005\u0002\u00065\b\"CAz5\u0005\u0005I\u0011QA{\u0011\u001d\u00119\u0001\u0001C\u0001\u0005\u0013AqAa\u0004\u0001\t\u0003\u0011\t\u0002C\u0004\u0003\u0016\u0001!\tAa\u0006\t\u000f\t\u0015\u0002\u0001\"\u0001\u0003(!9!\u0011\b\u0001\u0005\u0002\tm\u0002\"\u0003B%\u0001\t\u0007I\u0011\u0002B&\u0011!\u0011y\u0005\u0001Q\u0001\n\t5\u0003\"\u0003B)\u0001\t\u0007I\u0011\u0002B&\u0011!\u0011\u0019\u0006\u0001Q\u0001\n\t5\u0003\"\u0003B+\u0001\t\u0007I\u0011\u0002B&\u0011!\u00119\u0006\u0001Q\u0001\n\t5\u0003\"\u0003B-\u0001\t\u0007I\u0011\u0002B.\u0011!\u0011Y\u0007\u0001Q\u0001\n\tu\u0003b\u0002B7\u0001\u0011%\u0011\u0011\u000b\u0005\b\u0005_\u0002A\u0011\u0001B9\u0005I\u0019v\u000e\u001c:Qe\u0016$\u0017nY1uKJ+H.Z:\u000b\u0005A\n\u0014!C2bgN\fg\u000e\u001a:b\u0015\t\u00114'A\u0002tc2T!\u0001N\u001b\u0002\u000bM\u0004\u0018M]6\u000b\u0005Y:\u0014AB1qC\u000eDWMC\u00019\u0003\ry'oZ\u0002\u0001'\u0011\u00011(Q#\u0011\u0005qzT\"A\u001f\u000b\u0003y\nQa]2bY\u0006L!\u0001Q\u001f\u0003\r\u0005s\u0017PU3g!\t\u00115)D\u00010\u0013\t!uFA\fDCN\u001c\u0018M\u001c3sCB\u0013X\rZ5dCR,'+\u001e7fgB\u0011a\tU\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005kRLGN\u0003\u0002K\u0017\u0006I1m\u001c8oK\u000e$xN\u001d\u0006\u0003i1S!!\u0014(\u0002\u0011\u0011\fG/Y:uCbT\u0011aT\u0001\u0004G>l\u0017BA)H\u0005\u001daunZ4j]\u001e\f\u0011d]3be\u000eDw\n\u001d;j[&T\u0018\r^5p]\u0016s\u0017M\u00197fIB\u0011!\tV\u0005\u0003+>\u0012A\u0004R:f'\u0016\f'o\u00195PaRLW.\u001b>bi&|gnU3ui&tw-\u0001\u0004=S:LGO\u0010\u000b\u00031f\u0003\"A\u0011\u0001\t\u000bI\u0013\u0001\u0019A*\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000bq{\u0016-[8\u0011\u0005\tk\u0016B\u000100\u0005I\te.\u00197zu\u0016$\u0007K]3eS\u000e\fG/Z:\t\u000b\u0001\u001c\u0001\u0019\u0001/\u0002\u0015A\u0014X\rZ5dCR,7\u000fC\u0003c\u0007\u0001\u00071-\u0001\u0005uC\ndW\rR3g!\t!w-D\u0001f\u0015\t1\u0017*A\u0002dc2L!\u0001[3\u0003\u0011Q\u000b'\r\\3EK\u001aDQA[\u0002A\u0002-\f\u0011b\u001d9be.\u001cuN\u001c4\u0011\u00051lW\"A\u001a\n\u00059\u001c$!C*qCJ\\7i\u001c8g\u0011\u0015\u00018\u00011\u0001r\u0003U9W\r^*pYJLe\u000eZ3yK\u0012\u001cu\u000e\\;n]N\u0004R\u0001\u0010:dWRL!a]\u001f\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004cA;}\u007f:\u0011aO\u001f\t\u0003ovj\u0011\u0001\u001f\u0006\u0003sf\na\u0001\u0010:p_Rt\u0014BA>>\u0003\u0019\u0001&/\u001a3fM&\u0011QP \u0002\u0004'\u0016$(BA>>!\r)\u0018\u0011A\u0005\u0004\u0003\u0007q(AB*ue&tw\rF\u0004]\u0003\u000f\tI!a\u0003\t\u000b\u0001$\u0001\u0019\u0001/\t\u000b\t$\u0001\u0019A2\t\u000b)$\u0001\u0019A6\u0002A\u001d,GoU8me&sG-\u001a=fI\u000e{G.^7og\u001a\u0013x.\\*pYJDV\n\u0014\u000b\u0006i\u0006E\u00111\u0003\u0005\u0006E\u0016\u0001\ra\u0019\u0005\u0006U\u0016\u0001\ra[\u0001\u0019C2\u0014X-\u00193z\u0007>tG/Y5ogN{GN])vKJLH\u0003BA\r\u0003?\u00012\u0001PA\u000e\u0013\r\ti\"\u0010\u0002\b\u0005>|G.Z1o\u0011\u0015\u0001g\u00011\u0001]\u0003MI7oQ8om\u0016\u0014H/\u001b2mKR{7k\u001c7s)\u0019\tI\"!\n\u00026!9\u0011qE\u0004A\u0002\u0005%\u0012A\u00024jYR,'\u000f\u0005\u0003\u0002,\u0005ERBAA\u0017\u0015\r\ty#M\u0001\bg>,(oY3t\u0013\u0011\t\u0019$!\f\u0003\r\u0019KG\u000e^3s\u0011\u0019\t9d\u0002a\u0001i\u0006Y\u0011N\u001c3fq\u0016$7i\u001c7t\u0005)\u0019v\u000e\u001c:GS2$XM]\n\u0007\u0011m\ni$a\u0011\u0011\u0007q\ny$C\u0002\u0002Bu\u0012q\u0001\u0015:pIV\u001cG\u000fE\u0002=\u0003\u000bJ1!a\u0012>\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003%\u0019x\u000e\u001c:Rk\u0016\u0014\u00180F\u0001\u0000\u0003)\u0019x\u000e\u001c:Rk\u0016\u0014\u0018\u0010I\u0001\u000be\u00164WM]3oG\u0016\u001cXCAA*!\u0011a\u0014QK@\n\u0007\u0005]SHA\u0003BeJ\f\u00170A\u0006sK\u001a,'/\u001a8dKN\u0004CCBA/\u0003C\n\u0019\u0007E\u0002\u0002`!i\u0011\u0001\u0001\u0005\u0007\u0003\u0013j\u0001\u0019A@\t\u000f\u0005=S\u00021\u0001\u0002T\u0005!1m\u001c9z)\u0019\ti&!\u001b\u0002l!A\u0011\u0011\n\b\u0011\u0002\u0003\u0007q\u0010C\u0005\u0002P9\u0001\n\u00111\u0001\u0002T\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA9U\ry\u00181O\u0016\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(A\u0005v]\u000eDWmY6fI*\u0019\u0011qP\u001f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u0004\u0006e$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAEU\u0011\t\u0019&a\u001d\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ty\t\u0005\u0003\u0002\u0012\u0006mUBAAJ\u0015\u0011\t)*a&\u0002\t1\fgn\u001a\u0006\u0003\u00033\u000bAA[1wC&!\u00111AAJ\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t\t\u000bE\u0002=\u0003GK1!!*>\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY+!-\u0011\u0007q\ni+C\u0002\u00020v\u00121!\u00118z\u0011%\t\u0019lEA\u0001\u0002\u0004\t\t+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003s\u0003b!a/\u0002B\u0006-VBAA_\u0015\r\ty,P\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAb\u0003{\u0013\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011DAe\u0011%\t\u0019,FA\u0001\u0002\u0004\tY+\u0001\u0005iCND7i\u001c3f)\t\t\t+\u0001\u0005u_N#(/\u001b8h)\t\ty)\u0001\u0004fcV\fGn\u001d\u000b\u0005\u00033\t9\u000eC\u0005\u00024b\t\t\u00111\u0001\u0002,\u0006Q1k\u001c7s\r&dG/\u001a:\u0011\u0007\u0005}#dE\u0003\u001b\u0003?\f\u0019\u0005E\u0005\u0002b\u0006\u001dx0a\u0015\u0002^5\u0011\u00111\u001d\u0006\u0004\u0003Kl\u0014a\u0002:v]RLW.Z\u0005\u0005\u0003S\f\u0019OA\tBEN$(/Y2u\rVt7\r^5p]J\"\"!a7\u0015\r\u0005u\u0013q^Ay\u0011\u0019\tI%\ba\u0001\u007f\"9\u0011qJ\u000fA\u0002\u0005M\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003o\u0014\u0019\u0001E\u0003=\u0003s\fi0C\u0002\u0002|v\u0012aa\u00149uS>t\u0007C\u0002\u001f\u0002\u0000~\f\u0019&C\u0002\u0003\u0002u\u0012a\u0001V;qY\u0016\u0014\u0004\"\u0003B\u0003=\u0005\u0005\t\u0019AA/\u0003\rAH\u0005M\u0001\ri>\u001cv\u000e\u001c:TiJLgn\u001a\u000b\u0004\u007f\n-\u0001b\u0002B\u0007?\u0001\u0007\u00111V\u0001\u0006m\u0006dW/Z\u0001\u0014G>tg/\u001a:u)>\u001cv\u000e\u001c:GS2$XM\u001d\u000b\u0005\u0003;\u0012\u0019\u0002C\u0004\u0002(\u0001\u0002\r!!\u000b\u00025\u001d,G\u000fU1si&$\u0018n\u001c8LKf\u0014Vm\u001d;sS\u000e$\u0018n\u001c8\u0015\r\te!\u0011\u0005B\u0012!\u0011)HPa\u0007\u0011\t\u0005-\"QD\u0005\u0005\u0005?\tiCA\u0004FcV\fG\u000eV8\t\u000b\u0001\f\u0003\u0019\u0001/\t\u000b\t\f\u0003\u0019A2\u0002+\u0019Lg\u000eZ+tK2,7o]%t\u001d>$h*\u001e7mgR1!\u0011\u0006B\u0019\u0005o\u0001B!\u001e?\u0003,A!\u00111\u0006B\u0017\u0013\u0011\u0011y#!\f\u0003\u0013%\u001bhj\u001c;Ok2d\u0007b\u0002B\u001aE\u0001\u0007!QG\u0001\bM&dG/\u001a:t!\u0011)H0!\u000b\t\u000b\t\u0014\u0003\u0019A2\u0002%\r|gN^3siR{7k\u001c7s#V,'/\u001f\u000b\f9\nu\"q\bB!\u0005\u000b\u00129\u0005C\u0003aG\u0001\u0007A\fC\u0003cG\u0001\u00071\r\u0003\u0004\u0003D\r\u0002\r\u0001^\u0001\u0012g>d'/\u00138eKb,GMR5fY\u0012\u001c\b\"\u0002*$\u0001\u0004\u0019\u0006\"\u00026$\u0001\u0004Y\u0017aE3tG\u0006\u0004\u0018M\u00197f/>\u0014H\rV8lK:\u001cXC\u0001B'!\u0015a\u0014QKAH\u0003Q)7oY1qC\ndWmV8sIR{7.\u001a8tA\u0005qQm]2ba\u0006\u0014G.Z\"iCJ\u001c\u0018aD3tG\u0006\u0004\u0018M\u00197f\u0007\"\f'o\u001d\u0011\u0002)\u0015\u001c8-\u00199bE2,w\u000b[5uKN\u0004\u0018mY3t\u0003U)7oY1qC\ndWm\u00165ji\u0016\u001c\b/Y2fg\u0002\n!\"Z:dCB\f'\r\\3t+\t\u0011i\u0006\u0005\u0003\u0003`\t\u001dTB\u0001B1\u0015\u0011\u0011\u0019G!\u001a\u0002\u000bI,w-\u001a=\u000b\u0007!\u000b9*\u0003\u0003\u0003j\t\u0005$a\u0002)biR,'O\\\u0001\fKN\u001c\u0017\r]1cY\u0016\u001c\b%A\tfg\u000e\f\u0007/\u00192mK\u0016sG/\u001b;jKN\f1#Z:dCB,7k\u001c7s\u0007>tG-\u001b;j_:$2a B:\u0011\u0019\u0011)(\fa\u0001\u007f\u0006I1m\u001c8eSRLwN\u001c")
public class SolrPredicateRules
implements CassandraPredicateRules,
Logging {
    private volatile SolrPredicateRules$SolrFilter$ SolrFilter$module;
    private final DseSearchOptimizationSetting searchOptimizationEnabled;
    private final String[] escapableWordTokens;
    private final String[] escapableChars;
    private final String[] escapableWhitespaces;
    private final Pattern escapables;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public SolrPredicateRules$SolrFilter$ SolrFilter() {
        if (this.SolrFilter$module == null) {
            this.SolrFilter$lzycompute$1();
        }
        return this.SolrFilter$module;
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef, SparkConf sparkConf, Function2<TableDef, SparkConf, scala.collection.immutable.Set<String>> getSolrIndexedColumns) {
        AnalyzedPredicates analyzedPredicates;
        scala.collection.immutable.Set<IsNotNull> uselessIsNotNulls = this.findUselessIsNotNulls((scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark())), tableDef);
        AnalyzedPredicates usefulPredicates = new AnalyzedPredicates(predicates.handledByCassandra(), (scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)predicates.handledBySpark().$minus$minus(uselessIsNotNulls)));
        scala.collection.immutable.Set<EqualTo> pkRestriction = this.getPartitionKeyRestriction(usefulPredicates, tableDef);
        boolean primaryKeyRestrictionExists = pkRestriction.nonEmpty() && pkRestriction.subsetOf(usefulPredicates.handledByCassandra()) && usefulPredicates.handledBySpark().isEmpty();
        boolean solrEnabledOnTargetHosts = BoxesRunTime.unboxToBoolean(CassandraConnector$.MODULE$.apply(sparkConf).withSessionDo((Function1 & Serializable & scala.Serializable)session -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$1(session))));
        Option failedRequirement = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToBoolean((!solrEnabledOnTargetHosts ? 1 : 0) != 0), (Object)"Search is not enabled on DSE Target nodes."), new Tuple2((Object)BoxesRunTime.boxToBoolean((!this.searchOptimizationEnabled.enabled() ? 1 : 0) != 0), (Object)"Automatic Search optimizations for Spark SQL are disabled."), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)primaryKeyRestrictionExists), (Object)"There is a primary key restriction present"), new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)this.alreadyContainsSolrQuery(usefulPredicates)), (Object)"Manual Solr query (solr_query = xxx) present.")}))).collectFirst((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Object, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    boolean bl = A1._1$mcZ$sp();
                    String reason = (String)A1._2();
                    if (bl) {
                        object = reason;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Object, String> x1) {
                boolean bl;
                Tuple2<Object, String> tuple2 = x1;
                boolean bl2 = tuple2 != null && (bl = tuple2._1$mcZ$sp());
                return bl2;
            }
        });
        Option option = failedRequirement;
        if (option instanceof Some) {
            Some some = (Some)option;
            String reasonForFailure = (String)some.value();
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("Not using Solr Optimizations. ").append(reasonForFailure).toString());
            analyzedPredicates = usefulPredicates;
        } else if (None$.MODULE$.equals(option)) {
            analyzedPredicates = this.convertToSolrQuery(usefulPredicates, tableDef, (scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)getSolrIndexedColumns.apply((Object)tableDef, (Object)sparkConf)), this.searchOptimizationEnabled, sparkConf);
        } else {
            throw new MatchError((Object)option);
        }
        return analyzedPredicates;
    }

    @Override
    public AnalyzedPredicates apply(AnalyzedPredicates predicates, TableDef tableDef2, SparkConf sparkConf2) {
        return this.apply(predicates, tableDef2, sparkConf2, (Function2<TableDef, SparkConf, scala.collection.immutable.Set<String>>)(Function2 & Serializable & scala.Serializable)(tableDef, sparkConf) -> this.getSolrIndexedColumnsFromSolrXML((TableDef)tableDef, (SparkConf)sparkConf));
    }

    public scala.collection.immutable.Set<String> getSolrIndexedColumnsFromSolrXML(TableDef tableDef, SparkConf sparkConf) {
        scala.collection.immutable.Set set;
        Success success;
        String schema;
        String SelectSolrSchema = new StringOps(Predef$.MODULE$.augmentString(new java.lang.StringBuilder(154).append("SELECT blobAsText(resource_value) FROM\n         |solr_admin.solr_resources\n         |where core_name = '").append(tableDef.keyspaceName()).append(".").append(tableDef.tableName()).append("'\n         |and resource_name = 'schema.xml.bak' ").toString())).stripMargin();
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ((GettableByIndex)((PagingIterable)CassandraConnector$.MODULE$.apply(sparkConf).withSessionDo((Function1 & Serializable & scala.Serializable)x$2 -> x$2.execute(SelectSolrSchema))).one()).getString(0));
        if (try_ instanceof Success && (schema = (String)(success = (Success)try_).value()) != null) {
            scala.collection.immutable.Set set2;
            String string = schema;
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Elem schemaXML = (Elem)XML$.MODULE$.loadString(string);
                return ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)((scala.xml.Node)((IterableLike)schemaXML.child().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$5(x$3)))).head()).child().filter((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$6(x)))).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$7(x$4)))).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getSolrIndexedColumnsFromSolrXML$9(x$5)))).map((Function1 & Serializable & scala.Serializable)x$6 -> ((SeqLike)x$6.attribute("name").get()).toString(), Seq$.MODULE$.canBuildFrom())).toSet();
            });
            if (try_2 instanceof Success) {
                scala.collection.immutable.Set indexed;
                Success success2 = (Success)try_2;
                set2 = indexed = (scala.collection.immutable.Set)success2.value();
            } else if (try_2 instanceof Failure) {
                Failure failure = (Failure)try_2;
                Throwable e = failure.exception();
                set2 = this.solrIndexedFail$1(new java.lang.StringBuilder(32).append("Unable to parse schema.xml.bak: ").append(e).toString());
            } else {
                throw new MatchError((Object)try_2);
            }
            set = set2;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            set = this.solrIndexedFail$1(new java.lang.StringBuilder(28).append("Unable to access Solr Info: ").append(e).toString());
        } else {
            throw new MatchError((Object)try_);
        }
        return set;
    }

    public boolean alreadyContainsSolrQuery(AnalyzedPredicates predicates) {
        return ((TraversableOnce)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark()).collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    String column = equalTo.attribute();
                    Object value = equalTo.value();
                    String string = column;
                    String string2 = SolrConstants$.MODULE$.SolrQuery();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        object = new EqualTo(column, value);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Filter x1) {
                String column;
                Filter filter = x1;
                if (!(filter instanceof EqualTo)) return false;
                EqualTo equalTo = (EqualTo)filter;
                String string = column = equalTo.attribute();
                String string2 = SolrConstants$.MODULE$.SolrQuery();
                if (string != null) {
                    if (!string.equals(string2)) return false;
                    return true;
                }
                if (string2 == null) return true;
                return false;
            }
        }, Set$.MODULE$.canBuildFrom())).nonEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isConvertibleToSolr(Filter filter, scala.collection.immutable.Set<String> indexedCols) {
        Not not;
        Filter child;
        IsNotNull isNotNull;
        String attr;
        IsNull isNull;
        String attr2;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr3 = equalTo.attribute();
            Object value = equalTo.value();
            if (attr3 != null) {
                String string = attr3;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attr4 = equalNullSafe.attribute();
            Object value = equalNullSafe.value();
            if (attr4 != null) {
                String string = attr4;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attr5 = in.attribute();
            Object[] values = in.values();
            if (attr5 != null) {
                String string = attr5;
                if (values != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr6 = greaterThan.attribute();
            Object value = greaterThan.value();
            if (attr6 != null) {
                String string = attr6;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr7 = greaterThanOrEqual.attribute();
            Object value = greaterThanOrEqual.value();
            if (attr7 != null) {
                String string = attr7;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr8 = lessThan.attribute();
            Object value = lessThan.value();
            if (attr8 != null) {
                String string = attr8;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr9 = lessThanOrEqual.attribute();
            Object value = lessThanOrEqual.value();
            if (attr9 != null) {
                String string = attr9;
                if (value instanceof Object) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof IsNull && (attr2 = (isNull = (IsNull)filter2).attribute()) != null) {
            String string = attr2;
            return indexedCols.contains((Object)string);
        }
        if (filter2 instanceof IsNotNull && (attr = (isNotNull = (IsNotNull)filter2).attribute()) != null) {
            String string = attr;
            return indexedCols.contains((Object)string);
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            if (left != null) {
                Filter filter3 = left;
                if (right != null) {
                    Filter filter4 = right;
                    if (!this.isConvertibleToSolr(filter3, indexedCols)) return false;
                    if (!this.isConvertibleToSolr(filter4, indexedCols)) return false;
                    return true;
                }
            }
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            if (left != null) {
                Filter filter5 = left;
                if (right != null) {
                    Filter filter6 = right;
                    if (!this.isConvertibleToSolr(filter5, indexedCols)) return false;
                    if (!this.isConvertibleToSolr(filter6, indexedCols)) return false;
                    return true;
                }
            }
        }
        if (filter2 instanceof Not && (child = (not = (Not)filter2).child()) != null) {
            Filter filter7 = child;
            return this.isConvertibleToSolr(filter7, indexedCols);
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr10 = stringStartsWith.attribute();
            String value = stringStartsWith.value();
            if (attr10 != null) {
                String string = attr10;
                if (value != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attr11 = stringEndsWith.attribute();
            String value = stringEndsWith.value();
            if (attr11 != null) {
                String string = attr11;
                if (value != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        if (filter2 instanceof StringContains) {
            StringContains stringContains = (StringContains)filter2;
            String attr12 = stringContains.attribute();
            String value = stringContains.value();
            if (attr12 != null) {
                String string = attr12;
                if (value != null) {
                    return indexedCols.contains((Object)string);
                }
            }
        }
        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Unknown Filter Type ").append(filter2).toString());
        return false;
    }

    public String toSolrString(Object value) {
        String string;
        Object object = value;
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            string = DateTimeFormatter.ISO_INSTANT.format(timestamp.toInstant());
        } else {
            string = object.toString();
        }
        return StringEscapeUtils.escapeJson((String)this.escapeSolrCondition(string));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SolrFilter convertToSolrFilter(Filter filter) {
        Not not;
        Filter child;
        IsNotNull isNotNull;
        String attr;
        IsNull isNull;
        String attr2;
        Filter filter2 = filter;
        if (filter2 instanceof EqualTo) {
            EqualTo equalTo = (EqualTo)filter2;
            String attr3 = equalTo.attribute();
            Object value2 = equalTo.value();
            if (attr3 != null) {
                String string = attr3;
                if (value2 instanceof Object) {
                    Object object = value2;
                    return new SolrFilter(this, new java.lang.StringBuilder(1).append(this.toSolrString(string)).append(":").append(this.toSolrString(object)).toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof EqualNullSafe) {
            EqualNullSafe equalNullSafe = (EqualNullSafe)filter2;
            String attr4 = equalNullSafe.attribute();
            Object value3 = equalNullSafe.value();
            if (attr4 != null) {
                String string = attr4;
                if (value3 instanceof Object) {
                    Object object = value3;
                    return new SolrFilter(this, new java.lang.StringBuilder(1).append(this.toSolrString(string)).append(":").append(this.toSolrString(object)).toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof In) {
            In in = (In)filter2;
            String attr5 = in.attribute();
            Object[] values = in.values();
            if (attr5 != null) {
                String string = attr5;
                if (values != null) {
                    Object[] objectArray = values;
                    return new SolrFilter(this, new java.lang.StringBuilder(3).append(this.toSolrString(string)).append(":(").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps((Object)objectArray).map((Function1 & Serializable & scala.Serializable)value -> this.toSolrString(value), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(" ")).append(")").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof GreaterThan) {
            GreaterThan greaterThan = (GreaterThan)filter2;
            String attr6 = greaterThan.attribute();
            Object value4 = greaterThan.value();
            if (attr6 != null) {
                String string = attr6;
                if (value4 instanceof Object) {
                    Object object = value4;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrString(string)).append(":{").append(this.toSolrString(object)).append(" TO *]").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof GreaterThanOrEqual) {
            GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)filter2;
            String attr7 = greaterThanOrEqual.attribute();
            Object value5 = greaterThanOrEqual.value();
            if (attr7 != null) {
                String string = attr7;
                if (value5 instanceof Object) {
                    Object object = value5;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrString(string)).append(":[").append(this.toSolrString(object)).append(" TO *]").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof LessThan) {
            LessThan lessThan = (LessThan)filter2;
            String attr8 = lessThan.attribute();
            Object value6 = lessThan.value();
            if (attr8 != null) {
                String string = attr8;
                if (value6 instanceof Object) {
                    Object object = value6;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrString(string)).append(":[* TO ").append(this.toSolrString(object)).append("}").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof LessThanOrEqual) {
            LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)filter2;
            String attr9 = lessThanOrEqual.attribute();
            Object value7 = lessThanOrEqual.value();
            if (attr9 != null) {
                String string = attr9;
                if (value7 instanceof Object) {
                    Object object = value7;
                    return new SolrFilter(this, new java.lang.StringBuilder(8).append(this.toSolrString(string)).append(":[* TO ").append(this.toSolrString(object)).append("]").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof IsNull && (attr2 = (isNull = (IsNull)filter2).attribute()) != null) {
            String string = attr2;
            return new SolrFilter(this, new java.lang.StringBuilder(10).append("-").append(this.toSolrString(string)).append(":[* TO *]").toString(), filter.references());
        }
        if (filter2 instanceof IsNotNull && (attr = (isNotNull = (IsNotNull)filter2).attribute()) != null) {
            String string = attr;
            return new SolrFilter(this, new java.lang.StringBuilder(2).append(this.toSolrString(string)).append(":*").toString(), filter.references());
        }
        if (filter2 instanceof And) {
            And and = (And)filter2;
            Filter left = and.left();
            Filter right = and.right();
            if (left != null) {
                Filter filter3 = left;
                if (right != null) {
                    Filter filter4 = right;
                    return new SolrFilter(this, new java.lang.StringBuilder(7).append("(").append(this.convertToSolrFilter(filter3).solrQuery()).append(" AND ").append(this.convertToSolrFilter(filter4).solrQuery()).append(")").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof Or) {
            Or or = (Or)filter2;
            Filter left = or.left();
            Filter right = or.right();
            if (left != null) {
                Filter filter5 = left;
                if (right != null) {
                    Filter filter6 = right;
                    return new SolrFilter(this, new java.lang.StringBuilder(6).append("(").append(this.convertToSolrFilter(filter5).solrQuery()).append(" OR ").append(this.convertToSolrFilter(filter6).solrQuery()).append(")").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof Not && (child = (not = (Not)filter2).child()) != null) {
            Filter filter7 = child;
            return new SolrFilter(this, new java.lang.StringBuilder(3).append("-(").append(this.convertToSolrFilter(filter7).solrQuery()).append(")").toString(), filter.references());
        }
        if (filter2 instanceof StringStartsWith) {
            StringStartsWith stringStartsWith = (StringStartsWith)filter2;
            String attr10 = stringStartsWith.attribute();
            String value8 = stringStartsWith.value();
            if (attr10 != null) {
                String string = attr10;
                if (value8 != null) {
                    String string2 = value8;
                    return new SolrFilter(this, new java.lang.StringBuilder(2).append(this.toSolrString(string)).append(":").append(this.toSolrString(string2)).append("*").toString(), filter.references());
                }
            }
        }
        if (filter2 instanceof StringEndsWith) {
            StringEndsWith stringEndsWith = (StringEndsWith)filter2;
            String attr11 = stringEndsWith.attribute();
            String value9 = stringEndsWith.value();
            if (attr11 != null) {
                String string = attr11;
                if (value9 != null) {
                    String string3 = value9;
                    return new SolrFilter(this, new java.lang.StringBuilder(2).append(this.toSolrString(string)).append(":*").append(this.toSolrString(string3)).toString(), filter.references());
                }
            }
        }
        if (!(filter2 instanceof StringContains)) throw new IllegalArgumentException(new java.lang.StringBuilder(20).append(filter2).append(" cannot be converted").toString());
        StringContains stringContains = (StringContains)filter2;
        String attr12 = stringContains.attribute();
        String value10 = stringContains.value();
        if (attr12 == null) throw new IllegalArgumentException(new java.lang.StringBuilder(20).append(filter2).append(" cannot be converted").toString());
        String string = attr12;
        if (value10 == null) throw new IllegalArgumentException(new java.lang.StringBuilder(20).append(filter2).append(" cannot be converted").toString());
        String string4 = value10;
        return new SolrFilter(this, new java.lang.StringBuilder(3).append(this.toSolrString(string)).append(":*").append(this.toSolrString(string4)).append("*").toString(), filter.references());
    }

    public scala.collection.immutable.Set<EqualTo> getPartitionKeyRestriction(AnalyzedPredicates predicates, TableDef tableDef) {
        scala.collection.immutable.Set partitionKeyRestrictions;
        scala.collection.immutable.Set equalsRestrictions = (scala.collection.immutable.Set)predicates.handledByCassandra().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                EqualTo equalTo;
                A1 A1 = x1;
                Object object = A1 instanceof EqualTo ? (equalTo = (EqualTo)A1) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x1) {
                Filter filter = x1;
                boolean bl = filter instanceof EqualTo;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
        Map equalsRestrictionsByName = ((TraversableOnce)equalsRestrictions.map((Function1 & Serializable & scala.Serializable)eqClause -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)eqClause.attribute()), eqClause), Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Set partitionKeyColumnNames = ((TraversableOnce)tableDef.partitionKey().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.columnName(), Seq$.MODULE$.canBuildFrom())).toSet();
        boolean partitionKeyFullyRestricted = ((SetLike)partitionKeyColumnNames.$minus$minus((GenTraversableOnce)(partitionKeyRestrictions = (scala.collection.immutable.Set)equalsRestrictions.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$getPartitionKeyRestriction$3(partitionKeyColumnNames, x0$1)))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.attribute(), Set$.MODULE$.canBuildFrom()))).isEmpty();
        return partitionKeyFullyRestricted ? partitionKeyRestrictions : Predef$.MODULE$.Set().empty();
    }

    public scala.collection.immutable.Set<IsNotNull> findUselessIsNotNulls(scala.collection.immutable.Set<Filter> filters, TableDef tableDef) {
        IndexedSeq primaryKeyColumnNames = (IndexedSeq)tableDef.primaryKey().map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.columnName(), IndexedSeq$.MODULE$.canBuildFrom());
        Map isNotNullColumns = ((TraversableOnce)filters.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof IsNotNull) {
                    IsNotNull isNotNull = (IsNotNull)A1;
                    String attr = isNotNull.attribute();
                    object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)new IsNotNull(attr));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x1) {
                Filter filter = x1;
                boolean bl = filter instanceof IsNotNull;
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        scala.collection.immutable.Set restrictedColumns = (scala.collection.immutable.Set)filters.collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Filter, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof LessThan) {
                    LessThan lessThan = (LessThan)A1;
                    String attr = lessThan.attribute();
                    object = attr;
                } else if (A1 instanceof LessThanOrEqual) {
                    LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)A1;
                    String attr = lessThanOrEqual.attribute();
                    object = attr;
                } else if (A1 instanceof GreaterThan) {
                    GreaterThan greaterThan = (GreaterThan)A1;
                    String attr = greaterThan.attribute();
                    object = attr;
                } else if (A1 instanceof GreaterThanOrEqual) {
                    GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)A1;
                    String attr = greaterThanOrEqual.attribute();
                    object = attr;
                } else if (A1 instanceof EqualNullSafe) {
                    EqualNullSafe equalNullSafe = (EqualNullSafe)A1;
                    String attr = equalNullSafe.attribute();
                    object = attr;
                } else if (A1 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)A1;
                    String attr = equalTo.attribute();
                    object = attr;
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Filter x2) {
                Filter filter = x2;
                boolean bl = filter instanceof LessThan ? true : (filter instanceof LessThanOrEqual ? true : (filter instanceof GreaterThan ? true : (filter instanceof GreaterThanOrEqual ? true : (filter instanceof EqualNullSafe ? true : filter instanceof EqualTo))));
                return bl;
            }
        }, Set$.MODULE$.canBuildFrom());
        scala.collection.immutable.Set uselessIsNotNulls = ((TraversableOnce)((TraversableLike)primaryKeyColumnNames.$plus$plus((GenTraversableOnce)restrictedColumns, IndexedSeq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)attr -> Option$.MODULE$.option2Iterable(isNotNullColumns.get(attr)), IndexedSeq$.MODULE$.canBuildFrom())).toSet();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(45).append("Found isNotNulls ").append(uselessIsNotNulls).append(" that are already not needed").toString());
        return uselessIsNotNulls;
    }

    public AnalyzedPredicates convertToSolrQuery(AnalyzedPredicates predicates, TableDef tableDef, scala.collection.immutable.Set<String> solrIndexedFields, DseSearchOptimizationSetting searchOptimizationEnabled, SparkConf sparkConf) {
        AnalyzedPredicates analyzedPredicates;
        scala.collection.immutable.Set possibleSolrPredicates;
        Tuple2 tuple2;
        scala.collection.immutable.Set allPredicates = (scala.collection.immutable.Set)predicates.handledByCassandra().$plus$plus(predicates.handledBySpark());
        scala.collection.immutable.Set<EqualTo> pkRestriction = this.getPartitionKeyRestriction(predicates, tableDef);
        if (pkRestriction.nonEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(60).append("Partition restriction being withheld from Solr Conversion:  ").append(pkRestriction).toString());
        }
        if ((tuple2 = (possibleSolrPredicates = (scala.collection.immutable.Set)allPredicates.$minus$minus(pkRestriction)).partition((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)this.isConvertibleToSolr(x$10, (scala.collection.immutable.Set<String>)solrIndexedFields)))) == null) {
            throw new MatchError((Object)tuple2);
        }
        scala.collection.immutable.Set solrConvertibleFilters = (scala.collection.immutable.Set)tuple2._1();
        scala.collection.immutable.Set sparkFilters = (scala.collection.immutable.Set)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)solrConvertibleFilters, (Object)sparkFilters);
        Tuple2 tuple23 = tuple22;
        scala.collection.immutable.Set solrConvertibleFilters2 = (scala.collection.immutable.Set)tuple23._1();
        scala.collection.immutable.Set sparkFilters2 = (scala.collection.immutable.Set)tuple23._2();
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(30).append("Converting ").append(solrConvertibleFilters2).append(" to Solr Predicates").toString());
        scala.collection.immutable.Set solrFilters = (scala.collection.immutable.Set)solrConvertibleFilters2.map((Function1 & Serializable & scala.Serializable)filter -> this.convertToSolrFilter((Filter)filter), Set$.MODULE$.canBuildFrom());
        String combinedFilterQuery = ((TraversableOnce)solrFilters.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SolrFilter solrFilter = x0$1;
            if (solrFilter == null) {
                throw new MatchError((Object)solrFilter);
            }
            String query = solrFilter.solrQuery();
            String string = new java.lang.StringBuilder(2).append("\"").append(query).append("\"").toString();
            return string;
        }, Set$.MODULE$.canBuildFrom())).mkString(", ");
        String solrString = new java.lang.StringBuilder(20).append("{\"q\":\"*:*\", \"fq\":[").append(combinedFilterQuery).append("]}").toString();
        String FaultTolerant = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\"shards.failover\": false", "\"shards.tolerant\": true"}))).mkString(",");
        String solrStringNoFailoverTolerant = new java.lang.StringBuilder(22).append("{\"q\":\"*:*\", \"fq\":[").append(combinedFilterQuery).append("], ").append(FaultTolerant).append("}").toString();
        EqualTo combinedSolrFilter = new EqualTo(SolrConstants$.MODULE$.SolrQuery(), (Object)solrString);
        AnalyzedPredicates optimizedPredicates = new AnalyzedPredicates((scala.collection.immutable.Set<Filter>)((scala.collection.immutable.Set)((SetLike)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{combinedSolrFilter}))).$plus$plus(pkRestriction)), (scala.collection.immutable.Set<Filter>)sparkFilters2);
        if (solrConvertibleFilters2.isEmpty()) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No Solr Convertible Filters Found");
            analyzedPredicates = predicates;
        } else {
            AnalyzedPredicates analyzedPredicates2;
            DseSearchOptimizationSetting dseSearchOptimizationSetting = searchOptimizationEnabled;
            if (dseSearchOptimizationSetting instanceof Auto) {
                AnalyzedPredicates analyzedPredicates3;
                double queryRatio;
                Auto auto = (Auto)dseSearchOptimizationSetting;
                double ratio = auto.ratio();
                CassandraConnector conn = CassandraConnector$.MODULE$.apply(sparkConf);
                String request = new java.lang.StringBuilder(45).append("SELECT COUNT(*) from \"").append(tableDef.keyspaceName()).append("\".\"").append(tableDef.tableName()).append("\" where solr_query=?").toString();
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Checking total number of records");
                Tuple2 tuple24 = (Tuple2)conn.withSessionDo((Function1 & Serializable & scala.Serializable)session -> {
                    DriverExecutionProfile pagingDisabled = session.getContext().getConfig().getDefaultProfile().withInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE, -1);
                    SimpleStatement totalRequest = (SimpleStatement)SimpleStatement.newInstance((String)request, (Object[])new Object[]{new java.lang.StringBuilder(13).append("{\"q\":\"*:*\", ").append(FaultTolerant).append("}").toString()}).setExecutionProfile(pagingDisabled);
                    SimpleStatement queryRequest = (SimpleStatement)SimpleStatement.newInstance((String)request, (Object[])new Object[]{solrStringNoFailoverTolerant}).setExecutionProfile(pagingDisabled);
                    CompletionStage totalFuture = session.executeAsync((Statement)totalRequest);
                    CompletionStage queryFuture = session.executeAsync((Statement)queryRequest);
                    return new Tuple2.mcJJ.sp(((GettableByIndex)((AsyncPagingIterable)totalFuture.toCompletableFuture().get(5L, TimeUnit.SECONDS)).one()).getLong(0), ((GettableByIndex)((AsyncPagingIterable)queryFuture.toCompletableFuture().get(5L, TimeUnit.SECONDS)).one()).getLong(0));
                });
                if (tuple24 == null) {
                    throw new MatchError((Object)tuple24);
                }
                long totalRecords = tuple24._1$mcJ$sp();
                long queryRecords = tuple24._2$mcJ$sp();
                long l = totalRecords;
                long l2 = queryRecords;
                Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(l, l2);
                Tuple2.mcJJ.sp sp3 = sp2;
                long totalRecords2 = sp3._1$mcJ$sp();
                long queryRecords2 = sp3._2$mcJ$sp();
                double d = queryRatio = totalRecords2 == 0L ? 0.0 : (double)queryRecords2 / (double)totalRecords2;
                if (queryRatio > ratio) {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(107).append("Requesting ").append(queryRatio).append(" of the total records. Required to be less than ").append(ratio).append(" for DSE Search, falling back to Full Table Scan").toString());
                    analyzedPredicates3 = predicates;
                } else {
                    this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(80).append("Requesting ").append(queryRatio).append(" of the total records. Less than ").append(ratio).append(", using DSE Search Optimized request").toString());
                    analyzedPredicates3 = optimizedPredicates;
                }
                analyzedPredicates2 = analyzedPredicates3;
            } else if (On$.MODULE$.equals(dseSearchOptimizationSetting)) {
                this.logDebug((Function0<String>)((Function0 & Serializable & scala.Serializable)() -> SolrPredicateRules.$anonfun$convertToSolrQuery$11(solrConvertibleFilters2, (Filter)combinedSolrFilter)));
                analyzedPredicates2 = optimizedPredicates;
            } else if (Off$.MODULE$.equals(dseSearchOptimizationSetting)) {
                analyzedPredicates2 = predicates;
            } else {
                throw new MatchError((Object)dseSearchOptimizationSetting);
            }
            analyzedPredicates = analyzedPredicates2;
        }
        return analyzedPredicates;
    }

    private String[] escapableWordTokens() {
        return this.escapableWordTokens;
    }

    private String[] escapableChars() {
        return this.escapableChars;
    }

    private String[] escapableWhitespaces() {
        return this.escapableWhitespaces;
    }

    private Pattern escapables() {
        return this.escapables;
    }

    private String[] escapableEntities() {
        return (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[][]{this.escapableWordTokens(), this.escapableChars(), this.escapableWhitespaces()})).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
    }

    public String escapeSolrCondition(String condition) {
        Matcher matcher = this.escapables().matcher(condition);
        StringBuilder escaped = package$.MODULE$.StringBuilder().newBuilder();
        int firstUnprocessedCharPosition = 0;
        while (matcher.find()) {
            escaped.append(condition.substring(firstUnprocessedCharPosition, matcher.start()));
            firstUnprocessedCharPosition = matcher.end();
            escaped.append("\\");
            escaped.append(matcher.group());
        }
        escaped.append(condition.substring(firstUnprocessedCharPosition, condition.length()));
        return escaped.toString();
    }

    private final void SolrFilter$lzycompute$1() {
        SolrPredicateRules solrPredicateRules = this;
        synchronized (solrPredicateRules) {
            if (this.SolrFilter$module == null) {
                this.SolrFilter$module = new SolrPredicateRules$SolrFilter$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$apply$2(Node host) {
        NodeDistance nodeDistance = host.getDistance();
        NodeDistance nodeDistance2 = NodeDistance.IGNORED;
        return nodeDistance == null ? nodeDistance2 != null : !nodeDistance.equals(nodeDistance2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$4(Object x$1) {
        return ((Set)x$1).contains("Search");
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Node host) {
        Option workloads = Option$.MODULE$.apply(host.getExtras().get("DSE_WORKLOADS"));
        return workloads.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$4(x$1)));
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(CqlSession session) {
        Iterable hosts = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(session.getMetadata().getNodes().values()).asScala();
        Iterable possibleHosts = (Iterable)hosts.filter((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$2(host)));
        return possibleHosts.forall((Function1 & Serializable & scala.Serializable)host -> BoxesRunTime.boxToBoolean((boolean)SolrPredicateRules.$anonfun$apply$3(host)));
    }

    private final scala.collection.immutable.Set solrIndexedFail$1(String str) {
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Retrieval of Solr Index Info Failed: ").append(str).toString());
        return Predef$.MODULE$.Set().empty();
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$5(scala.xml.Node x$3) {
        String string = x$3.label();
        String string2 = "fields";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$6(scala.xml.Node x) {
        String string = x.label();
        String string2 = "field";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$7(scala.xml.Node x$4) {
        return !new StringOps(Predef$.MODULE$.augmentString((String)x$4.attributes().asAttrMap().getOrElse((Object)"multiValued", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getSolrIndexedColumnsFromSolrXML$9(scala.xml.Node x$5) {
        return new StringOps(Predef$.MODULE$.augmentString((String)x$5.attributes().asAttrMap().getOrElse((Object)"indexed", (Function0 & Serializable & scala.Serializable)() -> "false"))).toBoolean();
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionKeyRestriction$3(scala.collection.immutable.Set partitionKeyColumnNames$1, EqualTo x0$1) {
        EqualTo equalTo = x0$1;
        if (equalTo == null) {
            throw new MatchError((Object)equalTo);
        }
        String attr = equalTo.attribute();
        boolean bl = partitionKeyColumnNames$1.contains((Object)attr);
        return bl;
    }

    public static final /* synthetic */ String $anonfun$convertToSolrQuery$11(scala.collection.immutable.Set solrConvertibleFilters$1, Filter combinedSolrFilter$1) {
        return new java.lang.StringBuilder(14).append("Converted ").append(solrConvertibleFilters$1).append(" to ").append(combinedSolrFilter$1).toString();
    }

    public SolrPredicateRules(DseSearchOptimizationSetting searchOptimizationEnabled) {
        this.searchOptimizationEnabled = searchOptimizationEnabled;
        Logging.$init$((Logging)this);
        this.escapableWordTokens = (String[])((Object[])new String[]{"AND", "OR", "NOT"});
        this.escapableChars = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])"\\+-!():^[]\"{}~*?|&;/".split(""))).map((Function1 & Serializable & scala.Serializable)ch -> Pattern.quote(ch), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.escapableWhitespaces = (String[])((Object[])new String[]{"\\s"});
        this.escapables = Pattern.compile(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.escapableEntities())).mkString("|"));
    }

    public class SolrFilter
    implements Product,
    scala.Serializable {
        private final String solrQuery;
        private final String[] references;
        public final /* synthetic */ SolrPredicateRules $outer;

        public String solrQuery() {
            return this.solrQuery;
        }

        public String[] references() {
            return this.references;
        }

        public SolrFilter copy(String solrQuery, String[] references) {
            return new SolrFilter(this.org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer(), solrQuery, references);
        }

        public String copy$default$1() {
            return this.solrQuery();
        }

        public String[] copy$default$2() {
            return this.references();
        }

        public String productPrefix() {
            return "SolrFilter";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String[] stringArray;
            int n = x$1;
            switch (n) {
                case 0: {
                    stringArray = this.solrQuery();
                    break;
                }
                case 1: {
                    stringArray = this.references();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return stringArray;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SolrFilter;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SolrFilter)) return false;
            if (((SolrFilter)object).org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer() != this.org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            SolrFilter solrFilter = (SolrFilter)x$1;
            String string = this.solrQuery();
            String string2 = solrFilter.solrQuery();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.references() != solrFilter.references()) return false;
            if (!solrFilter.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SolrPredicateRules org$apache$spark$sql$cassandra$SolrPredicateRules$SolrFilter$$$outer() {
            return this.$outer;
        }

        public SolrFilter(SolrPredicateRules $outer, String solrQuery, String[] references) {
            this.solrQuery = solrQuery;
            this.references = references;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

