/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.cassandra.execution;

import com.datastax.spark.connector.datasource.CassandraScan;
import com.datastax.spark.connector.datasource.CassandraTable;
import com.datastax.spark.connector.util.Logging;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.cassandra.AlwaysOff$;
import org.apache.spark.sql.cassandra.CassandraSourceRelation$;
import org.apache.spark.sql.cassandra.execution.CassandraDirectJoinExec;
import org.apache.spark.sql.cassandra.execution.CassandraDirectJoinStrategy;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.optimizer.BuildLeft$;
import org.apache.spark.sql.catalyst.optimizer.BuildRight$;
import org.apache.spark.sql.catalyst.optimizer.BuildSide;
import org.apache.spark.sql.catalyst.planning.PhysicalOperation$;
import org.apache.spark.sql.catalyst.plans.Inner$;
import org.apache.spark.sql.catalyst.plans.JoinType;
import org.apache.spark.sql.catalyst.plans.LeftOuter$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.RightOuter$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.read.Scan;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.v2.BatchScanExec;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2ScanRelation;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class CassandraDirectJoinStrategy$
implements Logging,
scala.Serializable {
    public static CassandraDirectJoinStrategy$ MODULE$;
    private final Map<BuildSide, Seq<JoinType>> validJoins;
    private transient Logger com$datastax$spark$connector$util$Logging$$_log;

    static {
        new CassandraDirectJoinStrategy$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public Logger com$datastax$spark$connector$util$Logging$$_log() {
        return this.com$datastax$spark$connector$util$Logging$$_log;
    }

    public void com$datastax$spark$connector$util$Logging$$_log_$eq(Logger x$1) {
        this.com$datastax$spark$connector$util$Logging$$_log = x$1;
    }

    public Option<BatchScanExec> getScanExec(SparkPlan plan) {
        return plan.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                BatchScanExec batchScanExec;
                A1 A1 = x1;
                Object object = A1 instanceof BatchScanExec && (batchScanExec = (BatchScanExec)A1).scan() instanceof CassandraScan ? batchScanExec : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                BatchScanExec batchScanExec;
                SparkPlan sparkPlan = x1;
                boolean bl = sparkPlan instanceof BatchScanExec && (batchScanExec = (BatchScanExec)sparkPlan).scan() instanceof CassandraScan;
                return bl;
            }
        });
    }

    public Map<BuildSide, Seq<JoinType>> validJoins() {
        return this.validJoins;
    }

    public boolean validJoinType(BuildSide cassandraSide, JoinType joinType) {
        return ((SeqLike)this.validJoins().apply((Object)cassandraSide)).contains((Object)joinType);
    }

    public Option<DataSourceV2ScanRelation> getDSV2CassandraRelation(LogicalPlan plan) {
        Seq children = plan.collectLeaves();
        return children.length() == 1 ? plan.collectLeaves().collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                DataSourceV2Relation dataSourceV2Relation;
                A1 A1 = x1;
                Object object = A1 instanceof DataSourceV2ScanRelation && (dataSourceV2Relation = (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1).relation()) != null && dataSourceV2Relation.table() instanceof CassandraTable ? dataSourceV2ScanRelation : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                DataSourceV2Relation dataSourceV2Relation;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof DataSourceV2ScanRelation && (dataSourceV2Relation = (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan).relation()) != null && dataSourceV2Relation.table() instanceof CassandraTable;
                return bl;
            }
        }) : None$.MODULE$;
    }

    public Option<CassandraTable> getCassandraTable(LogicalPlan plan) {
        Seq children = plan.collectLeaves();
        return children.length() == 1 ? children.collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Table table;
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                DataSourceV2Relation dataSourceV2Relation;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2ScanRelation && (dataSourceV2Relation = (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1).relation()) != null && (table = dataSourceV2Relation.table()) instanceof CassandraTable) {
                    CassandraTable cassandraTable = (CassandraTable)table;
                    object = cassandraTable;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                Table table;
                DataSourceV2ScanRelation dataSourceV2ScanRelation;
                DataSourceV2Relation dataSourceV2Relation;
                LogicalPlan logicalPlan = x1;
                boolean bl = logicalPlan instanceof DataSourceV2ScanRelation && (dataSourceV2Relation = (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan).relation()) != null && (table = dataSourceV2Relation.table()) instanceof CassandraTable;
                return bl;
            }
        }) : None$.MODULE$;
    }

    public Option<CassandraScan> getCassandraScan(LogicalPlan plan) {
        Seq children = plan.collectLeaves();
        return children.length() == 1 ? plan.collectLeaves().collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DataSourceV2ScanRelation) {
                    DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)A1;
                    Scan cs = dataSourceV2ScanRelation.scan();
                    if (dataSourceV2ScanRelation.relation() != null && cs instanceof CassandraScan) {
                        CassandraScan cassandraScan = (CassandraScan)cs;
                        object = cassandraScan;
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (!(logicalPlan instanceof DataSourceV2ScanRelation)) return false;
                DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan;
                Scan cs = dataSourceV2ScanRelation.scan();
                if (dataSourceV2ScanRelation.relation() == null) return false;
                if (!(cs instanceof CassandraScan)) return false;
                return true;
            }
        }) : None$.MODULE$;
    }

    public <T extends QueryPlan<T>> boolean hasCassandraChild(T plan) {
        return plan.children().size() == 1 && plan.children().exists((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CassandraDirectJoinStrategy$.$anonfun$hasCassandraChild$1(x0$1)));
    }

    public SparkPlan reorderPlan(SparkPlan plan, CassandraDirectJoinExec directJoin) {
        BatchScanExec batchScanExec;
        SparkPlan sparkPlan = plan;
        CassandraDirectJoinExec cassandraDirectJoinExec = sparkPlan instanceof BatchScanExec && (batchScanExec = (BatchScanExec)sparkPlan).scan() instanceof CassandraScan ? directJoin : (SparkPlan)sparkPlan.transform((PartialFunction)new scala.Serializable(directJoin){
            public static final long serialVersionUID = 0L;
            private final CassandraDirectJoinExec directJoin$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                Object object = CassandraDirectJoinStrategy$.MODULE$.hasCassandraChild(A1) ? A1.withNewChildren((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CassandraDirectJoinExec[]{this.directJoin$1}))) : function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x1) {
                SparkPlan sparkPlan = x1;
                boolean bl = CassandraDirectJoinStrategy$.MODULE$.hasCassandraChild(sparkPlan);
                return bl;
            }
            {
                this.directJoin$1 = directJoin$1;
            }
        });
        CassandraDirectJoinExec reordered = cassandraDirectJoinExec;
        return (SparkPlan)reordered.transform((PartialFunction)new scala.Serializable(directJoin){
            public static final long serialVersionUID = 0L;
            private final CassandraDirectJoinExec directJoin$1;

            public final <A1 extends SparkPlan, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 instanceof ProjectExec) {
                    ProjectExec projectExec = (ProjectExec)A1;
                    Seq projectList = projectExec.projectList();
                    SparkPlan child = projectExec.child();
                    Map aliases = ((TraversableOnce)projectList.collect((PartialFunction)new scala.Serializable(null){
                        public static final long serialVersionUID = 0L;

                        public final <A1 extends NamedExpression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            Object object;
                            Alias alias;
                            Expression child;
                            A1 A1 = x1;
                            if (A1 instanceof Alias && (child = (alias = (Alias)A1).child()) instanceof AttributeReference) {
                                AttributeReference attributeReference = (AttributeReference)child;
                                object = new Tuple2((Object)attributeReference.toAttribute().exprId(), (Object)alias);
                            } else {
                                object = function1.apply(x1);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(NamedExpression x1) {
                            Alias alias;
                            Expression child;
                            NamedExpression namedExpression = x1;
                            boolean bl = namedExpression instanceof Alias && (child = (alias = (Alias)namedExpression).child()) instanceof AttributeReference;
                            return bl;
                        }
                    }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                    Seq aliasedOutput = (Seq)this.directJoin$1.output().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Attribute attribute;
                        Attribute attribute2 = x0$1;
                        if (aliases.contains((Object)attribute2.exprId())) {
                            Alias oldAlias = (Alias)aliases.apply((Object)attribute2.exprId());
                            attribute = oldAlias.copy((Expression)attribute2, oldAlias.copy$default$2(), oldAlias.exprId(), oldAlias.qualifier(), oldAlias.explicitMetadata(), oldAlias.nonInheritableMetadataKeys());
                        } else {
                            attribute = attribute2;
                        }
                        return attribute;
                    }, Seq$.MODULE$.canBuildFrom());
                    object = new ProjectExec(aliasedOutput, child);
                } else {
                    object = function1.apply(x2);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(SparkPlan x2) {
                SparkPlan sparkPlan = x2;
                boolean bl = sparkPlan instanceof ProjectExec;
                return bl;
            }
            {
                this.directJoin$1 = directJoin$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(scala.collection.immutable.Map org.apache.spark.sql.catalyst.expressions.Attribute )}, serializedLambda);
            }
        });
    }

    public boolean validJoinBranch(LogicalPlan plan, Seq<Expression> keys) {
        boolean safePlan = this.containsSafePlans(plan);
        boolean pkConstrained = this.allPartitionKeysAreJoined(plan, keys);
        if (this.containsSafePlans(plan)) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Plan was safe");
        }
        if (pkConstrained) {
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Plan constrained on all partition keys");
        }
        return safePlan && pkConstrained;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean allPartitionKeysAreJoined(LogicalPlan plan, Seq<Expression> joinKeys) {
        LogicalPlan logicalPlan = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan);
        if (option.isEmpty()) return false;
        Seq attributes = (Seq)((Tuple3)option.get())._1();
        LogicalPlan logicalPlan2 = (LogicalPlan)((Tuple3)option.get())._3();
        if (!(logicalPlan2 instanceof DataSourceV2ScanRelation)) return false;
        DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan2;
        DataSourceV2Relation dataSourceV2Relation = dataSourceV2ScanRelation.relation();
        if (dataSourceV2Relation == null) return false;
        Table cassandraTable = dataSourceV2Relation.table();
        if (!(cassandraTable instanceof CassandraTable)) return false;
        CassandraTable cassandraTable2 = (CassandraTable)cassandraTable;
        Seq joinKeysExprId = (Seq)joinKeys.collect((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AttributeReference) {
                    AttributeReference attributeReference = (AttributeReference)A1;
                    object = attributeReference.exprId();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AttributeReference;
                return bl;
            }
        }, Seq$.MODULE$.canBuildFrom());
        Map joinKeyAliases = (Map)this.aliasMap((Seq<NamedExpression>)attributes).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)CassandraDirectJoinStrategy$.$anonfun$allPartitionKeysAreJoined$1(joinKeysExprId, x0$1)));
        Seq partitionKeyNames = (Seq)cassandraTable2.tableDef().partitionKey().map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.columnName(), Seq$.MODULE$.canBuildFrom());
        boolean allKeysPresent = partitionKeyNames.forall((Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)joinKeyAliases.contains((Object)key)));
        if (allKeysPresent) return allKeysPresent;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Not all ").append(partitionKeyNames).append(" should be contained within ").append(joinKeyAliases).toString());
        return allKeysPresent;
    }

    public Map<String, ExprId> aliasMap(Seq<NamedExpression> aliases) {
        return ((TraversableOnce)aliases.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            Alias alias;
            Expression child;
            NamedExpression namedExpression = x0$1;
            if (namedExpression instanceof Alias && (child = (alias = (Alias)namedExpression).child()) instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)child;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attributeReference.name()), (Object)alias.exprId());
            } else if (namedExpression instanceof AttributeReference) {
                AttributeReference attributeReference = (AttributeReference)namedExpression;
                tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attributeReference.name()), (Object)attributeReference.exprId());
            } else {
                throw new MatchError((Object)namedExpression);
            }
            return tuple2;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean containsSafePlans(LogicalPlan plan) {
        LogicalPlan logicalPlan = plan;
        Option option = PhysicalOperation$.MODULE$.unapply(logicalPlan);
        if (option.isEmpty()) return false;
        LogicalPlan logicalPlan2 = (LogicalPlan)((Tuple3)option.get())._3();
        if (!(logicalPlan2 instanceof DataSourceV2ScanRelation)) return false;
        DataSourceV2ScanRelation dataSourceV2ScanRelation = (DataSourceV2ScanRelation)logicalPlan2;
        DataSourceV2Relation dataSourceV2Relation = dataSourceV2ScanRelation.relation();
        Scan scan = dataSourceV2ScanRelation.scan();
        if (dataSourceV2Relation == null) return false;
        if (!(dataSourceV2Relation.table() instanceof CassandraTable)) return false;
        if (!(scan instanceof CassandraScan)) return false;
        CassandraScan cassandraScan = (CassandraScan)scan;
        Product product = CassandraSourceRelation$.MODULE$.getDirectJoinSetting(cassandraScan.consolidatedConf());
        AlwaysOff$ alwaysOff$ = AlwaysOff$.MODULE$;
        if (product == null) {
            if (alwaysOff$ == null) return false;
            return true;
        } else if (product.equals(alwaysOff$)) return false;
        return true;
    }

    public CassandraDirectJoinStrategy apply(SparkSession spark) {
        return new CassandraDirectJoinStrategy(spark);
    }

    public Option<SparkSession> unapply(CassandraDirectJoinStrategy x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)x$0.spark());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$hasCassandraChild$1(QueryPlan x0$1) {
        BatchScanExec batchScanExec;
        DataSourceV2ScanRelation dataSourceV2ScanRelation;
        DataSourceV2Relation dataSourceV2Relation;
        QueryPlan queryPlan = x0$1;
        boolean bl = queryPlan instanceof DataSourceV2ScanRelation && (dataSourceV2Relation = (dataSourceV2ScanRelation = (DataSourceV2ScanRelation)queryPlan).relation()) != null && dataSourceV2Relation.table() instanceof CassandraTable ? true : queryPlan instanceof BatchScanExec && (batchScanExec = (BatchScanExec)queryPlan).scan() instanceof CassandraScan;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$allPartitionKeysAreJoined$1(Seq joinKeysExprId$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ExprId value = (ExprId)tuple2._2();
        boolean bl = joinKeysExprId$1.contains((Object)value);
        return bl;
    }

    private CassandraDirectJoinStrategy$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.validJoins = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BuildRight$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinType[]{Inner$.MODULE$, LeftOuter$.MODULE$}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BuildLeft$.MODULE$), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new JoinType[]{Inner$.MODULE$, RightOuter$.MODULE$})))}));
    }
}

