/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.swt.os;

import com.diffplug.common.swt.os.OS;

public enum Arch {
    x86,
    x64,
    arm64,
    unknown;


    public <T> T x86x64(T val86, T val64) {
        switch (this) {
            case x86: {
                return val86;
            }
            case x64: {
                return val64;
            }
        }
        throw Arch.unsupportedException(this);
    }

    public <T> T x64arm64(T val64, T arm64) {
        switch (this) {
            case x64: {
                return val64;
            }
            case arm64: {
                return arm64;
            }
        }
        throw Arch.unsupportedException(this);
    }

    public <T> T x86x64arm64(T val86, T val64, T arm64) {
        switch (this) {
            case x86: {
                return val86;
            }
            case x64: {
                return val64;
            }
            case arm64: {
                return arm64;
            }
        }
        throw Arch.unsupportedException(this);
    }

    public <T> T x86x64arm64unknown(T val86, T val64, T arm64, T unknown) {
        switch (this) {
            case x86: {
                return val86;
            }
            case x64: {
                return val64;
            }
            case arm64: {
                return arm64;
            }
            case unknown: {
                return unknown;
            }
        }
        throw Arch.unsupportedException(this);
    }

    public static Arch getNative() {
        return OS.getNative().getArch();
    }

    public static Arch getRunning() {
        return OS.getRunning().getArch();
    }

    public static UnsupportedOperationException unsupportedException(Arch arch) {
        return new UnsupportedOperationException("Arch '" + (Object)((Object)arch) + "' is unsupported.");
    }
}

