/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.ThrowingEx;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.annotation.Nullable;

public class EslintConfig
implements Serializable {
    private static final long serialVersionUID = -6196834313082791248L;
    @Nullable
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private final transient File eslintConfigPath;
    private final FileSignature eslintConfigPathSignature;
    private final String eslintConfigJs;

    public EslintConfig(@Nullable File eslintConfigPath, @Nullable String eslintConfigJs) {
        try {
            this.eslintConfigPath = eslintConfigPath;
            this.eslintConfigPathSignature = eslintConfigPath != null ? FileSignature.signAsList(this.eslintConfigPath) : FileSignature.signAsList(new File[0]);
            this.eslintConfigJs = eslintConfigJs;
        }
        catch (IOException e) {
            throw ThrowingEx.asRuntime(e);
        }
    }

    public EslintConfig withEslintConfigPath(@Nullable File eslintConfigPath) {
        return new EslintConfig(eslintConfigPath, this.eslintConfigJs);
    }

    @Nullable
    public File getEslintConfigPath() {
        return this.eslintConfigPath;
    }

    @Nullable
    public String getEslintConfigJs() {
        return this.eslintConfigJs;
    }

    public EslintConfig verify() {
        if (this.eslintConfigPath == null && this.eslintConfigJs == null) {
            throw new IllegalArgumentException("ESLint must be configured using either a configFile or a configJs - but both are null.");
        }
        return this;
    }
}

