/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven;

import com.diffplug.spotless.maven.ArtifactResolutionException;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;

public class ArtifactResolver {
    private static final DependencyFilter ACCEPT_ALL_FILTER = (node, parents) -> true;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;
    private final List<RemoteRepository> repositories;
    private final Log log;

    public ArtifactResolver(RepositorySystem repositorySystem, RepositorySystemSession session, List<RemoteRepository> repositories, Log log) {
        this.repositorySystem = Objects.requireNonNull(repositorySystem);
        this.session = Objects.requireNonNull(session);
        this.repositories = Objects.requireNonNull(repositories);
        this.log = Objects.requireNonNull(log);
    }

    public Set<File> resolve(String mavenCoordinate) {
        DefaultArtifact artifact = new DefaultArtifact(mavenCoordinate);
        Dependency dependency = new Dependency((Artifact)artifact, null);
        CollectRequest collectRequest = new CollectRequest(dependency, this.repositories);
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, ACCEPT_ALL_FILTER);
        DependencyResult dependencyResult = this.resolveDependencies(dependencyRequest);
        return dependencyResult.getArtifactResults().stream().peek(this::logResolved).map(ArtifactResult::getArtifact).map(Artifact::getFile).collect(Collectors.toSet());
    }

    private DependencyResult resolveDependencies(DependencyRequest dependencyRequest) {
        try {
            return this.repositorySystem.resolveDependencies(this.session, dependencyRequest);
        }
        catch (DependencyResolutionException e) {
            throw new ArtifactResolutionException("Unable to resolve dependencies", e);
        }
    }

    private void logResolved(ArtifactResult artifactResult) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("Resolved artifact: " + artifactResult));
        }
    }
}

