/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.maven.generic;

import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.maven.FormatterStepConfig;
import com.diffplug.spotless.maven.FormatterStepFactory;
import com.diffplug.spotless.npm.PrettierConfig;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.maven.plugins.annotations.Parameter;

public class Prettier
implements FormatterStepFactory {
    @Parameter
    private String prettierVersion;
    @Parameter
    private Map<String, String> devDependencies;
    @Parameter
    private Map<String, String> config;
    @Parameter
    private String configFile;
    @Parameter
    private String npmExecutable;

    @Override
    public FormatterStep newFormatterStep(FormatterStepConfig stepConfig) {
        LinkedHashMap<String, Object> configInline;
        if (this.prettierVersion != null && this.devDependencies != null) {
            throw Prettier.onlyOneConfig();
        }
        if (this.devDependencies == null) {
            this.devDependencies = this.prettierVersion == null || this.prettierVersion.isEmpty() ? PrettierFormatterStep.defaultDevDependencies() : PrettierFormatterStep.defaultDevDependenciesWithPrettier((String)this.prettierVersion);
        }
        File npm = this.npmExecutable != null ? stepConfig.getFileLocator().locateLocal(this.npmExecutable) : null;
        File configFileHandler = this.configFile != null ? stepConfig.getFileLocator().locateLocal(this.configFile) : null;
        if (this.config != null) {
            configInline = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, String> e : this.config.entrySet()) {
                try {
                    configInline.put(e.getKey(), Integer.parseInt(e.getValue()));
                }
                catch (NumberFormatException ignore) {
                    try {
                        configInline.put(e.getKey(), Boolean.parseBoolean(e.getValue()));
                    }
                    catch (IllegalArgumentException ignore2) {
                        configInline.put(e.getKey(), e.getValue());
                    }
                }
            }
        } else {
            configInline = null;
        }
        PrettierConfig prettierConfig = new PrettierConfig(configFileHandler, configInline);
        File buildDir = stepConfig.getFileLocator().getBuildDir();
        return PrettierFormatterStep.create(this.devDependencies, (Provisioner)stepConfig.getProvisioner(), (File)buildDir, (File)npm, (PrettierConfig)prettierConfig);
    }

    private static IllegalArgumentException onlyOneConfig() {
        return new IllegalArgumentException("must specify exactly one configFile or config");
    }
}

