/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.gradle.spotless;

import com.diffplug.gradle.spotless.FormatExtension;
import com.diffplug.gradle.spotless.HasBuiltinDelimiterForLicense;
import com.diffplug.gradle.spotless.PluginGradlePreconditions;
import com.diffplug.gradle.spotless.SpotlessExtensionBase;
import com.diffplug.gradle.spotless.SpotlessTask;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.cpp.CppDefaults;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import com.diffplug.spotless.extra.cpp.EclipseCdtFormatterStep;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.gradle.api.Project;

public class CppExtension
extends FormatExtension
implements HasBuiltinDelimiterForLicense {
    static final String NAME = "cpp";
    @Deprecated
    private static final List<String> FILE_FILTER = Collections.unmodifiableList(Arrays.asList("c", "h", "C", "cpp", "cxx", "cc", "c++", "h", "hpp", "hh", "hxx", "inc").stream().map(s -> "**/*." + s).collect(Collectors.toList()));

    public CppExtension(SpotlessExtensionBase spotless) {
        super(spotless);
    }

    public EclipseConfig eclipseCdt() {
        return new EclipseConfig(EclipseCdtFormatterStep.defaultVersion());
    }

    public EclipseConfig eclipseCdt(String version) {
        return new EclipseConfig(version);
    }

    @Deprecated
    public EclipseConfig eclipse() {
        this.getProject().getLogger().warn("Spotless: in the `cpp { }` block, use `eclipseCdt()` instead of `eclipse()`");
        return new EclipseConfig(EclipseCdtFormatterStep.defaultVersion());
    }

    @Deprecated
    public EclipseConfig eclipse(String version) {
        this.getProject().getLogger().warn("Spotless: in the `cpp { }` block, use `eclipseCdt('" + version + "')` instead of `eclipse('" + version + "')`");
        return new EclipseConfig(version);
    }

    @Override
    protected void setupTask(SpotlessTask task) {
        if (this.target == null) {
            this.noDefaultTarget();
            this.target(FILE_FILTER.toArray());
        }
        super.setupTask(task);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeader(String licenseHeader) {
        return this.licenseHeader(licenseHeader, CppDefaults.DELIMITER_EXPR);
    }

    @Override
    public FormatExtension.LicenseHeaderConfig licenseHeaderFile(Object licenseHeaderFile) {
        return this.licenseHeaderFile(licenseHeaderFile, CppDefaults.DELIMITER_EXPR);
    }

    public class EclipseConfig {
        private final EclipseBasedStepBuilder builder;

        EclipseConfig(String version) {
            this.builder = EclipseCdtFormatterStep.createBuilder((Provisioner)CppExtension.this.provisioner());
            this.builder.setVersion(version);
            CppExtension.this.addStep(this.builder.build());
        }

        public void configFile(Object ... configFiles) {
            PluginGradlePreconditions.requireElementsNonNull(configFiles);
            Project project = CppExtension.this.getProject();
            this.builder.setPreferences((Iterable)project.files(configFiles).getFiles());
            CppExtension.this.replaceStep(this.builder.build());
        }
    }
}

