/*
 * Decompiled with CFR 0.152.
 */
package com.digitalpetri.modbus.codec;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public abstract class Modbus {
    private Modbus() {
    }

    public static ExecutorService sharedExecutor() {
        return ExecutorHolder.Executor;
    }

    public static EventLoopGroup sharedEventLoop() {
        return EventLoopHolder.EventLoop;
    }

    public static HashedWheelTimer sharedWheelTimer() {
        return WheelTimerHolder.WheelTimer;
    }

    public static void releaseSharedResources() {
        Modbus.sharedExecutor().shutdown();
        Modbus.sharedEventLoop().shutdownGracefully();
        Modbus.sharedWheelTimer().stop();
    }

    public static void releaseSharedResources(long timeout, TimeUnit unit) throws InterruptedException {
        Modbus.sharedExecutor().awaitTermination(timeout, unit);
        Modbus.sharedEventLoop().shutdownGracefully().await(timeout, unit);
        Modbus.sharedWheelTimer().stop();
    }

    private static class WheelTimerHolder {
        private static final HashedWheelTimer WheelTimer = new HashedWheelTimer();

        private WheelTimerHolder() {
        }

        static {
            WheelTimer.start();
        }
    }

    private static class EventLoopHolder {
        private static final EventLoopGroup EventLoop = new NioEventLoopGroup();

        private EventLoopHolder() {
        }
    }

    private static class ExecutorHolder {
        private static final ExecutorService Executor = Executors.newWorkStealingPool();

        private ExecutorHolder() {
        }
    }
}

