/*
 * Decompiled with CFR 0.152.
 */
package discord4j.discordjson.json.gateway;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="GuildRoleUpdate", generator="Immutables")
public final class ImmutableGuildRoleUpdate
implements GuildRoleUpdate {
    private final long guildId_value;
    private final RoleData role;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGuildRoleUpdate(Id guildId, RoleData role) {
        Id guildId$impl = guildId;
        this.role = Objects.requireNonNull(role, "role");
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    private ImmutableGuildRoleUpdate(ImmutableGuildRoleUpdate original, Id guildId, RoleData role) {
        Id guildId$impl = guildId;
        this.role = role;
        this.guildId_value = guildId$impl.asLong();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="guild_id")
    public Id guildId() {
        return Id.of((long)this.guildId_value);
    }

    @Override
    @JsonProperty(value="role")
    public RoleData role() {
        return this.role;
    }

    public ImmutableGuildRoleUpdate withGuildId(long value) {
        Id newValue = Id.of((long)value);
        return new ImmutableGuildRoleUpdate(this, newValue, this.role);
    }

    public ImmutableGuildRoleUpdate withGuildId(String value) {
        Id newValue = Id.of((String)value);
        return new ImmutableGuildRoleUpdate(this, newValue, this.role);
    }

    public final ImmutableGuildRoleUpdate withRole(RoleData value) {
        if (this.role == value) {
            return this;
        }
        RoleData newValue = Objects.requireNonNull(value, "role");
        return new ImmutableGuildRoleUpdate(this, this.guildId(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGuildRoleUpdate && this.equalTo(0, (ImmutableGuildRoleUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableGuildRoleUpdate another) {
        return Objects.equals(this.guildId_value, another.guildId_value) && this.role.equals(another.role);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.guildId_value);
        h += (h << 5) + this.role.hashCode();
        return h;
    }

    public String toString() {
        return "GuildRoleUpdate{guildId=" + Objects.toString(this.guildId_value) + ", role=" + this.role + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGuildRoleUpdate fromJson(Json json) {
        Builder builder = ImmutableGuildRoleUpdate.builder();
        if (json.guildId != null) {
            builder.guildId(json.guildId);
        }
        if (json.role != null) {
            builder.role(json.role);
        }
        return builder.build();
    }

    public static ImmutableGuildRoleUpdate of(Id guildId, RoleData role) {
        return new ImmutableGuildRoleUpdate(guildId, role);
    }

    public static ImmutableGuildRoleUpdate copyOf(GuildRoleUpdate instance) {
        if (instance instanceof ImmutableGuildRoleUpdate) {
            return (ImmutableGuildRoleUpdate)instance;
        }
        return ImmutableGuildRoleUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GuildRoleUpdate", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ROLE = 1L;
        private long initBits = 1L;
        private Id guildId_id = null;
        private RoleData role;

        private Builder() {
        }

        public final Builder from(GuildRoleUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            this.guildId(instance.guildId());
            this.role(instance.role());
            return this;
        }

        public Builder guildId(String value) {
            this.guildId_id = Id.of((String)value);
            return this;
        }

        public Builder guildId(long value) {
            this.guildId_id = Id.of((long)value);
            return this;
        }

        @JsonProperty(value="guild_id")
        public Builder guildId(Id value) {
            this.guildId_id = value;
            return this;
        }

        @JsonProperty(value="role")
        public final Builder role(RoleData role) {
            this.role = Objects.requireNonNull(role, "role");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableGuildRoleUpdate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGuildRoleUpdate(null, this.guildId_build(), this.role);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("role");
            }
            return "Cannot build GuildRoleUpdate, some of required attributes are not set " + attributes;
        }

        private Id guildId_build() {
            return this.guildId_id;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GuildRoleUpdate", generator="Immutables")
    static final class Json
    implements GuildRoleUpdate {
        Id guildId;
        RoleData role;

        Json() {
        }

        @JsonProperty(value="guild_id")
        public void setGuildId(Id guildId) {
            this.guildId = guildId;
        }

        @JsonProperty(value="role")
        public void setRole(RoleData role) {
            this.role = role;
        }

        @Override
        public Id guildId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RoleData role() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="GuildRoleUpdate", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildRoleUpdate, attribute initializers form cycle " + attributes;
        }
    }
}

