/*
 * Decompiled with CFR 0.152.
 */
package discord4j.common.retry;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class ReconnectContext {
    private final Duration firstBackoff;
    private final Duration maxBackoffInterval;
    private final AtomicInteger attempts = new AtomicInteger(1);
    private final AtomicInteger resetCount = new AtomicInteger(0);

    public ReconnectContext(Duration firstBackoff, Duration maxBackoffInterval) {
        this.firstBackoff = firstBackoff;
        this.maxBackoffInterval = maxBackoffInterval;
    }

    public void next() {
        this.attempts.incrementAndGet();
    }

    public void reset() {
        this.attempts.set(1);
        this.resetCount.incrementAndGet();
    }

    public void clear() {
        this.attempts.set(1);
        this.resetCount.set(0);
    }

    public Duration getFirstBackoff() {
        return this.firstBackoff;
    }

    public Duration getMaxBackoffInterval() {
        return this.maxBackoffInterval;
    }

    public int getAttempts() {
        return this.attempts.get();
    }

    public int getResetCount() {
        return this.resetCount.get();
    }
}

