/*
 * Decompiled with CFR 0.152.
 */
package discord4j.rest.util;

import discord4j.rest.util.Permission;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import reactor.util.annotation.Nullable;

public final class PermissionSet
extends AbstractSet<Permission> {
    private static final long ALL_RAW = Arrays.stream(Permission.values()).mapToLong(Permission::getValue).reduce(0L, (a, b) -> a | b);
    private static final long NONE_RAW = 0L;
    private static final PermissionSet ALL = new PermissionSet(ALL_RAW);
    private static final PermissionSet NONE = new PermissionSet(0L);
    private final long rawValue;

    public static PermissionSet all() {
        return ALL;
    }

    public static PermissionSet none() {
        return NONE;
    }

    public static PermissionSet of(long rawValue) {
        return new PermissionSet(rawValue);
    }

    public static PermissionSet of(String rawValue) {
        return new PermissionSet(Long.parseUnsignedLong(rawValue));
    }

    public static PermissionSet of(Permission ... permissions) {
        long rawValue = Arrays.stream(permissions).mapToLong(Permission::getValue).reduce(0L, (left, right) -> left | right);
        return new PermissionSet(rawValue);
    }

    private PermissionSet(long rawValue) {
        this.rawValue = rawValue;
    }

    public PermissionSet and(PermissionSet other) {
        return PermissionSet.of(this.rawValue & other.rawValue);
    }

    public PermissionSet or(PermissionSet other) {
        return PermissionSet.of(this.rawValue | other.rawValue);
    }

    public PermissionSet xor(PermissionSet other) {
        return PermissionSet.of(this.rawValue ^ other.rawValue);
    }

    public PermissionSet andNot(PermissionSet other) {
        return PermissionSet.of(this.rawValue & (other.rawValue ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Deprecated
    public PermissionSet subtract(PermissionSet other) {
        return PermissionSet.of(this.rawValue & (other.rawValue ^ 0xFFFFFFFFFFFFFFFFL));
    }

    public PermissionSet not() {
        return PermissionSet.of((this.rawValue ^ 0xFFFFFFFFFFFFFFFFL) & ALL_RAW);
    }

    public EnumSet<Permission> asEnumSet() {
        EnumSet<Permission> permissions = EnumSet.allOf(Permission.class);
        permissions.removeIf(permission -> !this.contains(permission));
        return permissions;
    }

    public long getRawValue() {
        return this.rawValue;
    }

    @Override
    public boolean contains(Object o) {
        return o instanceof Permission && (((Permission)((Object)o)).getValue() & this.rawValue) > 0L;
    }

    @Override
    public Iterator<Permission> iterator() {
        return Collections.unmodifiableSet(this.asEnumSet()).iterator();
    }

    @Override
    public int size() {
        return Long.bitCount(this.rawValue);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PermissionSet that = (PermissionSet)o;
        return this.rawValue == that.rawValue;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.rawValue);
    }

    @Override
    public String toString() {
        return "PermissionSet{rawValue=" + this.rawValue + "} " + super.toString();
    }
}

