/*
 * Decompiled with CFR 0.152.
 */
package com.dkanejs.maven.plugins.docker.compose;

import com.dkanejs.maven.plugins.docker.compose.AbstractDockerComposeMojo;
import java.util.ArrayList;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="build", threadSafe=true)
public class DockerComposeBuildMojo
extends AbstractDockerComposeMojo {
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(AbstractDockerComposeMojo.Command.BUILD.getValue());
        if (this.buildArgs.forceRm) {
            this.getLog().info((CharSequence)"Always remove intermediate containers.");
            args.add("--force-rm");
        }
        if (this.buildArgs.noCache) {
            this.getLog().info((CharSequence)"Do not use cache when building the image.");
            args.add("--no-cache");
        }
        if (this.buildArgs.alwaysPull) {
            this.getLog().info((CharSequence)"Always attempt to pull a newer version of the image.");
            args.add("--pull");
        }
        if (this.buildArgs.args != null && !this.buildArgs.args.isEmpty()) {
            this.getLog().info((CharSequence)"Adding build args");
            this.buildArgs.args.forEach((key, value) -> {
                args.add("--build-arg");
                args.add(key + "=" + value);
            });
        }
        if (this.services != null && !this.services.isEmpty()) {
            args.addAll(this.services);
        }
        super.execute(args);
    }
}

