/*
 * Decompiled with CFR 0.152.
 */
package com.dkanejs.maven.plugins.docker.compose;

import com.dkanejs.maven.plugins.docker.compose.AbstractDockerComposeMojo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="up", threadSafe=true)
public class DockerComposeUpMojo
extends AbstractDockerComposeMojo {
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution");
            return;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(AbstractDockerComposeMojo.Command.UP.getValue());
        if (this.detachedMode) {
            this.getLog().info((CharSequence)"Running in detached mode");
            args.add("-d");
        }
        if (this.build) {
            this.getLog().info((CharSequence)"Building images");
            args.add("--build");
        }
        args.add("--no-color");
        if (this.services != null && !this.services.isEmpty()) {
            args.addAll(this.services);
        }
        super.execute(args);
        if (this.awaitCmd != null) {
            this.await(this.buildCmd(this.awaitCmd, this.awaitCmdArgs));
        }
    }

    private List<String> buildCmd(String cmd, String args) {
        String[] cmdArgs = null;
        if (args != null) {
            cmdArgs = args.split(",");
        }
        ArrayList<String> answer = new ArrayList<String>();
        answer.add(cmd);
        if (cmdArgs != null) {
            answer.addAll(Arrays.asList(cmdArgs));
        }
        return answer;
    }

    private void await(List<String> awaitCmd) {
        Integer exitCode = null;
        ProcessBuilder pb = new ProcessBuilder(awaitCmd).inheritIO();
        long start = System.currentTimeMillis();
        try {
            boolean stillWaiting;
            do {
                Object process = null;
                if (exitCode != null) {
                    Thread.sleep(1000L);
                }
                exitCode = pb.start().waitFor();
                boolean bl = stillWaiting = System.currentTimeMillis() - start < (long)(this.awaitTimeout * 1000);
            } while (exitCode != 0 && stillWaiting);
            if (exitCode != 0) {
                throw new RuntimeException("await failed after " + this.awaitTimeout + " seconds");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

