/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.CanonMakernoteDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonMakernoteDescriptor
extends TagDescriptor<CanonMakernoteDirectory> {
    public CanonMakernoteDescriptor(@NotNull CanonMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 12: {
                return this.getSerialNumberDescription();
            }
            case 49436: {
                return this.getFlashActivityDescription();
            }
            case 49426: {
                return this.getFocusTypeDescription();
            }
            case 49420: {
                return this.getDigitalZoomDescription();
            }
            case 49411: {
                return this.getQualityDescription();
            }
            case 49409: {
                return this.getMacroModeDescription();
            }
            case 49410: {
                return this.getSelfTimerDelayDescription();
            }
            case 49412: {
                return this.getFlashModeDescription();
            }
            case 49413: {
                return this.getContinuousDriveModeDescription();
            }
            case 49415: {
                return this.getFocusMode1Description();
            }
            case 49418: {
                return this.getImageSizeDescription();
            }
            case 49419: {
                return this.getEasyShootingModeDescription();
            }
            case 49421: {
                return this.getContrastDescription();
            }
            case 49422: {
                return this.getSaturationDescription();
            }
            case 49423: {
                return this.getSharpnessDescription();
            }
            case 49424: {
                return this.getIsoDescription();
            }
            case 49425: {
                return this.getMeteringModeDescription();
            }
            case 49427: {
                return this.getAfPointSelectedDescription();
            }
            case 49428: {
                return this.getExposureModeDescription();
            }
            case 49431: {
                return this.getLongFocalLengthDescription();
            }
            case 49432: {
                return this.getShortFocalLengthDescription();
            }
            case 49433: {
                return this.getFocalUnitsPerMillimetreDescription();
            }
            case 49437: {
                return this.getFlashDetailsDescription();
            }
            case 49440: {
                return this.getFocusMode2Description();
            }
            case 49671: {
                return this.getWhiteBalanceDescription();
            }
            case 49678: {
                return this.getAfPointUsedDescription();
            }
            case 49679: {
                return this.getFlashBiasDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getSerialNumberDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(12);
        if (value == null) {
            return null;
        }
        return String.format("%04X%05d", value >> 8 & 0xFF, value & 0xFF);
    }

    @Nullable
    public String getFlashBiasDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49679);
        if (value == null) {
            return null;
        }
        boolean isNegative = false;
        if (value > 61440) {
            isNegative = true;
            Integer n = value = Integer.valueOf(65535 - value);
            Integer n2 = value = Integer.valueOf(value + 1);
        }
        return (isNegative ? "-" : "") + Float.toString((float)value.intValue() / 32.0f) + " EV";
    }

    @Nullable
    public String getAfPointUsedDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49678);
        if (value == null) {
            return null;
        }
        if ((value & 7) == 0) {
            return "Right";
        }
        if ((value & 7) == 1) {
            return "Centre";
        }
        if ((value & 7) == 2) {
            return "Left";
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getWhiteBalanceDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49671);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Sunny";
            }
            case 2: {
                return "Cloudy";
            }
            case 3: {
                return "Tungsten";
            }
            case 4: {
                return "Florescent";
            }
            case 5: {
                return "Flash";
            }
            case 6: {
                return "Custom";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusMode2Description() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49440);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Single";
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashDetailsDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49437);
        if (value == null) {
            return null;
        }
        if ((value >> 14 & 1) > 0) {
            return "External E-TTL";
        }
        if ((value >> 13 & 1) > 0) {
            return "Internal flash";
        }
        if ((value >> 11 & 1) > 0) {
            return "FP sync used";
        }
        if ((value >> 4 & 1) > 0) {
            return "FP sync enabled";
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocalUnitsPerMillimetreDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49433);
        if (value == null) {
            return null;
        }
        if (value != 0) {
            return Integer.toString(value);
        }
        return "";
    }

    @Nullable
    public String getShortFocalLengthDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49432);
        if (value == null) {
            return null;
        }
        String units = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(value) + " " + units;
    }

    @Nullable
    public String getLongFocalLengthDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49431);
        if (value == null) {
            return null;
        }
        String units = this.getFocalUnitsPerMillimetreDescription();
        return Integer.toString(value) + " " + units;
    }

    @Nullable
    public String getExposureModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49428);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Easy shooting";
            }
            case 1: {
                return "Program";
            }
            case 2: {
                return "Tv-priority";
            }
            case 3: {
                return "Av-priority";
            }
            case 4: {
                return "Manual";
            }
            case 5: {
                return "A-DEP";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getAfPointSelectedDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49427);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 12288: {
                return "None (MF)";
            }
            case 12289: {
                return "Auto selected";
            }
            case 12290: {
                return "Right";
            }
            case 12291: {
                return "Centre";
            }
            case 12292: {
                return "Left";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getMeteringModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49425);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 3: {
                return "Evaluative";
            }
            case 4: {
                return "Partial";
            }
            case 5: {
                return "Centre weighted";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getIsoDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49424);
        if (value == null) {
            return null;
        }
        int canonMask = 16384;
        if ((value & canonMask) > 0) {
            return "" + (value & ~canonMask);
        }
        switch (value) {
            case 0: {
                return "Not specified (see ISOSpeedRatings tag)";
            }
            case 15: {
                return "Auto";
            }
            case 16: {
                return "50";
            }
            case 17: {
                return "100";
            }
            case 18: {
                return "200";
            }
            case 19: {
                return "400";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSharpnessDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49423);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSaturationDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49422);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContrastDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49421);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 65535: {
                return "Low";
            }
            case 0: {
                return "Normal";
            }
            case 1: {
                return "High";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getEasyShootingModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49419);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Full auto";
            }
            case 1: {
                return "Manual";
            }
            case 2: {
                return "Landscape";
            }
            case 3: {
                return "Fast shutter";
            }
            case 4: {
                return "Slow shutter";
            }
            case 5: {
                return "Night";
            }
            case 6: {
                return "B&W";
            }
            case 7: {
                return "Sepia";
            }
            case 8: {
                return "Portrait";
            }
            case 9: {
                return "Sports";
            }
            case 10: {
                return "Macro / Closeup";
            }
            case 11: {
                return "Pan focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getImageSizeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49418);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Large";
            }
            case 1: {
                return "Medium";
            }
            case 2: {
                return "Small";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusMode1Description() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49415);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "One-shot";
            }
            case 1: {
                return "AI Servo";
            }
            case 2: {
                return "AI Focus";
            }
            case 3: {
                return "Manual Focus";
            }
            case 4: {
                return "Single";
            }
            case 5: {
                return "Continuous";
            }
            case 6: {
                return "Manual Focus";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getContinuousDriveModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49413);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                Integer delay = ((CanonMakernoteDirectory)this._directory).getInteger(49410);
                if (delay != null) {
                    return delay == 0 ? "Single shot" : "Single shot with self-timer";
                }
            }
            case 1: {
                return "Continuous";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49412);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "No flash fired";
            }
            case 1: {
                return "Auto";
            }
            case 2: {
                return "On";
            }
            case 3: {
                return "Red-eye reduction";
            }
            case 4: {
                return "Slow-synchro";
            }
            case 5: {
                return "Auto and red-eye reduction";
            }
            case 6: {
                return "On and red-eye reduction";
            }
            case 16: {
                return "External flash";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getSelfTimerDelayDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49410);
        if (value == null) {
            return null;
        }
        if (value == 0) {
            return "Self timer not used";
        }
        return Double.toString((double)value.intValue() * 0.1) + " sec";
    }

    @Nullable
    public String getMacroModeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49409);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 1: {
                return "Macro";
            }
            case 2: {
                return "Normal";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getQualityDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49411);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 2: {
                return "Normal";
            }
            case 3: {
                return "Fine";
            }
            case 5: {
                return "Superfine";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getDigitalZoomDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49420);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "No digital zoom";
            }
            case 1: {
                return "2x";
            }
            case 2: {
                return "4x";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFocusTypeDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49426);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Manual";
            }
            case 1: {
                return "Auto";
            }
            case 3: {
                return "Close-up (Macro)";
            }
            case 8: {
                return "Locked (Pan Mode)";
            }
        }
        return "Unknown (" + value + ")";
    }

    @Nullable
    public String getFlashActivityDescription() {
        Integer value = ((CanonMakernoteDirectory)this._directory).getInteger(49436);
        if (value == null) {
            return null;
        }
        switch (value) {
            case 0: {
                return "Flash did not fire";
            }
            case 1: {
                return "Flash fired";
            }
        }
        return "Unknown (" + value + ")";
    }
}

