/* DO NOT EDIT */
/* This file was generated from cloud_docs_cloud_docs_public_api.stone */

package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

/**
 * This class is an open tagged union.  Tagged unions instances are always
 * associated to a specific tag.  This means only one of the {@code isAbc()}
 * methods will return {@code true}. You can use {@link #tag()} to determine the
 * tag associated with this instance.
 *
 * <p> Open unions may be extended in the future with additional tags. If a new
 * tag is introduced that this SDK does not recognized, the {@link #OTHER} value
 * will be used. </p>
 */
public final class GetMetadataErrorTagUnion {
    // union cloud_docs.get_metadata_error_tag_union (cloud_docs_cloud_docs_public_api.stone)

    /**
     * Discriminating tag type for {@link GetMetadataErrorTagUnion}.
     */
    public enum Tag {
        GENERIC_ERROR, // GenericErrorTag
        /**
         * Catch-all used for unknown tag values returned by the Dropbox
         * servers.
         *
         * <p> Receiving a catch-all value typically indicates this SDK version
         * is not up to date. Consider updating your SDK version to handle the
         * new tags. </p>
         */
        OTHER; // *catch_all
    }

    /**
     * Catch-all used for unknown tag values returned by the Dropbox servers.
     *
     * <p> Receiving a catch-all value typically indicates this SDK version is
     * not up to date. Consider updating your SDK version to handle the new
     * tags. </p>
     */
    public static final GetMetadataErrorTagUnion OTHER = new GetMetadataErrorTagUnion().withTag(Tag.OTHER);

    private Tag _tag;
    private GenericErrorTag genericErrorValue;

    /**
     * Private default constructor, so that object is uninitializable publicly.
     */
    private GetMetadataErrorTagUnion() {
    }


    /**
     *
     * @param _tag  Discriminating tag for this instance.
     */
    private GetMetadataErrorTagUnion withTag(Tag _tag) {
        GetMetadataErrorTagUnion result = new GetMetadataErrorTagUnion();
        result._tag = _tag;
        return result;
    }

    /**
     *
     * @param genericErrorValue  Must not be {@code null}.
     * @param _tag  Discriminating tag for this instance.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    private GetMetadataErrorTagUnion withTagAndGenericError(Tag _tag, GenericErrorTag genericErrorValue) {
        GetMetadataErrorTagUnion result = new GetMetadataErrorTagUnion();
        result._tag = _tag;
        result.genericErrorValue = genericErrorValue;
        return result;
    }

    /**
     * Returns the tag for this instance.
     *
     * <p> This class is a tagged union.  Tagged unions instances are always
     * associated to a specific tag.  This means only one of the {@code isXyz()}
     * methods will return {@code true}. Callers are recommended to use the tag
     * value in a {@code switch} statement to properly handle the different
     * values for this {@code GetMetadataErrorTagUnion}. </p>
     *
     * <p> If a tag returned by the server is unrecognized by this SDK, the
     * {@link Tag#OTHER} value will be used. </p>
     *
     * @return the tag for this instance.
     */
    public Tag tag() {
        return _tag;
    }

    /**
     * Returns {@code true} if this instance has the tag {@link
     * Tag#GENERIC_ERROR}, {@code false} otherwise.
     *
     * @return {@code true} if this instance is tagged as {@link
     *     Tag#GENERIC_ERROR}, {@code false} otherwise.
     */
    public boolean isGenericError() {
        return this._tag == Tag.GENERIC_ERROR;
    }

    /**
     * Returns an instance of {@code GetMetadataErrorTagUnion} that has its tag
     * set to {@link Tag#GENERIC_ERROR}.
     *
     * <p> None </p>
     *
     * @param value  value to assign to this instance.
     *
     * @return Instance of {@code GetMetadataErrorTagUnion} with its tag set to
     *     {@link Tag#GENERIC_ERROR}.
     *
     * @throws IllegalArgumentException  if {@code value} is {@code null}.
     */
    public static GetMetadataErrorTagUnion genericError(GenericErrorTag value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GetMetadataErrorTagUnion().withTagAndGenericError(Tag.GENERIC_ERROR, value);
    }

    /**
     * This instance must be tagged as {@link Tag#GENERIC_ERROR}.
     *
     * @return The {@link GenericErrorTag} value associated with this instance
     *     if {@link #isGenericError} is {@code true}.
     *
     * @throws IllegalStateException  If {@link #isGenericError} is {@code
     *     false}.
     */
    public GenericErrorTag getGenericErrorValue() {
        if (this._tag != Tag.GENERIC_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.GENERIC_ERROR, but was Tag." + this._tag.name());
        }
        return genericErrorValue;
    }

    /**
     * Returns {@code true} if this instance has the tag {@link Tag#OTHER},
     * {@code false} otherwise.
     *
     * @return {@code true} if this instance is tagged as {@link Tag#OTHER},
     *     {@code false} otherwise.
     */
    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object [] {
            _tag,
            genericErrorValue
        });
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        else if (obj instanceof GetMetadataErrorTagUnion) {
            GetMetadataErrorTagUnion other = (GetMetadataErrorTagUnion) obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (_tag) {
                case GENERIC_ERROR:
                    return (this.genericErrorValue == other.genericErrorValue) || (this.genericErrorValue.equals(other.genericErrorValue));
                case OTHER:
                    return true;
                default:
                    return false;
            }
        }
        else {
            return false;
        }
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    /**
     * Returns a String representation of this object formatted for easier
     * readability.
     *
     * <p> The returned String may contain newlines. </p>
     *
     * @return Formatted, multiline String representation of this object
     */
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    /**
     * For internal use only.
     */
    static class Serializer extends UnionSerializer<GetMetadataErrorTagUnion> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(GetMetadataErrorTagUnion value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case GENERIC_ERROR: {
                    g.writeStartObject();
                    writeTag("generic_error", g);
                    g.writeFieldName("generic_error");
                    GenericErrorTag.Serializer.INSTANCE.serialize(value.genericErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    g.writeString("other");
                }
            }
        }

        @Override
        public GetMetadataErrorTagUnion deserialize(JsonParser p) throws IOException, JsonParseException {
            GetMetadataErrorTagUnion value;
            boolean collapsed;
            String tag;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = getStringValue(p);
                p.nextToken();
            }
            else {
                collapsed = false;
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: " + TAG_FIELD);
            }
            else if ("generic_error".equals(tag)) {
                GenericErrorTag fieldValue = null;
                expectField("generic_error", p);
                fieldValue = GenericErrorTag.Serializer.INSTANCE.deserialize(p);
                value = GetMetadataErrorTagUnion.genericError(fieldValue);
            }
            else {
                value = GetMetadataErrorTagUnion.OTHER;
            }
            if (!collapsed) {
                skipFields(p);
                expectEndObject(p);
            }
            return value;
        }
    }
}
