/* DO NOT EDIT */
/* This file was generated from cloud_docs_cloud_docs_public_api.stone */

package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

public class GetMetadataResult {
    // struct cloud_docs.GetMetadataResult (cloud_docs_cloud_docs_public_api.stone)

    protected final String fileId;
    protected final String title;
    protected final String mimeType;
    protected final String version;
    protected final String providerVersion;
    protected final UserInfo user;
    protected final boolean isDeleted;
    protected final UserPermissions userPermissions;

    /**
     * Use {@link newBuilder} to create instances of this class without
     * specifying values for all optional fields.
     *
     * @param fileId  Must not be {@code null}.
     * @param title  Title of the Cloud Doc without extension. Must not be
     *     {@code null}.
     * @param mimeType  MIME type of the Cloud Doc. Must not be {@code null}.
     * @param version  Opaque string representing the version of the document
     *     stored in Dropbox (only set for Dropbox-stored Documents). Must not
     *     be {@code null}.
     * @param providerVersion  Application specific string representing the
     *     revision of a document (only set for App-stored Documents). Must not
     *     be {@code null}.
     * @param user  User identified by the auth token.
     * @param isDeleted  true if the document is deleted or purged.
     * @param userPermissions  Actions that the user identified by the auth
     *     token can performn. This message will not be populated for deleted
     *     documents.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public GetMetadataResult(String fileId, String title, String mimeType, String version, String providerVersion, UserInfo user, boolean isDeleted, UserPermissions userPermissions) {
        if (fileId == null) {
            throw new IllegalArgumentException("Required value for 'fileId' is null");
        }
        this.fileId = fileId;
        if (title == null) {
            throw new IllegalArgumentException("Required value for 'title' is null");
        }
        this.title = title;
        if (mimeType == null) {
            throw new IllegalArgumentException("Required value for 'mimeType' is null");
        }
        this.mimeType = mimeType;
        if (version == null) {
            throw new IllegalArgumentException("Required value for 'version' is null");
        }
        this.version = version;
        if (providerVersion == null) {
            throw new IllegalArgumentException("Required value for 'providerVersion' is null");
        }
        this.providerVersion = providerVersion;
        this.user = user;
        this.isDeleted = isDeleted;
        this.userPermissions = userPermissions;
    }

    /**
     * None
     *
     * <p> The default values for unset fields will be used. </p>
     */
    public GetMetadataResult() {
        this("\"\"", "\"\"", "\"\"", "\"\"", "\"\"", null, false, null);
    }

    /**
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     "\"\"".
     */
    public String getFileId() {
        return fileId;
    }

    /**
     * Title of the Cloud Doc without extension.
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     "\"\"".
     */
    public String getTitle() {
        return title;
    }

    /**
     * MIME type of the Cloud Doc.
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     "\"\"".
     */
    public String getMimeType() {
        return mimeType;
    }

    /**
     * Opaque string representing the version of the document stored in Dropbox
     * (only set for Dropbox-stored Documents).
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     "\"\"".
     */
    public String getVersion() {
        return version;
    }

    /**
     * Application specific string representing the revision of a document (only
     * set for App-stored Documents).
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     "\"\"".
     */
    public String getProviderVersion() {
        return providerVersion;
    }

    /**
     * User identified by the auth token.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public UserInfo getUser() {
        return user;
    }

    /**
     * true if the document is deleted or purged.
     *
     * @return value for this field, or {@code null} if not present. Defaults to
     *     false.
     */
    public boolean getIsDeleted() {
        return isDeleted;
    }

    /**
     * Actions that the user identified by the auth token can performn. This
     * message will not be populated for deleted documents.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public UserPermissions getUserPermissions() {
        return userPermissions;
    }

    /**
     * Returns a new builder for creating an instance of this class.
     *
     * @return builder for this class.
     */
    public static Builder newBuilder() {
        return new Builder();
    }

    /**
     * Builder for {@link GetMetadataResult}.
     */
    public static class Builder {

        protected String fileId;
        protected String title;
        protected String mimeType;
        protected String version;
        protected String providerVersion;
        protected UserInfo user;
        protected boolean isDeleted;
        protected UserPermissions userPermissions;

        protected Builder() {
            this.fileId = "\"\"";
            this.title = "\"\"";
            this.mimeType = "\"\"";
            this.version = "\"\"";
            this.providerVersion = "\"\"";
            this.user = null;
            this.isDeleted = false;
            this.userPermissions = null;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code "\"\""}.
         * </p>
         *
         * @param fileId  Must not be {@code null}. Defaults to {@code "\"\""}
         *     when set to {@code null}.
         *
         * @return this builder
         *
         * @throws IllegalArgumentException  If any argument does not meet its
         *     preconditions.
         */
        public Builder withFileId(String fileId) {
            if (fileId != null) {
                this.fileId = fileId;
            }
            else {
                this.fileId = "\"\"";
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code "\"\""}.
         * </p>
         *
         * @param title  Title of the Cloud Doc without extension. Must not be
         *     {@code null}. Defaults to {@code "\"\""} when set to {@code
         *     null}.
         *
         * @return this builder
         *
         * @throws IllegalArgumentException  If any argument does not meet its
         *     preconditions.
         */
        public Builder withTitle(String title) {
            if (title != null) {
                this.title = title;
            }
            else {
                this.title = "\"\"";
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code "\"\""}.
         * </p>
         *
         * @param mimeType  MIME type of the Cloud Doc. Must not be {@code
         *     null}. Defaults to {@code "\"\""} when set to {@code null}.
         *
         * @return this builder
         *
         * @throws IllegalArgumentException  If any argument does not meet its
         *     preconditions.
         */
        public Builder withMimeType(String mimeType) {
            if (mimeType != null) {
                this.mimeType = mimeType;
            }
            else {
                this.mimeType = "\"\"";
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code "\"\""}.
         * </p>
         *
         * @param version  Opaque string representing the version of the
         *     document stored in Dropbox (only set for Dropbox-stored
         *     Documents). Must not be {@code null}. Defaults to {@code "\"\""}
         *     when set to {@code null}.
         *
         * @return this builder
         *
         * @throws IllegalArgumentException  If any argument does not meet its
         *     preconditions.
         */
        public Builder withVersion(String version) {
            if (version != null) {
                this.version = version;
            }
            else {
                this.version = "\"\"";
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code "\"\""}.
         * </p>
         *
         * @param providerVersion  Application specific string representing the
         *     revision of a document (only set for App-stored Documents). Must
         *     not be {@code null}. Defaults to {@code "\"\""} when set to
         *     {@code null}.
         *
         * @return this builder
         *
         * @throws IllegalArgumentException  If any argument does not meet its
         *     preconditions.
         */
        public Builder withProviderVersion(String providerVersion) {
            if (providerVersion != null) {
                this.providerVersion = providerVersion;
            }
            else {
                this.providerVersion = "\"\"";
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * @param user  User identified by the auth token.
         *
         * @return this builder
         */
        public Builder withUser(UserInfo user) {
            this.user = user;
            return this;
        }

        /**
         * Set value for optional field.
         *
         * <p> If left unset or set to {@code null}, defaults to {@code false}.
         * </p>
         *
         * @param isDeleted  true if the document is deleted or purged. Defaults
         *     to {@code false} when set to {@code null}.
         *
         * @return this builder
         */
        public Builder withIsDeleted(Boolean isDeleted) {
            if (isDeleted != null) {
                this.isDeleted = isDeleted;
            }
            else {
                this.isDeleted = false;
            }
            return this;
        }

        /**
         * Set value for optional field.
         *
         * @param userPermissions  Actions that the user identified by the auth
         *     token can performn. This message will not be populated for
         *     deleted documents.
         *
         * @return this builder
         */
        public Builder withUserPermissions(UserPermissions userPermissions) {
            this.userPermissions = userPermissions;
            return this;
        }

        /**
         * Builds an instance of {@link GetMetadataResult} configured with this
         * builder's values
         *
         * @return new instance of {@link GetMetadataResult}
         */
        public GetMetadataResult build() {
            return new GetMetadataResult(fileId, title, mimeType, version, providerVersion, user, isDeleted, userPermissions);
        }
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object [] {
            fileId,
            title,
            mimeType,
            version,
            providerVersion,
            user,
            isDeleted,
            userPermissions
        });
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        // be careful with inheritance
        else if (obj.getClass().equals(this.getClass())) {
            GetMetadataResult other = (GetMetadataResult) obj;
            return ((this.fileId == other.fileId) || (this.fileId.equals(other.fileId)))
                && ((this.title == other.title) || (this.title.equals(other.title)))
                && ((this.mimeType == other.mimeType) || (this.mimeType.equals(other.mimeType)))
                && ((this.version == other.version) || (this.version.equals(other.version)))
                && ((this.providerVersion == other.providerVersion) || (this.providerVersion.equals(other.providerVersion)))
                && ((this.user == other.user) || (this.user != null && this.user.equals(other.user)))
                && (this.isDeleted == other.isDeleted)
                && ((this.userPermissions == other.userPermissions) || (this.userPermissions != null && this.userPermissions.equals(other.userPermissions)))
                ;
        }
        else {
            return false;
        }
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    /**
     * Returns a String representation of this object formatted for easier
     * readability.
     *
     * <p> The returned String may contain newlines. </p>
     *
     * @return Formatted, multiline String representation of this object
     */
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    /**
     * For internal use only.
     */
    static class Serializer extends StructSerializer<GetMetadataResult> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(GetMetadataResult value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("file_id");
            StoneSerializers.string().serialize(value.fileId, g);
            g.writeFieldName("title");
            StoneSerializers.string().serialize(value.title, g);
            g.writeFieldName("mime_type");
            StoneSerializers.string().serialize(value.mimeType, g);
            g.writeFieldName("version");
            StoneSerializers.string().serialize(value.version, g);
            g.writeFieldName("provider_version");
            StoneSerializers.string().serialize(value.providerVersion, g);
            if (value.user != null) {
                g.writeFieldName("user");
                StoneSerializers.nullableStruct(UserInfo.Serializer.INSTANCE).serialize(value.user, g);
            }
            g.writeFieldName("is_deleted");
            StoneSerializers.boolean_().serialize(value.isDeleted, g);
            if (value.userPermissions != null) {
                g.writeFieldName("user_permissions");
                StoneSerializers.nullableStruct(UserPermissions.Serializer.INSTANCE).serialize(value.userPermissions, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public GetMetadataResult deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            GetMetadataResult value;
            String tag = null;
            if (!collapsed) {
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                String f_fileId = "\"\"";
                String f_title = "\"\"";
                String f_mimeType = "\"\"";
                String f_version = "\"\"";
                String f_providerVersion = "\"\"";
                UserInfo f_user = null;
                Boolean f_isDeleted = false;
                UserPermissions f_userPermissions = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.string().deserialize(p);
                    }
                    else if ("title".equals(field)) {
                        f_title = StoneSerializers.string().deserialize(p);
                    }
                    else if ("mime_type".equals(field)) {
                        f_mimeType = StoneSerializers.string().deserialize(p);
                    }
                    else if ("version".equals(field)) {
                        f_version = StoneSerializers.string().deserialize(p);
                    }
                    else if ("provider_version".equals(field)) {
                        f_providerVersion = StoneSerializers.string().deserialize(p);
                    }
                    else if ("user".equals(field)) {
                        f_user = StoneSerializers.nullableStruct(UserInfo.Serializer.INSTANCE).deserialize(p);
                    }
                    else if ("is_deleted".equals(field)) {
                        f_isDeleted = StoneSerializers.boolean_().deserialize(p);
                    }
                    else if ("user_permissions".equals(field)) {
                        f_userPermissions = StoneSerializers.nullableStruct(UserPermissions.Serializer.INSTANCE).deserialize(p);
                    }
                    else {
                        skipValue(p);
                    }
                }
                value = new GetMetadataResult(f_fileId, f_title, f_mimeType, f_version, f_providerVersion, f_user, f_isDeleted, f_userPermissions);
            }
            else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}
