/* DO NOT EDIT */
/* This file was generated by Stone */

package com.dropbox.core.v2.filerequests;

import com.dropbox.core.DbxException;

/**
 * The request builder returned by {@link
 * DbxUserFileRequestsRequests#updateBuilder}.
 *
 * <p> Use this class to set optional request parameters and complete the
 * request. </p>
 */
public class UpdateBuilder {
    private final DbxUserFileRequestsRequests _client;
    private final UpdateFileRequestArgs.Builder _builder;

    /**
     * Creates a new instance of this builder.
     *
     * @param _client  Dropbox namespace-specific client used to issue
     *     file_requests requests.
     * @param _builder  Request argument builder.
     *
     * @return instsance of this builder
     */
    UpdateBuilder(DbxUserFileRequestsRequests _client, UpdateFileRequestArgs.Builder _builder) {
        if (_client == null) {
            throw new NullPointerException("_client");
        }
        this._client = _client;
        if (_builder == null) {
            throw new NullPointerException("_builder");
        }
        this._builder = _builder;
    }

    /**
     * Set value for optional field.
     *
     * @param title  The new title of the file request. Must not be empty. Must
     *     have length of at least 1.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UpdateBuilder withTitle(String title) {
        this._builder.withTitle(title);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * @param destination  The new path of the folder in the Dropbox where
     *     uploaded files will be sent. For apps with the app folder permission,
     *     this will be relative to the app folder. Must match pattern "{@code
     *     /(.|[\\r\\n])*}".
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UpdateBuilder withDestination(String destination) {
        this._builder.withDestination(destination);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * <p> If left unset or set to {@code null}, defaults to {@code
     * UpdateFileRequestDeadline.NO_UPDATE}. </p>
     *
     * @param deadline  The new deadline for the file request. Deadlines can
     *     only be set by Professional and Business accounts. Must not be {@code
     *     null}. Defaults to {@code UpdateFileRequestDeadline.NO_UPDATE} when
     *     set to {@code null}.
     *
     * @return this builder
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    public UpdateBuilder withDeadline(UpdateFileRequestDeadline deadline) {
        this._builder.withDeadline(deadline);
        return this;
    }

    /**
     * Set value for optional field.
     *
     * @param open  Whether to set this file request as open or closed.
     *
     * @return this builder
     */
    public UpdateBuilder withOpen(Boolean open) {
        this._builder.withOpen(open);
        return this;
    }

    /**
     * Issues the request.
     */
    public FileRequest start() throws UpdateFileRequestErrorException, DbxException {
        UpdateFileRequestArgs arg_ = this._builder.build();
        return _client.update(arg_);
    }
}
