/* DO NOT EDIT */
/* This file was generated from paper.stone */

package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;

/**
 * This class is a tagged union.  Tagged unions instances are always associated
 * to a specific tag.  This means only one of the {@code isAbc()} methods will
 * return {@code true}. You can use {@link #tag()} to determine the tag
 * associated with this instance.
 */
public final class ListUsersCursorError {
    // union paper.ListUsersCursorError (paper.stone)

    /**
     * Discriminating tag type for {@link ListUsersCursorError}.
     */
    public enum Tag {
        /**
         * Your account does not have permissions to perform this action. This
         * may be due to it only having access to Paper as files in the Dropbox
         * filesystem. For more information, refer to the <a
         * href="https://www.dropbox.com/lp/developers/reference/paper-migration-guide">Paper
         * Migration Guide</a>.
         */
        INSUFFICIENT_PERMISSIONS,
        /**
         * Catch-all used for unknown tag values returned by the Dropbox
         * servers.
         *
         * <p> Receiving a catch-all value typically indicates this SDK version
         * is not up to date. Consider updating your SDK version to handle the
         * new tags. </p>
         */
        OTHER,
        /**
         * The required doc was not found.
         */
        DOC_NOT_FOUND,
        CURSOR_ERROR; // PaperApiCursorError
    }

    /**
     * Your account does not have permissions to perform this action. This may
     * be due to it only having access to Paper as files in the Dropbox
     * filesystem. For more information, refer to the <a
     * href="https://www.dropbox.com/lp/developers/reference/paper-migration-guide">Paper
     * Migration Guide</a>.
     */
    public static final ListUsersCursorError INSUFFICIENT_PERMISSIONS = new ListUsersCursorError().withTag(Tag.INSUFFICIENT_PERMISSIONS);
    /**
     * Catch-all used for unknown tag values returned by the Dropbox servers.
     *
     * <p> Receiving a catch-all value typically indicates this SDK version is
     * not up to date. Consider updating your SDK version to handle the new
     * tags. </p>
     */
    public static final ListUsersCursorError OTHER = new ListUsersCursorError().withTag(Tag.OTHER);
    /**
     * The required doc was not found.
     */
    public static final ListUsersCursorError DOC_NOT_FOUND = new ListUsersCursorError().withTag(Tag.DOC_NOT_FOUND);

    private Tag _tag;
    private PaperApiCursorError cursorErrorValue;

    /**
     * Private default constructor, so that object is uninitializable publicly.
     */
    private ListUsersCursorError() {
    }


    /**
     *
     * @param _tag  Discriminating tag for this instance.
     */
    private ListUsersCursorError withTag(Tag _tag) {
        ListUsersCursorError result = new ListUsersCursorError();
        result._tag = _tag;
        return result;
    }

    /**
     *
     * @param cursorErrorValue  Must not be {@code null}.
     * @param _tag  Discriminating tag for this instance.
     *
     * @throws IllegalArgumentException  If any argument does not meet its
     *     preconditions.
     */
    private ListUsersCursorError withTagAndCursorError(Tag _tag, PaperApiCursorError cursorErrorValue) {
        ListUsersCursorError result = new ListUsersCursorError();
        result._tag = _tag;
        result.cursorErrorValue = cursorErrorValue;
        return result;
    }

    /**
     * Returns the tag for this instance.
     *
     * <p> This class is a tagged union.  Tagged unions instances are always
     * associated to a specific tag.  This means only one of the {@code isXyz()}
     * methods will return {@code true}. Callers are recommended to use the tag
     * value in a {@code switch} statement to properly handle the different
     * values for this {@code ListUsersCursorError}. </p>
     *
     * @return the tag for this instance.
     */
    public Tag tag() {
        return _tag;
    }

    /**
     * Returns {@code true} if this instance has the tag {@link
     * Tag#INSUFFICIENT_PERMISSIONS}, {@code false} otherwise.
     *
     * @return {@code true} if this instance is tagged as {@link
     *     Tag#INSUFFICIENT_PERMISSIONS}, {@code false} otherwise.
     */
    public boolean isInsufficientPermissions() {
        return this._tag == Tag.INSUFFICIENT_PERMISSIONS;
    }

    /**
     * Returns {@code true} if this instance has the tag {@link Tag#OTHER},
     * {@code false} otherwise.
     *
     * @return {@code true} if this instance is tagged as {@link Tag#OTHER},
     *     {@code false} otherwise.
     */
    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    /**
     * Returns {@code true} if this instance has the tag {@link
     * Tag#DOC_NOT_FOUND}, {@code false} otherwise.
     *
     * @return {@code true} if this instance is tagged as {@link
     *     Tag#DOC_NOT_FOUND}, {@code false} otherwise.
     */
    public boolean isDocNotFound() {
        return this._tag == Tag.DOC_NOT_FOUND;
    }

    /**
     * Returns {@code true} if this instance has the tag {@link
     * Tag#CURSOR_ERROR}, {@code false} otherwise.
     *
     * @return {@code true} if this instance is tagged as {@link
     *     Tag#CURSOR_ERROR}, {@code false} otherwise.
     */
    public boolean isCursorError() {
        return this._tag == Tag.CURSOR_ERROR;
    }

    /**
     * Returns an instance of {@code ListUsersCursorError} that has its tag set
     * to {@link Tag#CURSOR_ERROR}.
     *
     * <p> None </p>
     *
     * @param value  value to assign to this instance.
     *
     * @return Instance of {@code ListUsersCursorError} with its tag set to
     *     {@link Tag#CURSOR_ERROR}.
     *
     * @throws IllegalArgumentException  if {@code value} is {@code null}.
     */
    public static ListUsersCursorError cursorError(PaperApiCursorError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new ListUsersCursorError().withTagAndCursorError(Tag.CURSOR_ERROR, value);
    }

    /**
     * This instance must be tagged as {@link Tag#CURSOR_ERROR}.
     *
     * @return The {@link PaperApiCursorError} value associated with this
     *     instance if {@link #isCursorError} is {@code true}.
     *
     * @throws IllegalStateException  If {@link #isCursorError} is {@code
     *     false}.
     */
    public PaperApiCursorError getCursorErrorValue() {
        if (this._tag != Tag.CURSOR_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.CURSOR_ERROR, but was Tag." + this._tag.name());
        }
        return cursorErrorValue;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object [] {
            _tag,
            cursorErrorValue
        });
        hash = (31 * super.hashCode()) + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        else if (obj instanceof ListUsersCursorError) {
            ListUsersCursorError other = (ListUsersCursorError) obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (_tag) {
                case INSUFFICIENT_PERMISSIONS:
                    return true;
                case OTHER:
                    return true;
                case DOC_NOT_FOUND:
                    return true;
                case CURSOR_ERROR:
                    return (this.cursorErrorValue == other.cursorErrorValue) || (this.cursorErrorValue.equals(other.cursorErrorValue));
                default:
                    return false;
            }
        }
        else {
            return false;
        }
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    /**
     * Returns a String representation of this object formatted for easier
     * readability.
     *
     * <p> The returned String may contain newlines. </p>
     *
     * @return Formatted, multiline String representation of this object
     */
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    /**
     * For internal use only.
     */
    static class Serializer extends UnionSerializer<ListUsersCursorError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(ListUsersCursorError value, JsonGenerator g) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case INSUFFICIENT_PERMISSIONS: {
                    g.writeString("insufficient_permissions");
                    break;
                }
                case OTHER: {
                    g.writeString("other");
                    break;
                }
                case DOC_NOT_FOUND: {
                    g.writeString("doc_not_found");
                    break;
                }
                case CURSOR_ERROR: {
                    g.writeStartObject();
                    writeTag("cursor_error", g);
                    g.writeFieldName("cursor_error");
                    PaperApiCursorError.Serializer.INSTANCE.serialize(value.cursorErrorValue, g);
                    g.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + value.tag());
                }
            }
        }

        @Override
        public ListUsersCursorError deserialize(JsonParser p) throws IOException, JsonParseException {
            ListUsersCursorError value;
            boolean collapsed;
            String tag;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = getStringValue(p);
                p.nextToken();
            }
            else {
                collapsed = false;
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: " + TAG_FIELD);
            }
            else if ("insufficient_permissions".equals(tag)) {
                value = ListUsersCursorError.INSUFFICIENT_PERMISSIONS;
            }
            else if ("other".equals(tag)) {
                value = ListUsersCursorError.OTHER;
            }
            else if ("doc_not_found".equals(tag)) {
                value = ListUsersCursorError.DOC_NOT_FOUND;
            }
            else if ("cursor_error".equals(tag)) {
                PaperApiCursorError fieldValue = null;
                expectField("cursor_error", p);
                fieldValue = PaperApiCursorError.Serializer.INSTANCE.deserialize(p);
                value = ListUsersCursorError.cursorError(fieldValue);
            }
            else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                skipFields(p);
                expectEndObject(p);
            }
            return value;
        }
    }
}
