/* DO NOT EDIT */
/* This file was generated from shared_links.stone */

package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;

import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class SharedLinkSettings {
    // struct sharing.SharedLinkSettings (shared_links.stone)

    protected final RequestedVisibility requestedVisibility;
    protected final String linkPassword;
    protected final Date expires;
    protected final LinkAudience audience;
    protected final RequestedLinkAccessLevel access;

    /**
     * Use {@link newBuilder} to create instances of this class without
     * specifying values for all optional fields.
     *
     * @param requestedVisibility  The requested access for this shared link.
     * @param linkPassword  If {@link SharedLinkSettings#getRequestedVisibility}
     *     is {@link RequestedVisibility#PASSWORD} this is needed to specify the
     *     password to access the link.
     * @param expires  Expiration time of the shared link. By default the link
     *     won't expire.
     * @param audience  The new audience who can benefit from the access level
     *     specified by the link's access level specified in the
     *     `link_access_level` field of `LinkPermissions`. This is used in
     *     conjunction with team policies and shared folder policies to
     *     determine the final effective audience type in the
     *     `effective_audience` field of `LinkPermissions.
     * @param access  Requested access level you want the audience to gain from
     *     this link. Note, modifying access level for an existing link is not
     *     supported.
     */
    public SharedLinkSettings(RequestedVisibility requestedVisibility, String linkPassword, Date expires, LinkAudience audience, RequestedLinkAccessLevel access) {
        this.requestedVisibility = requestedVisibility;
        this.linkPassword = linkPassword;
        this.expires = LangUtil.truncateMillis(expires);
        this.audience = audience;
        this.access = access;
    }

    /**
     * None
     *
     * <p> The default values for unset fields will be used. </p>
     */
    public SharedLinkSettings() {
        this(null, null, null, null, null);
    }

    /**
     * The requested access for this shared link.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public RequestedVisibility getRequestedVisibility() {
        return requestedVisibility;
    }

    /**
     * If {@link SharedLinkSettings#getRequestedVisibility} is {@link
     * RequestedVisibility#PASSWORD} this is needed to specify the password to
     * access the link.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public String getLinkPassword() {
        return linkPassword;
    }

    /**
     * Expiration time of the shared link. By default the link won't expire.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public Date getExpires() {
        return expires;
    }

    /**
     * The new audience who can benefit from the access level specified by the
     * link's access level specified in the `link_access_level` field of
     * `LinkPermissions`. This is used in conjunction with team policies and
     * shared folder policies to determine the final effective audience type in
     * the `effective_audience` field of `LinkPermissions.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public LinkAudience getAudience() {
        return audience;
    }

    /**
     * Requested access level you want the audience to gain from this link.
     * Note, modifying access level for an existing link is not supported.
     *
     * @return value for this field, or {@code null} if not present.
     */
    public RequestedLinkAccessLevel getAccess() {
        return access;
    }

    /**
     * Returns a new builder for creating an instance of this class.
     *
     * @return builder for this class.
     */
    public static Builder newBuilder() {
        return new Builder();
    }

    /**
     * Builder for {@link SharedLinkSettings}.
     */
    public static class Builder {

        protected RequestedVisibility requestedVisibility;
        protected String linkPassword;
        protected Date expires;
        protected LinkAudience audience;
        protected RequestedLinkAccessLevel access;

        protected Builder() {
            this.requestedVisibility = null;
            this.linkPassword = null;
            this.expires = null;
            this.audience = null;
            this.access = null;
        }

        /**
         * Set value for optional field.
         *
         * @param requestedVisibility  The requested access for this shared
         *     link.
         *
         * @return this builder
         */
        public Builder withRequestedVisibility(RequestedVisibility requestedVisibility) {
            this.requestedVisibility = requestedVisibility;
            return this;
        }

        /**
         * Set value for optional field.
         *
         * @param linkPassword  If {@link
         *     SharedLinkSettings#getRequestedVisibility} is {@link
         *     RequestedVisibility#PASSWORD} this is needed to specify the
         *     password to access the link.
         *
         * @return this builder
         */
        public Builder withLinkPassword(String linkPassword) {
            this.linkPassword = linkPassword;
            return this;
        }

        /**
         * Set value for optional field.
         *
         * @param expires  Expiration time of the shared link. By default the
         *     link won't expire.
         *
         * @return this builder
         */
        public Builder withExpires(Date expires) {
            this.expires = LangUtil.truncateMillis(expires);
            return this;
        }

        /**
         * Set value for optional field.
         *
         * @param audience  The new audience who can benefit from the access
         *     level specified by the link's access level specified in the
         *     `link_access_level` field of `LinkPermissions`. This is used in
         *     conjunction with team policies and shared folder policies to
         *     determine the final effective audience type in the
         *     `effective_audience` field of `LinkPermissions.
         *
         * @return this builder
         */
        public Builder withAudience(LinkAudience audience) {
            this.audience = audience;
            return this;
        }

        /**
         * Set value for optional field.
         *
         * @param access  Requested access level you want the audience to gain
         *     from this link. Note, modifying access level for an existing link
         *     is not supported.
         *
         * @return this builder
         */
        public Builder withAccess(RequestedLinkAccessLevel access) {
            this.access = access;
            return this;
        }

        /**
         * Builds an instance of {@link SharedLinkSettings} configured with this
         * builder's values
         *
         * @return new instance of {@link SharedLinkSettings}
         */
        public SharedLinkSettings build() {
            return new SharedLinkSettings(requestedVisibility, linkPassword, expires, audience, access);
        }
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object [] {
            requestedVisibility,
            linkPassword,
            expires,
            audience,
            access
        });
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        // be careful with inheritance
        else if (obj.getClass().equals(this.getClass())) {
            SharedLinkSettings other = (SharedLinkSettings) obj;
            return ((this.requestedVisibility == other.requestedVisibility) || (this.requestedVisibility != null && this.requestedVisibility.equals(other.requestedVisibility)))
                && ((this.linkPassword == other.linkPassword) || (this.linkPassword != null && this.linkPassword.equals(other.linkPassword)))
                && ((this.expires == other.expires) || (this.expires != null && this.expires.equals(other.expires)))
                && ((this.audience == other.audience) || (this.audience != null && this.audience.equals(other.audience)))
                && ((this.access == other.access) || (this.access != null && this.access.equals(other.access)))
                ;
        }
        else {
            return false;
        }
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    /**
     * Returns a String representation of this object formatted for easier
     * readability.
     *
     * <p> The returned String may contain newlines. </p>
     *
     * @return Formatted, multiline String representation of this object
     */
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    /**
     * For internal use only.
     */
    static class Serializer extends StructSerializer<SharedLinkSettings> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(SharedLinkSettings value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            if (value.requestedVisibility != null) {
                g.writeFieldName("requested_visibility");
                StoneSerializers.nullable(RequestedVisibility.Serializer.INSTANCE).serialize(value.requestedVisibility, g);
            }
            if (value.linkPassword != null) {
                g.writeFieldName("link_password");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.linkPassword, g);
            }
            if (value.expires != null) {
                g.writeFieldName("expires");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expires, g);
            }
            if (value.audience != null) {
                g.writeFieldName("audience");
                StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).serialize(value.audience, g);
            }
            if (value.access != null) {
                g.writeFieldName("access");
                StoneSerializers.nullable(RequestedLinkAccessLevel.Serializer.INSTANCE).serialize(value.access, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public SharedLinkSettings deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            SharedLinkSettings value;
            String tag = null;
            if (!collapsed) {
                expectStartObject(p);
                tag = readTag(p);
            }
            if (tag == null) {
                RequestedVisibility f_requestedVisibility = null;
                String f_linkPassword = null;
                Date f_expires = null;
                LinkAudience f_audience = null;
                RequestedLinkAccessLevel f_access = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("requested_visibility".equals(field)) {
                        f_requestedVisibility = StoneSerializers.nullable(RequestedVisibility.Serializer.INSTANCE).deserialize(p);
                    }
                    else if ("link_password".equals(field)) {
                        f_linkPassword = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                    }
                    else if ("expires".equals(field)) {
                        f_expires = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                    }
                    else if ("audience".equals(field)) {
                        f_audience = StoneSerializers.nullable(LinkAudience.Serializer.INSTANCE).deserialize(p);
                    }
                    else if ("access".equals(field)) {
                        f_access = StoneSerializers.nullable(RequestedLinkAccessLevel.Serializer.INSTANCE).deserialize(p);
                    }
                    else {
                        skipValue(p);
                    }
                }
                value = new SharedLinkSettings(f_requestedVisibility, f_linkPassword, f_expires, f_audience, f_access);
            }
            else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}
