/*
 * Decompiled with CFR 0.152.
 */
package com.dyngr.core;

import com.dyngr.Poller;
import com.dyngr.core.Attempt;
import com.dyngr.core.AttemptMaker;
import com.dyngr.core.AttemptResult;
import com.dyngr.core.AttemptResults;
import com.dyngr.core.AttemptState;
import com.dyngr.core.DefaultAttempt;
import com.dyngr.core.StopStrategy;
import com.dyngr.core.WaitStrategy;
import com.dyngr.exception.PollerInterruptedException;
import com.dyngr.exception.PollerStoppedException;
import com.dyngr.exception.UserBreakException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultPoller<V>
implements Poller<V> {
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final ExecutorService executor;
    private final StopStrategy stopStrategy;
    private final WaitStrategy waitStrategy;
    private final AttemptMaker<V> maker;

    public DefaultPoller(AttemptMaker<V> maker, StopStrategy stopStrategy, WaitStrategy waitStrategy, ExecutorService executor) {
        this.maker = maker;
        this.stopStrategy = stopStrategy;
        this.waitStrategy = waitStrategy;
        this.executor = executor;
    }

    @Override
    public Future<V> start() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Poller already started");
        }
        return this.executor.submit(new PollerCallable<V>(this.maker, this.stopStrategy, this.waitStrategy));
    }

    private static class PollerCallable<V>
    implements Callable<V> {
        private final AttemptMaker<V> maker;
        private final StopStrategy stopStrategy;
        private final WaitStrategy waitStrategy;

        public PollerCallable(AttemptMaker<V> maker, StopStrategy stopStrategy, WaitStrategy waitStrategy) {
            this.maker = maker;
            this.stopStrategy = stopStrategy;
            this.waitStrategy = waitStrategy;
        }

        @Override
        public V call() throws Exception {
            long startTime = System.currentTimeMillis();
            int attemptCount = 1;
            while (true) {
                AttemptResult<V> result;
                try {
                    result = this.maker.process();
                }
                catch (Throwable e) {
                    result = AttemptResults.continueFor(e);
                }
                if (result == null) {
                    throw new IllegalStateException("AttemptMaker has returned a null result");
                }
                AttemptState state = result.getState();
                if (state == AttemptState.BREAK) {
                    throw new UserBreakException(result.getMessage(), result.getCause());
                }
                if (state == AttemptState.FINISH) {
                    return result.getResult();
                }
                Attempt failedAttempt = this.buildAttempt(attemptCount, startTime, System.currentTimeMillis(), result.getCause());
                if (this.stopStrategy.shouldStop(failedAttempt)) {
                    if (failedAttempt.hasException()) {
                        throw new PollerStoppedException(failedAttempt.getExceptionCause());
                    }
                    throw new PollerStoppedException();
                }
                long waitTime = this.waitStrategy.computeWaitTime(failedAttempt);
                try {
                    Thread.sleep(waitTime);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new PollerInterruptedException(e);
                }
                ++attemptCount;
            }
        }

        private Attempt buildAttempt(int attemptNumber, long startTime, long lastEndTime, Throwable cause) {
            return new DefaultAttempt(attemptNumber, startTime, lastEndTime, cause);
        }
    }
}

