/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import java.time.Instant;
import java.util.Map;

class ErrorResponse {
    private final String reason;
    private final Instant timestamp;

    public ErrorResponse(String reason, Instant timestamp) {
        this.reason = reason;
        this.timestamp = timestamp;
    }

    static ErrorResponse fromMap(Map<String, Object> errorResponseMap) {
        Instant timestamp;
        String reason;
        try {
            reason = (String)errorResponseMap.get("reason");
        }
        catch (ClassCastException e) {
            reason = null;
        }
        if (errorResponseMap.containsKey("timestamp")) {
            try {
                timestamp = Instant.ofEpochMilli((Long)errorResponseMap.get("timestamp"));
            }
            catch (ClassCastException e) {
                timestamp = null;
            }
        } else {
            timestamp = null;
        }
        return new ErrorResponse(reason, timestamp);
    }

    String getReason() {
        return this.reason;
    }

    Instant getTimestamp() {
        return this.timestamp;
    }
}

