/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.AttributeStreamBase;
import com.esri.core.geometry.AttributeStreamOfDbl;
import com.esri.core.geometry.AttributeStreamOfInt32;
import com.esri.core.geometry.AttributeStreamOfInt8;
import com.esri.core.geometry.Boundary;
import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryAccelerators;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.InternalUtils;
import com.esri.core.geometry.MathUtils;
import com.esri.core.geometry.MultiVertexGeometryImpl;
import com.esri.core.geometry.NumberUtils;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.Point3D;
import com.esri.core.geometry.QuadTreeImpl;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.Segment;
import com.esri.core.geometry.SegmentBuffer;
import com.esri.core.geometry.SegmentIteratorImpl;
import com.esri.core.geometry.Transformation2D;
import com.esri.core.geometry.Transformation3D;
import com.esri.core.geometry.VertexDescription;
import com.esri.core.geometry.VertexDescriptionDesignerImpl;

final class MultiPathImpl
extends MultiVertexGeometryImpl {
    protected boolean m_bPolygon;
    protected Point m_moveToPoint;
    protected double m_cachedLength2D;
    protected double m_cachedArea2D;
    protected AttributeStreamOfDbl m_cachedRingAreas2D;
    protected boolean m_bPathStarted;
    protected AttributeStreamOfInt32 m_paths;
    protected AttributeStreamOfInt8 m_pathFlags;
    protected AttributeStreamOfInt8 m_segmentFlags;
    protected AttributeStreamOfInt32 m_segmentParamIndex;
    protected AttributeStreamOfDbl m_segmentParams;
    protected int m_curveParamwritePoint;
    private int m_currentPathIndex;
    private int m_fill_rule = 0;
    static int[] _segmentParamSizes = new int[]{0, 0, 6, 0, 8, 0};

    public boolean hasNonLinearSegments() {
        return this.m_curveParamwritePoint > 0;
    }

    public MultiPathImpl(boolean bPolygon) {
        this.m_bPolygon = bPolygon;
        this.m_bPathStarted = false;
        this.m_curveParamwritePoint = 0;
        this.m_cachedLength2D = 0.0;
        this.m_cachedArea2D = 0.0;
        this.m_pointCount = 0;
        this.m_description = VertexDescriptionDesignerImpl.getDefaultDescriptor2D();
        this.m_cachedRingAreas2D = null;
        this.m_currentPathIndex = 0;
    }

    public MultiPathImpl(boolean bPolygon, VertexDescription description) {
        if (description == null) {
            throw new IllegalArgumentException();
        }
        this.m_bPolygon = bPolygon;
        this.m_bPathStarted = false;
        this.m_curveParamwritePoint = 0;
        this.m_cachedLength2D = 0.0;
        this.m_cachedArea2D = 0.0;
        this.m_pointCount = 0;
        this.m_description = description;
        this.m_cachedRingAreas2D = null;
        this.m_currentPathIndex = 0;
    }

    protected void _initPathStartPoint() {
        this._touch();
        if (this.m_moveToPoint == null) {
            this.m_moveToPoint = new Point(this.m_description);
        } else {
            this.m_moveToPoint.assignVertexDescription(this.m_description);
        }
    }

    public void startPath(double x, double y) {
        Point2D endPoint = new Point2D();
        endPoint.x = x;
        endPoint.y = y;
        this.startPath(endPoint);
    }

    public void startPath(Point2D point) {
        this._initPathStartPoint();
        this.m_moveToPoint.setXY(point);
        this.m_bPathStarted = true;
    }

    public void startPath(Point3D point) {
        this._initPathStartPoint();
        this.m_moveToPoint.setXYZ(point);
        this.assignVertexDescription(this.m_moveToPoint.getDescription());
        this.m_bPathStarted = true;
    }

    public void startPath(Point point) {
        if (point.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.mergeVertexDescription(point.getDescription());
        this._initPathStartPoint();
        point.copyTo(this.m_moveToPoint);
        this.m_bPathStarted = true;
    }

    protected void _beforeNewSegment(int resizeBy) {
        if (this.m_bPathStarted) {
            this._initPathStartPoint();
            if (this.m_paths == null) {
                this.m_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(2);
                this.m_paths.write(0, 0);
                this.m_pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(2, (byte)0);
            } else {
                this.m_paths.resize(this.m_paths.size() + 1, 0.0);
                this.m_pathFlags.resize(this.m_pathFlags.size() + 1, 0.0);
            }
            if (this.m_bPolygon) {
                this.m_pathFlags.write(this.m_pathFlags.size() - 2, (byte)1);
            }
            ++resizeBy;
        }
        int oldcount = this.m_pointCount;
        this.m_paths.write(this.m_paths.size() - 1, this.m_pointCount + resizeBy);
        this._resizeImpl(oldcount + resizeBy);
        this.m_pathFlags.write(this.m_paths.size() - 1, (byte)0);
        if (this.m_bPathStarted) {
            this.setPointByVal(oldcount, this.m_moveToPoint);
            this.m_bPathStarted = false;
        }
    }

    protected void _finishLineTo() {
    }

    public void lineTo(double x, double y) {
        this._beforeNewSegment(1);
        this.setXY(this.m_pointCount - 1, x, y);
        this._finishLineTo();
    }

    public void lineTo(Point2D endPoint) {
        this._beforeNewSegment(1);
        this.setXY(this.m_pointCount - 1, endPoint);
        this._finishLineTo();
    }

    public void lineTo(Point3D endPoint) {
        this._beforeNewSegment(1);
        this.setXYZ(this.m_pointCount - 1, endPoint);
        this._finishLineTo();
    }

    public void lineTo(Point endPoint) {
        this._beforeNewSegment(1);
        this.setPointByVal(this.m_pointCount - 1, endPoint);
        this._finishLineTo();
    }

    protected void _initSegmentData(int sz) {
        if (this.m_segmentParamIndex == null) {
            this.m_segmentFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(this.m_pointCount, (byte)1);
            this.m_segmentParamIndex = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(this.m_pointCount, -1);
        }
        int size = this.m_curveParamwritePoint + sz;
        if (this.m_segmentParams == null) {
            this.m_segmentParams = (AttributeStreamOfDbl)AttributeStreamBase.createAttributeStreamWithPersistence(1, size);
        } else {
            this.m_segmentParams.resize(size, 0.0);
        }
    }

    protected void _finishBezierTo() {
        this.m_segmentFlags.write(this.m_pointCount - 2, (byte)2);
    }

    public void bezierTo(Point2D controlPoint1, Point2D controlPoint2, Point2D endPoint) {
        this._beforeNewSegment(1);
        this.setXY(this.m_pointCount - 1, endPoint);
        this._initSegmentData(6);
        this.m_pathFlags.setBits(this.m_pathFlags.size() - 1, (byte)2);
        this.m_segmentParamIndex.write(this.m_pointCount - 2, this.m_curveParamwritePoint);
        this.m_curveParamwritePoint += 6;
        int curveIndex = this.m_curveParamwritePoint;
        this.m_segmentParams.write(curveIndex, controlPoint1.x);
        this.m_segmentParams.write(curveIndex + 1, controlPoint1.y);
        double z = 0.0;
        this.m_segmentParams.write(curveIndex + 2, z);
        this.m_segmentParams.write(curveIndex + 3, controlPoint2.x);
        this.m_segmentParams.write(curveIndex + 4, controlPoint2.y);
        z = 0.0;
        this.m_segmentParams.write(curveIndex + 5, z);
        this._finishBezierTo();
    }

    public void openPath(int pathIndex) {
        this._touch();
        if (this.m_bPolygon) {
            throw GeometryException.GeometryInternalError();
        }
        int pathCount = this.getPathCount();
        if (pathIndex > this.getPathCount()) {
            throw new IllegalArgumentException();
        }
        if (this.m_pathFlags == null) {
            throw GeometryException.GeometryInternalError();
        }
        this.m_pathFlags.clearBits(pathIndex, (byte)1);
    }

    public void openPathAndDuplicateStartVertex(int pathIndex) {
        this._touch();
        if (this.m_bPolygon) {
            throw GeometryException.GeometryInternalError();
        }
        int pathCount = this.getPathCount();
        if (pathIndex > pathCount) {
            throw GeometryException.GeometryInternalError();
        }
        if (!this.isClosedPath(pathIndex)) {
            return;
        }
        if (this.m_pathFlags == null) {
            throw GeometryException.GeometryInternalError();
        }
        int oldPointCount = this.m_pointCount;
        int pathIndexStart = this.getPathStart(pathIndex);
        int pathIndexEnd = this.getPathEnd(pathIndex);
        this._resizeImpl(this.m_pointCount + 1);
        this._verifyAllStreams();
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * pathIndexEnd, this.m_vertexAttributes[iattr], comp * pathIndexStart, comp, true, 1, comp * oldPointCount);
        }
        for (int ipath = pathCount; ipath > pathIndex; --ipath) {
            int iend = this.m_paths.read(ipath);
            this.m_paths.write(ipath, iend + 1);
        }
        this.m_pathFlags.clearBits(pathIndex, (byte)1);
    }

    public void openAllPathsAndDuplicateStartVertex() {
        this._touch();
        if (this.m_bPolygon) {
            throw GeometryException.GeometryInternalError();
        }
        if (this.m_pathFlags == null) {
            throw GeometryException.GeometryInternalError();
        }
        this._verifyAllStreams();
        int closedPathCount = 0;
        int pathCount = this.getPathCount();
        for (int i = 0; i < pathCount; ++i) {
            if (this.m_pathFlags.read(i) != 1) continue;
            ++closedPathCount;
        }
        int nattr = this.m_description.getAttributeCount();
        block1: for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            int newSize = comp * (this.m_pointCount + closedPathCount);
            this.m_vertexAttributes[iattr].resize(newSize);
            int offset = closedPathCount;
            int ipath = pathCount;
            for (int i = this.m_pointCount - 1; i >= 0; --i) {
                if (i + 1 == this.m_paths.read(ipath) && this.m_pathFlags.read(--ipath) == 1) {
                    int istart = this.m_paths.read(ipath);
                    for (int c = 0; c < comp; ++c) {
                        double v = this.m_vertexAttributes[iattr].readAsDbl(comp * istart + c);
                        this.m_vertexAttributes[iattr].writeAsDbl(comp * (offset + i) + c, v);
                    }
                    if (--offset == 0) continue block1;
                }
                for (int c = 0; c < comp; ++c) {
                    double v = this.m_vertexAttributes[iattr].readAsDbl(comp * i + c);
                    this.m_vertexAttributes[iattr].writeAsDbl(comp * (offset + i) + c, v);
                }
            }
        }
        int offset = closedPathCount;
        for (int ipath = pathCount; ipath > 0; --ipath) {
            int iend = this.m_paths.read(ipath);
            this.m_paths.write(ipath, iend + offset);
            if (this.m_pathFlags.read(ipath - 1) != 1) continue;
            this.m_pathFlags.clearBits(ipath - 1, (byte)1);
            if (--offset == 0) break;
        }
        this.m_pointCount += closedPathCount;
    }

    void closePathWithLine(int path_index) {
        this.throwIfEmpty();
        byte pf = this.m_pathFlags.read(path_index);
        this.m_pathFlags.write(path_index, (byte)(pf | 1));
        if (this.m_segmentFlags != null) {
            int vindex = this.getPathEnd(path_index) - 1;
            this.m_segmentFlags.write(vindex, (byte)1);
            this.m_segmentParamIndex.write(vindex, -1);
        }
    }

    void closePathWithLine() {
        this.throwIfEmpty();
        this.m_bPathStarted = false;
        this.closePathWithLine(this.getPathCount() - 1);
    }

    public void closeAllPaths() {
        this._touch();
        if (this.m_bPolygon || this.isEmptyImpl()) {
            return;
        }
        this.m_bPathStarted = false;
        int npart = this.m_paths.size() - 1;
        for (int ipath = 0; ipath < npart; ++ipath) {
            if (this.isClosedPath(ipath)) continue;
            byte pf = this.m_pathFlags.read(ipath);
            this.m_pathFlags.write(ipath, (byte)(pf | 1));
        }
    }

    public static int getSegmentDataSize(byte flag) {
        return _segmentParamSizes[flag];
    }

    public void closePathWithBezier(Point2D controlPoint1, Point2D controlPoint2) {
        this._touch();
        if (this.isEmptyImpl()) {
            throw new GeometryException("Invalid call. This operation cannot be performed on an empty geometry.");
        }
        this.m_bPathStarted = false;
        int pathIndex = this.m_paths.size() - 2;
        byte pf = this.m_pathFlags.read(pathIndex);
        this.m_pathFlags.write(pathIndex, (byte)(pf | 1 | 2));
        this._initSegmentData(6);
        byte oldType = this.m_segmentFlags.read((byte)(this.m_pointCount - 1 & 7));
        this.m_segmentFlags.write(this.m_pointCount - 1, (byte)2);
        int curveIndex = this.m_curveParamwritePoint;
        if (MultiPathImpl.getSegmentDataSize(oldType) < MultiPathImpl.getSegmentDataSize((byte)2)) {
            this.m_segmentParamIndex.write(this.m_pointCount - 1, this.m_curveParamwritePoint);
            this.m_curveParamwritePoint += 6;
        } else {
            curveIndex = this.m_segmentParamIndex.read(this.m_pointCount - 1);
        }
        this.m_segmentParams.write(curveIndex, controlPoint1.x);
        this.m_segmentParams.write(curveIndex + 1, controlPoint1.y);
        double z = 0.0;
        this.m_segmentParams.write(curveIndex + 2, z);
        this.m_segmentParams.write(curveIndex + 3, controlPoint2.x);
        this.m_segmentParams.write(curveIndex + 4, controlPoint2.y);
        z = 0.0;
        this.m_segmentParams.write(curveIndex + 5, z);
    }

    public boolean isClosedPath(int ipath) {
        return (byte)(this.m_pathFlags.read(ipath) & 1) != 0;
    }

    public boolean isClosedPathInXYPlane(int path_index) {
        int iend;
        if (this.isClosedPath(path_index)) {
            return true;
        }
        int istart = this.getPathStart(path_index);
        if (istart > (iend = this.getPathEnd(path_index) - 1)) {
            return false;
        }
        Point2D ptS = this.getXY(istart);
        Point2D ptE = this.getXY(iend);
        return ptS.isEqual(ptE);
    }

    public boolean hasNonLinearSegments(int ipath) {
        return (this.m_pathFlags.read(ipath) & 2) != 0;
    }

    public void addSegment(Segment segment, boolean bStartNewPath) {
        Point point;
        this.mergeVertexDescription(segment.getDescription());
        if (segment.getType() == Geometry.Type.Line) {
            point = new Point();
            if (bStartNewPath || this.isEmpty()) {
                segment.queryStart(point);
                this.startPath(point);
            }
        } else {
            throw GeometryException.GeometryInternalError();
        }
        segment.queryEnd(point);
        this.lineTo(point);
    }

    public void addEnvelope(Envelope2D envSrc, boolean bReverse) {
        boolean bWasEmpty = this.m_pointCount == 0;
        this.startPath(envSrc.xmin, envSrc.ymin);
        if (bReverse) {
            this.lineTo(envSrc.xmax, envSrc.ymin);
            this.lineTo(envSrc.xmax, envSrc.ymax);
            this.lineTo(envSrc.xmin, envSrc.ymax);
        } else {
            this.lineTo(envSrc.xmin, envSrc.ymax);
            this.lineTo(envSrc.xmax, envSrc.ymax);
            this.lineTo(envSrc.xmax, envSrc.ymin);
        }
        this.closePathWithLine();
        this.m_bPathStarted = false;
        if (bWasEmpty && !bReverse) {
            this._setDirtyFlag(256, false);
        }
    }

    public void addEnvelope(Envelope envSrc, boolean bReverse) {
        if (envSrc.isEmpty()) {
            return;
        }
        boolean bWasEmpty = this.m_pointCount == 0;
        Point pt = new Point(this.m_description);
        int n = 4;
        for (int i = 0; i < n; ++i) {
            int j = bReverse ? n - i - 1 : i;
            envSrc.queryCornerByVal(j, pt);
            if (i == 0) {
                this.startPath(pt);
                continue;
            }
            this.lineTo(pt);
        }
        this.closePathWithLine();
        this.m_bPathStarted = false;
        if (bWasEmpty && !bReverse) {
            this._setDirtyFlag(256, false);
        }
    }

    public void add(MultiPathImpl src, boolean bReversePaths) {
        for (int i = 0; i < src.getPathCount(); ++i) {
            this.addPath(src, i, !bReversePaths);
        }
    }

    public void addPath(MultiPathImpl src, int srcPathIndex, boolean bForward) {
        this.insertPath(-1, src, srcPathIndex, bForward);
    }

    public void addPath(Point2D[] _points, int count, boolean bForward) {
        this.insertPath(-1, _points, 0, count, bForward);
    }

    public void addSegmentsFromPath(MultiPathImpl src, int src_path_index, int src_segment_from, int src_segment_count, boolean b_start_new_path) {
        boolean bIncludesClosingSegment;
        if (!b_start_new_path && this.getPathCount() == 0) {
            b_start_new_path = true;
        }
        if (src_path_index < 0) {
            src_path_index = src.getPathCount() - 1;
        }
        if (src_path_index >= src.getPathCount() || src_segment_from < 0 || src_segment_count < 0 || src_segment_count > src.getSegmentCount(src_path_index)) {
            throw new GeometryException("index out of bounds");
        }
        if (src_segment_count == 0) {
            return;
        }
        boolean bl = bIncludesClosingSegment = src.isClosedPath(src_path_index) && src_segment_from + src_segment_count == src.getSegmentCount(src_path_index);
        if (bIncludesClosingSegment && src_segment_count == 1) {
            return;
        }
        this.m_bPathStarted = false;
        this.mergeVertexDescription(src.getDescription());
        int src_point_count = src_segment_count;
        int srcFromPoint = src.getPathStart(src_path_index) + src_segment_from + 1;
        if (b_start_new_path) {
            ++src_point_count;
            --srcFromPoint;
        }
        if (bIncludesClosingSegment) {
            --src_point_count;
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + src_point_count);
        this._verifyAllStreams();
        if (b_start_new_path) {
            if (src_point_count == 0) {
                return;
            }
            this.m_paths.add(this.m_pointCount);
            byte flags = src.m_pathFlags.read(src_path_index);
            flags = (byte)(flags & 0xFFFFFFFB);
            if (this.m_bPolygon) {
                flags = (byte)(flags | 1);
            }
            this.m_pathFlags.write(this.m_pathFlags.size() - 1, flags);
            this.m_pathFlags.add((byte)0);
        } else {
            this.m_paths.write(this.m_pathFlags.size() - 1, this.m_pointCount);
        }
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            int isrcAttr = src.m_description.getAttributeIndex(semantics);
            if (isrcAttr < 0 || src.m_vertexAttributes[isrcAttr] == null) {
                double v = VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[iattr].insertRange(comp * oldPointCount, v, src_point_count * comp, comp * oldPointCount);
                continue;
            }
            boolean b_forward = true;
            this.m_vertexAttributes[iattr].insertRange(comp * oldPointCount, src.m_vertexAttributes[isrcAttr], comp * srcFromPoint, src_point_count * comp, b_forward, comp, comp * oldPointCount);
        }
        if (this.hasNonLinearSegments()) {
            throw GeometryException.GeometryInternalError();
        }
        if (src.hasNonLinearSegments(src_path_index)) {
            throw GeometryException.GeometryInternalError();
        }
        this.notifyModified(1993);
    }

    public void reverseAllPaths() {
        int n = this.getPathCount();
        for (int i = 0; i < n; ++i) {
            this.reversePath(i);
        }
    }

    public void reversePath(int pathIndex) {
        this._verifyAllStreams();
        int pathCount = this.getPathCount();
        if (pathIndex >= pathCount) {
            throw new IllegalArgumentException();
        }
        int reversedPathStart = this.getPathStart(pathIndex);
        int reversedPathSize = this.getPathSize(pathIndex);
        int offset = this.isClosedPath(pathIndex) ? 1 : 0;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].reverseRange(comp * (reversedPathStart + offset), comp * (reversedPathSize - offset), comp);
        }
        this.notifyModified(1993);
    }

    public void removePath(int pathIndex) {
        int i;
        this._verifyAllStreams();
        int pathCount = this.getPathCount();
        if (pathIndex < 0) {
            pathIndex = pathCount - 1;
        }
        if (pathIndex >= pathCount) {
            throw new IllegalArgumentException();
        }
        boolean bDirtyRingAreas2D = this._hasDirtyFlag(1024);
        int removedPathStart = this.getPathStart(pathIndex);
        int removedPathSize = this.getPathSize(pathIndex);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].eraseRange(comp * removedPathStart, comp * removedPathSize, comp * this.m_pointCount);
        }
        for (i = pathIndex + 1; i <= pathCount; ++i) {
            int istart = this.m_paths.read(i);
            this.m_paths.write(i - 1, istart - removedPathSize);
        }
        if (this.m_pathFlags == null) {
            for (i = pathIndex + 1; i <= pathCount; ++i) {
                byte flags = this.m_pathFlags.read(i);
                this.m_pathFlags.write(i - 1, flags);
            }
        }
        this.m_paths.resize(pathCount);
        this.m_pathFlags.resize(pathCount);
        this.m_pointCount -= removedPathSize;
        this.m_reservedPointCount -= removedPathSize;
        this.notifyModified(1993);
    }

    public void insertPath(int pathIndex, MultiPathImpl src, int srcPathIndex, boolean bForward) {
        byte flags;
        int ipath;
        if (src == this) {
            throw new IllegalArgumentException();
        }
        if (srcPathIndex >= src.getPathCount()) {
            throw new IllegalArgumentException();
        }
        int oldPathCount = this.getPathCount();
        if (pathIndex > oldPathCount) {
            throw new IllegalArgumentException();
        }
        if (pathIndex < 0) {
            pathIndex = oldPathCount;
        }
        if (srcPathIndex < 0) {
            srcPathIndex = src.getPathCount() - 1;
        }
        this.m_bPathStarted = false;
        this.mergeVertexDescription(src.m_description);
        src._verifyAllStreams();
        int srcPathIndexStart = src.getPathStart(srcPathIndex);
        int srcPathSize = src.getPathSize(srcPathIndex);
        int oldPointCount = this.m_pointCount;
        int offset = src.isClosedPath(srcPathIndex) && !bForward ? 1 : 0;
        this._resizeImpl(this.m_pointCount + srcPathSize);
        this._verifyAllStreams();
        int pathIndexStart = pathIndex < oldPathCount ? this.getPathStart(pathIndex) : oldPointCount;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int isrcAttr = src.m_description.getAttributeIndex(semantics);
            int comp = VertexDescription.getComponentCount(semantics);
            if (isrcAttr >= 0 && src.m_vertexAttributes[isrcAttr] != null) {
                if (offset != 0) {
                    this.m_vertexAttributes[iattr].insertRange(pathIndexStart * comp, src.m_vertexAttributes[isrcAttr], comp * srcPathIndexStart, comp, true, comp, comp * oldPointCount);
                }
                this.m_vertexAttributes[iattr].insertRange((pathIndexStart + offset) * comp, src.m_vertexAttributes[isrcAttr], comp * (srcPathIndexStart + offset), comp * (srcPathSize - offset), bForward, comp, comp * (oldPointCount + offset));
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(pathIndexStart * comp, v, comp * srcPathSize, comp * oldPointCount);
        }
        int newPointCount = oldPointCount + srcPathSize;
        this.m_paths.add(newPointCount);
        for (ipath = oldPathCount; ipath >= pathIndex + 1; --ipath) {
            int iend = this.m_paths.read(ipath - 1);
            this.m_paths.write(ipath, iend + srcPathSize);
        }
        if (src.hasNonLinearSegments(srcPathIndex)) {
            // empty if block
        }
        this.m_pathFlags.add((byte)0);
        for (ipath = oldPathCount - 1; ipath >= pathIndex + 1; --ipath) {
            flags = this.m_pathFlags.read(ipath);
            flags = (byte)(flags & 0xFFFFFFFB);
            this.m_pathFlags.write(ipath + 1, flags);
        }
        AttributeStreamOfInt8 srcPathFlags = src.getPathFlagsStreamRef();
        flags = srcPathFlags.read(srcPathIndex);
        flags = (byte)(flags & 0xFFFFFFFB);
        if (this.m_bPolygon) {
            flags = (byte)(flags | 1);
        }
        this.m_pathFlags.write(pathIndex, flags);
    }

    public void insertPath(int pathIndex, Point2D[] points, int pointsOffset, int count, boolean bForward) {
        int ipath;
        int oldPathCount = this.getPathCount();
        if (pathIndex > oldPathCount) {
            throw new IllegalArgumentException();
        }
        if (pathIndex < 0) {
            pathIndex = oldPathCount;
        }
        this.m_bPathStarted = false;
        int oldPointCount = this.m_pointCount;
        if (points != null) {
            this._resizeImpl(this.m_pointCount + count);
            this._verifyAllStreams();
            int pathStart = pathIndex < oldPathCount ? this.getPathStart(pathIndex) : oldPointCount;
            int nattr = this.m_description.getAttributeCount();
            for (int iattr = 0; iattr < nattr; ++iattr) {
                int semantics = this.m_description._getSemanticsImpl(iattr);
                if (semantics == 0) {
                    this.m_vertexAttributes[iattr].writeRange(2 * (pathStart + count), 2 * (oldPointCount - pathIndex), this.m_vertexAttributes[iattr], 2 * pathStart, true, 2);
                    AttributeStreamOfDbl position = (AttributeStreamOfDbl)this.getAttributeStreamRef(semantics);
                    int j = pathStart;
                    int i = 0;
                    while (i < count) {
                        int index = bForward ? pointsOffset + i : pointsOffset + count - i - 1;
                        position.write(2 * j, points[index].x);
                        position.write(2 * j + 1, points[index].y);
                        ++i;
                        ++j;
                    }
                    continue;
                }
                int comp = VertexDescription.getComponentCount(semantics);
                double v = VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[iattr].insertRange(pathStart * comp, v, comp * count, comp * oldPointCount);
            }
        } else {
            this._verifyAllStreams();
        }
        this.m_paths.add(this.m_pointCount);
        for (ipath = oldPathCount; ipath >= pathIndex + 1; --ipath) {
            int iend = this.m_paths.read(ipath - 1);
            this.m_paths.write(ipath, iend + count);
        }
        this.m_pathFlags.add((byte)0);
        for (ipath = oldPathCount - 1; ipath >= pathIndex + 1; --ipath) {
            byte flags = this.m_pathFlags.read(ipath);
            flags = (byte)(flags & 0xFFFFFFFB);
            this.m_pathFlags.write(ipath + 1, flags);
        }
        if (this.m_bPolygon) {
            this.m_pathFlags.write(pathIndex, (byte)1);
        }
    }

    public void insertPoints(int pathIndex, int beforePointIndex, MultiPathImpl src, int srcPathIndex, int srcPointIndexFrom, int srcPointCount, boolean bForward) {
        if (pathIndex < 0) {
            pathIndex = this.getPathCount();
        }
        if (srcPathIndex < 0) {
            srcPathIndex = src.getPathCount() - 1;
        }
        if (pathIndex > this.getPathCount() || beforePointIndex >= 0 && beforePointIndex > this.getPathSize(pathIndex) || srcPathIndex >= src.getPathCount() || srcPointCount > src.getPathSize(srcPathIndex)) {
            throw new GeometryException("index out of bounds");
        }
        if (srcPointCount == 0) {
            return;
        }
        this.mergeVertexDescription(src.m_description);
        if (pathIndex == this.getPathCount()) {
            this.m_paths.add(this.m_pointCount);
            byte flags = src.m_pathFlags.read(srcPathIndex);
            flags = (byte)(flags & 0xFFFFFFFB);
            if (!this.m_bPolygon) {
                this.m_pathFlags.add(flags);
            } else {
                this.m_pathFlags.add((byte)(flags | 1));
            }
        }
        if (beforePointIndex < 0) {
            beforePointIndex = this.getPathSize(pathIndex);
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + srcPointCount);
        this._verifyAllStreams();
        src._verifyAllStreams();
        int pathStart = this.getPathStart(pathIndex);
        int absoluteIndex = pathStart + beforePointIndex;
        if (srcPointCount < 0) {
            srcPointCount = src.getPathSize(srcPathIndex);
        }
        int srcPathStart = src.getPathStart(srcPathIndex);
        int srcAbsoluteIndex = srcPathStart + srcPointCount;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            int isrcAttr = src.m_description.getAttributeIndex(semantics);
            if (isrcAttr < 0 || src.m_vertexAttributes[isrcAttr] == null) {
                double v = VertexDescription.getDefaultValue(semantics);
                this.m_vertexAttributes[iattr].insertRange(comp * absoluteIndex, v, srcAbsoluteIndex * comp, comp * oldPointCount);
                continue;
            }
            this.m_vertexAttributes[iattr].insertRange(comp * (pathStart + beforePointIndex), src.m_vertexAttributes[isrcAttr], comp * (srcPathStart + srcPointIndexFrom), srcPointCount * comp, bForward, comp, comp * oldPointCount);
        }
        if (this.hasNonLinearSegments()) {
            this.m_segmentFlags.writeRange(this.getPathStart(pathIndex) + beforePointIndex + srcPointCount, oldPointCount - this.getPathStart(pathIndex) - beforePointIndex, this.m_segmentFlags, this.getPathStart(pathIndex) + beforePointIndex, true, 1);
            this.m_segmentParamIndex.writeRange(this.getPathStart(pathIndex) + beforePointIndex + srcPointCount, oldPointCount - this.getPathStart(pathIndex) - beforePointIndex, this.m_segmentParamIndex, this.getPathStart(pathIndex) + beforePointIndex, true, 1);
            int n = this.getPathStart(pathIndex) + beforePointIndex + srcPointCount;
            for (int i = this.getPathStart(pathIndex) + beforePointIndex; i < n; ++i) {
                this.m_segmentFlags.write(i, (byte)1);
                this.m_segmentParamIndex.write(i, -1);
            }
        }
        if (src.hasNonLinearSegments(srcPathIndex)) {
            throw GeometryException.GeometryInternalError();
        }
        int npaths = this.getPathCount();
        for (int ipath = pathIndex + 1; ipath <= npaths; ++ipath) {
            int num = this.m_paths.read(ipath);
            this.m_paths.write(ipath, num + srcPointCount);
        }
    }

    public void insertPoints(int pathIndex, int beforePointIndex, Point2D[] src, int srcPointIndexFrom, int srcPointCount, boolean bForward) {
        if (pathIndex < 0) {
            pathIndex = this.getPathCount();
        }
        if (pathIndex > this.getPathCount() || beforePointIndex > this.getPathSize(pathIndex) || srcPointIndexFrom < 0 || srcPointCount > src.length) {
            throw new GeometryException("index out of bounds");
        }
        if (srcPointCount == 0) {
            return;
        }
        if (pathIndex == this.getPathCount()) {
            this.m_paths.add(this.m_pointCount);
            if (!this.m_bPolygon) {
                this.m_pathFlags.add((byte)0);
            } else {
                this.m_pathFlags.add((byte)1);
            }
        }
        if (beforePointIndex < 0) {
            beforePointIndex = this.getPathSize(pathIndex);
        }
        this._verifyAllStreams();
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + srcPointCount);
        this._verifyAllStreams();
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].writeRange(comp * (this.getPathStart(pathIndex) + beforePointIndex + srcPointCount), (oldPointCount - this.getPathStart(pathIndex) - beforePointIndex) * comp, this.m_vertexAttributes[iattr], comp * (this.getPathStart(pathIndex) + beforePointIndex), true, comp);
            if (iattr == 0) {
                ((AttributeStreamOfDbl)this.m_vertexAttributes[iattr]).writeRange(comp * (this.getPathStart(pathIndex) + beforePointIndex), srcPointCount, src, srcPointIndexFrom, bForward);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].setRange(v, (this.getPathStart(pathIndex) + beforePointIndex) * comp, srcPointCount * comp);
        }
        if (this.hasNonLinearSegments()) {
            this.m_segmentFlags.writeRange(this.getPathStart(pathIndex) + beforePointIndex + srcPointCount, oldPointCount - this.getPathStart(pathIndex) - beforePointIndex, this.m_segmentFlags, this.getPathStart(pathIndex) + beforePointIndex, true, 1);
            this.m_segmentParamIndex.writeRange(this.getPathStart(pathIndex) + beforePointIndex + srcPointCount, oldPointCount - this.getPathStart(pathIndex) - beforePointIndex, this.m_segmentParamIndex, this.getPathStart(pathIndex) + beforePointIndex, true, 1);
            this.m_segmentFlags.setRange(1.0, this.getPathStart(pathIndex) + beforePointIndex, srcPointCount);
            this.m_segmentParamIndex.setRange(-1.0, this.getPathStart(pathIndex) + beforePointIndex, srcPointCount);
        }
        int npaths = this.getPathCount();
        for (int ipath = pathIndex + 1; ipath <= npaths; ++ipath) {
            this.m_paths.write(ipath, this.m_paths.read(ipath) + srcPointCount);
        }
    }

    public void insertPoint(int pathIndex, int beforePointIndex, Point2D pt) {
        int pathCount = this.getPathCount();
        if (pathIndex < 0) {
            pathIndex = this.getPathCount();
        }
        if (pathIndex >= pathCount || beforePointIndex > this.getPathSize(pathIndex)) {
            throw new GeometryException("index out of bounds");
        }
        if (pathIndex == this.getPathCount()) {
            this.m_paths.add(this.m_pointCount);
            if (!this.m_bPolygon) {
                this.m_pathFlags.add((byte)0);
            } else {
                this.m_pathFlags.add((byte)1);
            }
        }
        if (beforePointIndex < 0) {
            beforePointIndex = this.getPathSize(pathIndex);
        }
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + 1);
        this._verifyAllStreams();
        int pathStart = this.getPathStart(pathIndex);
        ((AttributeStreamOfDbl)this.m_vertexAttributes[0]).insert(2 * (pathStart + beforePointIndex), pt, 2 * oldPointCount);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * (pathStart + beforePointIndex), v, comp, comp * oldPointCount);
        }
        int npaths = pathCount;
        for (int ipath = pathIndex + 1; ipath <= npaths; ++ipath) {
            this.m_paths.write(ipath, this.m_paths.read(ipath) + 1);
        }
    }

    public void insertPoint(int pathIndex, int beforePointIndex, Point pt) {
        int pathCount = this.getPathCount();
        if (pathIndex < 0) {
            pathIndex = this.getPathCount();
        }
        if (pathIndex >= pathCount || beforePointIndex > this.getPathSize(pathIndex)) {
            throw new GeometryException("index out of bounds");
        }
        if (pathIndex == this.getPathCount()) {
            this.m_paths.add(this.m_pointCount);
            if (!this.m_bPolygon) {
                this.m_pathFlags.add((byte)0);
            } else {
                this.m_pathFlags.add((byte)1);
            }
        }
        if (beforePointIndex < 0) {
            beforePointIndex = this.getPathSize(pathIndex);
        }
        this.mergeVertexDescription(pt.getDescription());
        int oldPointCount = this.m_pointCount;
        this._resizeImpl(this.m_pointCount + 1);
        this._verifyAllStreams();
        int pathStart = this.getPathStart(pathIndex);
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            if (pt.hasAttribute(semantics)) {
                this.m_vertexAttributes[iattr].insertAttributes(comp * (pathStart + beforePointIndex), pt, semantics, comp * oldPointCount);
                continue;
            }
            double v = VertexDescription.getDefaultValue(semantics);
            this.m_vertexAttributes[iattr].insertRange(comp * (pathStart + beforePointIndex), v, comp, comp * oldPointCount);
        }
        int npaths = pathCount;
        for (int ipath = pathIndex + 1; ipath <= npaths; ++ipath) {
            this.m_paths.write(ipath, this.m_paths.read(ipath) + 1);
        }
        this.notifyModified(1993);
    }

    public void removePoint(int pathIndex, int pointIndex) {
        int pathCount = this.getPathCount();
        if (pathIndex < 0) {
            pathIndex = pathCount - 1;
        }
        if (pathIndex >= pathCount || pointIndex >= this.getPathSize(pathIndex)) {
            throw new GeometryException("index out of bounds");
        }
        this._verifyAllStreams();
        int pathStart = this.getPathStart(pathIndex);
        if (pointIndex < 0) {
            pointIndex = this.getPathSize(pathIndex) - 1;
        }
        int absoluteIndex = pathStart + pointIndex;
        int nattr = this.m_description.getAttributeCount();
        for (int iattr = 0; iattr < nattr; ++iattr) {
            if (this.m_vertexAttributes[iattr] == null) continue;
            int semantics = this.m_description._getSemanticsImpl(iattr);
            int comp = VertexDescription.getComponentCount(semantics);
            this.m_vertexAttributes[iattr].eraseRange(comp * absoluteIndex, comp, comp * this.m_pointCount);
        }
        for (int ipath = pathCount; ipath >= pathIndex + 1; --ipath) {
            int iend = this.m_paths.read(ipath);
            this.m_paths.write(ipath, iend - 1);
        }
        --this.m_pointCount;
        --this.m_reservedPointCount;
        this.notifyModified(1993);
    }

    public double calculatePathLength2D(int pathIndex) {
        SegmentIteratorImpl segIter = this.querySegmentIteratorAtVertex(this.getPathStart(pathIndex));
        MathUtils.KahanSummator len = new MathUtils.KahanSummator(0.0);
        while (segIter.hasNextSegment()) {
            len.add(segIter.nextSegment().calculateLength2D());
        }
        return len.getResult();
    }

    double calculateSubLength2D(int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        int absolute_from_index = this.getPathStart(from_path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(to_path_index) + to_point_index;
        if (absolute_to_index < absolute_from_index || absolute_from_index < 0 || absolute_to_index > this.getPointCount() - 1) {
            throw new IllegalArgumentException();
        }
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        double sub_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        while (true) {
            if (seg_iter.hasNextSegment()) {
                Segment segment = seg_iter.nextSegment();
                if (seg_iter.getStartPointIndex() != absolute_to_index) {
                    double segment_length = segment.calculateLength2D();
                    sub_length += segment_length;
                    continue;
                }
            }
            if (seg_iter.getStartPointIndex() == absolute_to_index || !seg_iter.nextPath()) break;
        }
        return sub_length;
    }

    double calculateSubLength2D(int path_index, int from_point_index, int to_point_index) {
        int absolute_from_index = this.getPathStart(path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(path_index) + to_point_index;
        if (absolute_from_index < 0 || absolute_to_index > this.getPointCount() - 1) {
            throw new IllegalArgumentException();
        }
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        if (absolute_from_index > absolute_to_index) {
            if (!this.isClosedPath(path_index)) {
                throw new IllegalArgumentException("cannot iterate across an open path");
            }
            seg_iter.setCirculator(true);
        }
        double prev_length = 0.0;
        double sub_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        do {
            assert (seg_iter.hasNextSegment());
            sub_length += prev_length;
            Segment segment = seg_iter.nextSegment();
            prev_length = segment.calculateLength2D();
        } while (seg_iter.getStartPointIndex() != absolute_to_index);
        return sub_length;
    }

    @Override
    public Geometry getBoundary() {
        return Boundary.calculate(this, null);
    }

    void interpolateAttributes(int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        for (int ipath = from_path_index; ipath < to_path_index - 1; ++ipath) {
            if (!this.isClosedPath(ipath)) continue;
            throw new IllegalArgumentException("cannot interpolate across closed paths");
        }
        int nattr = this.m_description.getAttributeCount();
        if (nattr == 1) {
            return;
        }
        double sub_length = this.calculateSubLength2D(from_path_index, from_point_index, to_path_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int interpolation = VertexDescription.getInterpolation(semantics);
            if (interpolation == 2) continue;
            int components = VertexDescription.getComponentCount(semantics);
            for (int ordinate = 0; ordinate < components; ++ordinate) {
                this.interpolateAttributes_(semantics, from_path_index, from_point_index, to_path_index, to_point_index, sub_length, ordinate);
            }
        }
    }

    void interpolateAttributesForSemantics(int semantics, int from_path_index, int from_point_index, int to_path_index, int to_point_index) {
        if (semantics == 0) {
            return;
        }
        if (!this.hasAttribute(semantics)) {
            throw new IllegalArgumentException("does not have the given attribute");
        }
        int interpolation = VertexDescription.getInterpolation(semantics);
        if (interpolation == 2) {
            throw new IllegalArgumentException("not implemented for the given semantics");
        }
        for (int ipath = from_path_index; ipath < to_path_index - 1; ++ipath) {
            if (!this.isClosedPath(ipath)) continue;
            throw new IllegalArgumentException("cannot interpolate across closed paths");
        }
        double sub_length = this.calculateSubLength2D(from_path_index, from_point_index, to_path_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        int components = VertexDescription.getComponentCount(semantics);
        for (int ordinate = 0; ordinate < components; ++ordinate) {
            this.interpolateAttributes_(semantics, from_path_index, from_point_index, to_path_index, to_point_index, sub_length, ordinate);
        }
    }

    void interpolateAttributes(int path_index, int from_point_index, int to_point_index) {
        int nattr = this.m_description.getAttributeCount();
        if (nattr == 1) {
            return;
        }
        double sub_length = this.calculateSubLength2D(path_index, from_point_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        for (int iattr = 1; iattr < nattr; ++iattr) {
            int semantics = this.m_description.getSemantics(iattr);
            int interpolation = VertexDescription.getInterpolation(semantics);
            if (interpolation == 2) continue;
            int components = VertexDescription.getComponentCount(semantics);
            for (int ordinate = 0; ordinate < components; ++ordinate) {
                this.interpolateAttributes_(semantics, path_index, from_point_index, to_point_index, sub_length, ordinate);
            }
        }
    }

    void interpolateAttributesForSemantics(int semantics, int path_index, int from_point_index, int to_point_index) {
        if (semantics == 0) {
            return;
        }
        if (!this.hasAttribute(semantics)) {
            throw new IllegalArgumentException("does not have the given attribute");
        }
        int interpolation = VertexDescription.getInterpolation(semantics);
        if (interpolation == 2) {
            throw new IllegalArgumentException("not implemented for the given semantics");
        }
        double sub_length = this.calculateSubLength2D(path_index, from_point_index, to_point_index);
        if (sub_length == 0.0) {
            return;
        }
        int components = VertexDescription.getComponentCount(semantics);
        for (int ordinate = 0; ordinate < components; ++ordinate) {
            this.interpolateAttributes_(semantics, path_index, from_point_index, to_point_index, sub_length, ordinate);
        }
    }

    void interpolateAttributes_(int semantics, int from_path_index, int from_point_index, int to_path_index, int to_point_index, double sub_length, int ordinate) {
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        int absolute_from_index = this.getPathStart(from_path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(to_path_index) + to_point_index;
        double from_attribute = this.getAttributeAsDbl(semantics, absolute_from_index, ordinate);
        double to_attribute = this.getAttributeAsDbl(semantics, absolute_to_index, ordinate);
        double interpolated_attribute = from_attribute;
        double cumulative_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        do {
            if (!seg_iter.hasNextSegment()) continue;
            seg_iter.nextSegment();
            if (seg_iter.getStartPointIndex() == absolute_to_index) {
                return;
            }
            this.setAttribute(semantics, seg_iter.getStartPointIndex(), ordinate, interpolated_attribute);
            seg_iter.previousSegment();
            do {
                Segment segment = seg_iter.nextSegment();
                if (seg_iter.getEndPointIndex() == absolute_to_index) {
                    return;
                }
                double segment_length = segment.calculateLength2D();
                double t = (cumulative_length += segment_length) / sub_length;
                interpolated_attribute = MathUtils.lerp(from_attribute, to_attribute, t);
                if (seg_iter.isClosingSegment()) continue;
                this.setAttribute(semantics, seg_iter.getEndPointIndex(), ordinate, interpolated_attribute);
            } while (seg_iter.hasNextSegment());
        } while (seg_iter.nextPath());
    }

    void interpolateAttributes_(int semantics, int path_index, int from_point_index, int to_point_index, double sub_length, int ordinate) {
        assert (this.m_bPolygon);
        SegmentIteratorImpl seg_iter = this.querySegmentIterator();
        int absolute_from_index = this.getPathStart(path_index) + from_point_index;
        int absolute_to_index = this.getPathStart(path_index) + to_point_index;
        if (absolute_to_index == absolute_from_index) {
            return;
        }
        double from_attribute = this.getAttributeAsDbl(semantics, absolute_from_index, ordinate);
        double to_attribute = this.getAttributeAsDbl(semantics, absolute_to_index, ordinate);
        double cumulative_length = 0.0;
        seg_iter.resetToVertex(absolute_from_index);
        seg_iter.setCirculator(true);
        double prev_interpolated_attribute = from_attribute;
        do {
            Segment segment = seg_iter.nextSegment();
            this.setAttribute(semantics, seg_iter.getStartPointIndex(), ordinate, prev_interpolated_attribute);
            double segment_length = segment.calculateLength2D();
            double t = (cumulative_length += segment_length) / sub_length;
            prev_interpolated_attribute = MathUtils.lerp(from_attribute, to_attribute, t);
        } while (seg_iter.getEndPointIndex() != absolute_to_index);
    }

    @Override
    public void setEmpty() {
        this.m_curveParamwritePoint = 0;
        this.m_bPathStarted = false;
        this.m_paths = null;
        this.m_pathFlags = null;
        this.m_segmentParamIndex = null;
        this.m_segmentFlags = null;
        this.m_segmentParams = null;
        this._setEmptyImpl();
    }

    @Override
    public void applyTransformation(Transformation2D transform) {
        this.applyTransformation(transform, -1);
    }

    public void applyTransformation(Transformation2D transform, int pathIndex) {
        int lastIdx;
        int fistIdx;
        boolean bHasNonLinear;
        if (this.isEmpty()) {
            return;
        }
        if (transform.isIdentity()) {
            return;
        }
        this._verifyAllStreams();
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        Point2D ptStart = new Point2D();
        Point2D ptControl = new Point2D();
        if (pathIndex < 0) {
            bHasNonLinear = this.hasNonLinearSegments();
            fistIdx = 0;
            lastIdx = this.m_pointCount;
        } else {
            bHasNonLinear = this.hasNonLinearSegments(pathIndex);
            fistIdx = this.getPathStart(pathIndex);
            lastIdx = this.getPathEnd(pathIndex);
        }
        for (int ipoint = fistIdx; ipoint < lastIdx; ++ipoint) {
            int segIndex;
            ptStart.x = points.read(ipoint * 2);
            ptStart.y = points.read(ipoint * 2 + 1);
            if (bHasNonLinear && (segIndex = this.m_segmentParamIndex.read(ipoint)) >= 0) {
                byte segmentType = this.m_segmentFlags.read(ipoint);
                int type = segmentType & 7;
                switch (type) {
                    case 2: {
                        ptControl.x = this.m_segmentParams.read(segIndex);
                        ptControl.y = this.m_segmentParams.read(segIndex + 1);
                        transform.transform(ptControl, ptControl);
                        this.m_segmentParams.write(segIndex, ptControl.x);
                        this.m_segmentParams.write(segIndex + 1, ptControl.y);
                        ptControl.x = this.m_segmentParams.read(segIndex + 3);
                        ptControl.y = this.m_segmentParams.read(segIndex + 4);
                        transform.transform(ptControl, ptControl);
                        this.m_segmentParams.write(segIndex + 3, ptControl.x);
                        this.m_segmentParams.write(segIndex + 4, ptControl.y);
                        break;
                    }
                    case 4: {
                        throw GeometryException.GeometryInternalError();
                    }
                }
            }
            transform.transform(ptStart, ptStart);
            points.write(ipoint * 2, ptStart.x);
            points.write(ipoint * 2 + 1, ptStart.y);
        }
        this.notifyModified(1993);
    }

    @Override
    public void applyTransformation(Transformation3D transform) {
        if (this.isEmpty()) {
            return;
        }
        this.addAttribute(1);
        this._verifyAllStreams();
        AttributeStreamOfDbl points = (AttributeStreamOfDbl)this.m_vertexAttributes[0];
        AttributeStreamOfDbl zs = (AttributeStreamOfDbl)this.m_vertexAttributes[1];
        Point3D ptStart = new Point3D();
        Point3D ptControl = new Point3D();
        boolean bHasNonLinear = this.hasNonLinearSegments();
        for (int ipoint = 0; ipoint < this.m_pointCount; ++ipoint) {
            int segIndex;
            ptStart.x = points.read(ipoint * 2);
            ptStart.y = points.read(ipoint * 2 + 1);
            ptStart.z = zs.read(ipoint);
            if (bHasNonLinear && (segIndex = this.m_segmentParamIndex.read(ipoint)) >= 0) {
                byte segmentType = this.m_segmentFlags.read(ipoint);
                int type = segmentType & 7;
                switch (type) {
                    case 2: {
                        ptControl.x = this.m_segmentParams.read(segIndex);
                        ptControl.y = this.m_segmentParams.read(segIndex + 1);
                        ptControl.z = this.m_segmentParams.read(segIndex + 2);
                        ptControl = transform.transform(ptControl);
                        this.m_segmentParams.write(segIndex, ptControl.x);
                        this.m_segmentParams.write(segIndex + 1, ptControl.y);
                        this.m_segmentParams.write(segIndex + 1, ptControl.z);
                        ptControl.x = this.m_segmentParams.read(segIndex + 3);
                        ptControl.y = this.m_segmentParams.read(segIndex + 4);
                        ptControl.z = this.m_segmentParams.read(segIndex + 5);
                        ptControl = transform.transform(ptControl);
                        this.m_segmentParams.write(segIndex + 3, ptControl.x);
                        this.m_segmentParams.write(segIndex + 4, ptControl.y);
                        this.m_segmentParams.write(segIndex + 5, ptControl.z);
                        break;
                    }
                    case 4: {
                        throw GeometryException.GeometryInternalError();
                    }
                }
            }
            ptStart = transform.transform(ptStart);
            points.write(ipoint * 2, ptStart.x);
            points.write(ipoint * 2 + 1, ptStart.y);
            zs.write(ipoint, ptStart.z);
        }
        this.notifyModified(1993);
    }

    @Override
    protected void _verifyStreamsImpl() {
        if (this.m_paths == null) {
            this.m_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(1, 0);
            this.m_pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(1, (byte)0);
        }
        if (this.m_segmentFlags != null) {
            this.m_segmentFlags.resize(this.m_reservedPointCount, 1.0);
            this.m_segmentParamIndex.resize(this.m_reservedPointCount, -1.0);
        }
    }

    @Override
    void _copyToImpl(MultiVertexGeometryImpl dst) {
        MultiPathImpl dstPoly = (MultiPathImpl)dst;
        dstPoly.m_bPathStarted = false;
        dstPoly.m_curveParamwritePoint = this.m_curveParamwritePoint;
        dstPoly.m_fill_rule = this.m_fill_rule;
        dstPoly.m_paths = this.m_paths != null ? new AttributeStreamOfInt32(this.m_paths) : null;
        dstPoly.m_pathFlags = this.m_pathFlags != null ? new AttributeStreamOfInt8(this.m_pathFlags) : null;
        dstPoly.m_segmentParamIndex = this.m_segmentParamIndex != null ? new AttributeStreamOfInt32(this.m_segmentParamIndex) : null;
        dstPoly.m_segmentFlags = this.m_segmentFlags != null ? new AttributeStreamOfInt8(this.m_segmentFlags) : null;
        dstPoly.m_segmentParams = this.m_segmentParams != null ? new AttributeStreamOfDbl(this.m_segmentParams) : null;
        dstPoly.m_cachedLength2D = this.m_cachedLength2D;
        dstPoly.m_cachedArea2D = this.m_cachedArea2D;
        dstPoly.m_cachedRingAreas2D = !this._hasDirtyFlag(1024) ? this.m_cachedRingAreas2D : null;
    }

    @Override
    public double calculateLength2D() {
        if (!this._hasDirtyFlag(512)) {
            return this.m_cachedLength2D;
        }
        SegmentIteratorImpl segIter = this.querySegmentIterator();
        MathUtils.KahanSummator len = new MathUtils.KahanSummator(0.0);
        while (segIter.nextPath()) {
            while (segIter.hasNextSegment()) {
                len.add(segIter.nextSegment().calculateLength2D());
            }
        }
        this.m_cachedLength2D = len.getResult();
        this._setDirtyFlag(512, false);
        return len.getResult();
    }

    @Override
    public boolean equals(Object other) {
        int pathCountOther;
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiPathImpl)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        MultiPathImpl otherMultiPath = (MultiPathImpl)other;
        int pathCount = this.getPathCount();
        if (pathCount != (pathCountOther = otherMultiPath.getPathCount())) {
            return false;
        }
        if (this.m_paths != null && !this.m_paths.equals(otherMultiPath.m_paths, 0, pathCount + 1)) {
            return false;
        }
        if (this.m_fill_rule != otherMultiPath.m_fill_rule) {
            return false;
        }
        if (this.m_pathFlags != null && !this.m_pathFlags.equals(otherMultiPath.m_pathFlags, 0, pathCount)) {
            return false;
        }
        return super.equals(other);
    }

    public SegmentIteratorImpl querySegmentIteratorAtVertex(int startVertexIndex) {
        if (startVertexIndex < 0 || startVertexIndex >= this.getPointCount()) {
            throw new IndexOutOfBoundsException();
        }
        SegmentIteratorImpl iter = new SegmentIteratorImpl(this, startVertexIndex);
        return iter;
    }

    public SegmentIteratorImpl querySegmentIterator() {
        return new SegmentIteratorImpl(this);
    }

    @Override
    public void _updateXYImpl(boolean bExact) {
        super._updateXYImpl(bExact);
        boolean bHasCurves = this.hasNonLinearSegments();
        if (bHasCurves) {
            SegmentIteratorImpl segIter = this.querySegmentIterator();
            while (segIter.nextPath()) {
                Segment curve;
                while (segIter.hasNextSegment() && (curve = segIter.nextCurve()) != null) {
                    Envelope2D env2D = new Envelope2D();
                    curve.queryEnvelope2D(env2D);
                    this.m_envelope.merge(env2D);
                }
            }
        }
    }

    @Override
    void calculateEnvelope2D(Envelope2D env, boolean bExact) {
        super.calculateEnvelope2D(env, bExact);
        boolean bHasCurves = this.hasNonLinearSegments();
        if (bHasCurves) {
            SegmentIteratorImpl segIter = this.querySegmentIterator();
            while (segIter.nextPath()) {
                Segment curve;
                while (segIter.hasNextSegment() && (curve = segIter.nextCurve()) != null) {
                    Envelope2D env2D = new Envelope2D();
                    curve.queryEnvelope2D(env2D);
                    env.merge(env2D);
                }
            }
        }
    }

    @Override
    public void _notifyModifiedAllImpl() {
        this.m_pointCount = this.m_paths == null || this.m_paths.size() == 0 ? 0 : this.m_paths.read(this.m_paths.size() - 1);
    }

    @Override
    public double calculateArea2D() {
        if (!this.m_bPolygon) {
            return 0.0;
        }
        this._updateRingAreas2D();
        return this.m_cachedArea2D;
    }

    public boolean isExteriorRing(int ringIndex) {
        if (!this.m_bPolygon) {
            return false;
        }
        if (!this._hasDirtyFlag(8)) {
            return (this.m_pathFlags.read(ringIndex) & 4) != 0;
        }
        this._updateRingAreas2D();
        return this.m_cachedRingAreas2D.read(ringIndex) > 0.0;
    }

    public double calculateRingArea2D(int pathIndex) {
        if (!this.m_bPolygon) {
            return 0.0;
        }
        this._updateRingAreas2D();
        return this.m_cachedRingAreas2D.read(pathIndex);
    }

    public void _updateRingAreas2D() {
        if (this._hasDirtyFlag(1024)) {
            int pathCount = this.getPathCount();
            if (this.m_cachedRingAreas2D == null) {
                this.m_cachedRingAreas2D = new AttributeStreamOfDbl(pathCount);
            } else if (this.m_cachedRingAreas2D.size() != pathCount) {
                this.m_cachedRingAreas2D.resize(pathCount);
            }
            MathUtils.KahanSummator totalArea = new MathUtils.KahanSummator(0.0);
            MathUtils.KahanSummator pathArea = new MathUtils.KahanSummator(0.0);
            Point2D pt = new Point2D();
            int ipath = 0;
            SegmentIteratorImpl segIter = this.querySegmentIterator();
            while (segIter.nextPath()) {
                pathArea.reset();
                this.getXY(this.getPathStart(segIter.getPathIndex()), pt);
                while (segIter.hasNextSegment()) {
                    pathArea.add(segIter.nextSegment()._calculateArea2DHelper(pt.x, pt.y));
                }
                totalArea.add(pathArea.getResult());
                int i = ipath++;
                this.m_cachedRingAreas2D.write(i, pathArea.getResult());
            }
            this.m_cachedArea2D = totalArea.getResult();
            this._setDirtyFlag(1024, false);
        }
    }

    int getOGCPolygonCount() {
        if (!this.m_bPolygon) {
            return 0;
        }
        this._updateOGCFlags();
        int polygonCount = 0;
        int partCount = this.getPathCount();
        for (int ipart = 0; ipart < partCount; ++ipart) {
            if ((this.m_pathFlags.read(ipart) & 4) == 0) continue;
            ++polygonCount;
        }
        return polygonCount;
    }

    protected void _updateOGCFlags() {
        if (this._hasDirtyFlag(8)) {
            this._updateRingAreas2D();
            int pathCount = this.getPathCount();
            if (this.m_pathFlags == null || this.m_pathFlags.size() < pathCount) {
                this.m_pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(pathCount + 1);
            }
            int firstSign = 1;
            for (int ipath = 0; ipath < pathCount; ++ipath) {
                double area = this.m_cachedRingAreas2D.read(ipath);
                if (ipath == 0) {
                    int n = firstSign = area > 0.0 ? 1 : -1;
                }
                if (area * (double)firstSign > 0.0) {
                    this.m_pathFlags.setBits(ipath, (byte)4);
                    continue;
                }
                this.m_pathFlags.clearBits(ipath, (byte)4);
            }
            this._setDirtyFlag(8, false);
        }
    }

    public int getPathIndexFromPointIndex(int pointIndex) {
        int positionHint = this.m_currentPathIndex;
        int pathCount = this.getPathCount();
        if (positionHint >= 0 && positionHint < pathCount) {
            if (pointIndex < this.getPathEnd(positionHint)) {
                if (pointIndex >= this.getPathStart(positionHint)) {
                    return positionHint;
                }
                --positionHint;
            } else {
                ++positionHint;
            }
            if (positionHint >= 0 && positionHint < pathCount && pointIndex >= this.getPathStart(positionHint) && pointIndex < this.getPathEnd(positionHint)) {
                this.m_currentPathIndex = positionHint;
                return positionHint;
            }
        }
        if (pathCount < 5) {
            for (int i = 0; i < pathCount; ++i) {
                if (pointIndex >= this.getPathEnd(i)) continue;
                this.m_currentPathIndex = i;
                return i;
            }
            throw new GeometryException("corrupted geometry");
        }
        int minPathIndex = 0;
        int maxPathIndex = pathCount - 1;
        while (maxPathIndex > minPathIndex) {
            int mid = minPathIndex + (maxPathIndex - minPathIndex >> 1);
            int pathStart = this.getPathStart(mid);
            if (pointIndex < pathStart) {
                maxPathIndex = mid - 1;
                continue;
            }
            int pathEnd = this.getPathEnd(mid);
            if (pointIndex >= pathEnd) {
                minPathIndex = mid + 1;
                continue;
            }
            this.m_currentPathIndex = mid;
            return mid;
        }
        this.m_currentPathIndex = minPathIndex;
        return minPathIndex;
    }

    int getHighestPointIndex(int path_index) {
        assert (path_index >= 0 && path_index < this.getPathCount());
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        AttributeStreamOfInt32 paths = this.getPathStreamRef();
        int path_end = this.getPathEnd(path_index);
        int path_start = this.getPathStart(path_index);
        int max_index = -1;
        Point2D max_point = new Point2D();
        Point2D pt = new Point2D();
        max_point.y = NumberUtils.negativeInf();
        max_point.x = NumberUtils.negativeInf();
        for (int i = path_start + 0; i < path_end; ++i) {
            position.read(2 * i, pt);
            if (max_point.compare(pt) != -1) continue;
            max_index = i;
            max_point.setCoords(pt);
        }
        return max_index;
    }

    public int getSegmentCount() {
        int segCount = this.getPointCount();
        if (!this.m_bPolygon) {
            segCount -= this.getPathCount();
            int n = this.getPathCount();
            for (int i = 0; i < n; ++i) {
                if (!this.isClosedPath(i)) continue;
                ++segCount;
            }
        }
        return segCount;
    }

    public int getSegmentCount(int path_index) {
        int segCount = this.getPathSize(path_index);
        if (!this.isClosedPath(path_index)) {
            --segCount;
        }
        return segCount;
    }

    @Override
    public Geometry createInstance() {
        return new MultiPathImpl(this.m_bPolygon, this.getDescription());
    }

    @Override
    public int getDimension() {
        return this.m_bPolygon ? 2 : 1;
    }

    @Override
    public Geometry.Type getType() {
        return this.m_bPolygon ? Geometry.Type.Polygon : Geometry.Type.Polyline;
    }

    public boolean isEnvelope() {
        return !this._hasDirtyFlag(256);
    }

    public AttributeStreamOfInt32 getPathStreamRef() {
        this.throwIfEmpty();
        return this.m_paths;
    }

    public void setPathStreamRef(AttributeStreamOfInt32 paths) {
        this.m_paths = paths;
        this.notifyModified(0xFFFFFF);
    }

    public AttributeStreamOfInt8 getSegmentFlagsStreamRef() {
        this.throwIfEmpty();
        return this.m_segmentFlags;
    }

    public AttributeStreamOfInt8 getPathFlagsStreamRef() {
        this.throwIfEmpty();
        return this.m_pathFlags;
    }

    public void setPathFlagsStreamRef(AttributeStreamOfInt8 pathFlags) {
        this.m_pathFlags = pathFlags;
        this.notifyModified(0xFFFFFF);
    }

    public AttributeStreamOfInt32 getSegmentIndexStreamRef() {
        this.throwIfEmpty();
        return this.m_segmentParamIndex;
    }

    public AttributeStreamOfDbl getSegmentDataStreamRef() {
        this.throwIfEmpty();
        return this.m_segmentParams;
    }

    public int getPathCount() {
        return this.m_paths != null ? this.m_paths.size() - 1 : 0;
    }

    public int getPathEnd(int partIndex) {
        return this.m_paths.read(partIndex + 1);
    }

    public int getPathSize(int partIndex) {
        return this.m_paths.read(partIndex + 1) - this.m_paths.read(partIndex);
    }

    public int getPathStart(int partIndex) {
        return this.m_paths.read(partIndex);
    }

    @Override
    public Object _getImpl() {
        return this;
    }

    public void setDirtyOGCFlags(boolean bYesNo) {
        this._setDirtyFlag(8, bYesNo);
    }

    public boolean hasDirtyOGCStartFlags() {
        return this._hasDirtyFlag(8);
    }

    public void setDirtyRingAreas2D(boolean bYesNo) {
        this._setDirtyFlag(1024, bYesNo);
    }

    public boolean hasDirtyRingAreas2D() {
        return this._hasDirtyFlag(1024);
    }

    public void setRingAreasStreamRef(AttributeStreamOfDbl ringAreas) {
        this.m_cachedRingAreas2D = ringAreas;
        this._setDirtyFlag(1024, false);
    }

    @Override
    public boolean _buildRasterizedGeometryAccelerator(double toleranceXY, Geometry.GeometryAccelerationDegree accelDegree) {
        if (this.m_accelerators == null) {
            this.m_accelerators = new GeometryAccelerators();
        }
        int rasterSize = RasterizedGeometry2D.rasterSizeFromAccelerationDegree(accelDegree);
        RasterizedGeometry2D rgeom = this.m_accelerators.getRasterizedGeometry();
        if (rgeom != null) {
            if (rgeom.getToleranceXY() < toleranceXY || rasterSize > rgeom.getRasterSize()) {
                this.m_accelerators._setRasterizedGeometry(null);
            } else {
                return true;
            }
        }
        rgeom = RasterizedGeometry2D.create(this, toleranceXY, rasterSize);
        this.m_accelerators._setRasterizedGeometry(rgeom);
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = super.hashCode();
        if (!this.isEmptyImpl()) {
            int pathCount = this.getPathCount();
            if (this.m_paths != null) {
                this.m_paths.calculateHashImpl(hashCode, 0, pathCount + 1);
            }
            if (this.m_pathFlags != null) {
                this.m_pathFlags.calculateHashImpl(hashCode, 0, pathCount);
            }
        }
        return hashCode;
    }

    public byte getSegmentFlags(int ivertex) {
        if (this.m_segmentFlags != null) {
            return this.m_segmentFlags.read(ivertex);
        }
        return 1;
    }

    public void getSegment(int startVertexIndex, SegmentBuffer segBuffer, boolean bStripAttributes) {
        int ipath = this.getPathIndexFromPointIndex(startVertexIndex);
        if (startVertexIndex == this.getPathEnd(ipath) - 1 && !this.isClosedPath(ipath)) {
            throw new GeometryException("index out of bounds");
        }
        this._verifyAllStreams();
        AttributeStreamOfInt8 segFlagStream = this.getSegmentFlagsStreamRef();
        int segFlag = 1;
        if (segFlagStream != null) {
            segFlag = segFlagStream.read(startVertexIndex) & 7;
        }
        switch (segFlag) {
            case 1: {
                segBuffer.createLine();
                break;
            }
            case 2: {
                throw GeometryException.GeometryInternalError();
            }
            case 4: {
                throw GeometryException.GeometryInternalError();
            }
            default: {
                throw GeometryException.GeometryInternalError();
            }
        }
        Segment currentSegment = segBuffer.get();
        if (!bStripAttributes) {
            currentSegment.assignVertexDescription(this.m_description);
        } else {
            currentSegment.assignVertexDescription(VertexDescriptionDesignerImpl.getDefaultDescriptor2D());
        }
        int endVertexIndex = startVertexIndex == this.getPathEnd(ipath) - 1 && this.isClosedPath(ipath) ? this.getPathStart(ipath) : startVertexIndex + 1;
        Point2D pt = new Point2D();
        this.getXY(startVertexIndex, pt);
        currentSegment.setStartXY(pt);
        this.getXY(endVertexIndex, pt);
        currentSegment.setEndXY(pt);
        if (!bStripAttributes) {
            int nattr = this.m_description.getAttributeCount();
            for (int i = 1; i < nattr; ++i) {
                int semantics = this.m_description._getSemanticsImpl(i);
                int ncomp = VertexDescription.getComponentCount(semantics);
                for (int ord = 0; ord < ncomp; ++ord) {
                    double vs = this.getAttributeAsDbl(semantics, startVertexIndex, ord);
                    currentSegment.setStartAttribute(semantics, ord, vs);
                    double ve = this.getAttributeAsDbl(semantics, endVertexIndex, ord);
                    currentSegment.setEndAttribute(semantics, ord, ve);
                }
            }
        }
    }

    void queryPathEnvelope2D(int path_index, Envelope2D envelope) {
        if (path_index >= this.getPathCount()) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            envelope.setEmpty();
            return;
        }
        if (this.hasNonLinearSegments(path_index)) {
            throw new GeometryException("not implemented");
        }
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        Point2D pt = new Point2D();
        Envelope2D env = new Envelope2D();
        env.setEmpty();
        int iend = this.getPathEnd(path_index);
        for (int i = this.getPathStart(path_index); i < iend; ++i) {
            stream.read(2 * i, pt);
            env.merge(pt);
        }
        envelope.setCoords(env);
    }

    public void queryLoosePathEnvelope2D(int path_index, Envelope2D envelope) {
        if (path_index >= this.getPathCount()) {
            throw new IllegalArgumentException();
        }
        if (this.isEmpty()) {
            envelope.setEmpty();
            return;
        }
        if (this.hasNonLinearSegments(path_index)) {
            throw new GeometryException("not implemented");
        }
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)this.getAttributeStreamRef(0);
        Point2D pt = new Point2D();
        Envelope2D env = new Envelope2D();
        env.setEmpty();
        int iend = this.getPathEnd(path_index);
        for (int i = this.getPathStart(path_index); i < iend; ++i) {
            stream.read(2 * i, pt);
            env.merge(pt);
        }
        envelope.setCoords(env);
    }

    @Override
    public boolean _buildQuadTreeAccelerator(Geometry.GeometryAccelerationDegree d) {
        if (this.m_accelerators == null) {
            this.m_accelerators = new GeometryAccelerators();
        }
        if (d == Geometry.GeometryAccelerationDegree.enumMild || this.getPointCount() < 16) {
            return false;
        }
        QuadTreeImpl quad_tree_impl = InternalUtils.buildQuadTree(this);
        this.m_accelerators._setQuadTree(quad_tree_impl);
        return true;
    }

    boolean _buildQuadTreeForPathsAccelerator(Geometry.GeometryAccelerationDegree degree) {
        if (this.m_accelerators == null) {
            this.m_accelerators = new GeometryAccelerators();
        }
        if (this.m_accelerators.getQuadTreeForPaths() != null) {
            return true;
        }
        this.m_accelerators._setQuadTreeForPaths(null);
        QuadTreeImpl quad_tree_impl = InternalUtils.buildQuadTreeForPaths(this);
        this.m_accelerators._setQuadTreeForPaths(quad_tree_impl);
        return true;
    }

    void setFillRule(int rule) {
        assert (this.m_bPolygon);
        this.m_fill_rule = rule;
    }

    int getFillRule() {
        return this.m_fill_rule;
    }
}

