/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.charts.report;

import com.excilys.ebi.gatling.charts.component.Component;
import com.excilys.ebi.gatling.charts.component.ComponentLibrary;
import com.excilys.ebi.gatling.charts.component.StatisticsTextComponent;
import com.excilys.ebi.gatling.charts.config.ChartsFiles$;
import com.excilys.ebi.gatling.charts.report.ReportGenerator;
import com.excilys.ebi.gatling.charts.report.TemplateWriter;
import com.excilys.ebi.gatling.charts.series.Series;
import com.excilys.ebi.gatling.charts.template.GroupDetailsPageTemplate;
import com.excilys.ebi.gatling.charts.util.Colors$;
import com.excilys.ebi.gatling.core.result.Group;
import com.excilys.ebi.gatling.core.result.message.RequestStatus$;
import com.excilys.ebi.gatling.core.result.reader.DataReader;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00113A!\u0001\u0002\u0001\u001f\tYrI]8va\u0012+G/Y5mgJ+\u0007o\u001c:u\u000f\u0016tWM]1u_JT!a\u0001\u0003\u0002\rI,\u0007o\u001c:u\u0015\t)a!\u0001\u0004dQ\u0006\u0014Ho\u001d\u0006\u0003\u000f!\tqaZ1uY&twM\u0003\u0002\n\u0015\u0005\u0019QMY5\u000b\u0005-a\u0011aB3yG&d\u0017p\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0004\u0001M\u0019\u0001\u0001\u0005\u000b\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!a\u0004*fa>\u0014HoR3oKJ\fGo\u001c:\u0011\u0005UAR\"\u0001\f\u000b\u0003]\tQa]2bY\u0006L!!\u0007\f\u0003\u0017M\u001b\u0017\r\\1PE*,7\r\u001e\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005)!/\u001e8P]B\u0011Q\u0004\t\b\u0003+yI!a\b\f\u0002\rA\u0013X\rZ3g\u0013\t\t#E\u0001\u0004TiJLgn\u001a\u0006\u0003?YA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!J\u0001\u000bI\u0006$\u0018MU3bI\u0016\u0014\bC\u0001\u0014.\u001b\u00059#B\u0001\u0015*\u0003\u0019\u0011X-\u00193fe*\u0011!fK\u0001\u0007e\u0016\u001cX\u000f\u001c;\u000b\u000512\u0011\u0001B2pe\u0016L!AL\u0014\u0003\u0015\u0011\u000bG/\u0019*fC\u0012,'\u000f\u0003\u00051\u0001\t\u0005\t\u0015!\u00032\u0003A\u0019w.\u001c9p]\u0016tG\u000fT5ce\u0006\u0014\u0018\u0010\u0005\u00023k5\t1G\u0003\u00025\t\u0005I1m\\7q_:,g\u000e^\u0005\u0003mM\u0012\u0001cQ8na>tWM\u001c;MS\n\u0014\u0018M]=\t\u000ba\u0002A\u0011A\u001d\u0002\rqJg.\u001b;?)\u0011Q4\bP\u001f\u0011\u0005E\u0001\u0001\"B\u000e8\u0001\u0004a\u0002\"\u0002\u00138\u0001\u0004)\u0003\"\u0002\u00198\u0001\u0004\t\u0004\"B \u0001\t\u0003\u0001\u0015\u0001C4f]\u0016\u0014\u0018\r^3\u0016\u0003\u0005\u0003\"!\u0006\"\n\u0005\r3\"\u0001B+oSR\u0004")
public class GroupDetailsReportGenerator
extends ReportGenerator
implements ScalaObject {
    private final String runOn;
    private final DataReader dataReader;
    private final ComponentLibrary componentLibrary;

    public void generate() {
        this.dataReader.groupsAndRequests().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final GroupDetailsReportGenerator $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<Option<Group>, Option<String>> tuple2) {
                Option option;
                Tuple2<Option<Group>, Option<String>> tuple22 = tuple2;
                if (tuple22 != null && (option = (Option)tuple22._1()) instanceof Some) {
                    Some some = (Some)option;
                    Group group = (Group)some.x();
                    None$ none$ = None$.MODULE$;
                    Object object = tuple22._2();
                    if (!(none$ != null ? !none$.equals(object) : object != null)) {
                        this.$outer.generateDetailPage$1(group);
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    private final Component responseTimeChartComponent$1(Group group) {
        Seq durationsDataSuccess = this.dataReader.responseTimeGroupByExecutionStartDate(RequestStatus$.MODULE$.OK(), (Option)None$.MODULE$, (Option)new Some((Object)group));
        Seq durationsDataFailure = this.dataReader.responseTimeGroupByExecutionStartDate(RequestStatus$.MODULE$.KO(), (Option)None$.MODULE$, (Option)new Some((Object)group));
        Series<Object, Tuple2<Object, Object>> durationsSeriesSuccess = new Series<Object, Tuple2<Object, Object>>("Group duration (success)", durationsDataSuccess, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$.MODULE$.BLUE())})));
        Series<Object, Tuple2<Object, Object>> durationsSeriesFailure = new Series<Object, Tuple2<Object, Object>>("Group duration (failure)", durationsDataFailure, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$.MODULE$.RED())})));
        return this.componentLibrary.getGroupDurationChartComponent(this.dataReader.runStart(), durationsSeriesSuccess, durationsSeriesFailure);
    }

    private final Component responseTimeDistributionChartComponent$1(Group group) {
        Tuple2 tuple2 = this.dataReader.responseTimeDistribution(100, (Option)None$.MODULE$, (Option)new Some((Object)group));
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            Seq distributionSuccess = (Seq)tuple22._1();
            Seq distributionFailure = (Seq)tuple22._2();
            Series<Object, Object> distributionSeriesSuccess = new Series<Object, Object>("Group duration (failure)", distributionSuccess, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$.MODULE$.BLUE())})));
            Series<Object, Object> distributionSeriesFailure = new Series<Object, Object>("Group duration (failure)", distributionFailure, (List<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Colors$.MODULE$.color2String(Colors$.MODULE$.RED())})));
            return this.componentLibrary.getGroupDetailsDurationDistributionChartComponent(distributionSeriesSuccess, distributionSeriesFailure);
        }
        throw new MatchError((Object)tuple2);
    }

    private final Component statisticsComponent$1() {
        return new StatisticsTextComponent();
    }

    private final Component indicatorChartComponent$1() {
        return this.componentLibrary.getRequestDetailsIndicatorChartComponent();
    }

    public final void generateDetailPage$1(Group group$1) {
        GroupDetailsPageTemplate template = new GroupDetailsPageTemplate(group$1, this.responseTimeChartComponent$1(group$1), this.responseTimeDistributionChartComponent$1(group$1), this.statisticsComponent$1(), this.indicatorChartComponent$1());
        new TemplateWriter(ChartsFiles$.MODULE$.requestFile(this.runOn, group$1.path())).writeToFile(template.getOutput());
    }

    public GroupDetailsReportGenerator(String runOn, DataReader dataReader, ComponentLibrary componentLibrary) {
        this.runOn = runOn;
        this.dataReader = dataReader;
        this.componentLibrary = componentLibrary;
        super(runOn, dataReader, componentLibrary);
    }
}

