/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.core.result.writer;

import com.excilys.ebi.gatling.core.result.writer.ConsoleSummary;
import com.excilys.ebi.gatling.core.result.writer.RequestCounters;
import com.excilys.ebi.gatling.core.result.writer.UserCounters;
import com.excilys.ebi.gatling.core.util.PaddableStringBuilder$;
import com.excilys.ebi.gatling.core.util.StringHelper$;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConsoleSummary$
implements ScalaObject {
    public static final ConsoleSummary$ MODULE$;
    private final String iso8601Format;
    private final DateTimeFormatter dateTimeFormat;
    private final int outputLength;
    private final String blockSeparator;

    static {
        new ConsoleSummary$();
    }

    public String iso8601Format() {
        return this.iso8601Format;
    }

    public DateTimeFormatter dateTimeFormat() {
        return this.dateTimeFormat;
    }

    public int outputLength() {
        return this.outputLength;
    }

    public String blockSeparator() {
        return this.blockSeparator;
    }

    public ConsoleSummary apply(long elapsedTime, Map<String, UserCounters> usersCounters, Map<String, RequestCounters> requestsCounters, DateTime time) {
        StringBuilder buff$1 = new StringBuilder();
        this.newBlock$1(buff$1);
        this.appendTimeInfos$1(buff$1, time, elapsedTime);
        usersCounters.foreach((Function1)new Serializable(buff$1){
            public static final long serialVersionUID;
            private final StringBuilder buff$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, UserCounters> tuple2) {
                Tuple2<String, UserCounters> tuple22 = tuple2;
                if (tuple22 != null) {
                    UserCounters userCounters;
                    UserCounters usersStats = userCounters = (UserCounters)tuple22._2();
                    ConsoleSummary$.MODULE$.appendSubTitle$1(this.buff$1, (String)tuple22._1());
                    ConsoleSummary$.MODULE$.appendUsersProgressBar$1(this.buff$1, usersStats);
                    ConsoleSummary$.MODULE$.appendUserCounters$1(this.buff$1, usersStats);
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.buff$1 = stringBuilder;
            }
        });
        this.appendSubTitle$1(buff$1, "Requests");
        requestsCounters.foreach((Function1)new Serializable(buff$1){
            public static final long serialVersionUID;
            private final StringBuilder buff$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<String, RequestCounters> tuple2) {
                Tuple2<String, RequestCounters> tuple22 = tuple2;
                if (tuple22 != null) {
                    ConsoleSummary$.MODULE$.appendRequestCounters$1(this.buff$1, (String)tuple22._1(), (RequestCounters)tuple22._2());
                    return;
                }
                throw new MatchError(tuple22);
            }
            {
                this.buff$1 = stringBuilder;
            }
        });
        this.newBlock$1(buff$1);
        int totalWaiting = BoxesRunTime.unboxToInt((Object)((TraversableOnce)usersCounters.values().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(UserCounters userCounters) {
                return userCounters.waitingCount();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        int totalRunning = BoxesRunTime.unboxToInt((Object)((TraversableOnce)usersCounters.values().map((Function1)new Serializable(){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(UserCounters userCounters) {
                return userCounters.runningCount();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        boolean complete = totalWaiting == 0 && totalRunning == 0;
        return new ConsoleSummary(buff$1, complete);
    }

    public DateTime apply$default$4() {
        return DateTime.now();
    }

    private final void newBlock$1(StringBuilder buff) {
        buff.append(this.blockSeparator()).append(StringHelper$.MODULE$.END_OF_LINE());
    }

    private final void appendTimeInfos$1(StringBuilder buff, DateTime time, long elapsedTimeInSec) {
        String now = this.dateTimeFormat().print((ReadableInstant)time);
        PaddableStringBuilder$.MODULE$.toPaddable(buff.append(now)).appendLeftPaddedString(((Object)BoxesRunTime.boxToLong((long)elapsedTimeInSec)).toString(), this.outputLength() - this.iso8601Format().length() - 9).append("s elapsed").append(StringHelper$.MODULE$.END_OF_LINE());
    }

    public final void appendSubTitle$1(StringBuilder buff, String title) {
        PaddableStringBuilder$.MODULE$.toPaddable(buff.append("---- ").append(title).append(" ")).appendTimes("-", package$.MODULE$.max(this.outputLength() - title.length() - 6, 0)).append(StringHelper$.MODULE$.END_OF_LINE());
    }

    public final void appendUsersProgressBar$1(StringBuilder buff, UserCounters usersStats) {
        int width = this.outputLength() - 15;
        int totalCount = usersStats.totalCount();
        int runningCount = usersStats.runningCount();
        int doneCount = usersStats.doneCount();
        int donePercent = (int)package$.MODULE$.floor((double)100 * (double)doneCount / (double)totalCount);
        int done = (int)package$.MODULE$.floor((double)width * (double)doneCount / (double)totalCount);
        int running = (int)package$.MODULE$.ceil((double)width * (double)runningCount / (double)totalCount);
        int waiting = width - done - running;
        PaddableStringBuilder$.MODULE$.toPaddable(buff.append("Users  : [")).appendTimes("#", done).appendTimes("-", running).appendTimes(" ", waiting).append("]").appendLeftPaddedString(((Object)BoxesRunTime.boxToInteger((int)donePercent)).toString(), 3).append("%").append(StringHelper$.MODULE$.END_OF_LINE());
    }

    public final void appendUserCounters$1(StringBuilder buff, UserCounters userCounters) {
        PaddableStringBuilder$.MODULE$.toPaddable(buff.append("          waiting:")).appendRightPaddedString(((Object)BoxesRunTime.boxToInteger((int)userCounters.waitingCount())).toString(), 5).append(" / running:").appendRightPaddedString(((Object)BoxesRunTime.boxToInteger((int)userCounters.runningCount())).toString(), 5).append(" / done:").appendRightPaddedString(((Object)BoxesRunTime.boxToInteger((int)userCounters.doneCount())).toString(), 5).append(StringHelper$.MODULE$.END_OF_LINE());
    }

    public final void appendRequestCounters$1(StringBuilder buff, String actionName, RequestCounters requestCounters) {
        PaddableStringBuilder$.MODULE$.toPaddable(buff.append("> ")).appendRightPaddedString(actionName, this.outputLength() - 22).append(" OK=").appendRightPaddedString(((Object)BoxesRunTime.boxToInteger((int)requestCounters.successfulCount())).toString(), 6).append(" KO=").appendRightPaddedString(((Object)BoxesRunTime.boxToInteger((int)requestCounters.failedCount())).toString(), 6).append(StringHelper$.MODULE$.END_OF_LINE());
    }

    private ConsoleSummary$() {
        MODULE$ = this;
        this.iso8601Format = "yyyy-MM-dd HH:mm:ss";
        this.dateTimeFormat = DateTimeFormat.forPattern((String)this.iso8601Format());
        this.outputLength = 80;
        this.blockSeparator = Predef$.MODULE$.augmentString("=").$times(this.outputLength());
    }
}

