/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.mojo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "com.excilys.ebi.gatling:gatling-maven-plugin:1.3.4", 0);
        this.append(sb, "", 0);
        this.append(sb, "gatling-maven-plugin", 0);
        this.append(sb, "(no description available)", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 2 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "execute".equals(this.goal)) {
            this.append(sb, "gatling:execute", 0);
            this.append(sb, "Mojo to execute Gatling.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "configDir (Default: ${basedir}/src/main/resources)", 2);
                this.append(sb, "Uses this file as the configuration file.", 3);
                this.append(sb, "Expression: ${gatling.configDir}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dataFolder (Default: ${basedir}/src/main/resources/data)", 2);
                this.append(sb, "Uses this folder as the folder where feeders are stored", 3);
                this.append(sb, "Expression: ${gatling.dataFolder}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Sets the list of exclude patterns to use in directory scan for simulations. Relative to simulationsFolder.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError", 2);
                this.append(sb, "Will cause the project build to look successful, rather than fail, even if there are Gatling test failures. This can be useful on a continuous integration server, if your only option to be able to collect output files, is if the project builds successfully.", 3);
                this.append(sb, "Expression: ${gatling.failOnError}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Sets the list of include patterns to use in directory scan for simulations. Relative to simulationsFolder.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvmArgs", 2);
                this.append(sb, "Extra JVM arguments to pass when running Gatling.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noReports (Default: false)", 2);
                this.append(sb, "Runs simulation but does not generate reports. By default false.", 3);
                this.append(sb, "Expression: ${gatling.noReports}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectoryBaseName", 2);
                this.append(sb, "Force the name of the directory generated for the results of the run", 3);
                this.append(sb, "Expression: ${gatling.ouputName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "reportsOnly", 2);
                this.append(sb, "Generates the reports for the simulation in this folder.", 3);
                this.append(sb, "Expression: ${gatling.reportsOnly}", 3);
                this.append(sb, "", 0);
                this.append(sb, "requestBodiesFolder (Default: ${basedir}/src/main/resources/request-bodies)", 2);
                this.append(sb, "Uses this folder as the folder where request bodies are stored", 3);
                this.append(sb, "Expression: ${gatling.requestBodiesFolder}", 3);
                this.append(sb, "", 0);
                this.append(sb, "resultsFolder (Default: ${basedir}/target/gatling/results)", 2);
                this.append(sb, "Uses this folder as the folder where results are stored", 3);
                this.append(sb, "Expression: ${gatling.resultsFolder}", 3);
                this.append(sb, "", 0);
                this.append(sb, "simulation", 2);
                this.append(sb, "A name of a Simulation class to run. This takes precedence over the includes / excludes parameters.", 3);
                this.append(sb, "Expression: ${gatling.simulation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "simulationsFolder (Default: ${basedir}/src/main/resources/simulations)", 2);
                this.append(sb, "Uses this folder to discover simulations that could be run", 3);
                this.append(sb, "Expression: ${gatling.simulationsFolder}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "gatling:help", 0);
            this.append(sb, "Display help information on gatling-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0gatling:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

