/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.gatling.mojo;

import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.ExecuteStreamHandler;
import org.apache.commons.exec.ProcessDestroyer;
import org.apache.commons.exec.PumpStreamHandler;
import org.apache.commons.exec.ShutdownHookProcessDestroyer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.toolchain.Toolchain;
import org.codehaus.plexus.util.StringUtils;
import scala_maven_executions.JavaMainCallerByFork;

public class GatlingJavaMainCallerByFork
extends JavaMainCallerByFork {
    public GatlingJavaMainCallerByFork(AbstractMojo requester1, String mainClassName1, String classpath, String[] jvmArgs1, String[] args1, boolean forceUseArgFile, Toolchain toolchain, boolean propagateSystemProperties) throws Exception {
        super(requester1, mainClassName1, classpath, jvmArgs1, args1, forceUseArgFile, toolchain);
        if (propagateSystemProperties) {
            for (Map.Entry<Object, Object> systemProp : System.getProperties().entrySet()) {
                String name = systemProp.getKey().toString();
                String value = systemProp.getValue().toString();
                if (!this.isPropagatableProperty(name)) continue;
                this.addJvmArgs(new String[]{"-D" + name + "=" + StringUtils.escape((String)value)});
            }
        }
    }

    public boolean run(boolean displayCmd, boolean throwFailure) throws Exception {
        List cmd = this.buildCommand();
        this.displayCmd(displayCmd, cmd);
        DefaultExecutor exec = new DefaultExecutor();
        exec.setStreamHandler((ExecuteStreamHandler)new PumpStreamHandler((OutputStream)System.out, (OutputStream)System.err, System.in));
        exec.setProcessDestroyer((ProcessDestroyer)new ShutdownHookProcessDestroyer());
        CommandLine cl = new CommandLine((String)cmd.get(0));
        for (int i = 1; i < cmd.size(); ++i) {
            cl.addArgument((String)cmd.get(i), false);
        }
        try {
            int exitValue = exec.execute(cl);
            if (exitValue != 0) {
                if (throwFailure) {
                    throw new MojoFailureException("command line returned non-zero value:" + exitValue);
                }
                return false;
            }
            return true;
        }
        catch (ExecuteException exc) {
            if (throwFailure) {
                throw exc;
            }
            return false;
        }
    }

    public void displayCmd(boolean displayCmd, List<String> cmd) {
        if (displayCmd) {
            this.requester.getLog().info((CharSequence)("cmd:  " + StringUtils.join(cmd.iterator(), (String)" ")));
        } else if (this.requester.getLog().isDebugEnabled()) {
            this.requester.getLog().debug((CharSequence)("cmd:  " + StringUtils.join(cmd.iterator(), (String)" ")));
        }
    }

    private boolean isPropagatableProperty(String name) {
        return !name.startsWith("java.") && !name.startsWith("sun.") && !name.startsWith("maven.") && !name.startsWith("file.") && !name.startsWith("awt.") && !name.startsWith("os.") && !name.startsWith("user.") && !name.equals("line.separator") && !name.equals("path.separator");
    }
}

