/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit;

import com.excilys.ebi.spring.dbunit.DbUnitException;
import com.excilys.ebi.spring.dbunit.config.DataSetConfiguration;
import com.excilys.ebi.spring.dbunit.config.Phase;
import com.excilys.ebi.spring.dbunit.dataset.DataSetDecorator;
import com.excilys.ebi.spring.dbunit.utils.DbUnitUtils;
import java.io.IOException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.util.StopWatch;

public class DbUnitDatabasePopulator
implements DatabasePopulator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbUnitDatabasePopulator.class);
    private DataSetConfiguration dataSetConfiguration;
    private Phase phase;

    public void populate(Connection connection) throws SQLException {
        LOGGER.debug("populating");
        StopWatch sw = new StopWatch("DbUnitDatabasePopulator");
        DatabaseOperation operation = this.phase.getOperation(this.dataSetConfiguration);
        try {
            IDataSet dataSet = this.decorateDataSetIfNeeded(this.dataSetConfiguration.getDataSet(), this.dataSetConfiguration.getDecorators());
            String schema = this.dataSetConfiguration.getSchema();
            DatabaseConnection databaseConnection = DbUnitUtils.getDatabaseConnection(connection, schema, this.dataSetConfiguration);
            sw.start("populating");
            operation.execute((IDatabaseConnection)databaseConnection, dataSet);
            sw.stop();
            LOGGER.debug(sw.prettyPrint());
        }
        catch (BatchUpdateException e) {
            LOGGER.error("BatchUpdateException while loading dataset", (Throwable)e);
            LOGGER.error("Caused by : ", (Throwable)e.getNextException());
            throw e;
        }
        catch (DatabaseUnitException e) {
            throw new DbUnitException(e);
        }
        catch (IOException e) {
            throw new DbUnitException(e);
        }
    }

    private IDataSet decorateDataSetIfNeeded(IDataSet dataSet, Class<? extends DataSetDecorator>[] decorators) {
        if (decorators == null || decorators.length == 0) {
            return dataSet;
        }
        ReplacementDataSet decoratedSet = new ReplacementDataSet(dataSet);
        for (Class<? extends DataSetDecorator> decoratorClass : decorators) {
            try {
                DataSetDecorator decorator = decoratorClass.newInstance();
                decoratedSet.addReplacementSubstring(decorator.getStringToReplace(), decorator.getStringReplacement());
            }
            catch (InstantiationException e) {
                LOGGER.error("Could not instantiate DataSetDecorator {}" + decoratorClass, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error("Could not instantiate DataSetDecorator {}" + decoratorClass, (Throwable)e);
            }
        }
        return decoratedSet;
    }

    public DataSetConfiguration getDataSetConfiguration() {
        return this.dataSetConfiguration;
    }

    public Phase getPhase() {
        return this.phase;
    }

    @Required
    public void setDataSetConfiguration(DataSetConfiguration dataSetConfiguration) {
        this.dataSetConfiguration = dataSetConfiguration;
    }

    @Required
    public void setPhase(Phase phase) {
        this.phase = phase;
    }
}

