/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.config;

import com.excilys.ebi.spring.dbunit.config.Constants;
import com.excilys.ebi.spring.dbunit.config.DBType;
import com.excilys.ebi.spring.dbunit.config.DataSetFormat;
import com.excilys.ebi.spring.dbunit.config.DataSetFormatOptions;
import com.excilys.ebi.spring.dbunit.config.DatabaseConnectionConfigurer;
import java.io.IOException;
import java.util.List;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.dataset.CompositeDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ExpectedDataSetConfiguration
implements DatabaseConnectionConfigurer {
    private boolean disabled;
    private String dataSourceSpringName;
    private DBType dbType = Constants.ConfigurationDefaults.DEFAULT_DB_TYPE;
    private String[] dataSetResourceLocations = new String[]{"classpath:expectedDataSet.xml"};
    private String[] columnsToIgnore = new String[0];
    private DataSetFormat format = Constants.ConfigurationDefaults.DEFAULT_DB_FORMAT;
    private DataSetFormatOptions formatOptions = new DataSetFormatOptions();
    private String escapePattern = "";
    private boolean qualifiedTableNames = false;
    private String[] tableType = Constants.ConfigurationDefaults.DEFAULT_TABLE_TYPE;
    private String schema = Constants.ConfigurationDefaults.DEFAULT_SCHEMA;

    public IDataSet getDataSet() throws DataSetException, IOException {
        List<IDataSet> dataSets = this.format.loadMultiple(this.formatOptions, this.dataSetResourceLocations);
        return dataSets.size() == 1 ? dataSets.get(0) : new CompositeDataSet(dataSets.toArray(new IDataSet[dataSets.size()]));
    }

    @Override
    public void configure(DatabaseConfig databaseConfig) {
        Assert.notNull((Object)((Object)this.dbType), (String)"dbType is required");
        databaseConfig.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)this.dbType.getDataTypeFactory());
        databaseConfig.setProperty("http://www.dbunit.org/properties/metadataHandler", (Object)this.dbType.getMetadataHandler());
        databaseConfig.setProperty("http://www.dbunit.org/properties/escapePattern", (Object)this.escapePattern);
        databaseConfig.setProperty("http://www.dbunit.org/features/caseSensitiveTableNames", (Object)this.formatOptions.isCaseSensitiveTableNames());
        databaseConfig.setProperty("http://www.dbunit.org/features/qualifiedTableNames", (Object)this.qualifiedTableNames);
        databaseConfig.setProperty("http://www.dbunit.org/properties/tableType", (Object)this.tableType);
    }

    public static Builder newExpectedDataSetConfiguration() {
        return new Builder();
    }

    public String getDataSetResourceLocation() {
        throw new UnsupportedOperationException();
    }

    public void setDataSetResourceLocation(String dataSetResourceLocation) {
        this.dataSetResourceLocations = StringUtils.tokenizeToStringArray((String)dataSetResourceLocation, (String)",; \t\n");
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getDataSourceSpringName() {
        return this.dataSourceSpringName;
    }

    public DBType getDbType() {
        return this.dbType;
    }

    public String[] getDataSetResourceLocations() {
        return this.dataSetResourceLocations;
    }

    public DataSetFormat getFormat() {
        return this.format;
    }

    public DataSetFormatOptions getFormatOptions() {
        return this.formatOptions;
    }

    public String getEscapePattern() {
        return this.escapePattern;
    }

    public boolean isQualifiedTableNames() {
        return this.qualifiedTableNames;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setDataSourceSpringName(String dataSourceSpringName) {
        this.dataSourceSpringName = dataSourceSpringName;
    }

    public void setDbType(DBType dbType) {
        this.dbType = dbType;
    }

    public void setDataSetResourceLocations(String[] dataSetResourceLocations) {
        this.dataSetResourceLocations = dataSetResourceLocations;
    }

    public void setFormat(DataSetFormat format) {
        this.format = format;
    }

    public void setFormatOptions(DataSetFormatOptions formatOptions) {
        this.formatOptions = formatOptions;
    }

    public void setEscapePattern(String escapePattern) {
        this.escapePattern = escapePattern;
    }

    public void setQualifiedTableNames(boolean qualifiedTableNames) {
        this.qualifiedTableNames = qualifiedTableNames;
    }

    public String[] getTableType() {
        return this.tableType;
    }

    public void setTableType(String[] tableType) {
        this.tableType = tableType;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String[] getColumnsToIgnore() {
        return this.columnsToIgnore;
    }

    public void setColumnsToIgnore(String[] columnsToIgnore) {
        this.columnsToIgnore = columnsToIgnore;
    }

    static /* synthetic */ String[] access$302(ExpectedDataSetConfiguration x0, String[] x1) {
        x0.columnsToIgnore = x1;
        return x1;
    }

    static /* synthetic */ String[] access$502(ExpectedDataSetConfiguration x0, String[] x1) {
        x0.dataSetResourceLocations = x1;
        return x1;
    }

    static /* synthetic */ String[] access$1002(ExpectedDataSetConfiguration x0, String[] x1) {
        x0.tableType = x1;
        return x1;
    }

    public static class Builder {
        private ExpectedDataSetConfiguration expectedDataSetConfiguration = new ExpectedDataSetConfiguration();

        private Builder() {
        }

        public Builder withDisabled(boolean disabled) {
            this.expectedDataSetConfiguration.disabled = disabled;
            return this;
        }

        public Builder withDataSourceSpringName(String dataSourceSpringName) {
            this.expectedDataSetConfiguration.dataSourceSpringName = dataSourceSpringName;
            return this;
        }

        public Builder withColumnsToIgnore(String[] columnsToIgnore) {
            ExpectedDataSetConfiguration.access$302(this.expectedDataSetConfiguration, columnsToIgnore);
            return this;
        }

        public Builder withDbType(DBType dbType) {
            this.expectedDataSetConfiguration.dbType = dbType;
            return this;
        }

        public Builder withDataSetResourceLocations(String[] dataSetResourceLocations) {
            ExpectedDataSetConfiguration.access$502(this.expectedDataSetConfiguration, dataSetResourceLocations);
            return this;
        }

        public Builder withFormat(DataSetFormat format) {
            this.expectedDataSetConfiguration.format = format;
            return this;
        }

        public Builder withFormatOptions(DataSetFormatOptions formatOptions) {
            this.expectedDataSetConfiguration.formatOptions = formatOptions;
            return this;
        }

        public Builder withEscapePattern(String escapePattern) {
            this.expectedDataSetConfiguration.escapePattern = (escapePattern = escapePattern.trim()).isEmpty() ? null : escapePattern;
            return this;
        }

        public Builder withQualifiedTableNames(boolean qualifiedTableNames) {
            this.expectedDataSetConfiguration.qualifiedTableNames = qualifiedTableNames;
            return this;
        }

        public Builder withTableType(String[] tableType) {
            if (tableType != null) {
                ExpectedDataSetConfiguration.access$1002(this.expectedDataSetConfiguration, tableType);
            }
            return this;
        }

        public Builder withSchema(String schema) {
            if (!(schema = schema.trim()).isEmpty()) {
                this.expectedDataSetConfiguration.schema = schema;
            }
            return this;
        }

        public ExpectedDataSetConfiguration build() {
            Assert.notNull((Object)this.expectedDataSetConfiguration.dataSetResourceLocations, (String)"dataSetResourceLocations is required");
            Assert.notNull((Object)((Object)this.expectedDataSetConfiguration.dbType), (String)"dbType is required");
            Assert.notNull((Object)((Object)this.expectedDataSetConfiguration.format), (String)"format is required");
            Assert.notNull((Object)this.expectedDataSetConfiguration.formatOptions, (String)"formatOptions are required");
            return this.expectedDataSetConfiguration;
        }
    }
}

