/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.dataset.xml.flyweight;

import com.excilys.ebi.spring.dbunit.dataset.xml.flyweight.FlyWeightFlatXmlDataSet;
import com.excilys.ebi.spring.dbunit.dataset.xml.flyweight.FlyWeightFlatXmlProducer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public final class FlyWeightFlatXmlDataSetBuilder {
    private static final Logger logger = LoggerFactory.getLogger(FlyWeightFlatXmlDataSetBuilder.class);
    private IDataSet metaDataSet = null;
    private boolean dtdMetadata = true;
    private boolean columnSensing = false;
    private boolean caseSensitiveTableNames = false;

    public FlyWeightFlatXmlDataSet build(InputSource inputSource) throws DataSetException {
        return this.buildInternal(inputSource);
    }

    public FlyWeightFlatXmlDataSet build(File xmlInputFile) throws MalformedURLException, DataSetException {
        URL xmlInputUrl = xmlInputFile.toURI().toURL();
        InputSource inputSource = this.createInputSourceFromUrl(xmlInputUrl);
        return this.buildInternal(inputSource);
    }

    public FlyWeightFlatXmlDataSet build(URL xmlInputUrl) throws DataSetException {
        InputSource inputSource = this.createInputSourceFromUrl(xmlInputUrl);
        return this.buildInternal(inputSource);
    }

    public FlyWeightFlatXmlDataSet build(Reader xmlReader) throws DataSetException {
        InputSource inputSource = new InputSource(xmlReader);
        return this.buildInternal(inputSource);
    }

    public FlyWeightFlatXmlDataSet build(InputStream xmlInputStream) throws DataSetException {
        InputSource inputSource = new InputSource(xmlInputStream);
        return this.buildInternal(inputSource);
    }

    private InputSource createInputSourceFromUrl(URL xmlInputUrl) {
        String stringUrl = xmlInputUrl.toString();
        return new InputSource(stringUrl);
    }

    public FlyWeightFlatXmlDataSetBuilder setMetaDataSet(IDataSet metaDataSet) {
        this.metaDataSet = metaDataSet;
        return this;
    }

    public FlyWeightFlatXmlDataSetBuilder setMetaDataSetFromDtd(Reader dtdReader) throws DataSetException, IOException {
        this.metaDataSet = new FlatDtdDataSet(dtdReader);
        return this;
    }

    public FlyWeightFlatXmlDataSetBuilder setMetaDataSetFromDtd(InputStream dtdStream) throws DataSetException, IOException {
        this.metaDataSet = new FlatDtdDataSet(dtdStream);
        return this;
    }

    public boolean isDtdMetadata() {
        return this.dtdMetadata;
    }

    public FlyWeightFlatXmlDataSetBuilder setDtdMetadata(boolean dtdMetadata) {
        this.dtdMetadata = dtdMetadata;
        return this;
    }

    public boolean isColumnSensing() {
        return this.columnSensing;
    }

    public FlyWeightFlatXmlDataSetBuilder setColumnSensing(boolean columnSensing) {
        this.columnSensing = columnSensing;
        return this;
    }

    public boolean isCaseSensitiveTableNames() {
        return this.caseSensitiveTableNames;
    }

    public FlyWeightFlatXmlDataSetBuilder setCaseSensitiveTableNames(boolean caseSensitiveTableNames) {
        this.caseSensitiveTableNames = caseSensitiveTableNames;
        return this;
    }

    private FlyWeightFlatXmlDataSet buildInternal(InputSource inputSource) throws DataSetException {
        logger.trace("build(inputSource={}) - start", (Object)inputSource);
        if (inputSource == null) {
            throw new NullPointerException("The parameter 'inputSource' must not be null");
        }
        logger.debug("Creating FlatXmlDataSet with builder parameters: {}", (Object)this);
        FlyWeightFlatXmlProducer producer = this.createProducer(inputSource);
        return new FlyWeightFlatXmlDataSet(producer);
    }

    protected FlyWeightFlatXmlProducer createProducer(InputSource inputSource) {
        logger.trace("createProducer(inputSource={}) - start", (Object)inputSource);
        FlyWeightFlatXmlProducer producer = null;
        if (this.metaDataSet != null) {
            logger.debug("Creating FlatXmlProducer using the following metaDataSet: {}", (Object)this.metaDataSet);
            producer = new FlyWeightFlatXmlProducer(inputSource, this.metaDataSet);
        } else {
            logger.debug("Creating FlatXmlProducer using the properties of this builder: {}", (Object)this);
            producer = new FlyWeightFlatXmlProducer(inputSource, this.dtdMetadata, this.columnSensing, this.caseSensitiveTableNames);
        }
        return producer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getName()).append("[");
        sb.append("dtdMetadata=").append(this.dtdMetadata);
        sb.append(", columnSensing=").append(this.columnSensing);
        sb.append(", caseSensitiveTableNames=").append(this.caseSensitiveTableNames);
        sb.append(", metaDataSet=").append(this.metaDataSet);
        sb.append("]");
        return sb.toString();
    }
}

