/*
 * Decompiled with CFR 0.152.
 */
package com.excilys.ebi.spring.dbunit.dataset.xml.flyweight;

import com.excilys.ebi.spring.dbunit.dataset.xml.LinkedHashMapFlatDtdProducer;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultTableMetaData;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.dbunit.dataset.OrderedTableNameMap;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.stream.BufferedConsumer;
import org.dbunit.dataset.stream.DefaultConsumer;
import org.dbunit.dataset.stream.IDataSetConsumer;
import org.dbunit.dataset.stream.IDataSetProducer;
import org.dbunit.dataset.xml.FlatDtdDataSet;
import org.dbunit.dataset.xml.FlatDtdProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class FlyWeightFlatXmlProducer
extends DefaultHandler
implements IDataSetProducer {
    private static final Logger logger = LoggerFactory.getLogger(FlyWeightFlatXmlProducer.class);
    private static final IDataSetConsumer EMPTY_CONSUMER = new DefaultConsumer();
    private static final String DATASET = "dataset";
    private final InputSource _inputSource;
    private final EntityResolver _resolver;
    private boolean _validating = false;
    private IDataSet _metaDataSet;
    private FlatDtdHandler _dtdHandler;
    private int _lineNumber = 0;
    private int _lineNumberGlobal = 0;
    private boolean _columnSensing = false;
    private boolean _caseSensitiveTableNames;
    private IDataSetConsumer _consumer = EMPTY_CONSUMER;
    private OrderedTableNameMap _orderedTableNameMap;
    private HashMap<String, String> attributeNameCache = new HashMap();
    private HashMap<String, String> attributeValueCache = new HashMap();

    public FlyWeightFlatXmlProducer(InputSource xmlSource) {
        this(xmlSource, true);
    }

    public FlyWeightFlatXmlProducer(InputSource xmlSource, boolean dtdMetadata) {
        this(xmlSource, dtdMetadata, false);
    }

    public FlyWeightFlatXmlProducer(InputSource xmlSource, IDataSet metaDataSet) {
        this._inputSource = xmlSource;
        this._metaDataSet = metaDataSet;
        this._resolver = this;
        this._caseSensitiveTableNames = metaDataSet.isCaseSensitiveTableNames();
        this.initialize(false);
    }

    public FlyWeightFlatXmlProducer(InputSource xmlSource, EntityResolver resolver) {
        this._inputSource = xmlSource;
        this._resolver = resolver;
        this.initialize(true);
    }

    public FlyWeightFlatXmlProducer(InputSource xmlSource, boolean dtdMetadata, boolean columnSensing) {
        this(xmlSource, dtdMetadata, columnSensing, false);
    }

    public FlyWeightFlatXmlProducer(InputSource xmlSource, boolean dtdMetadata, boolean columnSensing, boolean caseSensitiveTableNames) {
        this._inputSource = xmlSource;
        this._columnSensing = columnSensing;
        this._caseSensitiveTableNames = caseSensitiveTableNames;
        this._resolver = this;
        this.initialize(dtdMetadata);
    }

    private void initialize(boolean dtdMetadata) {
        if (dtdMetadata) {
            this._dtdHandler = new FlatDtdHandler(this);
        }
    }

    public boolean isCaseSensitiveTableNames() {
        return this._caseSensitiveTableNames;
    }

    private String getAttributeNameFromCache(String qName) {
        if (this.attributeNameCache.containsKey(qName)) {
            return this.attributeNameCache.get(qName);
        }
        logger.debug("miss from name cache");
        this.attributeNameCache.put(qName, qName);
        return qName;
    }

    private String getAttributeValueFromCache(String value) {
        if (this.attributeValueCache.containsKey(value)) {
            return this.attributeValueCache.get(value);
        }
        logger.debug("miss from value cache");
        this.attributeValueCache.put(value, value);
        return value;
    }

    private ITableMetaData createTableMetaData(String tableName, Attributes attributes) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("createTableMetaData(tableName={}, attributes={}) - start", (Object)tableName, (Object)attributes);
        }
        if (this._metaDataSet != null) {
            return this._metaDataSet.getTableMetaData(tableName);
        }
        Column[] columns = new Column[attributes.getLength()];
        for (int i = 0; i < attributes.getLength(); ++i) {
            columns[i] = new Column(this.getAttributeNameFromCache(attributes.getQName(i)), DataType.UNKNOWN);
        }
        return new DefaultTableMetaData(tableName, columns);
    }

    private ITableMetaData mergeTableMetaData(List<Column> columnsToMerge, ITableMetaData originalMetaData) throws DataSetException {
        Column[] columns = new Column[originalMetaData.getColumns().length + columnsToMerge.size()];
        System.arraycopy(originalMetaData.getColumns(), 0, columns, 0, originalMetaData.getColumns().length);
        for (int i = 0; i < columnsToMerge.size(); ++i) {
            Column column;
            columns[columns.length - columnsToMerge.size() + i] = column = columnsToMerge.get(i);
        }
        return new DefaultTableMetaData(originalMetaData.getTableName(), columns);
    }

    private ITableMetaData getActiveMetaData() {
        if (this._orderedTableNameMap != null) {
            String lastTableName = this._orderedTableNameMap.getLastTableName();
            if (lastTableName != null) {
                return (ITableMetaData)this._orderedTableNameMap.get(lastTableName);
            }
            return null;
        }
        return null;
    }

    private boolean isNewTable(String tableName) {
        return !this._orderedTableNameMap.isLastTable(tableName);
    }

    protected void handleMissingColumns(Attributes attributes) throws DataSetException {
        ArrayList<Column> columnsToMerge = new ArrayList<Column>();
        ITableMetaData activeMetaData = this.getActiveMetaData();
        int attributeLength = attributes.getLength();
        for (int i = 0; i < attributeLength; ++i) {
            try {
                activeMetaData.getColumnIndex(this.getAttributeNameFromCache(attributes.getQName(i)));
                continue;
            }
            catch (NoSuchColumnException e) {
                columnsToMerge.add(new Column(this.getAttributeNameFromCache(attributes.getQName(i)), DataType.UNKNOWN));
            }
        }
        if (!columnsToMerge.isEmpty()) {
            if (this._columnSensing) {
                logger.debug("Column sensing enabled. Will create a new metaData with potentially new columns if needed");
                activeMetaData = this.mergeTableMetaData(columnsToMerge, activeMetaData);
                this._orderedTableNameMap.update(activeMetaData.getTableName(), (Object)activeMetaData);
                this._consumer.startTable(activeMetaData);
            } else {
                StringBuilder extraColumnNames = new StringBuilder();
                for (Column col : columnsToMerge) {
                    extraColumnNames.append(extraColumnNames.length() > 0 ? "," : "").append(col.getColumnName());
                }
                if (logger.isWarnEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Extra columns ({}) on line {} for table {} (global line number is {}). Those columns will be ignored.");
                    msg.append("\n\tPlease add the extra columns to line 1, or use a DTD to make sure the value of those columns are populated");
                    msg.append(" or specify 'columnSensing=true' for your FlatXmlProducer.");
                    msg.append("\n\tSee FAQ for more details.");
                    logger.warn(msg.toString(), new Object[]{extraColumnNames.toString(), this._lineNumber + 1, activeMetaData.getTableName(), this._lineNumberGlobal});
                }
            }
        }
    }

    public void setColumnSensing(boolean columnSensing) {
        this._columnSensing = columnSensing;
    }

    public void setValidating(boolean validating) {
        this._validating = validating;
    }

    public void setConsumer(IDataSetConsumer consumer) {
        logger.debug("setConsumer(consumer) - start");
        this._consumer = this._columnSensing ? new BufferedConsumer(consumer) : consumer;
    }

    public void produce() throws DataSetException {
        logger.debug("produce() - start");
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setValidating(this._validating);
            XMLReader xmlReader = saxParserFactory.newSAXParser().getXMLReader();
            if (this._dtdHandler != null) {
                FlatDtdProducer.setLexicalHandler((XMLReader)xmlReader, (LexicalHandler)((Object)this._dtdHandler));
                FlatDtdProducer.setDeclHandler((XMLReader)xmlReader, (DeclHandler)((Object)this._dtdHandler));
            }
            xmlReader.setContentHandler(this);
            xmlReader.setErrorHandler(this);
            xmlReader.setEntityResolver(this._resolver);
            xmlReader.parse(this._inputSource);
        }
        catch (ParserConfigurationException e) {
            throw new DataSetException((Throwable)e);
        }
        catch (SAXException e) {
            DataSetException exceptionToRethrow = FlyWeightFlatXmlProducer.buildException(e);
            throw exceptionToRethrow;
        }
        catch (IOException e) {
            throw new DataSetException((Throwable)e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        logger.debug("resolveEntity(publicId={}, systemId={}) - start", (Object)publicId, (Object)systemId);
        if (this._dtdHandler == null || !this._dtdHandler.isDtdPresent()) {
            return new InputSource(new StringReader(""));
        }
        return null;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("startElement(uri={}, localName={}, qName={}, attributes={}) - start", new Object[]{uri, localName, qName, attributes});
        }
        try {
            ITableMetaData activeMetaData = this.getActiveMetaData();
            if (activeMetaData == null && qName.equals(DATASET)) {
                this._consumer.startDataSet();
                this._orderedTableNameMap = new OrderedTableNameMap(this._caseSensitiveTableNames);
                if (this._metaDataSet != null) {
                    for (String tableName : this._metaDataSet.getTableNames()) {
                        this._consumer.startTable(this._metaDataSet.getTableMetaData(tableName));
                        this._consumer.endTable();
                    }
                }
                return;
            }
            if (this.isNewTable(qName)) {
                if (activeMetaData != null) {
                    this._consumer.endTable();
                }
                if (this._orderedTableNameMap.containsTable(qName)) {
                    activeMetaData = (ITableMetaData)this._orderedTableNameMap.get(qName);
                    this._orderedTableNameMap.setLastTable(qName);
                } else {
                    activeMetaData = this.createTableMetaData(qName, attributes);
                    this._orderedTableNameMap.add(activeMetaData.getTableName(), (Object)activeMetaData);
                }
                this._consumer.startTable(activeMetaData);
                this._lineNumber = 0;
            }
            if (attributes.getLength() > 0) {
                if (!(this._metaDataSet != null || this._dtdHandler != null && this._dtdHandler.isDtdPresent())) {
                    this.handleMissingColumns(attributes);
                    activeMetaData = this.getActiveMetaData();
                }
                ++this._lineNumber;
                ++this._lineNumberGlobal;
                Column[] columns = activeMetaData.getColumns();
                Object[] rowValues = new Object[columns.length];
                for (int i = 0; i < columns.length; ++i) {
                    Column column = columns[i];
                    rowValues[i] = this.getAttributeValueFromCache(attributes.getValue(column.getColumnName()));
                }
                this._consumer.row(rowValues);
            }
        }
        catch (DataSetException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("endElement(uri={}, localName={}, qName={}) - start", new Object[]{uri, localName, qName});
        }
        if (qName.equals(DATASET)) {
            try {
                if (this.getActiveMetaData() != null) {
                    this._consumer.endTable();
                }
                this._consumer.endDataSet();
            }
            catch (DataSetException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }

    protected static final DataSetException buildException(SAXException cause) {
        int lineNumber = -1;
        if (cause instanceof SAXParseException) {
            lineNumber = ((SAXParseException)cause).getLineNumber();
        }
        Exception exception = cause.getException() == null ? cause : cause.getException();
        String message = lineNumber >= 0 ? "Line " + lineNumber + ": " + exception.getMessage() : exception.getMessage();
        if (exception instanceof DataSetException) {
            return (DataSetException)((Object)exception);
        }
        return new DataSetException(message, (Throwable)exception);
    }

    private static class FlatDtdHandler
    extends LinkedHashMapFlatDtdProducer {
        private final Logger flatDtdLogger = LoggerFactory.getLogger(FlatDtdHandler.class);
        private boolean _dtdPresent = false;
        private FlyWeightFlatXmlProducer xmlProducer;

        public FlatDtdHandler(FlyWeightFlatXmlProducer xmlProducer) {
            this.xmlProducer = xmlProducer;
        }

        public boolean isDtdPresent() {
            return this._dtdPresent;
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.flatDtdLogger.isDebugEnabled()) {
                this.flatDtdLogger.debug("startDTD(name={}, publicId={}, systemId={}) - start", new Object[]{name, publicId, systemId});
            }
            this._dtdPresent = true;
            try {
                FlatDtdDataSet metaDataSet = new FlatDtdDataSet();
                this.setConsumer((IDataSetConsumer)metaDataSet);
                this.xmlProducer._metaDataSet = (IDataSet)metaDataSet;
                super.startDTD(name, publicId, systemId);
            }
            catch (DataSetException e) {
                throw new SAXException((Exception)((Object)e));
            }
        }
    }
}

